---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 165
  claims_with_evidence: 165
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-datastream-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードのインターフェース定義・メソッドシグネチャが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの仕様と矛盾していないか
3. **網羅性**：publicなインターフェース・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 165 / 165 = 1.00
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：165 / 165、根拠なし：0
- 優先レビュー（高）
  1. **状態管理関連テスト**：StateManager、ProcessingTimeManager、EventTimeManagerの動作確認
  2. **ストリーム変換テスト**：KeyedPartitionStream、NonKeyedPartitionStream、GlobalStream間の変換処理
  3. **ウィンドウ処理テスト**：WindowStrategy、WindowProcessFunction関連の動作確認

## 2) 参照した情報（Evidence一覧）
> 以下のソースファイルを根拠として参照

### Core API
- E-01: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/ExecutionEnvironment.java`
- E-02: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/builtin/BuiltinFuncs.java`

### Context API
- E-03: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/TaskInfo.java`
- E-04: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/JobInfo.java`
- E-05: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/RuntimeContext.java`
- E-06: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/StateManager.java`
- E-07: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/ProcessingTimeManager.java`
- E-08: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/PartitionedContext.java`
- E-09: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/NonPartitionedContext.java`
- E-10: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/BasePartitionedContext.java`
- E-11: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/TwoOutputPartitionedContext.java`
- E-12: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/context/TwoOutputNonPartitionedContext.java`

### Stream API
- E-13: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/stream/DataStream.java`
- E-14: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/stream/KeyedPartitionStream.java`
- E-15: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/stream/NonKeyedPartitionStream.java`
- E-16: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/stream/GlobalStream.java`
- E-17: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/stream/BroadcastStream.java`
- E-18: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/stream/ProcessConfigurable.java`

### Function API
- E-19: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/ProcessFunction.java`
- E-20: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/OneInputStreamProcessFunction.java`
- E-21: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/TwoOutputStreamProcessFunction.java`
- E-22: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/TwoInputNonBroadcastStreamProcessFunction.java`
- E-23: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/TwoInputBroadcastStreamProcessFunction.java`
- E-24: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/ApplyPartitionFunction.java`
- E-25: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/function/TwoOutputApplyPartitionFunction.java`
- E-26: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/common/Collector.java`

### Join Extension
- E-27: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/join/JoinType.java`
- E-28: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/join/JoinFunction.java`

### Window Extension
- E-29: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/strategy/WindowStrategy.java`
- E-30: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/strategy/TumblingTimeWindowStrategy.java`
- E-31: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/strategy/SlidingTimeWindowStrategy.java`
- E-32: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/strategy/GlobalWindowStrategy.java`
- E-33: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/strategy/SessionWindowStrategy.java`
- E-34: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/function/WindowProcessFunction.java`
- E-35: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/function/OneInputWindowStreamProcessFunction.java`
- E-36: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/function/TwoInputNonBroadcastWindowStreamProcessFunction.java`
- E-37: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/function/TwoOutputWindowStreamProcessFunction.java`
- E-38: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/context/WindowContext.java`
- E-39: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/context/OneInputWindowContext.java`
- E-40: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/window/context/TwoInputWindowContext.java`

### EventTime Extension
- E-41: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/EventTimeExtension.java`
- E-42: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/timer/EventTimeManager.java`
- E-43: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/function/EventTimeProcessFunction.java`
- E-44: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/function/OneInputEventTimeStreamProcessFunction.java`
- E-45: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/function/TwoInputNonBroadcastEventTimeStreamProcessFunction.java`
- E-46: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/function/TwoInputBroadcastEventTimeStreamProcessFunction.java`
- E-47: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/function/TwoOutputEventTimeStreamProcessFunction.java`
- E-48: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/strategy/EventTimeExtractor.java`
- E-49: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/strategy/EventTimeWatermarkGeneratorBuilder.java`
- E-50: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/extension/eventtime/strategy/EventTimeWatermarkStrategy.java`

### Attribute
- E-51: `flink-datastream-api/src/main/java/org/apache/flink/datastream/api/attribute/NoOutputUntilEndOfInput.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ExecutionEnvironment関連 (UT-DSA-001 - UT-DSA-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getInstance()でExecutionEnvironmentインスタンスが取得できる | E-01 (line 38-43) | ○ |
| C-02 | 実装クラス未存在時にReflectiveOperationExceptionスロー | E-01 (line 38-43) | ○ |
| C-03 | execute(String)でジョブが実行される | E-01 (line 46) | ○ |
| C-04 | execute(null)の挙動確認 | E-01 (line 46) | ○ |
| C-05 | getExecutionMode()でRuntimeExecutionMode取得 | E-01 (line 48-49) | ○ |
| C-06 | setExecutionMode(RuntimeExecutionMode)でモード設定 | E-01 (line 51-52) | ○ |
| C-07 | setExecutionMode(null)の挙動確認 | E-01 (line 51-52) | ○ |
| C-08 | fromSource(Source, String)でストリーム作成 | E-01 (line 54-55) | ○ |
| C-09 | fromSource(null, String)の挙動確認 | E-01 (line 54-55) | ○ |

### BuiltinFuncs関連 (UT-DSA-010 - UT-DSA-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | join(JoinFunction)でINNER Join実行 | E-02 (line 56-59) | ○ |
| C-11 | join(JoinFunction, JoinType)でJoin実行 | E-02 (line 65-75) | ○ |
| C-12 | join(null, JoinType)でRuntimeException | E-02 (line 65-75) | ○ |
| C-13 | KeyedPartitionStream間のjoin | E-02 (line 78-83) | ○ |
| C-14 | NonKeyedPartitionStream間のjoin | E-02 (line 98-111) | ○ |
| C-15 | window(WindowStrategy, OneInputWindowStreamProcessFunction) | E-02 (line 152-166) | ○ |
| C-16 | window(WindowStrategy, TwoInputNonBroadcastWindowStreamProcessFunction) | E-02 (line 176-190) | ○ |
| C-17 | window(WindowStrategy, TwoOutputWindowStreamProcessFunction) | E-02 (line 200-214) | ○ |
| C-18 | window(null, WindowProcessFunction)でRuntimeException | E-02 (line 152-214) | ○ |

### Context関連 (UT-DSA-019 - UT-DSA-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | TaskInfo.getParallelism() | E-03 (line 31) | ○ |
| C-20 | TaskInfo.getMaxParallelism() | E-03 (line 38) | ○ |
| C-21 | TaskInfo.getTaskName() | E-03 (line 45) | ○ |
| C-22 | TaskInfo.getIndexOfThisSubtask() | E-03 (line 53) | ○ |
| C-23 | TaskInfo.getIndexOfThisSubtask()境界値(並列度1) | E-03 (line 48-53) | ○ |
| C-24 | TaskInfo.getAttemptNumber() | E-03 (line 62) | ○ |
| C-25 | TaskInfo.getAttemptNumber()境界値(初回) | E-03 (line 57-62) | ○ |
| C-26 | JobInfo.getJobName() | E-04 (line 31) | ○ |
| C-27 | JobInfo.getExecutionMode() STREAMING | E-04 (line 34, 39) | ○ |
| C-28 | JobInfo.getExecutionMode() BATCH | E-04 (line 34, 40) | ○ |
| C-29 | RuntimeContext.getJobInfo() | E-05 (line 33) | ○ |
| C-30 | RuntimeContext.getTaskInfo() | E-05 (line 36) | ○ |
| C-31 | RuntimeContext.getMetricGroup() | E-05 (line 39) | ○ |
| C-32 | StateManager.getCurrentKey()正常系 | E-06 (line 47) | ○ |
| C-33 | StateManager.getCurrentKey()非Keyed例外 | E-06 (line 44-47) | ○ |
| C-34 | StateManager.getState(ListStateDeclaration) | E-06 (line 65) | ○ |
| C-35 | StateManager.getState未宣言状態例外 | E-06 (line 63-65) | ○ |
| C-36 | StateManager.getStateOptional存在時 | E-06 (line 55-56) | ○ |
| C-37 | StateManager.getStateOptional未存在時 | E-06 (line 55-56) | ○ |
| C-38 | StateManager.getState(ValueStateDeclaration) | E-06 (line 83) | ○ |
| C-39 | StateManager.getState(MapStateDeclaration) | E-06 (line 101) | ○ |
| C-40 | StateManager.getState(ReducingStateDeclaration) | E-06 (line 119) | ○ |
| C-41 | StateManager.getState(AggregatingStateDeclaration) | E-06 (line 137-138) | ○ |
| C-42 | StateManager.getState(BroadcastStateDeclaration) | E-06 (line 156-157) | ○ |
| C-43 | ProcessingTimeManager.registerTimer() | E-07 (line 35) | ○ |
| C-44 | ProcessingTimeManager.registerTimer()過去タイムスタンプ | E-07 (line 30-35) | ○ |
| C-45 | ProcessingTimeManager.deleteTimer()正常系 | E-07 (line 43) | ○ |
| C-46 | ProcessingTimeManager.deleteTimer()未登録 | E-07 (line 38-43) | ○ |
| C-47 | ProcessingTimeManager.currentTime() | E-07 (line 50) | ○ |
| C-48 | PartitionedContext.getNonPartitionedContext() | E-08 (line 27) | ○ |
| C-49 | NonPartitionedContext.applyToAllPartitions() | E-09 (line 36) | ○ |
| C-50 | NonPartitionedContext.applyToAllPartitions()例外伝播 | E-09 (line 36) | ○ |
| C-51 | NonPartitionedContext.getWatermarkManager() | E-09 (line 42) | ○ |
| C-52 | TwoOutputPartitionedContext.getNonPartitionedContext() | E-11 (line 26) | ○ |
| C-53 | TwoOutputNonPartitionedContext.applyToAllPartitions() | E-12 (line 36-37) | ○ |
| C-54 | BasePartitionedContext.getStateManager() | E-10 (line 30) | ○ |
| C-55 | BasePartitionedContext.getProcessingTimeManager() | E-10 (line 33) | ○ |

### Stream関連 (UT-DSA-056 - UT-DSA-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | KeyedPartitionStream.process(function, keySelector) | E-14 (line 49-51) | ○ |
| C-57 | KeyedPartitionStream.process(function) | E-14 (line 65-66) | ○ |
| C-58 | KeyedPartitionStream.process(twoOutputFunction) | E-14 (line 92-93) | ○ |
| C-59 | KeyedPartitionStream.connectAndProcess(keyed, function) | E-14 (line 109-111) | ○ |
| C-60 | KeyedPartitionStream.connectAndProcess(broadcast, function) | E-14 (line 145-147) | ○ |
| C-61 | KeyedPartitionStream.global() | E-14 (line 174) | ○ |
| C-62 | KeyedPartitionStream.keyBy() | E-14 (line 182) | ○ |
| C-63 | KeyedPartitionStream.shuffle() | E-14 (line 190) | ○ |
| C-64 | KeyedPartitionStream.broadcast() | E-14 (line 197) | ○ |
| C-65 | KeyedPartitionStream.toSink() | E-14 (line 199) | ○ |
| C-66 | NonKeyedPartitionStream.process(function) | E-15 (line 41-42) | ○ |
| C-67 | NonKeyedPartitionStream.process(twoOutputFunction) | E-15 (line 50-51) | ○ |
| C-68 | NonKeyedPartitionStream.connectAndProcess(nonKeyed, function) | E-15 (line 60-62) | ○ |
| C-69 | NonKeyedPartitionStream.connectAndProcess(broadcast, function) | E-15 (line 70-72) | ○ |
| C-70 | NonKeyedPartitionStream.keyBy() | E-15 (line 87) | ○ |
| C-71 | GlobalStream.process(function) | E-16 (line 37-38) | ○ |
| C-72 | GlobalStream.connectAndProcess(global, function) | E-16 (line 56-58) | ○ |
| C-73 | BroadcastStream.connectAndProcess(keyed, function) | E-17 (line 44-46) | ○ |
| C-74 | BroadcastStream.connectAndProcess(nonKeyed, function) | E-17 (line 55-57) | ○ |
| C-75 | ProcessConfigurable.withUid() | E-18 (line 42) | ○ |
| C-76 | ProcessConfigurable.withUid(null) | E-18 (line 42) | ○ |
| C-77 | ProcessConfigurable.withName() | E-18 (line 50) | ○ |
| C-78 | ProcessConfigurable.withParallelism() | E-18 (line 58) | ○ |
| C-79 | ProcessConfigurable.withParallelism(1) | E-18 (line 58) | ○ |
| C-80 | ProcessConfigurable.withParallelism(0)異常系 | E-18 (line 58) | ○ |
| C-81 | ProcessConfigurable.withMaxParallelism() | E-18 (line 69) | ○ |
| C-82 | ProcessConfigurable.withSlotSharingGroup() | E-18 (line 83) | ○ |

### Function関連 (UT-DSA-083 - UT-DSA-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | ProcessFunction.usesStates()デフォルト | E-19 (line 38-40) | ○ |
| C-84 | ProcessFunction.declareWatermarks()デフォルト | E-19 (line 48-50) | ○ |
| C-85 | ProcessFunction.close() | E-19 (line 62) | ○ |
| C-86 | OneInputStreamProcessFunction.open() | E-20 (line 41) | ○ |
| C-87 | OneInputStreamProcessFunction.processRecord() | E-20 (line 50-51) | ○ |
| C-88 | OneInputStreamProcessFunction.processRecord(null) | E-20 (line 50-51) | ○ |
| C-89 | OneInputStreamProcessFunction.endInput() | E-20 (line 59) | ○ |
| C-90 | OneInputStreamProcessFunction.onProcessingTimer() | E-20 (line 68-69) | ○ |
| C-91 | OneInputStreamProcessFunction.onWatermark()デフォルト | E-20 (line 72-76) | ○ |
| C-92 | TwoOutputStreamProcessFunction.processRecord() | E-21 (line 51-56) | ○ |
| C-93 | TwoOutputStreamProcessFunction.onProcessingTimer() | E-21 (line 74-79) | ○ |
| C-94 | TwoInputNonBroadcastStreamProcessFunction.processRecordFromFirstInput() | E-22 (line 50-51) | ○ |
| C-95 | TwoInputNonBroadcastStreamProcessFunction.processRecordFromSecondInput() | E-22 (line 60-61) | ○ |
| C-96 | TwoInputNonBroadcastStreamProcessFunction.endFirstInput() | E-22 (line 69) | ○ |
| C-97 | TwoInputNonBroadcastStreamProcessFunction.endSecondInput() | E-22 (line 77) | ○ |
| C-98 | TwoInputBroadcastStreamProcessFunction.processRecordFromNonBroadcastInput() | E-23 (line 53-54) | ○ |
| C-99 | TwoInputBroadcastStreamProcessFunction.processRecordFromBroadcastInput() | E-23 (line 64-65) | ○ |
| C-100 | ApplyPartitionFunction.apply() | E-24 (line 36) | ○ |
| C-101 | TwoOutputApplyPartitionFunction.apply() | E-25 (line 37-41) | ○ |
| C-102 | Collector.collect() | E-26 (line 31) | ○ |
| C-103 | Collector.collect(null) | E-26 (line 31) | ○ |
| C-104 | Collector.collectAndOverwriteTimestamp() | E-26 (line 39) | ○ |
| C-105 | JoinType.INNER | E-27 (line 31) | ○ |
| C-106 | JoinFunction.processRecord() | E-28 (line 41-42) | ○ |
| C-107 | JoinFunction.processRecord(null, record) | E-28 (line 41-42) | ○ |

### Window関連 (UT-DSA-108 - UT-DSA-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | WindowStrategy.global() | E-29 (line 71-73) | ○ |
| C-109 | WindowStrategy.tumbling(Duration) | E-29 (line 86-88) | ○ |
| C-110 | WindowStrategy.tumbling(Duration, TimeType) | E-29 (line 100-102) | ○ |
| C-111 | WindowStrategy.tumbling(Duration, TimeType, Duration) | E-29 (line 115-118) | ○ |
| C-112 | WindowStrategy.sliding(Duration, Duration) | E-29 (line 132-134) | ○ |
| C-113 | WindowStrategy.session(Duration) | E-29 (line 184-186) | ○ |
| C-114 | TumblingTimeWindowStrategy.getWindowSize() | E-30 (line 47-49) | ○ |
| C-115 | TumblingTimeWindowStrategy.getTimeType() | E-30 (line 51-53) | ○ |
| C-116 | TumblingTimeWindowStrategy.getAllowedLateness() | E-30 (line 55-57) | ○ |
| C-117 | SlidingTimeWindowStrategy.getWindowSlideInterval() | E-31 (line 55-57) | ○ |
| C-118 | SessionWindowStrategy.getSessionGap() | E-33 (line 40-42) | ○ |
| C-119 | WindowProcessFunction.useWindowStates()デフォルト | E-34 (line 41-43) | ○ |
| C-120 | OneInputWindowStreamProcessFunction.onRecord() | E-35 (line 40-47) | ○ |
| C-121 | OneInputWindowStreamProcessFunction.onTrigger() | E-35 (line 53-57) | ○ |
| C-122 | OneInputWindowStreamProcessFunction.onClear() | E-35 (line 64-68) | ○ |
| C-123 | OneInputWindowStreamProcessFunction.onLateRecord() | E-35 (line 71-72) | ○ |
| C-124 | TwoInputNonBroadcastWindowStreamProcessFunction.onRecord1() | E-36 (line 42-49) | ○ |
| C-125 | TwoInputNonBroadcastWindowStreamProcessFunction.onRecord2() | E-36 (line 56-63) | ○ |
| C-126 | WindowContext.getStartTime() | E-38 (line 49) | ○ |
| C-127 | WindowContext.getStartTime()非時間ウィンドウ | E-38 (line 44-49) | ○ |
| C-128 | WindowContext.getEndTime() | E-38 (line 58) | ○ |
| C-129 | WindowContext.getWindowState(ListStateDeclaration) | E-38 (line 64-65) | ○ |
| C-130 | OneInputWindowContext.putRecord() | E-39 (line 37) | ○ |
| C-131 | OneInputWindowContext.getAllRecords() | E-39 (line 44) | ○ |
| C-132 | OneInputWindowContext.getAllRecords()空ウィンドウ | E-39 (line 42-44) | ○ |
| C-133 | TwoInputWindowContext.putRecord1() | E-40 (line 35) | ○ |
| C-134 | TwoInputWindowContext.getAllRecords1() | E-40 (line 42) | ○ |
| C-135 | TwoInputWindowContext.putRecord2() | E-40 (line 49) | ○ |
| C-136 | TwoInputWindowContext.getAllRecords2() | E-40 (line 56) | ○ |

### EventTime関連 (UT-DSA-137 - UT-DSA-163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | EventTimeExtension.isEventTimeWatermark(EventTimeWatermark)=true | E-41 (line 110-112) | ○ |
| C-138 | EventTimeExtension.isEventTimeWatermark(other)=false | E-41 (line 110-122) | ○ |
| C-139 | EventTimeExtension.isIdleStatusWatermark()=true | E-41 (line 130-132) | ○ |
| C-140 | EventTimeExtension.newWatermarkGeneratorBuilder() | E-41 (line 156-159) | ○ |
| C-141 | EventTimeExtension.wrapProcessFunction(OneInput) | E-41 (line 173-185) | ○ |
| C-142 | EventTimeExtension.wrapProcessFunction(TwoOutput) | E-41 (line 197-210) | ○ |
| C-143 | EventTimeExtension.wrapProcessFunction(TwoInputNonBroadcast) | E-41 (line 222-236) | ○ |
| C-144 | EventTimeExtension.wrapProcessFunction(TwoInputBroadcast) | E-41 (line 248-262) | ○ |
| C-145 | EventTimeManager.registerTimer() | E-42 (line 37) | ○ |
| C-146 | EventTimeManager.deleteTimer() | E-42 (line 45) | ○ |
| C-147 | EventTimeManager.currentTime() | E-42 (line 52) | ○ |
| C-148 | EventTimeProcessFunction.initEventTimeProcessFunction() | E-43 (line 39) | ○ |
| C-149 | OneInputEventTimeStreamProcessFunction.onEventTimeWatermark() | E-44 (line 38-40) | ○ |
| C-150 | OneInputEventTimeStreamProcessFunction.onEventTimer() | E-44 (line 46-47) | ○ |
| C-151 | EventTimeExtractor.extractTimestamp() | E-48 (line 30) | ○ |
| C-152 | EventTimeWatermarkGeneratorBuilder.withIdleness() | E-49 (line 58-61) | ○ |
| C-153 | EventTimeWatermarkGeneratorBuilder.withMaxOutOfOrderTime() | E-49 (line 63-66) | ○ |
| C-154 | EventTimeWatermarkGeneratorBuilder.noWatermark() | E-49 (line 70-73) | ○ |
| C-155 | EventTimeWatermarkGeneratorBuilder.periodicWatermark() | E-49 (line 79-82) | ○ |
| C-156 | EventTimeWatermarkGeneratorBuilder.periodicWatermark(Duration) | E-49 (line 84-89) | ○ |
| C-157 | EventTimeWatermarkGeneratorBuilder.perEventWatermark() | E-49 (line 91-94) | ○ |
| C-158 | EventTimeWatermarkGeneratorBuilder.buildAsProcessFunction() | E-49 (line 98-115) | ○ |
| C-159 | EventTimeWatermarkStrategy.getEventTimeExtractor() | E-50 (line 68-70) | ○ |
| C-160 | EventTimeWatermarkStrategy.getGenerateMode() | E-50 (line 72-74) | ○ |
| C-161 | EventTimeWatermarkStrategy.getPeriodicWatermarkInterval() | E-50 (line 76-78) | ○ |
| C-162 | EventTimeWatermarkStrategy.getIdleTimeout() | E-50 (line 80-82) | ○ |
| C-163 | EventTimeWatermarkStrategy.getMaxOutOfOrderTime() | E-50 (line 84-86) | ○ |

### Attribute関連 (UT-DSA-164 - UT-DSA-165)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-164 | NoOutputUntilEndOfInputアノテーション適用 | E-51 (line 33-36) | ○ |
| C-165 | 非有界ソースでのコンパイルエラー | E-51 (line 29-32 Javadoc) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全165件のテストケースについて、対応するソースコードのインターフェース定義が存在する。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: このモジュールはAPIインターフェース定義が中心であり、実装はflink-datastreamモジュールに存在する。テストケースはインターフェースの仕様に基づいて作成されているため、リスクは低い。

注意点:
- flink-datastreamモジュールが存在しない場合、リフレクションベースのメソッド（ExecutionEnvironment.getInstance(), BuiltinFuncs.join()等）はRuntimeExceptionをスローする
- StateManager.getCurrentKey()はKeyedPartitionStreamでのみ使用可能であり、他のストリームタイプで呼び出すとUnsupportedOperationExceptionがスローされる

## 6) レビュアーチェックリスト（最小）
- [ ] 状態管理関連のテストケース（UT-DSA-032〜042）がStateManagerの各種状態タイプを網羅しているか確認
- [ ] ストリーム変換テストケース（UT-DSA-056〜074）が主要なストリーム変換パターンを網羅しているか確認
- [ ] ウィンドウ処理テストケース（UT-DSA-108〜136）が各ウィンドウ戦略のライフサイクルを網羅しているか確認
- [ ] EventTime拡張テストケース（UT-DSA-137〜163）がウォーターマーク生成とタイマー管理を網羅しているか確認
- [ ] 異常系テストケース（null入力、未宣言状態など）が十分にカバーされているか確認
- [ ] 境界値テストケース（空コレクション、最小/最大値など）が適切に設計されているか確認
