---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 127
  claims_with_evidence: 127
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-datastream 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：127 / 127、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコードからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/ExecutionEnvironmentImpl.java`
- E-02: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/ExecutionEnvironmentFactory.java`
- E-03: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/DefaultStateManager.java`
- E-04: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/DefaultProcessingTimeManager.java`
- E-05: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/UnsupportedProcessingTimeManager.java`
- E-06: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/DefaultJobInfo.java`
- E-07: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/DefaultTaskInfo.java`
- E-08: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/DefaultNonPartitionedContext.java`
- E-09: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/DefaultPartitionedContext.java`
- E-10: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/context/DefaultRuntimeContext.java`
- E-11: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/operators/ProcessOperator.java`
- E-12: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/operators/KeyedProcessOperator.java`
- E-13: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/operators/TwoOutputProcessOperator.java`
- E-14: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/operators/TwoInputNonBroadcastProcessOperator.java`
- E-15: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/stream/KeyedPartitionStreamImpl.java`
- E-16: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/stream/NonKeyedPartitionStreamImpl.java`
- E-17: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/stream/GlobalStreamImpl.java`
- E-18: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/stream/BroadcastStreamImpl.java`
- E-19: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/common/OutputCollector.java`
- E-20: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/common/TimestampCollector.java`
- E-21: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/common/KeyCheckedOutputCollector.java`
- E-22: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/utils/StreamUtils.java`
- E-23: `flink-datastream/src/main/java/org/apache/flink/datastream/impl/attribute/AttributeParser.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ExecutionEnvironmentImpl（UT-DST-001 〜 UT-DST-015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newInstanceメソッドでcontextEnvironmentFactoryがnullの場合ローカル環境が生成される | E-01 (L110-120) | ○ |
| C-02 | newInstanceメソッドでcontextEnvironmentFactoryが設定されている場合ファクトリから環境生成 | E-01 (L111-113) | ○ |
| C-03 | executeメソッドでジョブが正常に実行される | E-01 (L135-142) | ○ |
| C-04 | getStreamGraphGeneratorでtransformationsが空の場合IllegalStateException | E-01 (L325-328) | ○ |
| C-05 | getExecutionModeで設定された実行モードが取得できる | E-01 (L145-147) | ○ |
| C-06 | setExecutionModeで実行モードが設定される | E-01 (L150-154) | ○ |
| C-07 | setExecutionModeでnullの場合NullPointerException | E-01 (L151: checkNotNull) | ○ |
| C-08 | fromSourceでWrappedSourceからストリーム生成 | E-01 (L167-182) | ○ |
| C-09 | fromSourceでFromDataSourceからストリーム生成 | E-01 (L183-194) | ○ |
| C-10 | fromSourceで未サポートSource型の場合UnsupportedOperationException | E-01 (L195-197) | ○ |
| C-11 | extractTypeInfoFromCollectionで空コレクションの場合IllegalArgumentException | E-01 (L230-232) | ○ |
| C-12 | extractTypeInfoFromCollectionでnull要素の場合IllegalArgumentException | E-01 (L234-237) | ○ |
| C-13 | addOperatorでTransformationが追加される | E-01 (L276-279) | ○ |
| C-14 | addOperatorでnullの場合NullPointerException | E-01 (L277: checkNotNull) | ○ |
| C-15 | getStreamGraphでStreamGraphが生成されtransformationsがクリア | E-01 (L318-322) | ○ |

### DefaultStateManager（UT-DST-016 〜 UT-DST-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | getCurrentKeyで現在のキーが取得できる | E-03 (L76-79) | ○ |
| C-17 | getStateOptional(ValueStateDeclaration)でOptionalが取得できる | E-03 (L82-90) | ○ |
| C-18 | getState(ValueStateDeclaration)でValueStateが取得できる | E-03 (L93-97) | ○ |
| C-19 | getStateで状態が利用不可の場合IllegalStateException | E-03 (L212-220) | ○ |
| C-20 | getStateOptional(ListStateDeclaration)でUnion戦略でListState取得 | E-03 (L109-117) | ○ |
| C-21 | getStateOptional(ListStateDeclaration)でSplit戦略でListState取得 | E-03 (L115-117) | ○ |
| C-22 | getStateOptional(MapStateDeclaration)でMapState取得 | E-03 (L131-141) | ○ |
| C-23 | getStateOptional(ReducingStateDeclaration)でReducingState取得 | E-03 (L152-161) | ○ |
| C-24 | getStateOptional(AggregatingStateDeclaration)でAggregatingState取得 | E-03 (L172-181) | ○ |
| C-25 | getStateOptional(BroadcastStateDeclaration)でBroadcastState取得 | E-03 (L192-202) | ○ |
| C-26 | executeInKeyContextで指定キーコンテキストで処理実行 | E-03 (L227-229) | ○ |

### DefaultProcessingTimeManager（UT-DST-027 〜 UT-DST-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | registerTimerで処理時間タイマー登録 | E-04 (L34-36) | ○ |
| C-28 | deleteTimerで処理時間タイマー削除 | E-04 (L39-41) | ○ |
| C-29 | currentTimeで現在の処理時間取得 | E-04 (L44-46) | ○ |

### UnsupportedProcessingTimeManager（UT-DST-030 〜 UT-DST-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | registerTimerでUnsupportedOperationException | E-05 (L34-37) | ○ |
| C-31 | deleteTimerでUnsupportedOperationException | E-05 (L40-43) | ○ |
| C-32 | currentTimeでUnsupportedOperationException | E-05 (L46-49) | ○ |

### DefaultJobInfo（UT-DST-033 〜 UT-DST-035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | getJobNameでジョブ名取得 | E-06 (L36-38) | ○ |
| C-34 | getExecutionModeでSTREAMINGモード返却 | E-06 (L41-43) | ○ |
| C-35 | getExecutionModeでBATCHモード返却 | E-06 (L41-43) | ○ |

### DefaultTaskInfo（UT-DST-036 〜 UT-DST-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | getParallelismで並列度取得 | E-07 (L48-50) | ○ |
| C-37 | getMaxParallelismで最大並列度取得 | E-07 (L53-55) | ○ |
| C-38 | getTaskNameでタスク名取得 | E-07 (L58-60) | ○ |
| C-39 | getIndexOfThisSubtaskでインデックス取得 | E-07 (L63-65) | ○ |
| C-40 | getAttemptNumberで試行回数取得 | E-07 (L68-70) | ○ |

### DefaultNonPartitionedContext（UT-DST-041 〜 UT-DST-046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | applyToAllPartitionsでキー付きオペレータで全パーティション処理 | E-08 (L67-82) | ○ |
| C-42 | applyToAllPartitionsで非キー付きオペレータで1回処理 | E-08 (L83-86) | ○ |
| C-43 | getWatermarkManagerでWatermarkManager取得 | E-08 (L90-92) | ○ |
| C-44 | getJobInfoでJobInfo取得 | E-08 (L95-97) | ○ |
| C-45 | getTaskInfoでTaskInfo取得 | E-08 (L100-102) | ○ |
| C-46 | getMetricGroupでMetricGroup取得 | E-08 (L105-107) | ○ |

### DefaultPartitionedContext（UT-DST-047 〜 UT-DST-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | setNonPartitionedContextでコンテキスト設定 | E-09 (L60-62) | ○ |
| C-48 | getNonPartitionedContextでコンテキスト取得 | E-09 (L65-67) | ○ |

### DefaultRuntimeContext（UT-DST-049 〜 UT-DST-051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | getJobInfoでJobInfo取得 | E-10 (L51-53) | ○ |
| C-50 | getTaskInfoでTaskInfo取得 | E-10 (L56-58) | ○ |
| C-51 | getMetricGroupでMetricGroup取得 | E-10 (L61-63) | ○ |

### ProcessOperator（UT-DST-052 〜 UT-DST-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | openでオペレータ初期化 | E-11 (L77-130) | ○ |
| C-53 | processElementでレコード処理 | E-11 (L133-136) | ○ |
| C-54 | processWatermarkInternalでウォーターマーク処理 | E-11 (L139-157) | ○ |
| C-55 | endInputで終了処理 | E-11 (L164-166) | ○ |
| C-56 | currentKeyでUnsupportedOperationException | E-11 (L168-170) | ○ |
| C-57 | closeでオペレータとuserFunctionクローズ | E-11 (L204-207) | ○ |

### KeyedProcessOperator（UT-DST-058 〜 UT-DST-061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | openでtimerService初期化 | E-12 (L53-57) | ○ |
| C-59 | onEventTimeでイベント時間タイマー発火処理 | E-12 (L60-65) | ○ |
| C-60 | onProcessingTimeで処理時間タイマー発火処理 | E-12 (L68-71) | ○ |
| C-61 | getProcessingTimeManagerでDefaultProcessingTimeManager返却 | E-12 (L74-76) | ○ |

### TwoOutputProcessOperator（UT-DST-062 〜 UT-DST-065）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | openで両コレクタ初期化 | E-13 (L91-135) | ○ |
| C-63 | processElementで両出力処理 | E-13 (L138-143) | ○ |
| C-64 | getSideCollectorでSideOutputCollector返却 | E-13 (L177-179) | ○ |
| C-65 | SideOutputCollector.collectでサイド出力収集 | E-13 (L228-230) | ○ |

### TwoInputNonBroadcastProcessOperator（UT-DST-066 〜 UT-DST-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | processElement1で第1入力処理 | E-14 (L135-138) | ○ |
| C-67 | processElement2で第2入力処理 | E-14 (L141-145) | ○ |
| C-68 | processWatermark1Internalで第1入力ウォーターマーク処理 | E-14 (L148-165) | ○ |
| C-69 | processWatermark2Internalで第2入力ウォーターマーク処理 | E-14 (L168-185) | ○ |
| C-70 | endInput(1)でendFirstInput呼び出し | E-14 (L203-211) | ○ |
| C-71 | endInput(2)でendSecondInput呼び出し | E-14 (L203-211) | ○ |
| C-72 | endInput(0)でcheckState失敗 | E-14 (L205: checkState) | ○ |
| C-73 | endInput(3)でcheckState失敗 | E-14 (L205: checkState) | ○ |

### KeyedPartitionStreamImpl（UT-DST-074 〜 UT-DST-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | process(OneInputStreamProcessFunction)で変換 | E-15 (L114-146) | ○ |
| C-75 | process(OneInputStreamProcessFunction, KeySelector)で変換 | E-15 (L149-190) | ○ |
| C-76 | process(TwoOutputStreamProcessFunction)で変換 | E-15 (L264-312) | ○ |
| C-77 | connectAndProcess(KeyedPartitionStream)で接続 | E-15 (L315-368) | ○ |
| C-78 | connectAndProcess(BroadcastStream)で接続 | E-15 (L416-441) | ○ |
| C-79 | globalでGlobalStream返却 | E-15 (L523-527) | ○ |
| C-80 | keyByで新しいKeyedPartitionStream返却 | E-15 (L530-533) | ○ |
| C-81 | shuffleでNonKeyedPartitionStream返却 | E-15 (L536-540) | ○ |
| C-82 | broadcastでBroadcastStream返却 | E-15 (L543-545) | ○ |
| C-83 | toSinkでSink接続 | E-15 (L511-516) | ○ |

### NonKeyedPartitionStreamImpl（UT-DST-084 〜 UT-DST-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | process(OneInputStreamProcessFunction)で変換 | E-16 (L72-112) | ○ |
| C-85 | process(TwoOutputStreamProcessFunction)で変換 | E-16 (L115-168) | ○ |
| C-86 | connectAndProcess(NonKeyedPartitionStream)で接続 | E-16 (L171-228) | ○ |
| C-87 | connectAndProcess(BroadcastStream)で接続 | E-16 (L231-258) | ○ |
| C-88 | globalでGlobalStream返却 | E-16 (L273-277) | ○ |
| C-89 | keyByでKeyedPartitionStream返却 | E-16 (L280-282) | ○ |
| C-90 | shuffleでNonKeyedPartitionStream返却 | E-16 (L285-289) | ○ |
| C-91 | broadcastでBroadcastStream返却 | E-16 (L292-294) | ○ |
| C-92 | toSinkでSink接続 | E-16 (L261-266) | ○ |

### GlobalStreamImpl（UT-DST-093 〜 UT-DST-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | process(OneInputStreamProcessFunction)で変換 | E-17 (L69-102) | ○ |
| C-94 | process(TwoOutputStreamProcessFunction)で変換 | E-17 (L105-148) | ○ |
| C-95 | connectAndProcessで接続 | E-17 (L151-199) | ○ |
| C-96 | toSinkで並列度1でSink接続 | E-17 (L202-210) | ○ |
| C-97 | keyByでKeyedPartitionStream返却 | E-17 (L217-219) | ○ |
| C-98 | shuffleでNonKeyedPartitionStream返却 | E-17 (L222-226) | ○ |
| C-99 | broadcastでBroadcastStream返却 | E-17 (L229-231) | ○ |

### BroadcastStreamImpl（UT-DST-100 〜 UT-DST-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | connectAndProcess(KeyedPartitionStream)で接続 | E-18 (L60-90) | ○ |
| C-101 | connectAndProcess(NonKeyedPartitionStream)で接続 | E-18 (L93-124) | ○ |

### OutputCollector（UT-DST-102 〜 UT-DST-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | collectでレコード出力 | E-19 (L34-36) | ○ |
| C-103 | collectAndOverwriteTimestampでタイムスタンプ付き出力 | E-19 (L39-42) | ○ |

### TimestampCollector（UT-DST-104 〜 UT-DST-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | setTimestampFromStreamRecordでタイムスタンプ設定 | E-20 (L28-34) | ○ |
| C-105 | setTimestampFromStreamRecordでタイムスタンプ消去 | E-20 (L31-33) | ○ |
| C-106 | setTimestampでタイムスタンプ設定 | E-20 (L36-38) | ○ |
| C-107 | eraseTimestampでタイムスタンプ消去 | E-20 (L40-42) | ○ |

### KeyCheckedOutputCollector（UT-DST-108 〜 UT-DST-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | collectでキー一致時にレコード出力 | E-21 (L49-52) | ○ |
| C-109 | collectでキー不一致時にIllegalStateException | E-21 (L60-71) | ○ |
| C-110 | collectAndOverwriteTimestampでキー一致時に出力 | E-21 (L55-58) | ○ |

### StreamUtils（UT-DST-111 〜 UT-DST-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | getOutputTypeForOneInputProcessFunctionで型抽出 | E-22 (L86-118) | ○ |
| C-112 | getOutputTypeForTwoInputNonBroadcastProcessFunctionで型抽出 | E-22 (L124-177) | ○ |
| C-113 | getOutputTypeForTwoInputBroadcastProcessFunctionで型抽出 | E-22 (L183-205) | ○ |
| C-114 | getOutputTypesForTwoOutputProcessFunctionで2出力型抽出 | E-22 (L211-275) | ○ |
| C-115 | getOneInputTransformationで変換生成 | E-22 (L278-296) | ○ |
| C-116 | getOneInputKeyedTransformationでキー付き変換生成 | E-22 (L299-314) | ○ |
| C-117 | getTwoInputTransformationで2入力変換生成 | E-22 (L317-368) | ○ |
| C-118 | getTwoInputTransformationでキー型不一致時例外 | E-22 (L383-391) | ○ |
| C-119 | addSinkOperatorでシンク追加 | E-22 (L539-562) | ○ |
| C-120 | addSinkOperatorでWrappedSinkでない場合例外 | E-22 (L544-547) | ○ |
| C-121 | wrapWithConfigureHandle(NonKeyedPartitionStreamImpl)でラッパー生成 | E-22 (L565-568) | ○ |
| C-122 | wrapWithConfigureHandle(KeyedPartitionStreamImpl)でラッパー生成 | E-22 (L571-574) | ○ |
| C-123 | wrapWithConfigureHandle(GlobalStreamImpl)でラッパー生成 | E-22 (L577-580) | ○ |
| C-124 | validateStatesで有効な状態宣言時正常終了 | E-22 (L583-594) | ○ |
| C-125 | validateStatesで無効な再配布モード時例外 | E-22 (L583-594) | ○ |

### AttributeParser（UT-DST-126 〜 UT-DST-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | parseAttributeでNoOutputUntilEndOfInputアノテーション解析 | E-23 (L28-35) | ○ |
| C-127 | parseAttributeでアノテーションなし時デフォルト返却 | E-23 (L28-35) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースにソースコードからの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいており、メソッドシグネチャと動作が確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの網羅性：各クラス・メソッドに対して正常系/異常系/境界値が適切にカバーされているか
- [ ] 優先度の妥当性：ビジネスロジック・状態管理・エラーハンドリングに関するテストが「高」になっているか
- [ ] 入力値の具体性：テスト実行に十分な具体性があるか
- [ ] 期待結果の明確性：検証可能な期待結果が記載されているか
- [ ] 前提条件の妥当性：テスト実行に必要な前提条件が現実的か
