---
generated_at: 2026-02-02 12:30:00
metrics:
  claims_total: 112
  claims_with_evidence: 112
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-dstl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：112 / 112、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/FsStateChangelogStorage.java`
- E-02: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/FsStateChangelogWriter.java`
- E-03: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/BatchingStateChangeUploadScheduler.java`
- E-04: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/StateChangeFsUploader.java`
- E-05: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/AbstractStateChangeFsUploader.java`
- E-06: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/RetryingExecutor.java`
- E-07: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/RetryPolicy.java`
- E-08: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/TaskChangelogRegistry.java`
- E-09: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/TaskChangelogRegistryImpl.java`
- E-10: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/StateChangeSet.java`
- E-11: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/StateChangeFormat.java`
- E-12: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/UploadThrottle.java`
- E-13: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/UploadResult.java`
- E-14: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/StateChangeUploadScheduler.java`
- E-15: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/StateChangeUploader.java`
- E-16: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/ChangelogStreamHandleReaderWithCache.java`
- E-17: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/ChangelogStreamHandleReader.java`
- E-18: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/OutputStreamWithPos.java`
- E-19: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/DuplicatingOutputStreamWithPos.java`
- E-20: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/DuplicatingStateChangeFsUploader.java`
- E-21: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/ChangelogStreamWrapper.java`
- E-22: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/FsStateChangelogStorageFactory.java`
- E-23: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/FsStateChangelogStorageForRecovery.java`
- E-24: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/StateChangeIteratorImpl.java`
- E-25: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/ChangelogStorageMetricGroup.java`
- E-26: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/SchedulerFactory.java`
- E-27: `flink-dstl/flink-dstl-dfs/src/main/java/org/apache/flink/changelog/fs/FsStateChangelogOptions.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FsStateChangelogStorage.createWriter - Writerの基本生成機能 | E-01 (L153-166) | ○ |
| C-02 | FsStateChangelogStorage.createWriter - logIdの一意性 | E-01 (L68, L155) | ○ |
| C-03 | FsStateChangelogStorage.close - リソース解放 | E-01 (L169-172) | ○ |
| C-04 | FsStateChangelogStorage.getAvailabilityProvider | E-01 (L175-177) | ○ |
| C-05 | FsStateChangelogWriter.append - データ追加 | E-02 (L183-191) | ○ |
| C-06 | FsStateChangelogWriter.append - クローズ後の呼び出し | E-02 (L185-188) | ○ |
| C-07 | FsStateChangelogWriter.appendMeta - メタデータ追加 | E-02 (L172-180) | ○ |
| C-08 | FsStateChangelogWriter.appendMeta - クローズ後の呼び出し | E-02 (L173-176) | ○ |
| C-09 | FsStateChangelogWriter.nextSequenceNumber | E-02 (L199-207) | ○ |
| C-10 | FsStateChangelogWriter.persist - 永続化基本機能 | E-02 (L210-218) | ○ |
| C-11 | FsStateChangelogWriter.persist - 失敗済みシーケンス | E-02 (L462-465) | ○ |
| C-12 | FsStateChangelogWriter.persist - トランケート済み | E-02 (L466-470) | ○ |
| C-13 | FsStateChangelogWriter.persist - 未追加シーケンス | E-02 (L471-476) | ○ |
| C-14 | FsStateChangelogWriter.truncate | E-02 (L341-350) | ○ |
| C-15 | FsStateChangelogWriter.truncate - 不正な位置 | E-02 (L343) | ○ |
| C-16 | FsStateChangelogWriter.truncateAndClose | E-02 (L353-358) | ○ |
| C-17 | FsStateChangelogWriter.close | E-02 (L330-338) | ○ |
| C-18 | FsStateChangelogWriter.close - 二重クローズ | E-02 (L332) | ○ |
| C-19 | FsStateChangelogWriter.confirm | E-02 (L374-399) | ○ |
| C-20 | FsStateChangelogWriter.confirm - 不正範囲 | E-02 (L375-382) | ○ |
| C-21 | FsStateChangelogWriter.reset | E-02 (L402-405) | ○ |
| C-22 | FsStateChangelogWriter.initialSequenceNumber | E-02 (L194-196) | ○ |
| C-23 | FsStateChangelogWriter.preEmptiveFlushIfNeeded - 閾値到達 | E-02 (L220-230) | ○ |
| C-24 | FsStateChangelogWriter.preEmptiveFlushIfNeeded - 閾値未満 | E-02 (L222) | ○ |
| C-25 | BatchingStateChangeUploadScheduler.upload | E-03 (L158-188) | ○ |
| C-26 | BatchingStateChangeUploadScheduler.upload - エラー後 | E-03 (L159-164) | ○ |
| C-27 | BatchingStateChangeUploadScheduler.upload - 割り込み | E-03 (L180-183) | ○ |
| C-28 | BatchingStateChangeUploadScheduler.upload - 容量制限 | E-03 (L169-175) | ○ |
| C-29 | BatchingStateChangeUploadScheduler.close | E-03 (L251-267) | ○ |
| C-30 | BatchingStateChangeUploadScheduler.close - タスクキャンセル | E-03 (L263-264) | ○ |
| C-31 | BatchingStateChangeUploadScheduler.scheduleUploadIfNeeded - 遅延0 | E-03 (L207) | ○ |
| C-32 | BatchingStateChangeUploadScheduler.scheduleUploadIfNeeded - サイズ閾値 | E-03 (L207) | ○ |
| C-33 | BatchingStateChangeUploadScheduler.getAvailabilityProvider | E-03 (L297-304) | ○ |
| C-34 | StateChangeFsUploader.prepareStream | E-04 (L87-95) | ○ |
| C-35 | StateChangeFsUploader.prepareStream - エラー | E-04 (L87-95) | ○ |
| C-36 | StateChangeFsUploader.getBasePath | E-04 (L82-84) | ○ |
| C-37 | AbstractStateChangeFsUploader.upload | E-05 (L66-73) | ○ |
| C-38 | AbstractStateChangeFsUploader.upload - メトリクス | E-05 (L67-72) | ○ |
| C-39 | AbstractStateChangeFsUploader.upload - IOエラー | E-05 (L97-106) | ○ |
| C-40 | AbstractStateChangeFsUploader.generateFileName | E-05 (L110-112) | ○ |
| C-41 | RetryingExecutor.execute | E-06 (L85-96) | ○ |
| C-42 | RetryingExecutor.execute - リトライ | E-06 (L254-258) | ○ |
| C-43 | RetryingExecutor.execute - 上限到達 | E-06 (L260-264) | ○ |
| C-44 | RetryingExecutor.close | E-06 (L99-121) | ○ |
| C-45 | RetryingExecutor.close - 例外処理 | E-06 (L101-120) | ○ |
| C-46 | RetryPolicy.FixedRetryPolicy.timeoutFor | E-07 (L91-93) | ○ |
| C-47 | RetryPolicy.FixedRetryPolicy.retryAfter - タイムアウト | E-07 (L100-101) | ○ |
| C-48 | RetryPolicy.FixedRetryPolicy.retryAfter - IOException | E-07 (L102-103) | ○ |
| C-49 | RetryPolicy.FixedRetryPolicy.retryAfter - 上限 | E-07 (L98-99) | ○ |
| C-50 | RetryPolicy.FixedRetryPolicy.retryAfter - 未知例外 | E-07 (L104-105) | ○ |
| C-51 | RetryPolicy.fromConfig - fixed | E-07 (L31-36) | ○ |
| C-52 | RetryPolicy.fromConfig - 無効ポリシー | E-07 (L40-42) | ○ |
| C-53 | TaskChangelogRegistryImpl.startTracking | E-09 (L47-54) | ○ |
| C-54 | TaskChangelogRegistryImpl.startTracking - 不正refCount | E-09 (L48) | ○ |
| C-55 | TaskChangelogRegistryImpl.stopTracking | E-09 (L57-61) | ○ |
| C-56 | TaskChangelogRegistryImpl.release | E-09 (L64-88) | ○ |
| C-57 | TaskChangelogRegistryImpl.release - 自動破棄 | E-09 (L77-83) | ○ |
| C-58 | TaskChangelogRegistryImpl.release - 未登録 | E-09 (L71-73) | ○ |
| C-59 | StateChangeSet.getSize | E-10 (L61-67) | ○ |
| C-60 | StateChangeSet.getSize - 空リスト | E-10 (L61-67) | ○ |
| C-61 | StateChangeSet.getChanges | E-10 (L57-59) | ○ |
| C-62 | StateChangeFormat.write | E-11 (L49-64) | ○ |
| C-63 | StateChangeFormat.write - ソート | E-11 (L52-55) | ○ |
| C-64 | StateChangeFormat.read | E-11 (L95-149) | ○ |
| C-65 | StateChangeFormat.read - メタデータ | E-11 (L138-140) | ○ |
| C-66 | StateChangeFormat.read - 空ストリーム | E-11 (L103-105) | ○ |
| C-67 | UploadThrottle.seizeCapacity | E-12 (L44-47) | ○ |
| C-68 | UploadThrottle.seizeCapacity - 不足 | E-12 (L45) | ○ |
| C-69 | UploadThrottle.releaseCapacity | E-12 (L53-55) | ○ |
| C-70 | UploadThrottle.hasCapacity - 境界 | E-12 (L58-60) | ○ |
| C-71 | UploadThrottle.hasCapacity | E-12 (L58-60) | ○ |
| C-72 | UploadResult.of | E-13 (L61-74) | ○ |
| C-73 | UploadResult.getStreamStateHandle | E-13 (L76-78) | ○ |
| C-74 | UploadTask.complete | E-14 (L153-156) | ○ |
| C-75 | UploadTask.complete - 二重完了 | E-14 (L154) | ○ |
| C-76 | UploadTask.fail | E-14 (L159-166) | ○ |
| C-77 | UploadTask.fail - 二重失敗 | E-14 (L160) | ○ |
| C-78 | UploadTask.getSize | E-14 (L169-175) | ○ |
| C-79 | ChangelogStreamHandleReaderWithCache.openAndSeek - キャッシュ作成 | E-16 (L87-104) | ○ |
| C-80 | ChangelogStreamHandleReaderWithCache.openAndSeek - シーク | E-16 (L152-159) | ○ |
| C-81 | ChangelogStreamHandleReaderWithCache.openAndSeek - ローカル | E-16 (L106-113) | ○ |
| C-82 | ChangelogStreamHandleReaderWithCache.openAndSeek - 再利用 | E-16 (L115-124) | ○ |
| C-83 | ChangelogStreamHandleReaderWithCache.close | E-16 (L210-225) | ○ |
| C-84 | ChangelogStreamHandleReaderWithCache.cleanCacheFile | E-16 (L191-207) | ○ |
| C-85 | OutputStreamWithPos.write(int) | E-18 (L63-66) | ○ |
| C-86 | OutputStreamWithPos.write(byte[]) | E-18 (L69-72) | ○ |
| C-87 | OutputStreamWithPos.wrap | E-18 (L57-60) | ○ |
| C-88 | OutputStreamWithPos.close | E-18 (L86-93) | ○ |
| C-89 | OutputStreamWithPos.close - エラー | E-18 (L90-92) | ○ |
| C-90 | OutputStreamWithPos.getHandle | E-18 (L103-105) | ○ |
| C-91 | DuplicatingOutputStreamWithPos.write | E-19 (L69-107) | ○ |
| C-92 | DuplicatingOutputStreamWithPos.write - セカンダリエラー | E-19 (L71-77, L84-90, L98-105) | ○ |
| C-93 | DuplicatingOutputStreamWithPos.getSecondaryHandle | E-19 (L165-173) | ○ |
| C-94 | DuplicatingOutputStreamWithPos.getSecondaryHandle - エラー後 | E-19 (L169-172) | ○ |
| C-95 | DuplicatingStateChangeFsUploader.prepareStream | E-20 (L92-107) | ○ |
| C-96 | ChangelogStreamWrapper.wrap - 圧縮 | E-21 (L34-51) | ○ |
| C-97 | ChangelogStreamWrapper.wrap - 非圧縮 | E-21 (L36-41) | ○ |
| C-98 | ChangelogStreamWrapper.wrapAndSeek | E-21 (L53-61) | ○ |
| C-99 | ChangelogStreamWrapper.wrapAndSeek - オフセット0 | E-21 (L56-59) | ○ |
| C-100 | FsStateChangelogStorageFactory.createStorage | E-22 (L50-57) | ○ |
| C-101 | FsStateChangelogStorageFactory.createStorageView | E-22 (L60-63) | ○ |
| C-102 | FsStateChangelogStorageFactory.getIdentifier | E-22 (L45-47) | ○ |
| C-103 | FsStateChangelogStorageFactory.configure | E-22 (L65-74) | ○ |
| C-104 | FsStateChangelogStorageForRecovery.createReader | E-23 (L44-47) | ○ |
| C-105 | FsStateChangelogStorageForRecovery.close | E-23 (L50-54) | ○ |
| C-106 | FsStateChangelogStorageForRecovery.close - null | E-23 (L51-53) | ○ |
| C-107 | StateChangeIteratorImpl.read | E-24 (L39-43) | ○ |
| C-108 | ChangelogStorageMetricGroup.getUploadsCounter | E-25 (L74-76) | ○ |
| C-109 | ChangelogStorageMetricGroup.registerUploadQueueSizeGauge | E-25 (L106-108) | ○ |
| C-110 | UploadTasksResult.complete | E-15 (L71-78) | ○ |
| C-111 | UploadTasksResult.discard | E-15 (L98-100) | ○ |
| C-112 | SchedulerFactory.create | E-26 (L45-56) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースは対象ソースコードから直接導出されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり

本モジュール（flink-dstl）は分散状態変更ログ（Distributed State Table Log）のファイルシステム実装を提供しています。主要なクラスは以下の通りです：

1. **FsStateChangelogStorage**: 状態変更ログストレージの主要実装
2. **FsStateChangelogWriter**: 状態変更を書き込むWriter
3. **BatchingStateChangeUploadScheduler**: アップロードのバッチングとスケジューリング
4. **RetryingExecutor**: リトライ機能付き実行エンジン
5. **TaskChangelogRegistryImpl**: タスク側の変更ログレジストリ

テストケースはこれらのクラスの公開メソッドを網羅的にカバーしており、正常系・異常系・境界値のテストを含んでいます。

## 6) レビュアーチェックリスト（最小）
- [ ] FsStateChangelogStorageの初期化パラメータが適切に検証されているか確認
- [ ] FsStateChangelogWriterの並行性に関するテストケースが十分か確認
- [ ] BatchingStateChangeUploadSchedulerのバックプレッシャー動作を確認
- [ ] RetryPolicyのリトライロジックが業務要件に合致しているか確認
- [ ] ChangelogStreamHandleReaderWithCacheのキャッシュ管理が適切か確認
- [ ] メトリクス関連のテストが運用要件を満たしているか確認
