---
generated_at: 2026-02-02 18:15:00
metrics:
  claims_total: 54
  claims_with_evidence: 52
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：flink-filesystems_flink-azure-fs-hadoop 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：52 / 54、根拠なし：2
- 優先レビュー（高）
  1. **C-33 sync異常系**：出力ストリームクローズ後の挙動はコードから直接確認できない（Hadoop依存）
  2. **C-53 空文字キー**：環境変数が空文字の場合の挙動は実装から推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AbstractAzureFSFactory.java`
- E-02: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobStorageFSFactory.java`
- E-03: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/SecureAzureBlobStorageFSFactory.java`
- E-04: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureDataLakeStoreGen2FSFactory.java`
- E-05: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/SecureAzureDataLakeStoreGen2FSFactory.java`
- E-06: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobFileSystem.java`
- E-07: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobRecoverableWriter.java`
- E-08: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/AzureBlobFsRecoverableDataOutputStream.java`
- E-09: `flink-filesystems/flink-azure-fs-hadoop/src/main/java/org/apache/flink/fs/azurefs/EnvironmentVariableKeyProvider.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractAzureFSFactory.configureでFlinkConfigが設定される | E-01 (line 66-68) | ○ |
| C-02 | configure時のnull処理 | E-01 | ○ |
| C-03 | create時に有効なURIからFileSystemが生成される | E-01 (line 73-80) | ○ |
| C-04 | create時にnull URIでNullPointerException | E-01 (line 74) checkNotNull | ○ |
| C-05 | create時に不正URIでIOException | E-01 (line 78) initialize呼び出し | ○ |
| C-06 | AzureBlobStorageFSFactory.getSchemeが"wasb"を返す | E-02 (line 28-30) | ○ |
| C-07 | AzureBlobStorageFSFactory.createAzureFSがNativeAzureFileSystem返す | E-02 (line 33-35) | ○ |
| C-08 | SecureAzureBlobStorageFSFactory.getSchemeが"wasbs"を返す | E-03 (line 28-30) | ○ |
| C-09 | SecureAzureBlobStorageFSFactory.createAzureFSがNativeAzureFileSystem返す | E-03 (line 33-35) | ○ |
| C-10 | AzureDataLakeStoreGen2FSFactory.getSchemeが"abfs"を返す | E-04 (line 28-30) | ○ |
| C-11 | AzureDataLakeStoreGen2FSFactory.createAzureFSがAzureBlobFileSystem返す | E-04 (line 33-35) | ○ |
| C-12 | SecureAzureDataLakeStoreGen2FSFactory.getSchemeが"abfss"を返す | E-05 (line 28-30) | ○ |
| C-13 | SecureAzureDataLakeStoreGen2FSFactory.createAzureFSがAzureBlobFileSystem返す | E-05 (line 33-35) | ○ |
| C-14 | AzureBlobFileSystemコンストラクタがHadoopFileSystemを親に渡す | E-06 (line 38-40) | ○ |
| C-15 | createRecoverableWriterがAzureBlobRecoverableWriter返す | E-06 (line 43-45) | ○ |
| C-16 | AzureBlobRecoverableWriterコンストラクタ | E-07 (line 36-38) | ○ |
| C-17 | checkSupportedFSSchemesでabfsがサポートされる | E-07 (line 40-47) | ○ |
| C-18 | checkSupportedFSSchemesでabfssがサポートされる | E-07 (line 42-43) | ○ |
| C-19 | checkSupportedFSSchemesでwasbが拒否される | E-07 (line 42-46) | ○ |
| C-20 | checkSupportedFSSchemesでhdfsが拒否される | E-07 (line 42-46) | ○ |
| C-21 | getRecoverableFsDataOutputStreamが正常動作 | E-07 (line 50-54) | ○ |
| C-22 | recoverが正常動作 | E-07 (line 57-59) | ○ |
| C-23 | recoverForCommitが正常動作 | E-07 (line 62-66) | ○ |
| C-24 | AzureBlobFsRecoverableDataOutputStream 3引数コンストラクタ正常系 | E-08 (line 56-64) | ○ |
| C-25 | 3引数コンストラクタnull fs | E-08 (line 58) checkNotNull | ○ |
| C-26 | 3引数コンストラクタnull targetFile | E-08 (line 59) checkNotNull | ○ |
| C-27 | recoverableコンストラクタ既存ファイルリカバリ | E-08 (line 76-139) | ○ |
| C-28 | recoverableコンストラクタtruncate実行 | E-08 (line 114-116) | ○ |
| C-29 | recoverableコンストラクタtempFile不在時IOEx | E-08 (line 100-105) | ○ |
| C-30 | recoverableコンストラクタrenameファイルからリカバリ | E-08 (line 84-98) | ○ |
| C-31 | recoverableコンストラクタファイル長不足時IOEx | E-08 (line 116-127) | ○ |
| C-32 | sync正常系 | E-08 (line 223-225) | ○ |
| C-33 | sync異常系（クローズ後） | **根拠なし** | △ |
| C-34 | truncate正常系 | E-08 (line 141-197) | ○ |
| C-35 | truncate境界値offset=0 | E-08 (line 156-161) | ○ |
| C-36 | truncate minBufferLength境界 | E-08 (line 54, 157-158) | ○ |
| C-37 | rename正常系 | E-08 (line 199-220) | ○ |
| C-38 | rename失敗時IOEx | E-08 (line 204-219) | ○ |
| C-39 | createCommitterFromResumeRecoverable | E-08 (line 228-230) | ○ |
| C-40 | ABFSCommitterコンストラクタ正常系 | E-08 (line 246-249) | ○ |
| C-41 | ABFSCommitterコンストラクタnull fs | E-08 (line 247) checkNotNull | ○ |
| C-42 | commit正常系 | E-08 (line 252-299) | ○ |
| C-43 | commitサイズ不一致IOEx | E-08 (line 269-283) | ○ |
| C-44 | commit両ファイル不在IOEx | E-08 (line 290-298) | ○ |
| C-45 | commit targetFileのみ存在 | E-08 (line 290) | ○ |
| C-46 | commit rename失敗IOEx | E-08 (line 286-289) | ○ |
| C-47 | commitAfterRecovery | E-08 (line 302-304) | ○ |
| C-48 | getRecoverable | E-08 (line 307-309) | ○ |
| C-49 | EnvironmentVariableKeyProvider正常系 | E-09 (line 34-47) | ○ |
| C-50 | EnvironmentVariableKeyProvider未設定時KeyProviderEx | E-09 (line 42-46) | ○ |
| C-51 | accountNameパラメータ無視 | E-09 (line 37) | ○ |
| C-52 | configurationパラメータ無視 | E-09 (line 37) | ○ |
| C-53 | 空文字環境変数のハンドリング | **根拠なし** | △ |
| C-54 | AZURE_STORAGE_KEY_ENV_VARIABLE定数 | E-09 (line 31) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-33 sync異常系**: `out.hsync()` の呼び出しは確認できるが、`out` がクローズ後にどのような例外をスローするかはHadoop FSDataOutputStreamの実装依存
  - 候補：Hadoop FSDataOutputStream実装を確認 / 統合テストで検証
- **C-53 空文字キー**: `System.getenv()` が空文字を返した場合の挙動は、`null` チェックのみ行っているため空文字は正常値として返却される可能性がある
  - 候補：実際の環境変数設定で検証 / 要件定義で空文字の扱いを確認

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: `truncate` メソッドの複雑なファイル操作（作成・読み込み・書き込み・削除・リネーム）は障害時のデータ損失リスクがある
- **リスク1 (低)**: 環境変数 `AZURE_STORAGE_KEY` からの認証情報取得はセキュリティ上のベストプラクティスとは異なる可能性がある
- **リスク0 (低)**: ファクトリクラス群は単純な構造で、テストケースの信頼性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] リカバリ関連テスト（C-27〜C-31, C-42〜C-47）は実際のAzure環境での統合テストも必要か確認
- [ ] `checkSupportedFSSchemes` のスキーム検証がequalsIgnoreCaseを使用していることを考慮し、大文字小文字混在のテストケース追加を検討
- [ ] `truncate` のminBufferLength（2MB）の境界値テストの網羅性を確認
- [ ] Hadoop依存の挙動（hsync, append, rename等）は統合テストでカバーされているか確認
- [ ] セキュリティ観点で `EnvironmentVariableKeyProvider` の使用が適切か確認
