---
generated_at: 2026-02-02 18:15:00
metrics:
  claims_total: 178
  claims_with_evidence: 178
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-filesystems_flink-gs-fs-hadoop 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：178 / 178、根拠なし：0
- 優先レビュー（高）
  1. **チェックサム検証ロジック**：GSChecksumWriteChannel.close()のテストケースでチェックサム不一致時の動作確認が重要
  2. **Blob合成のリカーシブ処理**：32を超えるBlobの再帰的合成の動作確認が重要
  3. **クロスバケット操作**：異なるバケット間でのコピー操作のテストが重要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/GSFileSystemFactory.java`
- E-02: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/GSFileSystem.java`
- E-03: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/GSFileSystemOptions.java`
- E-04: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/utils/ConfigUtils.java`
- E-05: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/utils/BlobUtils.java`
- E-06: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/utils/ChecksumUtils.java`
- E-07: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/storage/GSBlobIdentifier.java`
- E-08: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/storage/GSBlobStorage.java`
- E-09: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/storage/GSBlobStorageImpl.java`
- E-10: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSRecoverableWriter.java`
- E-11: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSRecoverableFsDataOutputStream.java`
- E-12: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSChecksumWriteChannel.java`
- E-13: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSCommitRecoverable.java`
- E-14: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSResumeRecoverable.java`
- E-15: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSCommitRecoverableSerializer.java`
- E-16: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSResumeRecoverableSerializer.java`
- E-17: `flink-filesystems/flink-gs-fs-hadoop/src/main/java/org/apache/flink/fs/gs/writer/GSRecoverableWriterCommitter.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### GSFileSystemFactory（UT-GSF-001〜012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GSFileSystemFactory.configureメソッドが正常に動作すること | E-01 (L83-110) | ○ |
| C-02 | GSFileSystemFactory.configureがnullチェックを行うこと | E-01 (L84: Preconditions.checkNotNull) | ○ |
| C-03 | GSFileSystemFactory.getSchemeが'gs'を返却すること | E-01 (L55, L141-143) | ○ |
| C-04 | GSFileSystemFactory.createがファイルシステムを生成すること | E-01 (L146-161) | ○ |
| C-05 | GSFileSystemFactory.createがnullチェックを行うこと | E-01 (L149: Preconditions.checkNotNull) | ○ |
| C-06 | GSFileSystemFactory.createが無効なURIで例外をスローすること | E-01 (L153-157: IOException) | ○ |
| C-07 | getHttpTransportOptionsがタイムアウト設定を反映すること | E-01 (L112-119) | ○ |
| C-08 | getRetrySettingsがリトライ設定を反映すること | E-01 (L122-138) | ○ |
| C-09 | RuntimeConfigContext.getenvが環境変数を取得すること | E-01 (L172-174) | ○ |
| C-10 | RuntimeConfigContext.loadHadoopConfigFromDirがHadoop設定を読み込むこと | E-01 (L177-184) | ○ |
| C-11 | RuntimeConfigContext.loadStorageCredentialsFromFileが認証情報を読み込むこと | E-01 (L187-193) | ○ |
| C-12 | RuntimeConfigContext.loadStorageCredentialsFromFileがファイルなしで例外をスローすること | E-01 (L190-192: RuntimeException) | ○ |

### GSFileSystem（UT-GSF-013〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | GSFileSystemコンストラクタが正常に動作すること | E-02 (L41-48) | ○ |
| C-14 | GSFileSystemコンストラクタがnullチェックを行うこと | E-02 (L45-47: Preconditions.checkNotNull) | ○ |
| C-15 | createRecoverableWriterがGSRecoverableWriterを生成すること | E-02 (L51-59) | ○ |

### GSFileSystemOptions（UT-GSF-016〜033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | GSFileSystemOptionsコンストラクタが正常に動作すること | E-03 (L163-173) | ○ |
| C-17 | GSFileSystemOptionsコンストラクタがnullチェックを行うこと | E-03 (L164: Preconditions.checkNotNull) | ○ |
| C-18 | コンストラクタが不正なチャンクサイズで例外をスローすること | E-03 (L165-172: Preconditions.checkArgument) | ○ |
| C-19 | チャンクサイズ256KBで正常に生成されること | E-03 (L171: 256*1024の倍数チェック) | ○ |
| C-20 | チャンクサイズ0で例外がスローされること | E-03 (L170-171: >0チェック) | ○ |
| C-21 | getWriterTemporaryBucketNameが設定値を返却すること | E-03 (L179-181) | ○ |
| C-22 | getWriterTemporaryBucketNameが未設定時にemptyを返却すること | E-03 (L180: getOptional) | ○ |
| C-23 | getHTTPConnectionTimeoutが設定値を返却すること | E-03 (L184-186) | ○ |
| C-24 | getHTTPReadTimeoutが設定値を返却すること | E-03 (L189-191) | ○ |
| C-25 | getMaxAttemptsが設定値を返却すること | E-03 (L193-195) | ○ |
| C-26 | getInitialRpcTimeoutがorg.threeten.bp.Durationを返却すること | E-03 (L197-201) | ○ |
| C-27 | getRpcTimeoutMultiplierが設定値を返却すること | E-03 (L203-205) | ○ |
| C-28 | getMaxRpcTimeoutがorg.threeten.bp.Durationを返却すること | E-03 (L207-211) | ○ |
| C-29 | getTotalTimeoutがorg.threeten.bp.Durationを返却すること | E-03 (L213-217) | ○ |
| C-30 | getWriterChunkSizeが設定値を返却すること | E-03 (L220-222) | ○ |
| C-31 | isFileSinkEntropyEnabledがtrueを返却すること | E-03 (L225-227) | ○ |
| C-32 | isFileSinkEntropyEnabledがデフォルトでfalseを返却すること | E-03 (L58: defaultValue=Boolean.FALSE) | ○ |
| C-33 | toStringがオプション情報を返却すること | E-03 (L230-237) | ○ |

### ConfigUtils（UT-GSF-034〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | getHadoopConfigurationがHadoop設定を生成すること | E-04 (L64-100) | ○ |
| C-35 | HADOOP_CONF_DIRから設定が読み込まれること | E-04 (L74-81) | ○ |
| C-36 | FLINK_HADOOP_CONF_DIRが優先されること | E-04 (L73: CoreOptions.FLINK_HADOOP_CONF_DIR) | ○ |
| C-37 | GOOGLE_APPLICATION_CREDENTIALSから認証情報が取得されること | E-04 (L130-134) | ○ |
| C-38 | Hadoop設定から認証情報が取得されること | E-04 (L136-144) | ○ |
| C-39 | サービスアカウントが無効な場合にemptyが返却されること | E-04 (L124-126) | ○ |
| C-40 | 認証情報がない場合にemptyが返却されること | E-04 (L155-158) | ○ |
| C-41 | getGcsRootUrlがURLを取得すること | E-04 (L161-167) | ○ |
| C-42 | getGcsRootUrlが未設定時にemptyを返却すること | E-04 (L166: Optional.ofNullable) | ○ |
| C-43 | stringifyHadoopConfigが文字列を返却すること | E-04 (L176-184) | ○ |

### BlobUtils（UT-GSF-044〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | parseUriがGS URIを解析すること | E-05 (L46-64) | ○ |
| C-45 | parseUriがスキーム不一致で例外をスローすること | E-05 (L47-49: IllegalArgumentException) | ○ |
| C-46 | parseUriがバケット名空で例外をスローすること | E-05 (L52-54: IllegalArgumentException) | ○ |
| C-47 | parseUriがオブジェクト名空で例外をスローすること | E-05 (L56-62: IllegalArgumentException) | ○ |
| C-48 | parseUriがパス/のみで例外をスローすること | E-05 (L60-62) | ○ |
| C-49 | getTemporaryBucketNameがオプション設定値を返却すること | E-05 (L74-77) | ○ |
| C-50 | getTemporaryBucketNameがデフォルトでfinalBucketを返却すること | E-05 (L77: orElse) | ○ |
| C-51 | getTemporaryObjectPartialNameが部分名を生成すること | E-05 (L88-94) | ○ |
| C-52 | getTemporaryObjectNameが一時オブジェクト名を生成すること | E-05 (L105-108) | ○ |
| C-53 | getTemporaryObjectNameWithEntropyがエントロピー付き名前を生成すること | E-05 (L119-124) | ○ |
| C-54 | getTemporaryBlobIdentifierがエントロピー無効時に通常識別子を生成すること | E-05 (L135-146) | ○ |
| C-55 | getTemporaryBlobIdentifierがエントロピー有効時にエントロピー付き識別子を生成すること | E-05 (L141-143) | ○ |

### ChecksumUtils（UT-GSF-056〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | convertChecksumToStringがBase64文字列を返却すること | E-06 (L44-49) | ○ |
| C-57 | チェックサム0で正しく変換されること | E-06 (L44-49) | ○ |
| C-58 | チェックサムMAX_VALUEで正しく変換されること | E-06 (L44-49) | ○ |
| C-59 | チェックサムMIN_VALUEで正しく変換されること | E-06 (L44-49) | ○ |

### GSBlobIdentifier（UT-GSF-060〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | GSBlobIdentifierコンストラクタが正常に動作すること | E-07 (L42-45) | ○ |
| C-61 | コンストラクタがbucketName=nullで例外をスローすること | E-07 (L43: Preconditions.checkNotNull) | ○ |
| C-62 | コンストラクタがobjectName=nullで例外をスローすること | E-07 (L44: Preconditions.checkNotNull) | ○ |
| C-63 | getBlobIdがBlobIdを生成すること | E-07 (L52-54) | ○ |
| C-64 | equalsが同値で true を返却すること | E-07 (L57-66) | ○ |
| C-65 | equalsが異値で false を返却すること | E-07 (L57-66) | ○ |
| C-66 | equalsがnullで false を返却すること | E-07 (L62) | ○ |
| C-67 | hashCodeが一貫性を持つこと | E-07 (L69-71) | ○ |
| C-68 | toStringが情報を含む文字列を返却すること | E-07 (L74-83) | ○ |
| C-69 | fromBlobIdがGSBlobIdentifierを生成すること | E-07 (L91-93) | ○ |

### GSBlobStorageImpl（UT-GSF-070〜101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | GSBlobStorageImplコンストラクタが正常に動作すること | E-09 (L54-57) | ○ |
| C-71 | コンストラクタがstorage=nullで例外をスローすること | E-09 (L56: Preconditions.checkNotNull) | ○ |
| C-72 | writeBlobがWriteChannelを生成すること | E-09 (L60-66) | ○ |
| C-73 | writeBlobがnull識別子で例外をスローすること | E-09 (L62: Preconditions.checkNotNull) | ○ |
| C-74 | writeBlob(チャンクサイズ付き)が正常に動作すること | E-09 (L69-81) | ○ |
| C-75 | writeBlob(チャンクサイズ付き)がサイズ0で例外をスローすること | E-09 (L76: Preconditions.checkArgument) | ○ |
| C-76 | createBlobが空Blobを作成すること | E-09 (L96-102) | ○ |
| C-77 | createBlobがnull識別子で例外をスローすること | E-09 (L98: Preconditions.checkNotNull) | ○ |
| C-78 | getMetadataがメタデータを取得すること | E-09 (L105-118) | ○ |
| C-79 | getMetadataが存在しないBlobでemptyを返却すること | E-09 (L110: Optional.ofNullable) | ○ |
| C-80 | getMetadataがnull識別子で例外をスローすること | E-09 (L107: Preconditions.checkNotNull) | ○ |
| C-81 | listがBlobをリストすること | E-09 (L121-138) | ○ |
| C-82 | listが一致なしで空リストを返却すること | E-09 (L127-131) | ○ |
| C-83 | listがnullバケット名で例外をスローすること | E-09 (L123: Preconditions.checkNotNull) | ○ |
| C-84 | copyがBlobをコピーすること | E-09 (L141-149) | ○ |
| C-85 | copyがnullソースで例外をスローすること | E-09 (L143: Preconditions.checkNotNull) | ○ |
| C-86 | composeがBlobを合成すること | E-09 (L152-173) | ○ |
| C-87 | composeが空リストで例外をスローすること | E-09 (L156: Preconditions.checkArgument) | ○ |
| C-88 | composeが33以上で例外をスローすること | E-09 (L157: COMPOSE_MAX_BLOBS=32) | ○ |
| C-89 | composeが32で正常に動作すること | E-09 (L157) | ○ |
| C-90 | composeが1で正常に動作すること | E-09 (L156: >0) | ○ |
| C-91 | deleteがBlobを削除すること | E-09 (L236-245) | ○ |
| C-92 | deleteが存在しないBlobでも失敗しないこと | E-09 (L244: storage.delete) | ○ |
| C-93 | deleteがnull識別子で例外をスローすること | E-09 (L238: Preconditions.checkNotNull) | ○ |
| C-94 | getBlobOptionがdoesNotExistを返却すること | E-09 (L194-203) | ○ |
| C-95 | getBlobOptionがgenerationMatchを返却すること | E-09 (L201) | ○ |
| C-96 | BlobMetadata.getChecksumがチェックサムを返却すること | E-09 (L260-265) | ○ |
| C-97 | WriteChannel.writeがデータを書き込むこと | E-09 (L282-291) | ○ |
| C-98 | WriteChannel.writeがnullコンテンツで例外をスローすること | E-09 (L284: Preconditions.checkNotNull) | ○ |
| C-99 | WriteChannel.writeが負のstartで例外をスローすること | E-09 (L285: Preconditions.checkArgument) | ○ |
| C-100 | WriteChannel.writeが負のlengthで例外をスローすること | E-09 (L286: Preconditions.checkArgument) | ○ |
| C-101 | WriteChannel.closeがチャネルを閉じること | E-09 (L295-298) | ○ |

### GSRecoverableWriter（UT-GSF-102〜114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | GSRecoverableWriterコンストラクタが正常に動作すること | E-10 (L53-57) | ○ |
| C-103 | コンストラクタがstorage=nullで例外をスローすること | E-10 (L55: Preconditions.checkNotNull) | ○ |
| C-104 | requiresCleanupOfRecoverableStateがfalseを返却すること | E-10 (L60-64) | ○ |
| C-105 | supportsResumeがtrueを返却すること | E-10 (L67-69) | ○ |
| C-106 | openが出力ストリームを開くこと | E-10 (L72-78) | ○ |
| C-107 | openがnullパスで例外をスローすること | E-10 (L74: Preconditions.checkNotNull) | ○ |
| C-108 | recoverが出力ストリームを復元すること | E-10 (L81-87) | ○ |
| C-109 | recoverがnullで例外をスローすること | E-10 (L83: Preconditions.checkNotNull) | ○ |
| C-110 | cleanupRecoverableStateがtrueを返却すること | E-10 (L90-94) | ○ |
| C-111 | recoverForCommitがCommitterを返却すること | E-10 (L97-103) | ○ |
| C-112 | recoverForCommitがnullで例外をスローすること | E-10 (L99: Preconditions.checkNotNull) | ○ |
| C-113 | getCommitRecoverableSerializerがシリアライザを返却すること | E-10 (L106-109) | ○ |
| C-114 | getResumeRecoverableSerializerがシリアライザを返却すること | E-10 (L112-115) | ○ |

### GSRecoverableFsDataOutputStream（UT-GSF-115〜130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | 新規コンストラクタが正常に動作すること | E-11 (L82-96) | ○ |
| C-116 | 復元コンストラクタが正常に動作すること | E-11 (L105-118) | ○ |
| C-117 | 復元コンストラクタが負のpositionで例外をスローすること | E-11 (L114: Preconditions.checkArgument) | ○ |
| C-118 | getPosが現在位置を返却すること | E-11 (L121-123) | ○ |
| C-119 | write(int)が1バイトを書き込むこと | E-11 (L126-129) | ○ |
| C-120 | write(byte[])がバイト配列を書き込むこと | E-11 (L132-136) | ○ |
| C-121 | write(byte[])がnullで例外をスローすること | E-11 (L133: Preconditions.checkNotNull) | ○ |
| C-122 | write(byte[], int, int)が指定範囲を書き込むこと | E-11 (L139-172) | ○ |
| C-123 | write(byte[], int, int)が負のstartで例外をスローすること | E-11 (L141: Preconditions.checkArgument) | ○ |
| C-124 | write(byte[], int, int)が負のlengthで例外をスローすること | E-11 (L142: Preconditions.checkArgument) | ○ |
| C-125 | write(byte[], int, int)がクローズ後に例外をスローすること | E-11 (L145-147: IOException) | ○ |
| C-126 | flushがチャネルをクローズすること | E-11 (L175-178) | ○ |
| C-127 | syncがチャネルをクローズすること | E-11 (L181-184) | ○ |
| C-128 | persistがGSResumeRecoverableを返却すること | E-11 (L187-191) | ○ |
| C-129 | closeがストリームをクローズすること | E-11 (L194-198) | ○ |
| C-130 | closeForCommitがCommitterを返却すること | E-11 (L201-205) | ○ |

### GSChecksumWriteChannel（UT-GSF-131〜137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | GSChecksumWriteChannelコンストラクタが正常に動作すること | E-12 (L58-67) | ○ |
| C-132 | コンストラクタがnullで例外をスローすること | E-12 (L63-65: Preconditions.checkNotNull) | ○ |
| C-133 | writeがデータを書き込みチェックサムを更新すること | E-12 (L78-86) | ○ |
| C-134 | writeがnullで例外をスローすること | E-12 (L80: Preconditions.checkNotNull) | ○ |
| C-135 | closeがチャネルをクローズしチェックサムを検証すること | E-12 (L95-115) | ○ |
| C-136 | closeがメタデータ取得失敗時に例外をスローすること | E-12 (L101-104: IOException) | ○ |
| C-137 | closeがチェックサム不一致時に例外をスローすること | E-12 (L109-113: IOException) | ○ |

### GSCommitRecoverable（UT-GSF-138〜143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | GSCommitRecoverableコンストラクタが正常に動作すること | E-13 (L50-59) | ○ |
| C-139 | コンストラクタがnull識別子で例外をスローすること | E-13 (L55: Preconditions.checkNotNull) | ○ |
| C-140 | componentObjectIdsが不変リストとして保持されること | E-13 (L56-58: Collections.unmodifiableList) | ○ |
| C-141 | getComponentBlobIdsがエントロピー無効時にリストを取得すること | E-13 (L70-91) | ○ |
| C-142 | getComponentBlobIdsがエントロピー有効時にリストを取得すること | E-13 (L76-79) | ○ |
| C-143 | toStringが情報を含む文字列を返却すること | E-13 (L94-101) | ○ |

### GSResumeRecoverable（UT-GSF-144〜147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | GSResumeRecoverableコンストラクタが正常に動作すること | E-14 (L43-58) | ○ |
| C-145 | コンストラクタが負のpositionで例外をスローすること | E-14 (L55: Preconditions.checkArgument) | ○ |
| C-146 | position=0で正常に生成されること | E-14 (L55: >=0) | ○ |
| C-147 | toStringが情報を含む文字列を返却すること | E-14 (L61-72) | ○ |

### GSCommitRecoverableSerializer（UT-GSF-148〜155）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | getVersionが1を返却すること | E-15 (L43, L59-61) | ○ |
| C-149 | serializeがバイト配列を返却すること | E-15 (L86-100) | ○ |
| C-150 | serializeがnullで例外をスローすること | E-15 (L89: Preconditions.checkNotNull) | ○ |
| C-151 | deserializeがオブジェクトを復元すること | E-15 (L135-152) | ○ |
| C-152 | deserializeがサポート外バージョンで例外をスローすること | E-15 (L140-145: IOException) | ○ |
| C-153 | deserializeがnullで例外をスローすること | E-15 (L137: Preconditions.checkNotNull) | ○ |
| C-154 | deserializeがversion<=0で例外をスローすること | E-15 (L136: Preconditions.checkArgument) | ○ |
| C-155 | シリアライズ/デシリアライズ往復が正常に動作すること | E-15 (全体) | ○ |

### GSResumeRecoverableSerializer（UT-GSF-156〜162）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-156 | getVersionが1を返却すること | E-16 (L40, L54-57) | ○ |
| C-157 | serializeがバイト配列を返却すること | E-16 (L60-82) | ○ |
| C-158 | serializeがnullで例外をスローすること | E-16 (L62: Preconditions.checkNotNull) | ○ |
| C-159 | deserializeがオブジェクトを復元すること | E-16 (L85-121) | ○ |
| C-160 | deserializeがサポート外バージョンで例外をスローすること | E-16 (L90-95: IOException) | ○ |
| C-161 | deserializeがversion<=0で例外をスローすること | E-16 (L86: Preconditions.checkArgument) | ○ |
| C-162 | シリアライズ/デシリアライズ往復が正常に動作すること | E-16 (全体) | ○ |

### GSRecoverableWriterCommitter（UT-GSF-163〜178）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-163 | GSRecoverableWriterCommitterコンストラクタが正常に動作すること | E-17 (L59-73) | ○ |
| C-164 | コンストラクタがnullで例外をスローすること | E-17 (L68-70: Preconditions.checkNotNull) | ○ |
| C-165 | コンストラクタがcomposeMaxBlobs<=0で例外をスローすること | E-17 (L71: Preconditions.checkArgument) | ○ |
| C-166 | commitが最終Blobを作成すること | E-17 (L81-100) | ○ |
| C-167 | commitが最終Blob既存時に例外をスローすること | E-17 (L88-93: IOException) | ○ |
| C-168 | commitがコンポーネントなしで空Blobを作成すること | E-17 (L176-179) | ○ |
| C-169 | commitAfterRecoveryがコミットを行うこと | E-17 (L103-117) | ○ |
| C-170 | commitAfterRecoveryが最終Blob既存時にスキップすること | E-17 (L109-113) | ○ |
| C-171 | getRecoverableがリカバリ可能オブジェクトを返却すること | E-17 (L120-122) | ○ |
| C-172 | composeBlobsが32以下のBlobを合成すること | E-17 (L131-169) | ○ |
| C-173 | composeBlobsが32を超えるBlobを再帰的に合成すること | E-17 (L165-168: 再帰呼び出し) | ○ |
| C-174 | composeBlobsが空リストで例外をスローすること | E-17 (L139: Preconditions.checkArgument) | ○ |
| C-175 | writeFinalBlobが同一バケット内で直接合成すること | E-17 (L189-193) | ○ |
| C-176 | writeFinalBlobが異なるバケット間でコピーすること | E-17 (L195-205) | ○ |
| C-177 | cleanupTemporaryBlobsがエントロピー無効時にプレフィックス検索すること | E-17 (L230-238) | ○ |
| C-178 | cleanupTemporaryBlobsがエントロピー有効時に既知Blobを削除すること | E-17 (L223-229) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に基づいて生成されている
- 注意点：
  - チェックサム検証のテストは実際のGCSとの統合テストが必要な場合がある
  - 大量Blobの再帰的合成は、実環境でのパフォーマンステストが推奨される
  - クロスバケット操作は権限設定によってテスト結果が変わる可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] GSFileSystemFactoryの設定読み込みロジックが要件を満たしているか確認
- [ ] チェックサム検証の精度が十分か確認（GSChecksumWriteChannel）
- [ ] 32を超えるBlobの再帰的合成が正しく動作するか確認（GSRecoverableWriterCommitter）
- [ ] クロスバケット操作のテストが実環境で動作するか確認
- [ ] エントロピー有効/無効の両ケースがカバーされているか確認
- [ ] シリアライザのバージョン互換性が考慮されているか確認
- [ ] 例外メッセージが適切で、デバッグに有用か確認
