---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 191
  claims_with_evidence: 191
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-filesystems_flink-hadoop-fs 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：191 / 191、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースはソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/util/HadoopUtils.java`
- E-02: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/util/HadoopConfigLoader.java`
- E-03: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopRecoverableSerializer.java`
- E-04: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopFsRecoverable.java`
- E-05: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopDataInputStream.java`
- E-06: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopFileSystem.java`
- E-07: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/BaseHadoopFsRecoverableFsDataOutputStream.java`
- E-08: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopFileStatus.java`
- E-09: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopRecoverableWriter.java`
- E-10: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/LocatedHadoopFileStatus.java`
- E-11: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopRecoverableFsDataOutputStream.java`
- E-12: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopBlockLocation.java`
- E-13: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopDataOutputStream.java`
- E-14: `flink-filesystems/flink-hadoop-fs/src/main/java/org/apache/flink/runtime/fs/hdfs/HadoopFsFactory.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### HadoopUtils (UT-HFS-001 - UT-HFS-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getHadoopConfigurationはHdfsConfigurationを生成する | E-01 (L58-116) | ○ |
| C-02 | HADOOP_HOME環境変数からconf設定を読み込む | E-01 (L70-81) | ○ |
| C-03 | HADOOP_CONF_DIR環境変数から設定を読み込む | E-01 (L84-89) | ○ |
| C-04 | Hadoop設定が見つからない場合に警告を出力 | E-01 (L109-113) | ○ |
| C-05 | isKerberosSecurityEnabledはKerberos認証をチェック | E-01 (L118-122) | ○ |
| C-06 | areKerberosCredentialsValidはクレデンシャルを検証 | E-01 (L124-146) | ○ |
| C-07 | hasHDFSDelegationTokenはHDFSトークンをチェック | E-01 (L149-157) | ○ |
| C-08 | isMinHadoopVersionはバージョン比較を行う | E-01 (L160-166) | ○ |
| C-09 | isMaxHadoopVersionはバージョン比較を行う | E-01 (L169-175) | ○ |
| C-10 | getMajorMinorBundledHadoopVersionはバージョンをパース | E-01 (L177-190) | ○ |

### HadoopConfigLoader (UT-HFS-019 - UT-HFS-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | コンストラクタで設定パラメータを初期化 | E-02 (L57-70) | ○ |
| C-12 | setFlinkConfigでFlink設定をセット | E-02 (L72-75) | ○ |
| C-13 | getOrLoadHadoopConfigでHadoop設定を取得 | E-02 (L78-92) | ○ |
| C-14 | loadHadoopConfigFromFlinkでプレフィックス変換 | E-02 (L95-111) | ○ |
| C-15 | mirrorCertainHadoopConfigでキーをミラー | E-02 (L115-124) | ○ |
| C-16 | fixHadoopConfigでシェーディング処理 | E-02 (L126-128) | ○ |
| C-17 | shadeClassConfigでクラス名にプレフィックス付与 | E-02 (L130-134) | ○ |

### HadoopRecoverableSerializer (UT-HFS-028 - UT-HFS-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | getVersionは1を返す | E-03 (L46-48) | ○ |
| C-19 | serializeはマジックナンバー付きでシリアライズ | E-03 (L51-65) | ○ |
| C-20 | deserializeはバージョン1のデシリアライズをサポート | E-03 (L68-75) | ○ |
| C-21 | deserializeV1はマジックナンバーを検証 | E-03 (L77-94) | ○ |

### HadoopFsRecoverable (UT-HFS-034 - UT-HFS-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | コンストラクタでoffset >= 0を検証 | E-04 (L52-57) | ○ |
| C-23 | targetFile/tempFile/offsetアクセサ | E-04 (L59-69) | ○ |
| C-24 | toStringは期待されたフォーマット | E-04 (L72-74) | ○ |

### HadoopDataInputStream (UT-HFS-043 - UT-HFS-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | コンストラクタでnullチェック | E-05 (L62-64) | ○ |
| C-26 | seekで小さな前方移動時にskipを使用 | E-05 (L67-79) | ○ |
| C-27 | MIN_SKIP_BYTESは1MB | E-05 (L52) | ○ |
| C-28 | read/close/availableはHadoopストリームに委譲 | E-05 (L87-104) | ○ |
| C-29 | forceSeekは内部seekを呼び出す | E-05 (L130-132) | ○ |
| C-30 | skipFullyは完全スキップを保証 | E-05 (L140-144) | ○ |
| C-31 | read(ByteBuffer)は配列バックとダイレクトバッファを処理 | E-05 (L147-172) | ○ |
| C-32 | read(long, ByteBuffer)は位置指定読み取りをサポート | E-05 (L175-190) | ○ |

### HadoopFileSystem (UT-HFS-063 - UT-HFS-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | コンストラクタでnullチェック | E-06 (L55-57) | ○ |
| C-34 | getFileStatusはHadoopFileStatusを返す | E-06 (L87-90) | ○ |
| C-35 | getFileBlockLocationsはブロック位置を返す | E-06 (L93-122) | ○ |
| C-36 | open/createはHadoopData*Streamを返す | E-06 (L125-159) | ○ |
| C-37 | delete/exists/mkdirs/renameはHadoop FSに委譲 | E-06 (L162-192) | ○ |
| C-38 | createRecoverableWriterはHadoopRecoverableWriterを返す | E-06 (L206-226) | ○ |
| C-39 | getKindForSchemeはスキームに基づいてKindを判定 | E-06 (L246-267) | ○ |

### BaseHadoopFsRecoverableFsDataOutputStream (UT-HFS-095 - UT-HFS-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | getPos/write/flush/sync/close操作 | E-07 (L46-84) | ○ |
| C-41 | persistはsync後にRecoverableを返す | E-07 (L72-75) | ○ |
| C-42 | createHadoopFsRecoverableはinitialFileSizeを加算 | E-07 (L77-79) | ○ |

### HadoopFileStatus (UT-HFS-103 - UT-HFS-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | getBlockSizeはlen/blockSizeの小さい方を返す | E-08 (L47-49) | ○ |
| C-44 | fromHadoopStatusはLocated*を適切に判定 | E-08 (L88-93) | ○ |

### HadoopRecoverableWriter (UT-HFS-116 - UT-HFS-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | コンストラクタでhdfs/viewfsスキームを検証 | E-09 (L69-86) | ○ |
| C-46 | openはステージングファイルパスを生成 | E-09 (L89-93) | ○ |
| C-47 | recoverはHadoopFsRecoverableを検証 | E-09 (L102-110) | ○ |
| C-48 | generateStagingTempFilePathは絶対パスを要求 | E-09 (L160-179) | ○ |

### LocatedHadoopFileStatus (UT-HFS-133 - UT-HFS-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | getBlockLocationsはHadoopBlockLocation配列を返す | E-10 (L36-46) | ○ |

### HadoopRecoverableFsDataOutputStream (UT-HFS-136 - UT-HFS-155)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | コンストラクタでnoLocalWriteフラグを処理 | E-11 (L65-91) | ○ |
| C-51 | Recoverable復元時にtruncateと位置検証 | E-11 (L102-128) | ○ |
| C-52 | safelyTruncateFileはリース解放を待機 | E-11 (L141-162) | ○ |
| C-53 | HadoopFsCommitter.commitはリネームを実行 | E-11 (L227-251) | ○ |
| C-54 | waitUntilLeaseIsRevokedはDFS限定 | E-11 (L327-346) | ○ |

### HadoopBlockLocation (UT-HFS-156 - UT-HFS-169)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | getHostsはFQDNからドメイン部分を削除 | E-12 (L54-74) | ○ |
| C-56 | stripHostnameはIPv4アドレスを保持 | E-12 (L102-122) | ○ |
| C-57 | compareToはオフセットで比較 | E-12 (L87-90) | ○ |

### HadoopDataOutputStream (UT-HFS-170 - UT-HFS-178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | コンストラクタでnullチェック | E-13 (L33-38) | ○ |
| C-59 | write/close/flush/syncはHadoop FSに委譲 | E-13 (L40-68) | ○ |

### HadoopFsFactory (UT-HFS-179 - UT-HFS-191)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | getSchemeは"*"を返す | E-14 (L57-60) | ○ |
| C-61 | configureでflinkConfig設定とhadoopConfigリセット | E-14 (L63-66) | ○ |
| C-62 | createはHadoop FSクラスを動的にロード | E-14 (L69-198) | ○ |
| C-63 | limitIfConfiguredは接続制限を適用 | E-14 (L208-226) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースはソースコードの解析に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全テストケースはソースコードの実装に基づいている
- 統合テストや実環境でのHadoopクラスタ接続テストは別途必要
- モック化が必要なテストケース（Hadoop FileSystem、DistributedFileSystem等）については、実際のテスト実装時に適切なモックライブラリの使用を検討すること

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全publicメソッドを網羅しているか
- [ ] 正常系・異常系・境界値の観点が適切にカバーされているか
- [ ] 優先度の設定が妥当か（金額計算、セキュリティ、データ整合性は高優先度）
- [ ] テストケース名が具体的で何をテストするか明確か
- [ ] 前提条件と入力値が実際にテスト可能な形式で記述されているか
- [ ] 期待結果が検証可能な形式で記述されているか
- [ ] Hadoop依存のテストケースについてモック化戦略が検討されているか
