---
generated_at: 2026-02-02 12:30:00
metrics:
  claims_total: 114
  claims_with_evidence: 114
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-filesystems_flink-oss-fs-hadoop 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：114 / 114、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースにソースコード根拠あり
  2. 外部システム（Aliyun OSS）との連携部分は統合テストでの追加検証推奨
  3. 並行処理関連のテストケースは実環境での検証推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/OSSFileSystemFactory.java`
- E-02: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/FlinkOSSFileSystem.java`
- E-03: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/OSSAccessor.java`
- E-04: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/writer/OSSRecoverable.java`
- E-05: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/writer/OSSRecoverableSerializer.java`
- E-06: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/writer/OSSRecoverableWriter.java`
- E-07: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/writer/OSSRecoverableMultipartUpload.java`
- E-08: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/writer/OSSRecoverableFsDataOutputStream.java`
- E-09: `flink-filesystems/flink-oss-fs-hadoop/src/main/java/org/apache/flink/fs/osshadoop/writer/OSSCommitter.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### OSSFileSystemFactory (UT-OSS-001 - UT-OSS-010)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getScheme()が"oss"を返却する | E-01 Line 78-80 | ○ |
| C-02 | configure()でflinkConfigが保存される | E-01 Line 83-86 | ○ |
| C-03 | configure()でhadoopConfigがnullにリセットされる | E-01 Line 85 | ○ |
| C-04 | create()でFlinkOSSFileSystemが作成される | E-01 Line 89-115 | ○ |
| C-05 | scheme/authorityがnullの場合デフォルトURIを使用 | E-01 Line 95-96 | ○ |
| C-06 | schemeがデフォルトと一致しauthorityがnullの場合デフォルトURI | E-01 Line 97-101 | ○ |
| C-07 | 一時ディレクトリ未設定で例外スロー | E-01 Line 107 (Preconditions.checkArgument) | ○ |
| C-08 | flinkConfigがnullの場合空のHadoop設定 | E-01 Line 120-122 | ○ |
| C-09 | fs.oss.プレフィックス設定のコピー | E-01 Line 125-140 | ○ |
| C-10 | fs.oss.credentials.providerのシェーディング | E-01 Line 130-132, Line 47-50 | ○ |

### FlinkOSSFileSystem (UT-OSS-011 - UT-OSS-016)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | コンストラクタで有効なインスタンス作成 | E-02 Line 58-82 | ○ |
| C-12 | ossUploadPartSize最小値未満で例外 | E-02 Line 66 (Preconditions.checkArgument) | ○ |
| C-13 | ossUploadPartSize最小値（10MB）で正常作成 | E-02 Line 42, 66 | ○ |
| C-14 | localTmpDirectoryがnullで例外 | E-02 Line 76 (Preconditions.checkNotNull) | ○ |
| C-15 | createRecoverableWriter()でOSSRecoverableWriter作成 | E-02 Line 85-92 | ○ |
| C-16 | getLocalTmpDir()で一時ディレクトリ返却 | E-02 Line 94-96 | ○ |

### OSSAccessor (UT-OSS-017 - UT-OSS-029)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | コンストラクタでstore取得 | E-03 Line 42-45 | ○ |
| C-18 | pathToObject()で絶対パス変換 | E-03 Line 47-54 | ○ |
| C-19 | pathToObject()で相対パス変換 | E-03 Line 49-51 | ○ |
| C-20 | objectToPath()でPath変換 | E-03 Line 56-58 | ○ |
| C-21 | startMultipartUpload()でuploadId取得 | E-03 Line 60-62 | ○ |
| C-22 | deleteObject()で正常削除 | E-03 Line 64-66 | ○ |
| C-23 | deleteObject()で存在しないオブジェクト | E-03 Line 64-66 | ○ |
| C-24 | completeMultipartUpload()で完了 | E-03 Line 68-71 | ○ |
| C-25 | uploadPart()でパートアップロード | E-03 Line 73-76 | ○ |
| C-26 | putObject()でオブジェクトアップロード | E-03 Line 78-80 | ○ |
| C-27 | getObject()でダウンロード | E-03 Line 82-99 | ○ |
| C-28 | getObject()でサイズ不一致時例外 | E-03 Line 84-91 | ○ |
| C-29 | getObject()でCRCファイル削除 | E-03 Line 97-98 | ○ |

### OSSRecoverable (UT-OSS-030 - UT-OSS-039)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | コンストラクタで全パラメータ設定 | E-04 Line 44-57 | ○ |
| C-31 | partETagsの防御的コピー | E-04 Line 53 (new ArrayList<>(partETags)) | ○ |
| C-32 | lastPartObject=nullで正常作成 | E-04 Line 38 (@Nullable), Line 54 | ○ |
| C-33-39 | 各アクセサメソッドの返却値 | E-04 Line 59-82 | ○ |

### OSSRecoverableSerializer (UT-OSS-040 - UT-OSS-048)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | getVersion()で1返却 | E-05 Line 45-47 | ○ |
| C-41 | serialize()でバイト配列生成 | E-05 Line 50-114 | ○ |
| C-42 | 空partETagsでシリアライズ | E-05 Line 54-59, 94-100 | ○ |
| C-43 | lastPartObject=nullでシリアライズ | E-05 Line 63, 104-109 | ○ |
| C-44 | 複数partETagsのシリアライズ | E-05 Line 94-100 | ○ |
| C-45 | deserialize()でOSSRecoverable復元 | E-05 Line 117-169 | ○ |
| C-46 | 不正バージョンで例外 | E-05 Line 122 | ○ |
| C-47 | 不正マジックナンバーで例外 | E-05 Line 129-131 | ○ |
| C-48 | 往復変換テスト | E-05 Line 50-169 | ○ |

### OSSRecoverableWriter (UT-OSS-049 - UT-OSS-062)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタで全パラメータ設定 | E-06 Line 51-62 | ○ |
| C-50 | open()で新規ストリーム作成 | E-06 Line 65-78 | ○ |
| C-51 | recover()でストリーム復元 | E-06 Line 81-95 | ○ |
| C-52 | lastPartObject=nullでrecover | E-06 Line 98-101 | ○ |
| C-53 | lastPartObjectダウンロードで復元 | E-06 Line 103-110 | ○ |
| C-54 | requiresCleanupOfRecoverableState()でtrue | E-06 Line 113-115 | ○ |
| C-55 | cleanupRecoverableState()で削除 | E-06 Line 118-122 | ○ |
| C-56 | lastPartObject=nullでcleanupfalse | E-06 Line 121 | ○ |
| C-57 | recoverForCommit()でCommitter取得 | E-06 Line 125-129 | ○ |
| C-58-59 | シリアライザ取得 | E-06 Line 132-139 | ○ |
| C-60 | supportsResume()でtrue | E-06 Line 142-144 | ○ |
| C-61-62 | getExecutor()の条件分岐 | E-06 Line 146-151 | ○ |

### OSSRecoverableMultipartUpload (UT-OSS-063 - UT-OSS-085)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | 新規アップロードでuploadId自動生成 | E-07 Line 78-82 | ○ |
| C-64 | リカバリで既存uploadId使用 | E-07 Line 78-82 | ○ |
| C-65 | completeParts=nullで空リスト初期化 | E-07 Line 71-75 | ○ |
| C-66 | getIncompletePart()の返却値 | E-07 Line 91-93 | ○ |
| C-67 | uploadPart()でアップロード開始 | E-07 Line 95-108 | ○ |
| C-68 | ファイル未クローズで例外 | E-07 Line 96 (checkState) | ○ |
| C-69 | パート番号インクリメント | E-07 Line 101 | ○ |
| C-70-74 | getRecoverable()の各ケース | E-07 Line 110-143 | ○ |
| C-75-78 | createIncompletePartObjectNamePrefix() | E-07 Line 166-181 | ○ |
| C-79 | getCommitter()でOSSCommitter返却 | E-07 Line 183-191 | ○ |
| C-80-83 | UploadTaskパート番号検証 | E-07 Line 217 (checkArgument partNumber >= 1 && partNumber <= 10_000) | ○ |
| C-84-85 | UploadTask.run()の成功/失敗 | E-07 Line 225-234 | ○ |

### OSSRecoverableFsDataOutputStream (UT-OSS-086 - UT-OSS-103)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86-87 | コンストラクタの初期化 | E-08 Line 64-82 | ○ |
| C-88-89 | persist()の動作 | E-08 Line 85-96 | ○ |
| C-90-92 | closeForCommit()の動作 | E-08 Line 99-116 | ○ |
| C-93-94 | getPos()の計算 | E-08 Line 119-121 | ○ |
| C-95-97 | write()メソッド群 | E-08 Line 124-132 | ○ |
| C-98-99 | flush()の動作 | E-08 Line 135-138 | ○ |
| C-100 | sync()の動作 | E-08 Line 141-143 | ○ |
| C-101-103 | close()の動作 | E-08 Line 146-155 | ○ |

### OSSCommitter (UT-OSS-104 - UT-OSS-114)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | コンストラクタで全パラメータ設定 | E-09 Line 44-55 | ○ |
| C-105-108 | コンストラクタnullチェック | E-09 Line 50-54 (checkNotNull) | ○ |
| C-109-110 | commit()の動作 | E-09 Line 58-65 | ○ |
| C-111-113 | commitAfterRecovery()の動作 | E-09 Line 68-86 | ○ |
| C-114 | getRecoverable()の返却値 | E-09 Line 89-91 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースがソースコードから直接導出されており、根拠なしの項目はありません
- 候補：なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから明確に導出可能
- **1（中リスク）**: 外部システム（Aliyun OSS）との連携テストは実環境依存
  - UT-OSS-021〜028: OSSAccessorの外部API呼び出し部分
  - UT-OSS-084〜085: UploadTaskの非同期処理部分
- **1（中リスク）**: 並行処理関連
  - UT-OSS-103: 並行close呼び出しのデッドロック検証

## 6) レビュアーチェックリスト（最小）
- [ ] OSSFileSystemFactory: 設定キーのシェーディング処理が正しいか確認（特にfs.oss.credentials.provider）
- [ ] FlinkOSSFileSystem: MULTIPART_UPLOAD_PART_SIZE_MIN（10MB）の境界値テストが妥当か確認
- [ ] OSSAccessor: getObject()のサイズ検証ロジックが要件と一致しているか確認
- [ ] OSSRecoverableSerializer: マジックナンバー（0x98761234）とバージョン管理が適切か確認
- [ ] OSSRecoverableMultipartUpload: パート番号の上限（10,000）がOSS仕様と一致しているか確認
- [ ] OSSRecoverableFsDataOutputStream: ロック機構（ReentrantLock）の使用方法が適切か確認
- [ ] OSSCommitter: commitAfterRecovery()の例外処理がべき等性を保証しているか確認
