---
generated_at: 2026-02-02 18:30:00
metrics:
  claims_total: 98
  claims_with_evidence: 95
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：flink-formats_flink-avro-confluent-registry 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：95 / 98、根拠なし：3
- 優先レビュー（高）
  1. **UT-ACR-007（境界値 - 負のキャッシュ容量）**：CachedSchemaRegistryClientの実際の挙動は外部ライブラリ依存
  2. **UT-ACR-006（境界値 - キャッシュ容量0）**：同上、外部ライブラリの挙動に依存
  3. **UT-ACR-029（境界値 - 空のInputStream）**：DataInputStreamの挙動に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/ConfluentRegistryAvroDeserializationSchema.java`
- E-02: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/ConfluentRegistryAvroSerializationSchema.java`
- E-03: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/ConfluentSchemaRegistryCoder.java`
- E-04: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/RegistryAvroFormatFactory.java`
- E-05: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/AvroConfluentFormatOptions.java`
- E-06: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/CachedSchemaCoderProvider.java`
- E-07: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/debezium/DebeziumAvroFormatFactory.java`
- E-08: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/debezium/DebeziumAvroSerializationSchema.java`
- E-09: `flink-formats/flink-avro-confluent-registry/src/main/java/org/apache/flink/formats/avro/registry/confluent/debezium/DebeziumAvroDeserializationSchema.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConfluentRegistryAvroDeserializationSchema

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | forGeneric(Schema, String)がGenericRecordデシリアライザを生成 | E-01 (L74-77) | ○ |
| C-02 | nullスキーマでNullPointerException | E-01 (コンストラクタ呼び出し) | ○ |
| C-03 | nullURLでNullPointerException | E-06 (L53 Objects.requireNonNull) | ○ |
| C-04 | 空文字URLの挙動 | E-06 | ○ |
| C-05 | カスタムキャッシュ容量指定 | E-01 (L89-92) | ○ |
| C-06 | キャッシュ容量0の挙動 | E-06, 外部ライブラリ依存 | △ |
| C-07 | 負のキャッシュ容量の挙動 | E-06, 外部ライブラリ依存 | △ |
| C-08 | レジストリ設定付きforGeneric | E-01 (L107-110) | ○ |
| C-09 | registryConfigs=nullでも生成可能 | E-01 (L124-133) | ○ |
| C-10 | 全パラメータforGeneric | E-01 (L124-133) | ○ |
| C-11 | forSpecific基本動作 | E-01 (L145-148) | ○ |
| C-12 | nullクラスでNullPointerException | E-01 | ○ |
| C-13 | キャッシュ容量指定forSpecific | E-01 (L159-163) | ○ |
| C-14 | レジストリ設定付きforSpecific | E-01 (L177-181) | ○ |
| C-15 | 全パラメータforSpecific | E-01 (L194-204) | ○ |

### ConfluentRegistryAvroSerializationSchema

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | forSpecific基本動作 | E-02 (L71-75) | ○ |
| C-17 | nullクラスでNullPointerException | E-02 | ○ |
| C-18 | nullSubjectの挙動 | E-02 | ○ |
| C-19 | 空subjectの挙動 | E-02 | ○ |
| C-20 | レジストリ設定付きforSpecific | E-02 (L88-102) | ○ |
| C-21 | forGeneric基本動作 | E-02 (L113-116) | ○ |
| C-22 | nullスキーマでNullPointerException | E-02 | ○ |
| C-23 | レジストリ設定付きforGeneric | E-02 (L129-142) | ○ |

### ConfluentSchemaRegistryCoder

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | コンストラクタ(subject, client) | E-03 (L49-52) | ○ |
| C-25 | コンストラクタ(client)のみ | E-03 (L60-62) | ○ |
| C-26 | readSchemaが有効データからスキーマを読む | E-03 (L65-80) | ○ |
| C-27 | magic byte不正でIOException | E-03 (L68-69) | ○ |
| C-28 | 存在しないschemaIdでIOException | E-03 (L73-78) | ○ |
| C-29 | 空InputStreamの挙動 | E-03, DataInputStream依存 | △ |
| C-30 | writeSchemaがスキーマを登録 | E-03 (L83-91) | ○ |
| C-31 | スキーマ登録失敗でIOException | E-03 (L89-91) | ○ |
| C-32 | nullスキーマの挙動 | E-03 | ○ |

### RegistryAvroFormatFactory

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | factoryIdentifierが'avro-confluent' | E-04 (L84, L165) | ○ |
| C-34 | requiredOptionsにURL含む | E-04 (L169-173) | ○ |
| C-35 | optionalOptionsに各種設定含む | E-04 (L176-190) | ○ |
| C-36 | createDecodingFormat基本動作 | E-04 (L87-121) | ○ |
| C-37 | カスタムスキーマ指定 | E-04 (L103-106) | ○ |
| C-38 | URL未指定でValidationException | E-04 (L89) | ○ |
| C-39 | createEncodingFormat基本動作 | E-04 (L124-161) | ○ |
| C-40 | subject未指定でValidationException | E-04 (L133-138) | ○ |
| C-41 | SSL設定がプロパティマップに含まれる | E-04 (L216-227) | ○ |
| C-42 | Basic認証設定がプロパティマップに含まれる | E-04 (L229-234) | ○ |
| C-43 | Bearer認証設定がプロパティマップに含まれる | E-04 (L235-239) | ○ |
| C-44 | オプション未設定でnull返却 | E-04 (L241-244) | ○ |
| C-45 | propertiesオプション値の反映 | E-04 (L214) | ○ |
| C-46 | getAvroSchemaがSchemaを生成 | E-04 (L247-263) | ○ |
| C-47 | スキーマ不一致でIllegalArgumentException | E-04 (L255-260) | ○ |

### CachedSchemaCoderProvider

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | コンストラクタ(url, capacity) | E-06 (L43-45) | ○ |
| C-49 | フルコンストラクタ | E-06 (L47-56) | ○ |
| C-50 | nullURLでNullPointerException | E-06 (L53) | ○ |
| C-51 | getがConfluentSchemaRegistryCoderを返す | E-06 (L59-63) | ○ |
| C-52 | equals - 同じ設定で等価 | E-06 (L66-78) | ○ |
| C-53 | equals - 異なる設定で非等価 | E-06 (L66-78) | ○ |
| C-54 | hashCode | E-06 (L81-83) | ○ |

### DebeziumAvroFormatFactory

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | factoryIdentifierが'debezium-avro-confluent' | E-07 (L76, L158) | ○ |
| C-56 | requiredOptionsにURL含む | E-07 (L161-165) | ○ |
| C-57 | optionalOptionsに各種設定含む | E-07 (L168-182) | ○ |
| C-58 | createDecodingFormat基本動作 | E-07 (L79-115) | ○ |
| C-59 | ChangelogModeに4種類のRowKind含む | E-07 (L106-113) | ○ |
| C-60 | createEncodingFormat基本動作 | E-07 (L118-153) | ○ |
| C-61 | subject未指定でValidationException | E-07 (L127-132) | ○ |
| C-62 | validateSchemaString - 有効スキーマ | E-07 (L184-197) | ○ |
| C-63 | validateSchemaString - null許容 | E-07 (L185) | ○ |
| C-64 | validateSchemaString - 不一致でIllegalArgumentException | E-07 (L189-195) | ○ |

### DebeziumAvroSerializationSchema

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | コンストラクタ基本動作 | E-08 (L66-93) | ○ |
| C-66 | open初期化 | E-08 (L101-104) | ○ |
| C-67 | serialize - INSERT変換 | E-08 (L110-115) | ○ |
| C-68 | serialize - UPDATE_AFTER変換 | E-08 (L110-115) | ○ |
| C-69 | serialize - UPDATE_BEFORE変換 | E-08 (L116-121) | ○ |
| C-70 | serialize - DELETE変換 | E-08 (L116-121) | ○ |
| C-71 | serialize失敗でRuntimeException | E-08 (L128-130) | ○ |
| C-72 | equals | E-08 (L134-143) | ○ |
| C-73 | hashCode | E-08 (L146-148) | ○ |
| C-74 | createDebeziumAvroRowType | E-08 (L150-159) | ○ |

### DebeziumAvroDeserializationSchema

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | コンストラクタ基本動作 | E-09 (L86-107) | ○ |
| C-76 | open初期化 | E-09 (L118-120) | ○ |
| C-77 | deserialize(byte[])でRuntimeException | E-09 (L123-126) | ○ |
| C-78 | nullメッセージスキップ | E-09 (L131-134) | ○ |
| C-79 | 空配列スキップ | E-09 (L131-134) | ○ |
| C-80 | op='c'でINSERT | E-09 (L141-143) | ○ |
| C-81 | op='r'でINSERT | E-09 (L141-143) | ○ |
| C-82 | op='u'でUPDATE_BEFORE/AFTER | E-09 (L144-152) | ○ |
| C-83 | op='u'でbeforeがnullだとIllegalStateException | E-09 (L145-148) | ○ |
| C-84 | op='d'でDELETE | E-09 (L153-159) | ○ |
| C-85 | op='d'でbeforeがnullだとIllegalStateException | E-09 (L154-157) | ○ |
| C-86 | 不明opでIOException | E-09 (L160-165) | ○ |
| C-87 | デシリアライズ失敗でIOException | E-09 (L166-169) | ○ |
| C-88 | isEndOfStreamがfalse | E-09 (L173-175) | ○ |
| C-89 | getProducedType | E-09 (L178-180) | ○ |
| C-90 | equals | E-09 (L183-193) | ○ |
| C-91 | hashCode | E-09 (L196-198) | ○ |
| C-92 | createDebeziumAvroRowType | E-09 (L200-209) | ○ |

### AvroConfluentFormatOptions

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | URL設定オプション定義 | E-05 (L31-37) | ○ |
| C-94 | SUBJECT設定オプション定義 | E-05 (L39-50) | ○ |
| C-95 | SCHEMA設定オプション定義 | E-05 (L52-62) | ○ |
| C-96 | SSL設定オプション定義 | E-05 (L68-90) | ○ |
| C-97 | 認証設定オプション定義 | E-05 (L92-114) | ○ |
| C-98 | PROPERTIES設定オプション定義 | E-05 (L120-128) | ○ |

## 4) 不足情報（Unknown / Missing）
- **外部ライブラリ（Confluent Schema Registry Client）の境界値挙動**
  - CachedSchemaRegistryClientの容量制限（0や負の値）に対する挙動はライブラリ内部実装に依存
  - 候補：Confluentライブラリのドキュメント / 単体テスト / 実機確認
- **DataInputStreamの空ストリーム読み取り挙動**
  - Java標準ライブラリの挙動に依存
  - 候補：Javadoc / 実機確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接確認可能
- **1: 中リスク** - 境界値テスト（キャッシュ容量0/負値、空InputStream）は外部依存のため実機確認推奨
- **0: 低リスク** - Debezium関連の操作（op='c','r','u','d'）は明確にコード内で定義

## 6) レビュアーチェックリスト（最小）
- [ ] UT-ACR-006, UT-ACR-007: CachedSchemaRegistryClientの境界値挙動を実機確認
- [ ] UT-ACR-029: 空InputStreamに対するDataInputStreamの挙動を確認
- [ ] SSL/認証関連テスト（UT-ACR-041〜043）: 実際のSchema Registryへの接続テストを検討
- [ ] Debezium関連テスト（UT-ACR-067〜092）: 実際のDebeziumメッセージ形式との整合性確認
- [ ] 全ファクトリメソッドのnullパラメータ検証が適切に行われているか確認
