---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-formats_flink-avro 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースはソースコードに基づいて生成されており、根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroDeserializationSchema.java`
- E-02: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroSerializationSchema.java`
- E-03: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroRowDataSerializationSchema.java`
- E-04: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroRowDataDeserializationSchema.java`
- E-05: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/RowDataToAvroConverters.java`
- E-06: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroToRowDataConverters.java`
- E-07: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/typeutils/AvroSchemaConverter.java`
- E-08: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/typeutils/AvroSerializer.java`
- E-09: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroInputFormat.java`
- E-10: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroOutputFormat.java`
- E-11: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroFormatFactory.java`
- E-12: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/RegistryAvroDeserializationSchema.java`
- E-13: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/RegistryAvroSerializationSchema.java`
- E-14: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/typeutils/AvroTypeInfo.java`
- E-15: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/typeutils/GenericRecordAvroTypeInfo.java`
- E-16: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/typeutils/AvroFactory.java`
- E-17: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AbstractAvroBulkFormat.java`
- E-18: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/utils/MutableByteArrayInputStream.java`
- E-19: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/SchemaCoder.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### AvroDeserializationSchema (C-01 〜 C-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | forGeneric(Schema)でGenericRecord用デシリアライズスキーマが作成される | E-01 (L60-62) | ○ |
| C-02 | forGeneric(Schema, AvroEncoding)でエンコーディング指定可能 | E-01 (L72-75) | ○ |
| C-03 | forSpecific(Class)でSpecificRecord用スキーマが作成される | E-01 (L84-86) | ○ |
| C-04 | deserialize()で有効なバイト配列がデシリアライズされる | E-01 (L168-185) | ○ |
| C-05 | deserialize(null)でnullが返却される | E-01 (L169-171) | ○ |
| C-06 | 不正バイト配列でIOExceptionがスローされる | E-01 (L184) datumReader.read() | ○ |
| C-07 | checkAvroInitialized()で遅延初期化される | E-01 (L187-213) | ○ |
| C-08 | 二重初期化防止 | E-01 (L188-190) | ○ |
| C-09 | isEndOfStream()で常にfalse | E-01 (L216-218) | ○ |
| C-10 | getProducedType()でSpecificRecordの場合AvroTypeInfo | E-01 (L223-224) | ○ |
| C-11 | getProducedType()でGenericRecordの場合GenericRecordAvroTypeInfo | E-01 (L226) | ○ |
| C-12 | equals()で同一設定がtrue | E-01 (L231-240) | ○ |
| C-13 | equals()で異なる設定がfalse | E-01 (L231-240) | ○ |

### AvroSerializationSchema (C-14 〜 C-20)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | forSpecific(Class)でSpecificRecord用スキーマ作成 | E-02 (L57-59) | ○ |
| C-15 | forGeneric(Schema)でGenericRecord用スキーマ作成 | E-02 (L81-83) | ○ |
| C-16 | serialize()で有効なオブジェクトがシリアライズされる | E-02 (L161-177) | ○ |
| C-17 | serialize(null)でnullが返却される | E-02 (L164-166) | ○ |
| C-18 | open()でschemaStringからschemaが復元される | E-02 (L154-158) | ○ |
| C-19 | checkAvroInitialized()でSpecificRecordのdatumWriter作成 | E-02 (L184-187) | ○ |
| C-20 | JSONエンコーディングでjsonEncoder作成 | E-02 (L196-201) | ○ |

### AvroRowDataSerializationSchema (C-21 〜 C-24)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | RowTypeからシリアライズスキーマ作成 | E-03 (L58-59, L67-73) | ○ |
| C-22 | serialize()でRowDataがAvroバイトにシリアライズ | E-03 (L116-124) | ○ |
| C-23 | 変換エラー時にRuntimeException | E-03 (L121-123) | ○ |
| C-24 | open()でnestedSchema.open()呼び出し | E-03 (L106-107) | ○ |

### AvroRowDataDeserializationSchema (C-25 〜 C-30)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | RowTypeからデシリアライズスキーマ作成 | E-04 (L68-69, L80-87) | ○ |
| C-26 | deserialize()でAvroバイトがRowDataにデシリアライズ | E-04 (L135-145) | ○ |
| C-27 | deserialize(null)でnullが返却 | E-04 (L136-138) | ○ |
| C-28 | デシリアライズエラー時にIOException | E-04 (L143-144) | ○ |
| C-29 | getProducedType()でtypeInfoが返却 | E-04 (L153-155) | ○ |
| C-30 | isEndOfStream()で常にfalse | E-04 (L148-150) | ○ |

### RowDataToAvroConverters (C-31 〜 C-42)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | NULL型コンバータがnullを返す | E-05 (L83-91) | ○ |
| C-32 | TINYINT型がIntegerに変換 | E-05 (L94-102) | ○ |
| C-33 | SMALLINT型がIntegerに変換 | E-05 (L105-113) | ○ |
| C-34 | VARCHAR型がUtf8に変換 | E-05 (L136-144) | ○ |
| C-35 | BINARY型がByteBufferに変換 | E-05 (L148-156) | ○ |
| C-36 | TIMESTAMP型がlongに変換 | E-05 (L158-183) | ○ |
| C-37 | DECIMAL型がByteBufferに変換 | E-05 (L199-208) | ○ |
| C-38 | ARRAY型がListに変換 | E-05 (L210-211) | ○ |
| C-39 | ROW型がGenericRecordに変換 | E-05 (L213-214) | ○ |
| C-40 | MAP型がMapに変換 | E-05 (L216-218) | ○ |
| C-41 | RAW型でUnsupportedOperationException | E-05 (L220-222) | ○ |
| C-42 | null変換でnullが返却 | E-05 (L231-233) | ○ |

### AvroToRowDataConverters (C-43 〜 C-54)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | createRowConverter()でRowコンバータ作成 | E-06 (L71-94) | ○ |
| C-44 | IndexedRecordがGenericRowDataに変換 | E-06 (L84-93) | ○ |
| C-45 | TINYINT型がByteに変換 | E-06 (L115) | ○ |
| C-46 | VARCHAR型がStringDataに変換 | E-06 (L140) | ○ |
| C-47 | DATE型がintに変換 | E-06 (L127, L234-248) | ○ |
| C-48 | TIME型がintに変換 | E-06 (L129, L250-266) | ○ |
| C-49 | TIMESTAMP型がTimestampDataに変換 | E-06 (L131, L214-232) | ○ |
| C-50 | BINARY型がbyte[]に変換 | E-06 (L143, L268-279) | ○ |
| C-51 | DECIMAL型がDecimalDataに変換 | E-06 (L145, L159-175) | ○ |
| C-52 | ARRAY型がGenericArrayDataに変換 | E-06 (L147, L177-193) | ○ |
| C-53 | MAP型がGenericMapDataに変換 | E-06 (L151, L195-212) | ○ |
| C-54 | null変換でnullが返却 | E-06 (L100-105) | ○ |

### AvroSchemaConverter (C-55 〜 C-77)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | convertToTypeInfo(Class)でTypeInfo作成 | E-07 (L75-78) | ○ |
| C-56 | convertToTypeInfo(String)でTypeInfo作成 | E-07 (L105-107) | ○ |
| C-57 | 不正スキーマ文字列でIllegalArgumentException | E-07 (L124-126) | ○ |
| C-58 | nullスキーマでNullPointerException | E-07 (L120) | ○ |
| C-59 | convertToDataType()でDataType作成 | E-07 (L236-238) | ○ |
| C-60 | convertToSchema(LogicalType)でAvroスキーマ作成 | E-07 (L386-388) | ○ |
| C-61 | BOOLEAN型がbooleanスキーマに変換 | E-07 (L437-439) | ○ |
| C-62 | INTEGER型がintスキーマに変換 | E-07 (L440-444) | ○ |
| C-63 | BIGINT型がlongスキーマに変換 | E-07 (L445-447) | ○ |
| C-64 | VARCHAR型がstringスキーマに変換 | E-07 (L454-457) | ○ |
| C-65 | BINARY型がbytesスキーマに変換 | E-07 (L458-461) | ○ |
| C-66 | DATE型がdateロジカル型に変換 | E-07 (L514-517) | ○ |
| C-67 | TIME型がtime-millisロジカル型に変換 | E-07 (L518-529) | ○ |
| C-68 | TIMESTAMP型がtimestamp-millisロジカル型に変換 | E-07 (L462-491) | ○ |
| C-69 | TIME型precision>3でIllegalArgumentException | E-07 (L520-525) | ○ |
| C-70 | DECIMAL型がdecimalロジカル型に変換 | E-07 (L530-536) | ○ |
| C-71 | ROW型がrecordスキーマに変換 | E-07 (L537-561) | ○ |
| C-72 | ARRAY型がarrayスキーマに変換 | E-07 (L571-577) | ○ |
| C-73 | MAP型がmapスキーマに変換 | E-07 (L562-570) | ○ |
| C-74 | RAW型でUnsupportedOperationException | E-07 (L578-581) | ○ |
| C-75 | nullable型がunionスキーマに変換 | E-07 (L606-611) | ○ |
| C-76 | extractValueTypeToAvroMap()でMap値型抽出 | E-07 (L585-604) | ○ |
| C-77 | 非文字列キーでUnsupportedOperationException | E-07 (L597-601) | ○ |

### AvroSerializer (C-78 〜 C-89)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | コンストラクタ(Class)でSpecificRecord型シリアライザ作成 | E-08 (L107-112) | ○ |
| C-79 | GenericRecord型でIllegalArgumentException | E-08 (L109-111) | ○ |
| C-80 | コンストラクタ(Class,Schema)でGenericRecord型シリアライザ作成 | E-08 (L119-127) | ○ |
| C-81 | serialize()でオブジェクトがシリアライズ | E-08 (L172-187) | ○ |
| C-82 | deserialize()でバイトがデシリアライズ | E-08 (L190-204) | ○ |
| C-83 | deserialize(reuse)で再利用デシリアライズ | E-08 (L207-221) | ○ |
| C-84 | copy()でディープコピー | E-08 (L228-241) | ○ |
| C-85 | createInstance()で新インスタンス作成 | E-08 (L166-170) | ○ |
| C-86 | duplicate()で複製作成 | E-08 (L279-283) | ○ |
| C-87 | snapshotConfiguration()でSnapshot返却 | E-08 (L261-267) | ○ |
| C-88 | isImmutableType()でfalse | E-08 (L152-154) | ○ |
| C-89 | getLength()で-1 | E-08 (L156-158) | ○ |

### AvroInputFormat (C-90 〜 C-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | コンストラクタでInputFormat作成 | E-09 (L72-75) | ○ |
| C-91 | open()でDataFileReader初期化 | E-09 (L107-112) | ○ |
| C-92 | nextRecord()でレコード読み込み | E-09 (L156-179) | ○ |
| C-93 | reuseAvroValue=falseで新規インスタンス | E-09 (L171-178) | ○ |
| C-94 | reachedEndでnull返却 | E-09 (L157-159) | ○ |
| C-95 | reachedEnd()でファイル終端判定 | E-09 (L147-149) | ○ |
| C-96 | reachedEnd()でファイル途中false | E-09 (L147-149) | ○ |
| C-97 | getProducedType()でTypeInformation返却 | E-09 (L98-100) | ○ |
| C-98 | getCurrentState()で状態返却 | E-09 (L186-188) | ○ |
| C-99 | reopen()で状態復元 | E-09 (L191-212) | ○ |
| C-100 | reopen(null split)でNullPointerException | E-09 (L192) | ○ |

### AvroOutputFormat (C-101 〜 C-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | コンストラクタでOutputFormat作成 | E-10 (L91-94) | ○ |
| C-102 | open()でDataFileWriter初期化 | E-10 (L124-157) | ○ |
| C-103 | SpecificRecordで適切なDatumWriter作成 | E-10 (L129-137) | ○ |
| C-104 | GenericRecordでスキーマ未設定時IllegalStateException | E-10 (L139-141) | ○ |
| C-105 | writeRecord()でレコード書き込み | E-10 (L119-121) | ○ |
| C-106 | close()でフラッシュ・クローズ | E-10 (L198-202) | ○ |
| C-107 | setCodec()で圧縮コーデック設定 | E-10 (L114-116) | ○ |
| C-108 | setCodec(null)でNullPointerException | E-10 (L115) | ○ |
| C-109 | setSchema()でスキーマ設定 | E-10 (L105-107) | ○ |
| C-110 | Codec.forCodecByte()で有効バイト変換 | E-10 (L71-78) | ○ |
| C-111 | 無効codecByteでIllegalArgumentException | E-10 (L77) | ○ |

### AvroFormatFactory (C-112 〜 C-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | factoryIdentifier()で"avro"返却 | E-11 (L114-116) | ○ |
| C-113 | createDecodingFormat()でDecodingFormat作成 | E-11 (L60-87) | ○ |
| C-114 | createEncodingFormat()でEncodingFormat作成 | E-11 (L89-111) | ○ |
| C-115 | requiredOptions()で空Set返却 | E-11 (L119-121) | ○ |
| C-116 | optionalOptions()でオプションSet返却 | E-11 (L123-129) | ○ |

### RegistryAvroDeserializationSchema (C-117 〜 C-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | コンストラクタでスキーマ作成 | E-12 (L60-88) | ○ |
| C-118 | deserialize()でスキーマ読み込みデシリアライズ | E-12 (L91-110) | ○ |
| C-119 | deserialize(null)でnull返却 | E-12 (L92-94) | ○ |
| C-120 | checkAvroInitialized()でschemaCoder初期化 | E-12 (L113-118) | ○ |

### RegistryAvroSerializationSchema (C-121 〜 C-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | forSpecific()でSpecificRecord用スキーマ作成 | E-13 (L84-94) | ○ |
| C-122 | forGeneric()でGenericRecord用スキーマ作成 | E-13 (L96-107) | ○ |
| C-123 | serialize()でスキーマ付きシリアライズ | E-13 (L109-128) | ○ |
| C-124 | serialize(null)でnull返却 | E-13 (L113-114) | ○ |

### AvroTypeInfo (C-125 〜 C-126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | コンストラクタでAvroTypeInfo作成 | E-14 (L54-56) | ○ |
| C-126 | createSerializer()でAvroSerializer作成 | E-14 (L59-61) | ○ |

### GenericRecordAvroTypeInfo (C-127 〜 C-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | コンストラクタでGenericRecordAvroTypeInfo作成 | E-15 (L43-45) | ○ |
| C-128 | createSerializer()でAvroSerializer作成 | E-15 (L78-80) | ○ |
| C-129 | getTypeClass()でGenericRecord.class返却 | E-15 (L68-70) | ○ |
| C-130 | equals()で同一スキーマtrue | E-15 (L88-95) | ○ |

### AvroFactory (C-131 〜 C-138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | create()でSpecificRecord型AvroFactory作成 | E-16 (L89-91) | ○ |
| C-132 | create()でGenericRecord型AvroFactory作成 | E-16 (L92-94) | ○ |
| C-133 | create()でリフレクション型AvroFactory作成 | E-16 (L95-96) | ○ |
| C-134 | GenericRecordでスキーマnull時NullPointerException | E-16 (L119-121) | ○ |
| C-135 | parseSchemaString()でスキーマパース | E-16 (L99-101) | ○ |
| C-136 | parseSchemaString(null)でnull返却 | E-16 (L100) | ○ |
| C-137 | extractAvroSpecificSchema()でスキーマ抽出 | E-16 (L148-151) | ○ |
| C-138 | getSpecificDataForClass()でSpecificData取得 | E-16 (L161-172) | ○ |

### AbstractAvroBulkFormat (C-139 〜 C-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | createReader()でAvroReader作成 | E-17 (L58-59) | ○ |
| C-140 | restoreReader()でAvroReader復元 | E-17 (L63-65) | ○ |
| C-141 | isSplittable()でtrue返却 | E-17 (L68-70) | ○ |
| C-142 | readBatch()でバッチ読み込み | E-17 (L144-173) | ○ |
| C-143 | ファイル終端でnull返却 | E-17 (L154-157) | ○ |
| C-144 | close()でDataFileReaderクローズ | E-17 (L182-184) | ○ |

### MutableByteArrayInputStream (C-145 〜 C-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | コンストラクタで空バッファ初期化 | E-18 (L30-32) | ○ |
| C-146 | setBuffer()でバッファ設定 | E-18 (L40-44) | ○ |
| C-147 | 空バイト配列設定 | E-18 (L40-44) | ○ |

### SchemaCoder (C-148 〜 C-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | readSchema()でスキーマ読み込み | E-19 (L33) | ○ |
| C-149 | writeSchema()でスキーマ書き込み | E-19 (L35) | ○ |
| C-150 | SchemaCoderProvider.get()でインスタンス返却 | E-19 (L49) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべてのテストケースはソースコードを直接解析して生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] AvroDeserializationSchema: null入力処理、例外処理のテストケースが適切か確認
- [ ] AvroSerializationSchema: シリアライズ・デシリアライズの往復テストが考慮されているか確認
- [ ] AvroSchemaConverter: 各型変換のテストケースが網羅されているか確認
- [ ] AvroSerializer: 並行アクセス制限のテストケースが必要か検討
- [ ] AvroInputFormat/OutputFormat: ファイルI/Oのエッジケース（大容量ファイル、空ファイル等）が考慮されているか確認
- [ ] RowDataToAvroConverters/AvroToRowDataConverters: 全型変換のテストケースが網羅されているか確認
