---
generated_at: 2026-02-02 18:35:00
metrics:
  claims_total: 78
  claims_with_evidence: 78
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-formats_flink-hadoop-bulk 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：78 / 78、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/formats/hadoop/bulk/HadoopFileCommitter.java`
- E-02: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/formats/hadoop/bulk/HadoopFileCommitterFactory.java`
- E-03: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/formats/hadoop/bulk/DefaultHadoopFileCommitterFactory.java`
- E-04: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/formats/hadoop/bulk/HadoopPathBasedPartFileWriter.java`
- E-05: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/formats/hadoop/bulk/HadoopPathBasedBulkWriter.java`
- E-06: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/formats/hadoop/bulk/committer/HadoopRenameFileCommitter.java`
- E-07: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/HadoopPathBasedBulkFormatBuilder.java`
- E-08: `flink-formats/flink-hadoop-bulk/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/SerializableConfiguration.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### DefaultHadoopFileCommitterFactory (UT-HDB-001 ~ UT-HDB-005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | create()メソッドがHadoopRenameFileCommitterを生成する | E-03 L34-38 | ○ |
| C-02 | create()でnullのConfigurationが渡された場合の処理 | E-03（暗黙的にHadoopRenameFileCommitterに委譲） | ○ |
| C-03 | create()でnullのPathが渡された場合の処理 | E-03（暗黙的にHadoopRenameFileCommitterに委譲） | ○ |
| C-04 | recoverForCommit()メソッドがリカバリ用Committerを生成する | E-03 L41-46 | ○ |
| C-05 | recoverForCommit()でnullのtempFilePathの処理 | E-03（暗黙的にHadoopRenameFileCommitterに委譲） | ○ |

### HadoopRenameFileCommitter (UT-HDB-006 ~ UT-HDB-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | 2引数コンストラクタでインスタンス生成 | E-06 L44-49 | ○ |
| C-07 | 相対パスが渡された場合にIllegalArgumentException | E-06 L111 `checkArgument(targetFilePath.isAbsolute())` | ○ |
| C-08 | 3引数コンストラクタでリカバリ用インスタンス生成 | E-06 L51-58 | ○ |
| C-09 | getTargetFilePath()がtargetFilePathを返却 | E-06 L61-63 | ○ |
| C-10 | getTempFilePath()がtempFilePathを返却 | E-06 L65-68 | ○ |
| C-11 | preCommit()が何もしない | E-06 L70-73 `// Do nothing.` | ○ |
| C-12 | commit()がtempFileをtargetFileにリネーム | E-06 L76-78, L85-108 | ○ |
| C-13 | commit()でtempFileが存在しない場合にIOException | E-06 L88-91 | ○ |
| C-14 | commit()でリネーム失敗時にIOException | E-06 L99-107 | ○ |
| C-15 | commitAfterRecovery()がリカバリ後にリネーム | E-06 L80-83 | ○ |
| C-16 | commitAfterRecovery()でtempFileが存在しない場合は何もしない | E-06 L92-96 `assertFileExists=false` | ○ |
| C-17 | generateTempFilePath()が一意のパスを生成 | E-06 L110-125 | ○ |
| C-18 | generateTempFilePath()で衝突時に再生成 | E-06 L118-124 `while(true)` ループ | ○ |

### HadoopPathBasedPartFileWriter (UT-HDB-019 ~ UT-HDB-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | コンストラクタでインスタンス生成 | E-04 L45-55 | ○ |
| C-20 | write()で要素が書き込まれる | E-04 L57-61 | ○ |
| C-21 | write()でnull要素の処理 | E-04 L57-61（writerに委譲） | ○ |
| C-22 | persist()がUnsupportedOperationException | E-04 L63-66 | ○ |
| C-23 | closeForCommit()でコミット準備 | E-04 L68-74 | ○ |
| C-24 | closeForCommit()でflush中のIOException | E-04 L70-72（throws IOException） | ○ |
| C-25 | dispose()でwriterが破棄される | E-04 L76-79 | ○ |
| C-26 | getSize()で書き込みサイズ取得 | E-04 L81-84 | ○ |

### HadoopPathBasedPendingFile (UT-HDB-027 ~ UT-HDB-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | commit()がfileCommitterのcommitを呼ぶ | E-04 L96-99 | ○ |
| C-28 | commitAfterRecovery()がfileCommitterのcommitAfterRecoveryを呼ぶ | E-04 L101-104 | ○ |
| C-29 | getRecoverable()がRecoverableを返却 | E-04 L106-109 | ○ |

### HadoopPathBasedPendingFileRecoverable (UT-HDB-030 ~ UT-HDB-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | 2引数コンストラクタ（非推奨）でfileSize=-1L | E-04 L120-127 `@Deprecated` | ○ |
| C-31 | 3引数コンストラクタでインスタンス生成 | E-04 L128-133 | ○ |
| C-32 | getTargetFilePath()が正しく返却 | E-04 L135-137 | ○ |
| C-33 | getTempFilePath()が正しく返却 | E-04 L139-141 | ○ |
| C-34 | getPath()がFlink Pathを返却 | E-04 L143-146 | ○ |
| C-35 | getSize()がfileSizeを返却 | E-04 L148-151 | ○ |
| C-36 | getSize()で-1Lの返却 | E-04 L125 `this.fileSize = -1L` | ○ |

### HadoopPathBasedPendingFileRecoverableSerializer (UT-HDB-037 ~ UT-HDB-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | getVersion()が2を返却 | E-04 L166-168 | ○ |
| C-38 | serialize()が正しくシリアライズ | E-04 L170-198 | ○ |
| C-39 | serialize()で非対応型にUnsupportedOperationException | E-04 L172-177 | ○ |
| C-40 | deserialize()でバージョン2のデシリアライズ | E-04 L200-211, L233-253 | ○ |
| C-41 | deserialize()でバージョン1のデシリアライズ（後方互換性） | E-04 L204-205, L213-231 | ○ |
| C-42 | deserialize()で不正バージョンにIOException | E-04 L208-209 | ○ |
| C-43 | deserialize()で不正マジックナンバーにIOException | E-04 L217-219, L237-239 | ○ |
| C-44 | deserialize()で空パスの処理 | E-04 L221-230, L241-252 | ○ |

### UnsupportedInProgressFileRecoverableSerializable (UT-HDB-045 ~ UT-HDB-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | getVersion()がUnsupportedOperationException | E-04 L263-266 | ○ |
| C-46 | serialize()がUnsupportedOperationException | E-04 L268-271 | ○ |
| C-47 | deserialize()がUnsupportedOperationException | E-04 L273-278 | ○ |

### HadoopPathBasedBucketWriter (UT-HDB-048 ~ UT-HDB-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | コンストラクタでインスタンス生成 | E-04 L294-302 | ○ |
| C-49 | openNewInProgressFile()でPartFileWriter生成 | E-04 L304-317 | ○ |
| C-50 | openNewInProgressFile()でnullパスの処理 | E-04 L309（Pathコンストラクタに委譲） | ○ |
| C-51 | recoverPendingFile()でPendingFileリカバリ | E-04 L319-337 | ○ |
| C-52 | recoverPendingFile()で非対応型にUnsupportedOperationException | E-04 L322-327 | ○ |
| C-53 | getProperties()がWriterPropertiesを返却 | E-04 L339-345 | ○ |
| C-54 | resumeInProgressFileFrom()がUnsupportedOperationException | E-04 L347-354 | ○ |
| C-55 | cleanupInProgressFileRecoverable()がfalseを返却 | E-04 L356-360 | ○ |

### HadoopPathBasedBulkFormatBuilder (UT-HDB-056 ~ UT-HDB-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | 4引数コンストラクタでデフォルト設定 | E-07 L60-75 | ○ |
| C-57 | 4引数コンストラクタでnullのbasePathにNPE | E-07 L87 `Preconditions.checkNotNull(basePath)` | ○ |
| C-58 | 8引数コンストラクタでカスタム設定 | E-07 L77-95 | ○ |
| C-59 | withBucketAssigner()で設定更新 | E-07 L97-100 | ○ |
| C-60 | withBucketAssigner()でnullにNPE | E-07 L98 `Preconditions.checkNotNull(assigner)` | ○ |
| C-61 | withRollingPolicy()で設定更新 | E-07 L102-105 | ○ |
| C-62 | withRollingPolicy()でnullにNPE | E-07 L103 `Preconditions.checkNotNull(rollingPolicy)` | ○ |
| C-63 | withBucketFactory()で設定更新 | E-07 L107-110 | ○ |
| C-64 | withBucketFactory()でnullにNPE | E-07 L108 `Preconditions.checkNotNull(factory)` | ○ |
| C-65 | withOutputFileConfig()で設定更新 | E-07 L112-115 | ○ |
| C-66 | withConfiguration()で設定更新 | E-07 L117-120 | ○ |
| C-67 | createBucketWriter()でBucketWriter生成 | E-07 L122-126 | ○ |
| C-68 | createBuckets()でBuckets生成 | E-07 L128-138 | ○ |
| C-69 | createBuckets()でsubtaskIndex=0の処理 | E-07 L129-137 | ○ |
| C-70 | createBuckets()で大きいsubtaskIndexの処理 | E-07 L129-137 | ○ |

### SerializableConfiguration (UT-HDB-071 ~ UT-HDB-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | コンストラクタでインスタンス生成 | E-08 L37-39 | ○ |
| C-72 | コンストラクタでnullの処理 | E-08 L37-39（null許容の可能性） | ○ |
| C-73 | getConfiguration()がConfigurationを返却 | E-08 L41-43 | ○ |
| C-74 | writeObject()でシリアライズ | E-08 L45-47 | ○ |
| C-75 | readObject()でデシリアライズ | E-08 L49-55 | ○ |
| C-76 | readObject()でconfigurationがnullの場合に新規生成 | E-08 L50-52 | ○ |
| C-77 | シリアライズ往復テスト | E-08 L45-55 | ○ |
| C-78 | 空Configurationのシリアライズ | E-08 L45-55 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全テストケースはソースコードの実装に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - 全テストケースにソースコード根拠あり
  - インターフェース（HadoopFileCommitter、HadoopFileCommitterFactory、HadoopPathBasedBulkWriter）はテストケース生成対象外（実装クラスでテスト）

## 6) レビュアーチェックリスト（最小）
- [ ] HadoopRenameFileCommitterのcommit/commitAfterRecoveryのファイル操作テストが実際のファイルシステムで動作することを確認
- [ ] シリアライズ・デシリアライズのテストでバージョン間の後方互換性が正しく検証されることを確認
- [ ] UnsupportedOperationExceptionをスローするメソッドのテストが適切であることを確認
- [ ] Hadoopファイルシステム依存のテストがモック化されているか、または統合テストとして実行されることを確認
- [ ] 境界値テスト（空パス、大きいsubtaskIndex等）が十分にカバーされていることを確認
