---
generated_at: 2026-02-02 15:30:00
metrics:
  claims_total: 121
  claims_with_evidence: 121
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-formats_flink-json 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：121 / 121、根拠なし：0
- 優先レビュー（高）
  1. なし：全てのテストケースはソースコードに基づいて生成されている
  2. なし：各クラス・メソッドの実装を直接参照して抽出
  3. なし：テスト観点は標準的な単体テスト手法に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonSerializationSchema.java`
- E-02: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonDeserializationSchema.java`
- E-03: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonRowDataSerializationSchema.java`
- E-04: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonRowDataDeserializationSchema.java`
- E-05: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/AbstractJsonDeserializationSchema.java`
- E-06: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonToRowDataConverters.java`
- E-07: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/RowDataToJsonConverters.java`
- E-08: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonRowSchemaConverter.java`
- E-09: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonParserRowDataDeserializationSchema.java`
- E-10: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonParserToRowDataConverters.java`
- E-11: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonFormatFactory.java`
- E-12: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonFormatOptions.java`
- E-13: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonFormatOptionsUtil.java`
- E-14: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonParseException.java`
- E-15: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/canal/CanalJsonDeserializationSchema.java`
- E-16: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/canal/CanalJsonSerializationSchema.java`
- E-17: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/canal/CanalJsonFormatFactory.java`
- E-18: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/canal/CanalJsonFormatOptions.java`
- E-19: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/canal/CanalJsonDecodingFormat.java`
- E-20: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/debezium/DebeziumJsonDeserializationSchema.java`
- E-21: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/debezium/DebeziumJsonSerializationSchema.java`
- E-22: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/debezium/DebeziumJsonFormatFactory.java`
- E-23: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/debezium/DebeziumJsonFormatOptions.java`
- E-24: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/debezium/DebeziumJsonDecodingFormat.java`
- E-25: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/maxwell/MaxwellJsonDeserializationSchema.java`
- E-26: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/maxwell/MaxwellJsonSerializationSchema.java`
- E-27: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/maxwell/MaxwellJsonFormatFactory.java`
- E-28: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/maxwell/MaxwellJsonFormatOptions.java`
- E-29: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/maxwell/MaxwellJsonDecodingFormat.java`
- E-30: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/ogg/OggJsonDeserializationSchema.java`
- E-31: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/ogg/OggJsonSerializationSchema.java`
- E-32: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/ogg/OggJsonFormatFactory.java`
- E-33: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/ogg/OggJsonFormatOptions.java`
- E-34: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/ogg/OggJsonDecodingFormat.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JsonSerializationSchema.serialize - 有効なオブジェクトがJSON形式のbyte配列にシリアライズされること | E-01 (line 51-58) | ○ |
| C-02 | JsonSerializationSchema.serialize - シリアライズ失敗時にRuntimeExceptionがスローされること | E-01 (line 54-57) | ○ |
| C-03 | JsonSerializationSchema.open - ObjectMapperが正しく初期化されること | E-01 (line 46-48) | ○ |
| C-04 | JsonSerializationSchema - カスタムObjectMapperFactoryで初期化できること | E-01 (line 41-43) | ○ |
| C-05 | JsonDeserializationSchema.deserialize - 有効なJSONバイト配列がオブジェクトにデシリアライズされること | E-02 (line 67-70) | ○ |
| C-06 | JsonDeserializationSchema.deserialize - 不正なJSONフォーマットでIOExceptionがスローされること | E-02 (line 68-69) | ○ |
| C-07 | JsonDeserializationSchema.open - ObjectMapperが正しく初期化されること | E-02 (line 62-65) | ○ |
| C-08 | JsonDeserializationSchema - Class型で初期化できること | E-02 (line 40-42) | ○ |
| C-09 | JsonDeserializationSchema - TypeInformation型で初期化できること | E-02 (line 44-46) | ○ |
| C-10 | JsonRowDataSerializationSchema.serialize - RowDataがJSON byte配列にシリアライズされること | E-03 (line 109-121) | ○ |
| C-11 | JsonRowDataSerializationSchema.serialize - シリアライズ失敗時にRuntimeExceptionがスローされること | E-03 (line 118-120) | ○ |
| C-12 | JsonRowDataSerializationSchema.serialize - nullフィールドを無視するオプションが機能すること | E-03 (line 74, 111-112) | ○ |
| C-13 | JsonRowDataSerializationSchema.serialize - Decimalがプレーンナンバーとしてエンコードされること | E-03 (line 71, 103-104) | ○ |
| C-14 | JsonRowDataSerializationSchema.open - ObjectMapperが正しく設定されること | E-03 (line 98-107) | ○ |
| C-15 | JsonRowDataSerializationSchema.equals - 同一設定のスキーマが等しいと判定されること | E-03 (line 123-138) | ○ |
| C-16 | JsonRowDataSerializationSchema.hashCode - 同一設定のスキーマが同じハッシュコードを返すこと | E-03 (line 140-149) | ○ |
| C-17 | JsonRowDataDeserializationSchema.deserialize - JSON配列がRowDataに正しくデシリアライズされること | E-04 (line 74-88) | ○ |
| C-18 | JsonRowDataDeserializationSchema.deserialize - JSONオブジェクトがRowDataに正しくデシリアライズされること | E-04 (line 89-93) | ○ |
| C-19 | JsonRowDataDeserializationSchema.deserialize - nullメッセージが渡された場合に何も出力しないこと | E-04 (line 69-71) | ○ |
| C-20 | JsonRowDataDeserializationSchema.deserialize - パースエラー無視オプションがtrueの場合に例外をスローしないこと | E-04 (line 95-100) | ○ |
| C-21 | JsonRowDataDeserializationSchema.deserialize - パースエラー無視オプションがfalseの場合にIOExceptionがスローされること | E-04 (line 96-99) | ○ |
| C-22 | JsonRowDataDeserializationSchema.deserializeToJsonNode - byte配列がJsonNodeに変換されること | E-04 (line 103-105) | ○ |
| C-23 | JsonRowDataDeserializationSchema.convertToRowData - JsonNodeがRowDataに変換されること | E-04 (line 107-109) | ○ |
| C-24 | AbstractJsonDeserializationSchema - ignoreParseErrorsとfailOnMissingFieldが両方trueの場合に例外がスローされること | E-05 (line 83-86) | ○ |
| C-25 | AbstractJsonDeserializationSchema.deserialize - 非推奨のdeserializeメソッドが正しく動作すること | E-05 (line 115-127) | ○ |
| C-26 | AbstractJsonDeserializationSchema.deserialize - 複数レコードの場合にFlinkRuntimeExceptionがスローされること | E-05 (line 118-122) | ○ |
| C-27 | AbstractJsonDeserializationSchema.isEndOfStream - 常にfalseを返すこと | E-05 (line 130-132) | ○ |
| C-28 | AbstractJsonDeserializationSchema.getProducedType - 正しいTypeInformationが返却されること | E-05 (line 134-137) | ○ |
| C-29 | JsonToRowDataConverters.createConverter - BOOLEAN型のコンバーターが正しく変換すること | E-06 (line 110-111, 162-169) | ○ |
| C-30 | JsonToRowDataConverters.createConverter - TINYINT型のコンバーターが正しく変換すること | E-06 (line 112-113) | ○ |
| C-31 | JsonToRowDataConverters.createConverter - INTEGER型のコンバーターが正しく変換すること | E-06 (line 116-118, 171-178) | ○ |
| C-32 | JsonToRowDataConverters.createConverter - BIGINT型のコンバーターが正しく変換すること | E-06 (line 119-121, 180-187) | ○ |
| C-33 | JsonToRowDataConverters.createConverter - FLOAT型のコンバーターが正しく変換すること | E-06 (line 130-131, 198-205) | ○ |
| C-34 | JsonToRowDataConverters.createConverter - DOUBLE型のコンバーターが正しく変換すること | E-06 (line 132-133, 189-196) | ○ |
| C-35 | JsonToRowDataConverters.createConverter - VARCHAR型のコンバーターが正しく変換すること | E-06 (line 134-136, 265-271) | ○ |
| C-36 | JsonToRowDataConverters.createConverter - DATE型のコンバーターが正しく変換すること | E-06 (line 122-123, 207-210) | ○ |
| C-37 | JsonToRowDataConverters.createConverter - TIME型のコンバーターが正しく変換すること | E-06 (line 124-125, 212-218) | ○ |
| C-38 | JsonToRowDataConverters.createConverter - TIMESTAMP型のコンバーターがSQL形式で正しく変換すること | E-06 (line 126-127, 220-239) | ○ |
| C-39 | JsonToRowDataConverters.createConverter - TIMESTAMP型のコンバーターがISO-8601形式で正しく変換すること | E-06 (line 126-127, 220-239) | ○ |
| C-40 | JsonToRowDataConverters.createConverter - DECIMAL型のコンバーターが正しく変換すること | E-06 (line 140-141, 281-293) | ○ |
| C-41 | JsonToRowDataConverters.createConverter - ARRAY型のコンバーターが正しく変換すること | E-06 (line 142-143, 295-308) | ○ |
| C-42 | JsonToRowDataConverters.createConverter - MAP型のコンバーターが正しく変換すること | E-06 (line 144-147, 310-332) | ○ |
| C-43 | JsonToRowDataConverters.createConverter - MAP型でキーがSTRING型でない場合に例外がスローされること | E-06 (line 312-317) | ○ |
| C-44 | JsonToRowDataConverters.createConverter - ROW型のコンバーターが正しく変換すること | E-06 (line 154-155, 334-359) | ○ |
| C-45 | JsonToRowDataConverters.createConverter - RAW型でUnsupportedOperationExceptionがスローされること | E-06 (line 156-158) | ○ |
| C-46 | JsonToRowDataConverters.createRowConverter - フィールドが存在しない場合にfailOnMissingFieldがtrueならJsonParseExceptionがスローされること | E-06 (line 361-372) | ○ |
| C-47 | JsonToRowDataConverters.createRowConverter - フィールドが存在しない場合にfailOnMissingFieldがfalseならnullが設定されること | E-06 (line 363-368) | ○ |
| C-48 | JsonToRowDataConverters.wrapIntoNullableConverter - nullノードが渡された場合にnullを返すこと | E-06 (line 374-388) | ○ |
| C-49 | JsonToRowDataConverters.wrapIntoNullableConverter - missingノードが渡された場合にnullを返すこと | E-06 (line 376) | ○ |
| C-50 | RowDataToJsonConverters.createConverter - BOOLEAN型がJsonNodeに正しく変換されること | E-07 (line 104-106) | ○ |
| C-51 | RowDataToJsonConverters.createConverter - 各プリミティブ型がJsonNodeに正しく変換されること | E-07 (line 100-156) | ○ |
| C-52 | RowDataToJsonConverters.createConverter - DATE型がISO形式の文字列に変換されること | E-07 (line 169-175) | ○ |
| C-53 | RowDataToJsonConverters.createConverter - TIMESTAMP型がSQL形式で変換されること | E-07 (line 185-203) | ○ |
| C-54 | RowDataToJsonConverters.createConverter - TIMESTAMP型がISO-8601形式で変換されること | E-07 (line 185-203) | ○ |
| C-55 | RowDataToJsonConverters.createMapConverter - mapNullKeyMode=FAILの場合にnullキーでRuntimeExceptionがスローされること | E-07 (line 293-299) | ○ |
| C-56 | RowDataToJsonConverters.createMapConverter - mapNullKeyMode=DROPの場合にnullキーがスキップされること | E-07 (line 291-292) | ○ |
| C-57 | RowDataToJsonConverters.createMapConverter - mapNullKeyMode=LITERALの場合にnullキーがリテラル文字列に置換されること | E-07 (line 288-290) | ○ |
| C-58 | RowDataToJsonConverters.createRowConverter - ignoreNullFieldsがtrueの場合にnullフィールドがスキップされること | E-07 (line 344) | ○ |
| C-59 | RowDataToJsonConverters.wrapIntoNullableConverter - null値がnullNodeに変換されること | E-07 (line 358-366) | ○ |
| C-60 | JsonRowSchemaConverter.convert - 有効なJSONスキーマがTypeInformationに変換されること | E-08 (line 99-113) | ○ |
| C-61 | JsonRowSchemaConverter.convert - 不正なJSONスキーマでIllegalArgumentExceptionがスローされること | E-08 (line 109-111) | ○ |
| C-62 | JsonRowSchemaConverter.convert - string型がTypes.STRINGに変換されること | E-08 (line 155-164) | ○ |
| C-63 | JsonRowSchemaConverter.convert - integer型がTypes.BIG_DECに変換されること | E-08 (line 168-172) | ○ |
| C-64 | JsonRowSchemaConverter.convert - object型がTypes.ROWに変換されること | E-08 (line 173-174, 240-277) | ○ |
| C-65 | JsonRowSchemaConverter.convert - array型がTypes.OBJECT_ARRAYに変換されること | E-08 (line 176-177, 279-309) | ○ |
| C-66 | JsonRowSchemaConverter.convert - format: dateがTypes.SQL_DATEに変換されること | E-08 (line 311-327) | ○ |
| C-67 | JsonRowSchemaConverter.convert - $refが正しく解決されること | E-08 (line 121-127, 350-367) | ○ |
| C-68 | JsonRowSchemaConverter.convert - 循環参照でIllegalArgumentExceptionがスローされること | E-08 (line 363-365) | ○ |
| C-69 | JsonParserRowDataDeserializationSchema.deserialize - JSONオブジェクトがRowDataに正しくデシリアライズされること | E-09 (line 112-114) | ○ |
| C-70 | JsonParserRowDataDeserializationSchema.deserialize - JSON配列がRowDataに正しくデシリアライズされること | E-09 (line 106-110) | ○ |
| C-71 | JsonParserRowDataDeserializationSchema.deserialize - 空のbyte配列が渡された場合に何も出力しないこと | E-09 (line 77-79) | ○ |
| C-72 | JsonParserRowDataDeserializationSchema.deserialize - 内容がない場合にJsonMappingExceptionがスローされること | E-09 (line 89-92) | ○ |
| C-73 | JsonParserRowDataDeserializationSchema.deserialize - プロジェクションプッシュダウンが正しく動作すること | E-09 (line 67-73) | ○ |
| C-74 | JsonParserToRowDataConverters.createConverter - projectedFieldsがnullの場合に通常のコンバーターが作成されること | E-10 (line 104-110) | ○ |
| C-75 | JsonParserToRowDataConverters.createRowConverter - ROW型のコンバーターが正しく動作すること | E-10 (line 384-432) | ○ |
| C-76 | JsonParserToRowDataConverters.skipToNextField - ネストしたオブジェクトが正しくスキップされること | E-10 (line 434-452) | ○ |
| C-77 | JsonFormatFactory.createDecodingFormat - DecodingFormatが正しく作成されること | E-11 (line 66-116) | ○ |
| C-78 | JsonFormatFactory.createEncodingFormat - EncodingFormatが正しく作成されること | E-11 (line 138-172) | ○ |
| C-79 | JsonFormatFactory.factoryIdentifier - 識別子"json"が返却されること | E-11 (line 63, 174-177) | ○ |
| C-80 | JsonFormatOptionsUtil.getTimestampFormat - SQLフォーマットが正しく返却されること | E-13 (line 61-74) | ○ |
| C-81 | JsonFormatOptionsUtil.getTimestampFormat - ISO-8601フォーマットが正しく返却されること | E-13 (line 61-74) | ○ |
| C-82 | JsonFormatOptionsUtil.getMapNullKeyMode - FAILモードが正しく返却されること | E-13 (line 82-97) | ○ |
| C-83 | JsonFormatOptionsUtil.validateDecodingFormatOptions - ignoreParseErrorsとfailOnMissingFieldが両方trueの場合にValidationExceptionがスローされること | E-13 (line 104-115) | ○ |
| C-84 | JsonFormatOptionsUtil.validateEncodingFormatOptions - 不正なmapNullKeyModeでValidationExceptionがスローされること | E-13 (line 118-133) | ○ |
| C-85 | JsonParseException - メッセージのみで例外が作成されること | E-14 (line 25-27) | ○ |
| C-86 | JsonParseException - メッセージと原因で例外が作成されること | E-14 (line 29-31) | ○ |
| C-87 | CanalJsonDeserializationSchema.deserialize - INSERT操作がRowKind.INSERTとして処理されること | E-15 (line 241-248) | ○ |
| C-88 | CanalJsonDeserializationSchema.deserialize - UPDATE操作がUPDATE_BEFOREとUPDATE_AFTERとして処理されること | E-15 (line 249-271) | ○ |
| C-89 | CanalJsonDeserializationSchema.deserialize - DELETE操作がRowKind.DELETEとして処理されること | E-15 (line 272-279) | ○ |
| C-90 | CanalJsonDeserializationSchema.deserialize - CREATE(DDL)操作がスキップされること | E-15 (line 280-283) | ○ |
| C-91 | CanalJsonDeserializationSchema.deserialize - databaseフィルタが正しく機能すること | E-15 (line 225-230) | ○ |
| C-92 | CanalJsonDeserializationSchema.deserialize - tableフィルタが正しく機能すること | E-15 (line 231-238) | ○ |
| C-93 | CanalJsonDeserializationSchema.deserialize - 不明なtype値でIOExceptionがスローされること | E-15 (line 284-291) | ○ |
| C-94 | CanalJsonSerializationSchema.serialize - INSERTがtype=INSERTとしてシリアライズされること | E-16 (line 81-91) | ○ |
| C-95 | CanalJsonSerializationSchema.serialize - DELETEがtype=DELETEとしてシリアライズされること | E-16 (line 81-91) | ○ |
| C-96 | CanalJsonSerializationSchema.rowKind2String - 未サポートのRowKindでUnsupportedOperationExceptionがスローされること | E-16 (line 93-105) | ○ |
| C-97 | DebeziumJsonDeserializationSchema.deserialize - op=cがRowKind.INSERTとして処理されること | E-20 (line 153-155) | ○ |
| C-98 | DebeziumJsonDeserializationSchema.deserialize - op=rがRowKind.INSERTとして処理されること | E-20 (line 153-155) | ○ |
| C-99 | DebeziumJsonDeserializationSchema.deserialize - op=uがUPDATE_BEFOREとUPDATE_AFTERとして処理されること | E-20 (line 156-164) | ○ |
| C-100 | DebeziumJsonDeserializationSchema.deserialize - UPDATEでbeforeがnullの場合にIllegalStateExceptionがスローされること | E-20 (line 157-159) | ○ |
| C-101 | DebeziumJsonDeserializationSchema.deserialize - schemaInclude=trueでpayloadからデータが抽出されること | E-20 (line 144-148) | ○ |
| C-102 | DebeziumJsonSerializationSchema.serialize - INSERTがop=cとしてシリアライズされること | E-21 (line 78-102) | ○ |
| C-103 | DebeziumJsonSerializationSchema.serialize - DELETEがop=dとしてシリアライズされること | E-21 (line 78-102) | ○ |
| C-104 | DebeziumJsonFormatFactory.createDecodingFormat - DecodingFormatが正しく作成されること | E-22 (line 65-80) | ○ |
| C-105 | DebeziumJsonFormatFactory.createEncodingFormat - schemaInclude=trueの場合にValidationExceptionがスローされること | E-22 (line 154-164) | ○ |
| C-106 | MaxwellJsonDeserializationSchema.deserialize - type=insertがRowKind.INSERTとして処理されること | E-25 (line 138-142) | ○ |
| C-107 | MaxwellJsonDeserializationSchema.deserialize - type=updateがUPDATE_BEFOREとUPDATE_AFTERとして処理されること | E-25 (line 143-161) | ○ |
| C-108 | MaxwellJsonDeserializationSchema.deserialize - type=deleteがRowKind.DELETEとして処理されること | E-25 (line 162-166) | ○ |
| C-109 | MaxwellJsonSerializationSchema.serialize - INSERTがtype=insertとしてシリアライズされること | E-26 (line 79-83) | ○ |
| C-110 | MaxwellJsonSerializationSchema.serialize - DELETEがtype=deleteとしてシリアライズされること | E-26 (line 79-83) | ○ |
| C-111 | OggJsonDeserializationSchema.deserialize - op_type=IがRowKind.INSERTとして処理されること | E-30 (line 175-177) | ○ |
| C-112 | OggJsonDeserializationSchema.deserialize - op_type=UがUPDATE_BEFOREとUPDATE_AFTERとして処理されること | E-30 (line 178-186) | ○ |
| C-113 | OggJsonDeserializationSchema.deserialize - op_type=DがRowKind.DELETEとして処理されること | E-30 (line 187-193) | ○ |
| C-114 | OggJsonDeserializationSchema.deserialize - UPDATEでbeforeがnullの場合にIllegalStateExceptionがスローされること | E-30 (line 179-181) | ○ |
| C-115 | OggJsonSerializationSchema.serialize - INSERTがop_type=Iとしてシリアライズされること | E-31 (line 90-114) | ○ |
| C-116 | OggJsonSerializationSchema.serialize - DELETEがop_type=Dとしてシリアライズされること | E-31 (line 90-114) | ○ |
| C-117 | CanalJsonDecodingFormat.createRuntimeDecoder - CanalJsonDeserializationSchemaが正しく作成されること | E-19 (line 81-109) | ○ |
| C-118 | CanalJsonDecodingFormat.getChangelogMode - INSERT/UPDATE_BEFORE/UPDATE_AFTER/DELETEを含むChangelogModeが返却されること | E-19 (line 124-132) | ○ |
| C-119 | DebeziumJsonDecodingFormat.listReadableMetadata - 読み取り可能なメタデータ一覧が返却されること | E-24 (line 111-116) | ○ |
| C-120 | MaxwellJsonDecodingFormat.applyReadableMetadata - メタデータキーが適用されること | E-29 (line 110-112) | ○ |
| C-121 | OggJsonDecodingFormat.createRuntimeDecoder - OggJsonDeserializationSchemaが正しく作成されること | E-34 (line 66-96) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースは実際のソースコードに基づいて抽出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードの実装に基づいて生成されており、根拠が明確である

## 6) レビュアーチェックリスト（最小）
- [ ] 各CDCフォーマット（Canal, Debezium, Maxwell, Ogg）の操作タイプ（INSERT/UPDATE/DELETE）に対するテストケースが網羅されているか確認
- [ ] 型変換（JsonToRowDataConverters, RowDataToJsonConverters）の各LogicalTypeに対するテストケースが網羅されているか確認
- [ ] エラーハンドリング（ignoreParseErrors, failOnMissingField）のテストケースが正しく定義されているか確認
- [ ] タイムスタンプフォーマット（SQL, ISO-8601）のテストケースが含まれているか確認
- [ ] mapNullKeyMode（FAIL, DROP, LITERAL）のテストケースが網羅されているか確認
- [ ] プロジェクションプッシュダウン機能のテストケースが含まれているか確認
