---
generated_at: 2026-02-02 18:35:00
metrics:
  claims_total: 96
  claims_with_evidence: 96
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-formats_flink-orc-nohive.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：96 / 96、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/OrcNoHiveColumnarRowInputFormat.java`
- E-02: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/OrcNoHiveBulkWriterFactory.java`
- E-03: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/OrcNoHiveSplitReaderUtil.java`
- E-04: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/writer/NoHivePhysicalWriterImpl.java`
- E-05: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/shim/OrcNoHiveShim.java`
- E-06: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/vector/AbstractOrcNoHiveVector.java`
- E-07: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/vector/OrcNoHiveBatchWrapper.java`
- E-08: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/vector/OrcNoHiveBytesVector.java`
- E-09: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/vector/OrcNoHiveDecimalVector.java`
- E-10: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/vector/OrcNoHiveDoubleVector.java`
- E-11: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/vector/OrcNoHiveLongVector.java`
- E-12: `flink-formats/flink-orc-nohive/src/main/java/org/apache/flink/orc/nohive/vector/OrcNoHiveTimestampVector.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### OrcNoHiveColumnarRowInputFormat (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createPartitionedFormat: パーティション付きORCフォーマット作成 | E-01 L56-108 | ○ |
| C-02 | createPartitionedFormat: パーティション列の定数ベクトル化 | E-01 L84-88 | ○ |
| C-03 | createPartitionedFormat: 非パーティション列のORC読み込み | E-01 L89-90 | ○ |
| C-04 | createPartitionedFormat: パーティションキー空の場合 | E-01 L72-74 | ○ |
| C-05 | createPartitionedFormat: selectedFields=1つ | E-01 L79-92 | ○ |
| C-06 | createPartitionedFormat: 述語フィルタ適用 | E-01 L100 | ○ |

### OrcNoHiveBulkWriterFactory (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | コンストラクタ初期化 | E-02 L57-61 | ○ |
| C-08 | create: BulkWriter作成 | E-02 L64-99 | ○ |
| C-09 | addElement: VARCHAR書き込み | E-02 L124-131 | ○ |
| C-10 | addElement: BOOLEAN書き込み | E-02 L132-137 | ○ |
| C-11 | addElement: DECIMAL書き込み | E-02 L146-156 | ○ |
| C-12 | addElement: TINYINT書き込み | E-02 L157-161 | ○ |
| C-13 | addElement: SMALLINT書き込み | E-02 L162-166 | ○ |
| C-14 | addElement: INTEGER書き込み | E-02 L169-176 | ○ |
| C-15 | addElement: BIGINT書き込み | E-02 L177-181 | ○ |
| C-16 | addElement: FLOAT書き込み | E-02 L182-186 | ○ |
| C-17 | addElement: DOUBLE書き込み | E-02 L187-191 | ○ |
| C-18 | addElement: TIMESTAMP書き込み | E-02 L195-203 | ○ |
| C-19 | addElement: TIMESTAMP_WITH_LOCAL_TIME_ZONE書き込み | E-02 L204-212 | ○ |
| C-20 | addElement: DATE書き込み | E-02 L169-176 | ○ |
| C-21 | addElement: BINARY書き込み | E-02 L138-145 | ○ |
| C-22 | addElement: NULL値処理 | E-02 L117-121 | ○ |
| C-23 | addElement: 未サポート型例外 | E-02 L213-214 | ○ |
| C-24 | addElement: バッチフラッシュ | E-02 L79-82 | ○ |
| C-25 | flush: 手動フラッシュ | E-02 L86-91 | ○ |
| C-26 | flush: 空フラッシュ | E-02 L87 | ○ |
| C-27 | finish: ライター終了 | E-02 L94-97 | ○ |
| C-28 | writeObject/readObject: シリアライズ | E-02 L102-113 | ○ |

### OrcNoHiveSplitReaderUtil (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | genPartColumnarRowReader: SplitReader生成 | E-03 L48-94 | ○ |
| C-30 | genPartColumnarRowReader: パーティション列定数生成 | E-03 L74-76 | ○ |
| C-31 | genPartColumnarRowReader: データ列読み込み | E-03 L77-78 | ○ |
| C-32 | genPartColumnarRowReader: パーティションなし | E-03 L61 | ○ |
| C-33 | genPartColumnarRowReader: splitLength=0 | E-03 L92 | ○ |

### NoHivePhysicalWriterImpl (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | コンストラクタ初期化 | E-04 L39-43 | ○ |
| C-35 | writeMetadata: メタデータ書き込み | E-04 L46-50 | ○ |
| C-36 | writeFileFooter: フッター書き込み | E-04 L53-57 | ○ |
| C-37 | writeStripeFooter: ストライプフッター書き込み | E-04 L60-64 | ○ |

### OrcNoHiveShim (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | createRecordReader: RecordReader作成 | E-05 L46-85 | ○ |
| C-39 | createRecordReader: カラムプロジェクション | E-05 L76 | ○ |
| C-40 | createRecordReader: Split範囲設定 | E-05 L68 | ○ |
| C-41 | createRecordReader: ZeroCopy設定 | E-05 L69 | ○ |
| C-42 | createRecordReader: 破損レコードスキップ | E-05 L70 | ○ |
| C-43 | createRecordReader: スキーマ欠落許容 | E-05 L71 | ○ |
| C-44 | createRecordReader: ファイル不存在エラー | E-05 L58 | ○ |
| C-45 | createBatchWrapper: ラッパー生成 | E-05 L88-90 | ○ |
| C-46 | createBatchWrapper: batchSize=1 | E-05 L89 | ○ |
| C-47 | nextBatch: バッチ読み込み | E-05 L93-95 | ○ |
| C-48 | nextBatch: データ終端 | E-05 L94 | ○ |

### AbstractOrcNoHiveVector (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | isNullAt: 非NULL判定 | E-06 L52-54 | ○ |
| C-50 | isNullAt: NULL判定 | E-06 L52-54 | ○ |
| C-51 | isNullAt: 繰り返しモード | E-06 L53 | ○ |
| C-52 | createFlinkVector: Long変換 | E-06 L58-59 | ○ |
| C-53 | createFlinkVector: Double変換 | E-06 L60-61 | ○ |
| C-54 | createFlinkVector: Bytes変換 | E-06 L62-63 | ○ |
| C-55 | createFlinkVector: Decimal変換 | E-06 L64-65 | ○ |
| C-56 | createFlinkVector: Timestamp変換 | E-06 L66-67 | ○ |
| C-57 | createFlinkVector: 未サポートベクトルエラー | E-06 L68-71 | ○ |
| C-58 | createFlinkVectorFromConstant: VARCHAR定数 | E-06 L87-91, L131-147 | ○ |
| C-59 | createFlinkVectorFromConstant: BOOLEAN定数 | E-06 L92-93, L118-129 | ○ |
| C-60 | createFlinkVectorFromConstant: INTEGER定数 | E-06 L94-98, L118-129 | ○ |
| C-61 | createFlinkVectorFromConstant: DECIMAL定数 | E-06 L99-102, L149-166 | ○ |
| C-62 | createFlinkVectorFromConstant: DOUBLE定数 | E-06 L103-105, L168-179 | ○ |
| C-63 | createFlinkVectorFromConstant: DATE定数 | E-06 L106-110, L118-129 | ○ |
| C-64 | createFlinkVectorFromConstant: TIMESTAMP定数 | E-06 L111-112, L181-196 | ○ |
| C-65 | createFlinkVectorFromConstant: NULL定数 | E-06 L120-123, L133-136, L152-155, L170-173, L183-186 | ○ |
| C-66 | createFlinkVectorFromConstant: 未サポート型エラー | E-06 L113-114 | ○ |

### OrcNoHiveBatchWrapper (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | コンストラクタ初期化 | E-07 L30-32 | ○ |
| C-68 | getBatch: バッチ取得 | E-07 L35-37 | ○ |
| C-69 | size: サイズ取得 | E-07 L40-42 | ○ |
| C-70 | size: 空バッチ | E-07 L41 | ○ |

### OrcNoHiveBytesVector (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | コンストラクタ初期化 | E-08 L29-32 | ○ |
| C-72 | getBytes: バイト取得 | E-08 L35-41 | ○ |
| C-73 | getBytes: 繰り返しモード | E-08 L36 | ○ |
| C-74 | getBytes: オフセット・長さ処理 | E-08 L40 | ○ |

### OrcNoHiveDecimalVector (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | コンストラクタ初期化 | E-09 L35-38 | ○ |
| C-76 | getDecimal: Decimal取得 | E-09 L41-45 | ○ |
| C-77 | getDecimal: 繰り返しモード | E-09 L43 | ○ |
| C-78 | getDecimal: precision/scale処理 | E-09 L44 | ○ |

### OrcNoHiveDoubleVector (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | コンストラクタ初期化 | E-10 L33-36 | ○ |
| C-80 | getDouble: Double取得 | E-10 L39-41 | ○ |
| C-81 | getDouble: 繰り返しモード | E-10 L40 | ○ |
| C-82 | getFloat: Float取得 | E-10 L44-46 | ○ |
| C-83 | getFloat: 繰り返しモード | E-10 L45 | ○ |

### OrcNoHiveLongVector (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | コンストラクタ初期化 | E-11 L36-39 | ○ |
| C-85 | getLong: Long取得 | E-11 L42-44 | ○ |
| C-86 | getLong: 繰り返しモード | E-11 L43 | ○ |
| C-87 | getBoolean: true取得 | E-11 L47-49 | ○ |
| C-88 | getBoolean: false取得 | E-11 L48 | ○ |
| C-89 | getByte: Byte取得 | E-11 L52-54 | ○ |
| C-90 | getInt: Int取得 | E-11 L57-59 | ○ |
| C-91 | getShort: Short取得 | E-11 L62-64 | ○ |

### OrcNoHiveTimestampVector (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | コンストラクタ初期化 | E-12 L36-39 | ○ |
| C-93 | getTimestamp: Timestamp取得 | E-12 L42-47 | ○ |
| C-94 | getTimestamp: 繰り返しモード | E-12 L43 | ○ |
| C-95 | getTimestamp: ナノ秒処理 | E-12 L45 | ○ |
| C-96 | getTimestamp: precision=0 | E-12 L42 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全テストケースに対応するソースコード根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている

### モジュール特性に関する注記
- 本モジュール（flink-orc-nohive）はHive依存を排除したORC形式のサポートモジュール
- ProtobufクラスがリロケートされているためNoHivePhysicalWriterImplが必要
- ベクトル変換クラス群（OrcNoHive*Vector）は型変換の正確性が重要

## 6) レビュアーチェックリスト（最小）
- [ ] OrcNoHiveBulkWriterFactory: 各データ型の書き込み処理が網羅されているか確認
- [ ] AbstractOrcNoHiveVector: createFlinkVector/createFlinkVectorFromConstantの型マッピングが正確か確認
- [ ] OrcNoHiveShim: OrcConfの設定項目（ZeroCopy, SkipCorruptData等）の適用確認
- [ ] 各ベクトルクラス: isRepeatingモードの処理が正しくテストされているか確認
- [ ] NoHivePhysicalWriterImpl: Protobufリロケーションに関する特殊処理の妥当性確認
