---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 130
  claims_with_evidence: 128
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：flink-formats_flink-orc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードに該当するクラス・メソッドが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がコードの実装と矛盾していないか
3. **網羅性**：主要なpublicメソッド・重要なロジックがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 128 / 130 = 0.98
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：128 / 130、根拠なし：2
- 優先レビュー（高）
  1. **UT-ORC-064**: TimestampUtil.createVectorFromConstant - hiveTSColVectorClz == null のケースは環境依存
  2. **UT-ORC-063**: TimestampUtil.createVectorFromConstant - hiveTSColVectorClz != null のケースは環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。解析したソースコードファイルを記載。

- E-01: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcSplitReaderUtil.java`
- E-02: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcColumnarRowInputFormat.java`
- E-03: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFilters.java`
- E-04: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFileFormatFactory.java`
- E-05: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcColumnarRowSplitReader.java`
- E-06: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcSplitReader.java`
- E-07: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/AbstractOrcFileInputFormat.java`
- E-08: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/TimestampUtil.java`
- E-09: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/writer/OrcBulkWriterFactory.java`
- E-10: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/writer/OrcBulkWriter.java`
- E-11: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/writer/PhysicalWriterImpl.java`
- E-12: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/util/OrcFormatStatisticsReportUtil.java`
- E-13: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/util/SerializableHadoopConfigWrapper.java`
- E-14: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/Vectorizer.java`
- E-15: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/RowDataVectorizer.java`
- E-16: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/AbstractOrcColumnVector.java`
- E-17: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/OrcVectorizedBatchWrapper.java`
- E-18: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/OrcTimestampColumnVector.java`
- E-19: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/OrcLegacyTimestampColumnVector.java`
- E-20: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/HiveOrcBatchWrapper.java`
- E-21: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/ColumnBatchFactory.java`
- E-22: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/shim/OrcShim.java`
- E-23: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/shim/OrcShimV200.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### OrcSplitReaderUtil（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-ORC-001) | genPartColumnarRowReaderが正常に動作すること | E-01 L54-101 | ○ |
| C-02 (UT-ORC-002) | 無効なパスで例外がスローされること | E-01 L54-101, OrcSplitReader | ○ |
| C-03 (UT-ORC-003) | getSelectedOrcFieldsが正しくインデックスを返すこと | E-01 L103-110 | ○ |
| C-04 (UT-ORC-004) | 空の選択フィールドで空配列が返されること | E-01 L103-110 | ○ |
| C-05 (UT-ORC-005) | getNonPartNamesがパーティションキー以外を返すこと | E-01 L112-124 | ○ |
| C-06 (UT-ORC-006) | 全てパーティションキーの場合に空リストが返されること | E-01 L112-124 | ○ |
| C-07 (UT-ORC-007) | convertToOrcTypeWithPartが型変換すること | E-01 L126-151 | ○ |
| C-08-15 (UT-ORC-008-015) | logicalTypeToOrcTypeの各型変換 | E-01 L153-216 | ○ |

### OrcColumnarRowInputFormat（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 (UT-ORC-016) | createReaderBatchがバッチを生成すること | E-02 L87-96 | ○ |
| C-17 (UT-ORC-017) | getProducedTypeが型情報を返すこと | E-02 L99-101 | ○ |
| C-18 (UT-ORC-018) | reportStatisticsが統計を返すこと | E-02 L104-107 | ○ |
| C-19 (UT-ORC-019) | createPartitionedFormatがフォーマットを生成すること | E-02 L144-197 | ○ |
| C-20 (UT-ORC-020) | convertAndGetIteratorがイテレータを返すこと | E-02 L129-137 | ○ |

### OrcFilters（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21-31 (UT-ORC-021-031) | 各種述語変換 | E-03 L50-299 | ○ |
| C-32-33 (UT-ORC-032-033) | convertBinaryの左右処理 | E-03 L206-249 | ○ |
| C-34-37 (UT-ORC-034-037) | castLiteralの型変換 | E-03 L412-480 | ○ |
| C-38-40 (UT-ORC-038-040) | Predicate.addメソッド | E-03 L492-679 | ○ |

### OrcFileFormatFactory（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 (UT-ORC-041) | factoryIdentifierがorcを返すこと | E-04 L65-70 | ○ |
| C-42-46 (UT-ORC-042-046) | デコード/エンコードフォーマット生成 | E-04 L99-187 | ○ |

### OrcColumnarRowSplitReader（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47-49 (UT-ORC-047-049) | コンストラクタ、fillRows、nextRecord | E-05 L34-86 | ○ |

### OrcSplitReader（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50-53 (UT-ORC-050-053) | seekToRow、reachedEnd、close | E-06 L38-149 | ○ |

### AbstractOrcFileInputFormat（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54-60 (UT-ORC-054-060) | createReader、restoreReader、OrcVectorizedReader | E-07 L52-303 | ○ |

### TimestampUtil（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61-62 (UT-ORC-061-062) | isHiveTimestampColumnVector | E-08 L50-52 | ○ |
| C-63 (UT-ORC-063) | createVectorFromConstant (新API) | E-08 L55-61 | △ |
| C-64 (UT-ORC-064) | createVectorFromConstant (レガシーAPI) | E-08 L55-61 | △ |

### writer パッケージ（E-09, E-10, E-11）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65-67 (UT-ORC-065-067) | OrcBulkWriterFactory | E-09 L48-122 | ○ |
| C-68-72 (UT-ORC-068-072) | OrcBulkWriter | E-10 L38-76 | ○ |
| C-73-79 (UT-ORC-073-079) | PhysicalWriterImpl | E-11 L57-398 | ○ |

### util パッケージ（E-12, E-13）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80-82 (UT-ORC-080-082) | OrcFormatStatisticsReportUtil | E-12 L57-293 | ○ |
| C-83-86 (UT-ORC-083-086) | SerializableHadoopConfigWrapper | E-13 L34-78 | ○ |

### vector パッケージ（E-14-21）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87-91 (UT-ORC-087-091) | Vectorizer | E-14 L44-97 | ○ |
| C-92-100 (UT-ORC-092-100) | RowDataVectorizer | E-15 L48-277 | ○ |
| C-101-108 (UT-ORC-101-108) | AbstractOrcColumnVector | E-16 L47-194 | ○ |
| C-121-125 (UT-ORC-121-125) | OrcTimestampColumnVector | E-18 L33-67 | ○ |
| C-126-127 (UT-ORC-126-127) | OrcLegacyTimestampColumnVector | E-19 L33-91 | ○ |
| C-128-129 (UT-ORC-128-129) | HiveOrcBatchWrapper | E-20 L24-41 | ○ |
| C-130 (UT-ORC-130) | ColumnBatchFactory | E-21 L27-31 | ○ |

### shim パッケージ（E-22, E-23）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109-113 (UT-ORC-109-113) | OrcShim | E-22 L34-72 | ○ |
| C-114-120 (UT-ORC-114-120) | OrcShimV200 | E-23 L46-209 | ○ |

## 4) 不足情報（Unknown / Missing）

### 環境依存テストケース
- **UT-ORC-063, UT-ORC-064**: TimestampUtil.createVectorFromConstant
  - `hiveTSColVectorClz` の値はクラスパス上に `org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector` が存在するかどうかで決まる
  - 実行環境によって挙動が変わるため、両方のケースをテストする必要がある
  - 候補：Mock / クラスローダー操作 / 統合テストでの検証

### 既存テストとの重複確認
- 本モジュールには既存のテストクラスが存在する（`src/test/java/`配下）
- 既存テストとの重複・不足の確認が推奨される

## 5) リスクフラグ（レビュー観点）

| レベル | 対象 | 説明 |
|--------|------|------|
| 0 | UT-ORC-001-015 | OrcSplitReaderUtil - 型変換ロジック、十分なカバレッジ |
| 0 | UT-ORC-021-040 | OrcFilters - フィルタプッシュダウンの各種述語 |
| 0 | UT-ORC-065-079 | Writer関連 - データ書き込みの基本機能 |
| 1 | UT-ORC-063-064 | TimestampUtil - 環境依存のため実行環境での確認が必要 |
| 0 | UT-ORC-109-120 | OrcShim - Hiveバージョン対応のShim層 |

## 6) レビュアーチェックリスト（最小）

- [ ] 高優先度テストケース（金額計算、認証、データ整合性）が網羅されているか
  - DECIMAL型の変換（UT-ORC-011, UT-ORC-036, UT-ORC-095）
  - フィルタプッシュダウン（UT-ORC-021-040）
- [ ] 境界値テストが適切に設計されているか
  - 空配列・空リスト（UT-ORC-004, UT-ORC-006, UT-ORC-071）
  - スプリット範囲外（UT-ORC-119）
- [ ] 異常系テストが例外の種類まで正確か
  - UnsupportedOperationException（UT-ORC-015, UT-ORC-100, UT-ORC-106, UT-ORC-113）
  - IllegalArgumentException（UT-ORC-037, UT-ORC-077）
  - NullPointerException（UT-ORC-084, UT-ORC-088）
- [ ] 環境依存テスト（UT-ORC-063, UT-ORC-064）の実行方法が明確か
- [ ] 既存テストクラスとの整合性を確認したか
