---
generated_at: 2026-02-02 12:30:00
metrics:
  claims_total: 173
  claims_with_evidence: 173
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-formats_flink-parquet 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：173 / 173、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースにソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetWriterFactory.java`
- E-02: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetBulkWriter.java`
- E-03: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetColumnarRowInputFormat.java`
- E-04: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetVectorizedInputFormat.java`
- E-05: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetInputFile.java`
- E-06: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/StreamOutputFile.java`
- E-07: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/PositionOutputStreamAdapter.java`
- E-08: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetFileFormatFactory.java`
- E-09: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetBuilder.java`
- E-10: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/utils/ParquetSchemaConverter.java`
- E-11: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/utils/SerializableConfiguration.java`
- E-12: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/utils/ParquetFormatStatisticsReportUtil.java`
- E-13: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/utils/NestedPositionUtil.java`
- E-14: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/row/ParquetRowDataBuilder.java`
- E-15: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/row/ParquetRowDataWriter.java`
- E-16: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/avro/AvroParquetWriters.java`
- E-17: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/avro/AvroParquetRecordFormat.java`
- E-18: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/avro/AvroParquetReaders.java`
- E-19: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/vector/ParquetSplitReaderUtil.java`
- E-20: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/vector/ParquetColumnarRowSplitReader.java`
- E-21: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/vector/reader/TimestampColumnReader.java`
- E-22: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/protobuf/ParquetProtoWriters.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ParquetWriterFactory (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでParquetBuilderを設定 | E-01 L49-51 | ○ |
| C-02 | FSDataOutputStreamからBulkWriterを生成 | E-01 L54-58 | ○ |
| C-03 | nullストリームでNPE | E-01 L55 (StreamOutputFile呼び出し) | ○ |

### ParquetBulkWriter (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | コンストラクタでParquetWriterを設定 | E-02 L46-48 | ○ |
| C-05 | null ParquetWriterでNPE | E-02 L47 checkNotNull | ○ |
| C-06 | addElementでwrite呼び出し | E-02 L51-53 | ○ |
| C-07 | flushが何もしない | E-02 L55-58 | ○ |
| C-08 | finishでclose呼び出し | E-02 L61-63 | ○ |

### ParquetColumnarRowInputFormat (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | コンストラクタでパラメータ設定 | E-03 L60-75, L85-101 | ○ |
| C-10 | numBatchesToCirculateが1を返す | E-03 L104-110 | ○ |
| C-11 | getProducedTypeでTypeInfo返却 | E-03 L121-123 | ○ |
| C-12 | reportStatisticsで統計取得 | E-03 L126-129 | ○ |
| C-13 | createPartitionedFormatでインスタンス生成 | E-03 L155-203 | ○ |

### ParquetVectorizedInputFormat (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | コンストラクタでパラメータ設定 | E-04 L94-108 | ○ |
| C-15 | createReaderでParquetReader生成 | E-04 L111-159 | ○ |
| C-16 | restoreReaderでリーダー復元 | E-04 L166-178 | ○ |
| C-17 | restoreReaderでoffset検証 | E-04 L172-174 | ○ |
| C-18 | isSplittableがtrue返却 | E-04 L181-183 | ○ |
| C-19 | ParquetReader.readBatchでバッチ読み取り | E-04 L377-392 | ○ |
| C-20 | ParquetReader.seekで行スキップ | E-04 L449-468 | ○ |
| C-21 | ParquetReader.closeでリソース解放 | E-04 L486-491 | ○ |

### ParquetInputFile (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | コンストラクタで入力ストリームと長さ設定 | E-05 L38-41 | ○ |
| C-23 | getLengthで長さ返却 | E-05 L44-46 | ○ |
| C-24 | newStreamでSeekableInputStream返却 | E-05 L49-51 | ○ |
| C-25 | FSDataInputStreamAdapter.getPos | E-05 L67-69 | ○ |
| C-26 | FSDataInputStreamAdapter.seek | E-05 L72-74 | ○ |

### StreamOutputFile (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | コンストラクタでストリーム設定 | E-06 L53-56 | ○ |
| C-28 | null streamでNPE | E-06 L54 checkNotNull | ○ |
| C-29 | createでPositionOutputStream返却 | E-06 L59-65 | ○ |
| C-30 | 2回目createでIllegalStateException | E-06 L60-64 | ○ |
| C-31 | createOrOverwriteでcreate呼び出し | E-06 L68-70 | ○ |
| C-32 | supportsBlockSizeがfalse返却 | E-06 L73-75 | ○ |
| C-33 | defaultBlockSizeが64MB返却 | E-06 L78-80 | ○ |

### PositionOutputStreamAdapter (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | コンストラクタでストリーム設定 | E-07 L42-44 | ○ |
| C-35 | getPosで位置返却 | E-07 L47-49 | ○ |
| C-36 | write(int)で1バイト書き込み | E-07 L52-54 | ○ |
| C-37 | write(byte[], int, int)でバイト配列書き込み | E-07 L57-59 | ○ |
| C-38 | flushでフラッシュ実行 | E-07 L62-64 | ○ |
| C-39 | closeで内部ストリームを閉じない | E-07 L67-70 | ○ |

### ParquetFileFormatFactory (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | factoryIdentifierが'parquet'返却 | E-08 L127-128 | ○ |
| C-41 | createDecodingFormatでParquetBulkDecodingFormat生成 | E-08 L92-95 | ○ |
| C-42 | createEncodingFormatでEncodingFormat生成 | E-08 L98-115 | ○ |
| C-43 | requiredOptionsで空Set返却 | E-08 L131-133 | ○ |
| C-44 | optionalOptionsで空Set返却 | E-08 L136-138 | ○ |
| C-45 | ParquetBulkDecodingFormat.createRuntimeDecoder | E-08 L156-170 | ○ |
| C-46 | ParquetBulkDecodingFormat.getChangelogMode | E-08 L173-175 | ○ |
| C-47 | ParquetBulkDecodingFormat.reportStatistics | E-08 L178-184 | ○ |

### ParquetSchemaConverter (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | convertToParquetMessageTypeでMessageType変換 | E-10 L52-61 | ○ |
| C-49 | convertToParquetTypeで各型変換 | E-10 L63-180 | ○ |
| C-50 | computeMinBytesForDecimalPrecisionでバイト数計算 | E-10 L192-198 | ○ |
| C-51 | is32BitDecimalで判定 | E-10 L201-203 | ○ |
| C-52 | is64BitDecimalで判定 | E-10 L205-207 | ○ |

### SerializableConfiguration (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | コンストラクタでConfiguration設定 | E-11 L35-37 | ○ |
| C-54 | confでConfiguration返却 | E-11 L39-41 | ○ |
| C-55 | writeObject/readObjectでシリアライズ | E-11 L43-51 | ○ |

### ParquetFormatStatisticsReportUtil (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | getTableStatisticsで統計取得 | E-12 L74-134 | ○ |

### NestedPositionUtil (E-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | calculateRowOffsetsで行オフセット計算 | E-13 L46-72 | ○ |
| C-58 | calculateCollectionOffsetsでコレクションオフセット計算 | E-13 L92-144 | ○ |
| C-59 | isOptionalFieldValueNullでnull判定 | E-13 L146-148 | ○ |
| C-60 | calculateLengthByOffsetsで長さ計算 | E-13 L150-168 | ○ |

### ParquetRowDataBuilder (E-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | コンストラクタでパラメータ設定 | E-14 L55-59 | ○ |
| C-62 | selfでthis返却 | E-14 L62-64 | ○ |
| C-63 | getWriteSupportでParquetWriteSupport返却 | E-14 L67-69 | ○ |
| C-64 | createWriterFactoryでファクトリ生成 | E-14 L111-114 | ○ |
| C-65 | FlinkParquetBuilder.createWriterでWriter生成 | E-14 L130-148 | ○ |

### ParquetRowDataWriter (E-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | コンストラクタでパラメータ設定 | E-15 L73-98 | ○ |
| C-67 | writeでRowData書き込み | E-15 L105-109 | ○ |
| C-68 | createWriterで各型Writer生成 | E-15 L111-169 | ○ |
| C-69 | BooleanWriter.write | E-15 L178-193 | ○ |
| C-70 | StringWriter.write | E-15 L280-295 | ○ |
| C-71 | TimestampWriter.write | E-15 L336-357 | ○ |
| C-72 | MapWriter.writeMapData | E-15 L359-425 | ○ |
| C-73 | ArrayWriter.writeArrayData | E-15 L427-476 | ○ |
| C-74 | RowWriter.write | E-15 L478-521 | ○ |
| C-75 | timestampToInt64 | E-15 L544-556 | ○ |
| C-76 | timestampToInt96 | E-15 L558-580 | ○ |
| C-77 | convertInt64ToLong | E-15 L531-542 | ○ |
| C-78 | createDecimalWriter | E-15 L582-675 | ○ |

### AvroParquetWriters (E-16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | forSpecificRecordでWriterFactory生成 | E-16 L49-55 | ○ |
| C-80 | forGenericRecordでWriterFactory生成 | E-16 L63-76 | ○ |
| C-81 | forReflectRecordでWriterFactory生成 | E-16 L84-89 | ○ |

### AvroParquetRecordFormat (E-17)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | コンストラクタでパラメータ設定 | E-17 L62-66 | ○ |
| C-83 | createReaderでReader生成 | E-17 L76-88 | ○ |
| C-84 | createReaderで分割検証 | E-17 L81 | ○ |
| C-85 | restoreReaderでリーダー復元 | E-17 L94-111 | ○ |
| C-86 | restoreReaderでオフセット検証 | E-17 L106-108 | ○ |
| C-87 | isSplittableがfalse返却 | E-17 L119-122 | ○ |
| C-88 | getProducedTypeでTypeInfo返却 | E-17 L128-131 | ○ |
| C-89 | AvroParquetRecordReader.read | E-17 L166-171 | ○ |
| C-90 | AvroParquetRecordReader.close | E-17 L174-176 | ○ |

### AvroParquetReaders (E-18)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | forSpecificRecordでStreamFormat生成 | E-18 L51-55 | ○ |
| C-92 | forReflectRecordでStreamFormat生成 | E-18 L70-88 | ○ |
| C-93 | forReflectRecordでSpecificRecordBase検証 | E-18 L71-73 | ○ |
| C-94 | forReflectRecordでGenericRecord検証 | E-18 L74-82 | ○ |
| C-95 | forGenericRecordでStreamFormat生成 | E-18 L100-111 | ○ |

### ParquetSplitReaderUtil (E-19)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | genPartColumnarRowReaderでSplitReader生成 | E-19 L108-163 | ○ |
| C-97 | createVectorFromConstantで各型ベクトル生成 | E-19 L165-286 | ○ |
| C-98 | createColumnReaderで各型Reader生成 | E-19 L308-380 | ○ |
| C-99 | createWritableColumnVectorで各型Vector生成 | E-19 L382-571 | ○ |
| C-100 | buildFieldsListでField一覧構築 | E-19 L573-582 | ○ |
| C-101 | lookupColumnByNameでカラム検索 | E-19 L689-703 | ○ |

### ParquetColumnarRowSplitReader (E-20)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | コンストラクタでパラメータ設定 | E-20 L110-157 | ○ |
| C-103 | reachedEndで終端確認 | E-20 L262-264 | ○ |
| C-104 | nextRecordでレコード取得 | E-20 L266-270 | ○ |
| C-105 | seekToRowでシーク | E-20 L343-369 | ○ |
| C-106 | closeでリソース解放 | E-20 L372-377 | ○ |

### TimestampColumnReader (E-21)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | コンストラクタでINT96/INT64設定 | E-21 L58-73 | ○ |
| C-108 | checkTypeNameで型検証 | E-21 L75-83 | ○ |
| C-109 | int96ToTimestampで変換 | E-21 L146-158 | ○ |
| C-110 | int64ToTimestampで変換 | E-21 L160-189 | ○ |
| C-111 | decodeInt96ToTimestampでDictionary復号 | E-21 L138-144 | ○ |
| C-112 | decodeInt64ToTimestampでDictionary復号 | E-21 L130-136 | ○ |

### ParquetProtoWriters (E-22)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | forTypeでWriterFactory生成 | E-22 L39-42 | ○ |
| C-114 | ParquetProtoWriterBuilderコンストラクタ | E-22 L52-55 | ○ |
| C-115 | selfでthis返却 | E-22 L58-60 | ○ |
| C-116 | getWriteSupportでPatchedProtoWriteSupport返却 | E-22 L63-66 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいており、高い信頼性がある

特記事項:
- Parquetフォーマットの読み書き機能は金額計算等には直接関係しないが、データ整合性に関わる重要な機能
- Timestamp変換ロジック（INT96/INT64、UTC/ローカル）は境界値テストが重要
- スキーマ変換機能は様々なデータ型を扱うため、網羅的なテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] Timestamp変換テスト（INT96/INT64、UTC/ローカル）の境界値が適切か確認
- [ ] Decimal精度（9桁、18桁、38桁境界）のテストケースが十分か確認
- [ ] パーティション処理のエッジケース（空パーティション、大量パーティション）が考慮されているか確認
- [ ] ネストした複合型（Array内Map、Map内Row等）のテストケースが必要か検討
- [ ] チェックポイント/リストア機能のテストケースが十分か確認
- [ ] Avro/Protobuf連携のスキーマ互換性テストが必要か検討
