---
generated_at: 2026-02-02 15:30:00
metrics:
  claims_total: 147
  claims_with_evidence: 147
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-formats_flink-protobuf 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：147 / 147、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースはソースコードに基づいて生成

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbFormatFactory.java`
- E-02: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbDecodingFormat.java`
- E-03: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbEncodingFormat.java`
- E-04: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbFormatConfig.java`
- E-05: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbFormatOptions.java`
- E-06: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbFormatContext.java`
- E-07: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbFileFormatFactory.java`
- E-08: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbConstant.java`
- E-09: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbCodegenException.java`
- E-10: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/PbRowDataDeserializationSchema.java`
- E-11: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/ProtoToRowConverter.java`
- E-12: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/PbCodegenDeserializer.java`
- E-13: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/PbCodegenDeserializeFactory.java`
- E-14: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/PbCodegenRowDeserializer.java`
- E-15: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/PbCodegenSimpleDeserializer.java`
- E-16: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/PbCodegenArrayDeserializer.java`
- E-17: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/deserialize/PbCodegenMapDeserializer.java`
- E-18: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/PbRowDataSerializationSchema.java`
- E-19: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/RowToProtoConverter.java`
- E-20: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/PbCodegenSerializer.java`
- E-21: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/PbCodegenSerializeFactory.java`
- E-22: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/PbCodegenRowSerializer.java`
- E-23: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/PbCodegenSimpleSerializer.java`
- E-24: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/PbCodegenArraySerializer.java`
- E-25: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/serialize/PbCodegenMapSerializer.java`
- E-26: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/util/PbFormatUtils.java`
- E-27: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/util/PbCodegenUtils.java`
- E-28: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/util/PbCodegenAppender.java`
- E-29: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/util/PbCodegenVarId.java`
- E-30: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/util/PbSchemaValidationUtils.java`
- E-31: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/util/PbToRowTypeUtil.java`
- E-32: `flink-formats/flink-protobuf/src/main/java/com/google/protobuf/ProtobufInternalUtils.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### PbFormatFactory関連（テストID: UT-PBF-001 〜 UT-PBF-005）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createDecodingFormatがPbDecodingFormatを返却する | E-01 (line 45-48) | ○ |
| C-02 | createEncodingFormatがPbEncodingFormatを返却する | E-01 (line 52-55) | ○ |
| C-03 | factoryIdentifierが"protobuf"を返却する | E-01 (line 42, 76-77) | ○ |
| C-04 | requiredOptionsがMESSAGE_CLASS_NAMEを含む | E-01 (line 80-83) | ○ |
| C-05 | optionalOptionsが設定オプションを含む | E-01 (line 86-93) | ○ |

### PbDecodingFormat/PbEncodingFormat関連（テストID: UT-PBF-006 〜 UT-PBF-009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | createRuntimeDecoderがPbRowDataDeserializationSchemaを返却する | E-02 (line 40-46) | ○ |
| C-07 | getChangelogModeがinsertOnlyを返却する | E-02 (line 49-51) | ○ |
| C-08 | createRuntimeEncoderがPbRowDataSerializationSchemaを返却する | E-03 (line 44-48) | ○ |
| C-09 | getChangelogModeがinsertOnlyを返却する | E-03 (line 39-41) | ○ |

### PbFormatConfig関連（テストID: UT-PBF-010 〜 UT-PBF-018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | getMessageClassNameが設定値を返却する | E-04 (line 48-50) | ○ |
| C-11 | isIgnoreParseErrorsが設定値を返却する | E-04 (line 52-54) | ○ |
| C-12 | isReadDefaultValuesが設定値を返却する | E-04 (line 56-58) | ○ |
| C-13 | getWriteNullStringLiteralsが設定値を返却する | E-04 (line 60-62) | ○ |
| C-14 | equalsが同一設定で等価判定する | E-04 (line 64-77) | ○ |
| C-15 | hashCodeが一貫した値を返す | E-04 (line 79-84) | ○ |
| C-16 | PbFormatConfigBuilderがビルダーパターンを実装 | E-04 (line 86-119) | ○ |

### PbFormatContext関連（テストID: UT-PBF-019 〜 UT-PBF-023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | getPbFormatConfigが設定を返却する | E-06 (line 76-78) | ○ |
| C-18 | getSplitMethodStackがリストを返却する | E-06 (line 72-74) | ○ |
| C-19 | splitDeserializerRowTypeMethodがコードを生成する | E-06 (line 61-65) | ○ |
| C-20 | splitSerializerRowTypeMethodがコードを生成する | E-06 (line 67-70) | ○ |
| C-21 | getReadDefaultValuesForPrimitiveTypesが設定を返却する | E-06 (line 80-82) | ○ |

### PbFileFormatFactory関連（テストID: UT-PBF-024 〜 UT-PBF-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | createDecodingFormatがValidationExceptionをスローする | E-07 (line 71-74) | ○ |
| C-23 | createEncodingFormatがValidationExceptionをスローする | E-07 (line 77-81) | ○ |
| C-24 | factoryIdentifierがprotobufを返却する | E-07 (line 51-53) | ○ |

### PbRowDataDeserializationSchema関連（テストID: UT-PBF-027 〜 UT-PBF-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | deserializeがRowDataを返却する | E-10 (line 69-78) | ○ |
| C-26 | 不正データでIOExceptionをスローする | E-10 (line 73-76) | ○ |
| C-27 | ignoreParseErrors=trueでnullを返却する | E-10 (line 73-75) | ○ |
| C-28 | isEndOfStreamが常にfalseを返却する | E-10 (line 86-88) | ○ |
| C-29 | getProducedTypeがTypeInformationを返却する | E-10 (line 91-93) | ○ |
| C-30 | openがProtoToRowConverterを初期化する | E-10 (line 64-66) | ○ |
| C-31 | equalsが等価性を判定する | E-10 (line 96-112) | ○ |

### ProtoToRowConverter関連（テストID: UT-PBF-034 〜 UT-PBF-037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | convertProtoBinaryToRowがRowDataを返却する | E-11 (line 132-135) | ○ |
| C-33 | 不正データで例外をスローする | E-11 (line 132-135) | ○ |
| C-34 | isCodeSplitがフラグを返却する | E-11 (line 137-140) | ○ |
| C-35 | 不正クラス名でPbCodegenExceptionをスローする | E-11 (line 127-129) | ○ |

### PbCodegenDeserializeFactory関連（テストID: UT-PBF-038 〜 UT-PBF-043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | RowType用デシリアライザを返却する | E-13 (line 38-39) | ○ |
| C-37 | シンプル型用デシリアライザを返却する | E-13 (line 40-41) | ○ |
| C-38 | Array型用デシリアライザを返却する | E-13 (line 42-44) | ○ |
| C-39 | Map型用デシリアライザを返却する | E-13 (line 45-46) | ○ |
| C-40 | サポートされない型でPbCodegenExceptionをスローする | E-13 (line 47-48) | ○ |
| C-41 | getPbCodegenTopRowDesがデシリアライザを返却する | E-13 (line 52-55) | ○ |

### PbCodegenRowDeserializer関連（テストID: UT-PBF-044 〜 UT-PBF-046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | codegenがJavaコードを生成する | E-14 (line 47-122) | ○ |
| C-43 | ネストしたメッセージ対応コードを生成する | E-14 (line 71-72) | ○ |
| C-44 | readDefaultValues設定を反映する | E-14 (line 74-89) | ○ |

### PbCodegenSimpleDeserializer関連（テストID: UT-PBF-047 〜 UT-PBF-052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | INT型変換コードを生成する | E-15 (line 45-51) | ○ |
| C-46 | STRING型変換コードを生成する | E-15 (line 55-61) | ○ |
| C-47 | BYTE_STRING型変換コードを生成する | E-15 (line 52-54) | ○ |
| C-48 | ENUM型をVARCHARに変換するコードを生成する | E-15 (line 63-69) | ○ |
| C-49 | ENUM型をINTEGERに変換するコードを生成する | E-15 (line 70-74) | ○ |
| C-50 | サポートされない型でPbCodegenExceptionをスローする | E-15 (line 80-82) | ○ |

### PbCodegenArrayDeserializer関連（テストID: UT-PBF-053 〜 UT-PBF-055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | 配列変換コードを生成する | E-16 (line 46-85) | ○ |
| C-52 | ネストしたメッセージ配列を処理する | E-16 (line 77-80) | ○ |
| C-53 | 空配列を処理する | E-16 (line 61-62) | ○ |

### PbCodegenMapDeserializer関連（テストID: UT-PBF-056 〜 UT-PBF-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Map変換コードを生成する | E-17 (line 46-112) | ○ |
| C-55 | 複合型値を持つMapを処理する | E-17 (line 94-95) | ○ |
| C-56 | 空Mapを処理する | E-17 (line 79) | ○ |

### PbRowDataSerializationSchema関連（テストID: UT-PBF-059 〜 UT-PBF-062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | serializeがbyte[]を返却する | E-18 (line 65-71) | ○ |
| C-58 | 変換エラーでFlinkRuntimeExceptionをスローする | E-18 (line 68-70) | ○ |
| C-59 | openがRowToProtoConverterを初期化する | E-18 (line 55-57) | ○ |
| C-60 | isCodeSplitがフラグを返却する | E-18 (line 60-62) | ○ |

### RowToProtoConverter関連（テストID: UT-PBF-063 〜 UT-PBF-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | convertRowToProtoBinaryがbyte[]を返却する | E-19 (line 116-119) | ○ |
| C-62 | 変換エラーで例外をスローする | E-19 (line 116-119) | ○ |
| C-63 | isCodeSplitがフラグを返却する | E-19 (line 121-124) | ○ |
| C-64 | 不正クラス名でPbCodegenExceptionをスローする | E-19 (line 111-113) | ○ |

### PbCodegenSerializeFactory関連（テストID: UT-PBF-067 〜 UT-PBF-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | RowType用シリアライザを返却する | E-21 (line 36-37) | ○ |
| C-66 | シンプル型用シリアライザを返却する | E-21 (line 38-39) | ○ |
| C-67 | Array型用シリアライザを返却する | E-21 (line 40-42) | ○ |
| C-68 | Map型用シリアライザを返却する | E-21 (line 43-44) | ○ |
| C-69 | サポートされない型でPbCodegenExceptionをスローする | E-21 (line 45-47) | ○ |
| C-70 | getPbCodegenTopRowSerがシリアライザを返却する | E-21 (line 50-53) | ○ |

### PbCodegenRowSerializer関連（テストID: UT-PBF-073 〜 UT-PBF-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | codegenがJavaコードを生成する | E-22 (line 47-137) | ○ |
| C-72 | ネストしたメッセージ対応コードを生成する | E-22 (line 88-92) | ○ |
| C-73 | null値フィールドをスキップする | E-22 (line 84) | ○ |

### PbCodegenSimpleSerializer関連（テストID: UT-PBF-076 〜 UT-PBF-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | FLOAT/DOUBLE/BOOLEAN型変換コードを生成する | E-23 (line 53-57) | ○ |
| C-75 | INTEGER/BIGINT型変換コードを生成する | E-23 (line 58-78) | ○ |
| C-76 | VARCHAR/CHAR型変換コードを生成する | E-23 (line 79-108) | ○ |
| C-77 | BINARY/VARBINARY型変換コードを生成する | E-23 (line 109-112) | ○ |
| C-78 | ENUM型を整数からEnumに変換する | E-23 (line 62-74) | ○ |
| C-79 | ENUM型を文字列からEnumに変換する | E-23 (line 85-104) | ○ |
| C-80 | 不正Enum値でデフォルト値を使用する | E-23 (line 72-74, 96-98) | ○ |
| C-81 | サポートされない型でPbCodegenExceptionをスローする | E-23 (line 113-114) | ○ |

### PbCodegenArraySerializer関連（テストID: UT-PBF-084 〜 UT-PBF-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | 配列シリアライズコードを生成する | E-24 (line 46-87) | ○ |
| C-83 | null要素をデフォルト値に変換する | E-24 (line 71-80) | ○ |
| C-84 | 空配列を処理する | E-24 (line 60) | ○ |

### PbCodegenMapSerializer関連（テストID: UT-PBF-087 〜 UT-PBF-089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | Mapシリアライズコードを生成する | E-25 (line 46-122) | ○ |
| C-86 | null値をデフォルト値に変換する | E-25 (line 95-116) | ○ |
| C-87 | 空Mapを処理する | E-25 (line 75-82) | ○ |

### PbFormatUtils関連（テストID: UT-PBF-090 〜 UT-PBF-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | getFullJavaNameがトップレベルメッセージ名を返却する | E-26 (line 31-40) | ○ |
| C-89 | getFullJavaNameがネストメッセージ名を返却する | E-26 (line 32-35) | ○ |
| C-90 | getFullJavaNameがEnum名を返却する | E-26 (line 43-52) | ○ |
| C-91 | isSimpleTypeがプリミティブ型を判定する | E-26 (line 54-69) | ○ |
| C-92 | getStrongCamelCaseJsonNameがキャメルケースに変換する | E-26 (line 71-73) | ○ |
| C-93 | getOuterClassNameが外部クラス名を返却する | E-26 (line 75-103) | ○ |
| C-94 | getDescriptorがDescriptorを返却する | E-26 (line 118-128) | ○ |
| C-95 | getDescriptorが不正クラス名で例外をスローする | E-26 (line 125-127) | ○ |
| C-96 | isRepeatedTypeが判定する | E-26 (line 130-132) | ○ |
| C-97 | isArrayTypeが判定する | E-26 (line 134-136) | ○ |

### PbCodegenUtils関連（テストID: UT-PBF-103 〜 UT-PBF-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | flinkContainerElementCodeがアクセスコードを生成する | E-27 (line 44-73) | ○ |
| C-99 | getTypeStrFromProtoが型文字列を返却する | E-27 (line 81-133) | ○ |
| C-100 | getTypeStrFromLogicTypeが型文字列を返却する | E-27 (line 140-167) | ○ |
| C-101 | pbDefaultValueCodeがデフォルト値コードを返却する | E-27 (line 174-203) | ○ |
| C-102 | convertFlinkArrayElementToPbWithDefaultValueCodeがコードを生成する | E-27 (line 218-252) | ○ |
| C-103 | compileClassがClassを返却する | E-27 (line 254-266) | ○ |
| C-104 | compileClassが不正コードで例外をスローする | E-27 (line 260-263) | ○ |
| C-105 | needToSplitが閾値判定する | E-27 (line 268-270) | ○ |

### PbCodegenAppender関連（テストID: UT-PBF-117 〜 UT-PBF-123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | appendLineがセミコロン付きで追加する | E-28 (line 65-67) | ○ |
| C-107 | appendSegmentがそのまま追加する | E-28 (line 69-71) | ○ |
| C-108 | beginがインデントを増加する | E-28 (line 39-46) | ○ |
| C-109 | endがインデントを減少する | E-28 (line 48-55) | ○ |
| C-110 | currentIndentが現在値を返却する | E-28 (line 57-59) | ○ |
| C-111 | codeがコードを返却する | E-28 (line 73-75) | ○ |
| C-112 | printWithLineNumberが行番号付きで返却する | E-28 (line 77-84) | ○ |

### PbCodegenVarId関連（テストID: UT-PBF-124 〜 UT-PBF-126）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | getInstanceがシングルトンを返却する | E-29 (line 33-35) | ○ |
| C-114 | getAndIncrementが一意IDを返却する | E-29 (line 37-39) | ○ |
| C-115 | getAndIncrementがスレッドセーフである | E-29 (line 29) | ○ |

### PbSchemaValidationUtils関連（テストID: UT-PBF-127 〜 UT-PBF-133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | validateが有効スキーマで成功する | E-30 (line 64-66) | ○ |
| C-117 | validateが存在しないカラムで例外をスローする | E-30 (line 82-87) | ○ |
| C-118 | validateが型不一致で例外をスローする | E-30 (line 159-165) | ○ |
| C-119 | validateがネストメッセージを検証する | E-30 (line 104-109) | ○ |
| C-120 | validateがMap型を検証する | E-30 (line 111-124) | ○ |
| C-121 | validateが配列型を検証する | E-30 (line 124-146) | ○ |

### PbToRowTypeUtil関連（テストID: UT-PBF-134 〜 UT-PBF-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | generateRowTypeがRowTypeを生成する | E-31 (line 41-56) | ○ |
| C-123 | enumAsInt=trueでEnumがIntTypeになる | E-31 (line 93-95) | ○ |
| C-124 | enumAsInt=falseでEnumがVarCharTypeになる | E-31 (line 96-98) | ○ |
| C-125 | ネストメッセージがネストRowTypeになる | E-31 (line 77-79) | ○ |
| C-126 | Map型フィールドがMapTypeになる | E-31 (line 63-74) | ○ |
| C-127 | repeated型がArrayTypeになる | E-31 (line 75-76, 104-106) | ○ |
| C-128 | サポートされない型でValidationExceptionをスローする | E-31 (line 102) | ○ |

### ProtobufInternalUtils関連（テストID: UT-PBF-141 〜 UT-PBF-143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | underScoreToCamelCaseがキャメルケースに変換する | E-32 (line 24-26) | ○ |

### PbCodegenException関連（テストID: UT-PBF-144 〜 UT-PBF-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | コンストラクタが例外を生成する | E-09 (line 22-35) | ○ |

### PbConstant関連（テストID: UT-PBF-147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | CODEGEN_SPLIT_THRESHOLDが4000である | E-08 (line 36) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコードの根拠があります

## 6) レビュアーチェックリスト（最小）
- [ ] デシリアライゼーション（Proto -> Row）のテストケースが主要なデータ型を網羅しているか確認
- [ ] シリアライゼーション（Row -> Proto）のテストケースが主要なデータ型を網羅しているか確認
- [ ] エラーハンドリング（異常系）のテストケースが十分に網羅されているか確認
- [ ] 境界値テスト（空配列、空Map等）が適切に設定されているか確認
- [ ] コード生成（Codegen）関連のテストケースがコンパイルエラーケースを含んでいるか確認
- [ ] スキーマ検証のテストケースが型不一致・カラム不在を網羅しているか確認
