---
generated_at: 2026-02-02 15:30:00
metrics:
  claims_total: 143
  claims_with_evidence: 143
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-kubernetes 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：143 / 143、根拠なし：0
- 優先レビュー（高）
  1. **高可用性（HA）関連テスト**：ConfigMap操作やリーダー選出の複雑なシナリオ
  2. **リソースマネージャ関連テスト**：Pod作成・削除の非同期処理
  3. **クラスタデプロイ関連テスト**：エラーハンドリングとクリーンアップ処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/FlinkKubeClient.java`
- E-02: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/Fabric8FlinkKubeClient.java`
- E-03: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/KubernetesClusterDescriptor.java`
- E-04: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/KubernetesResourceManagerDriver.java`
- E-05: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/parameters/KubernetesJobManagerParameters.java`
- E-06: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/parameters/KubernetesTaskManagerParameters.java`
- E-07: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/parameters/AbstractKubernetesParameters.java`
- E-08: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/factory/KubernetesJobManagerFactory.java`
- E-09: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/factory/KubernetesTaskManagerFactory.java`
- E-10: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/resources/KubernetesPod.java`
- E-11: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/FlinkPod.java`
- E-12: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/highavailability/KubernetesStateHandleStore.java`
- E-13: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/highavailability/KubernetesCheckpointIDCounter.java`
- E-14: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/highavailability/KubernetesLeaderElectionDriver.java`
- E-15: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/highavailability/KubernetesLeaderRetrievalDriver.java`
- E-16: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/resources/KubernetesLeaderElector.java`
- E-17: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/decorators/InitJobManagerDecorator.java`
- E-18: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/kubeclient/decorators/InitTaskManagerDecorator.java`
- E-19: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/utils/KubernetesUtils.java`
- E-20: `flink-kubernetes/src/main/java/org/apache/flink/kubernetes/KubernetesWorkerNode.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### FlinkKubeClient / Fabric8FlinkKubeClient（C-01 〜 C-24）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createJobManagerComponent: 有効な仕様でコンポーネント作成 | E-01, E-02 | ○ |
| C-02 | createJobManagerComponent: Deployment=null時のエラー | E-02 | ○ |
| C-03 | createTaskManagerPod: Pod正常作成 | E-01, E-02 | ○ |
| C-04 | createTaskManagerPod: Master Deployment不在時のエラー | E-02 (line 154-160) | ○ |
| C-05 | stopPod: Pod正常停止 | E-01, E-02 | ○ |
| C-06 | stopPod: 存在しないPod停止（冪等性） | E-02 | ○ |
| C-07 | getRestEndpoint: エンドポイント取得 | E-01, E-02 | ○ |
| C-08 | getRestEndpoint: Service不在時のOptional.empty | E-02 (line 189-203) | ○ |
| C-09 | getPodsWithLabels: ラベル一致Podリスト取得 | E-02 | ○ |
| C-10 | getPodsWithLabels: マッチなしで空リスト | E-02 (line 217-222) | ○ |
| C-11 | stopAndCleanupCluster: クラスタクリーンアップ | E-01, E-02 | ○ |
| C-12 | getService: Service取得 | E-02 | ○ |
| C-13 | getService: 存在しないService | E-02 (line 235-242) | ○ |
| C-14 | createConfigMap: ConfigMap正常作成 | E-01, E-02 | ○ |
| C-15 | createConfigMap: 重複作成エラー | E-02 (line 276-291) | ○ |
| C-16 | getConfigMap: ConfigMap取得 | E-02 | ○ |
| C-17 | getConfigMap: 存在しないConfigMap | E-02 (line 294-299) | ○ |
| C-18 | checkAndUpdateConfigMap: トランザクション更新 | E-01, E-02 | ○ |
| C-19 | checkAndUpdateConfigMap: 存在しないConfigMap更新エラー | E-02 (line 313-351) | ○ |
| C-20 | deleteConfigMap: ConfigMap削除 | E-02 | ○ |
| C-21 | loadPodFromTemplateFile: テンプレート読込 | E-02 | ○ |
| C-22 | loadPodFromTemplateFile: ファイル不在エラー | E-02 (line 376-380) | ○ |
| C-23 | updateServiceTargetPort: ポート更新 | E-02 | ○ |
| C-24 | close: クライアントクローズ | E-02 (line 369-372) | ○ |

### KubernetesClusterDescriptor（C-25 〜 C-36）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | コンストラクタ: 正常初期化 | E-03 (line 86-98) | ○ |
| C-26 | コンストラクタ: ClusterID未設定エラー | E-03 (line 94-97) | ○ |
| C-27 | retrieve: クラスタ取得 | E-03 (line 157-169) | ○ |
| C-28 | retrieve: エンドポイント取得失敗 | E-03 (line 119-122) | ○ |
| C-29 | deploySessionCluster: セッションクラスタデプロイ | E-03 (line 172-187) | ○ |
| C-30 | deploySessionCluster: デプロイエラー時クリーンアップ | E-03 (line 296-310) | ○ |
| C-31 | deployApplicationCluster: アプリケーションクラスタデプロイ | E-03 (line 190-247) | ○ |
| C-32 | deployApplicationCluster: 重複デプロイエラー | E-03 (line 194-198) | ○ |
| C-33 | deployApplicationCluster: デプロイターゲット不一致 | E-03 (line 203-213) | ○ |
| C-34 | killCluster: クラスタ停止 | E-03 (line 314-320) | ○ |
| C-35 | killCluster: 停止エラー | E-03 (line 316-319) | ○ |
| C-36 | close: Descriptorクローズ | E-03 (line 322-329) | ○ |

### KubernetesResourceManagerDriver（C-37 〜 C-43）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | initializeInternal: ドライバ初期化 | E-04 (line 121-134) | ○ |
| C-38 | terminate: ドライバ終了 | E-04 (line 136-161) | ○ |
| C-39 | terminate: 冪等な終了 | E-04 (line 138-140) | ○ |
| C-40 | requestResource: リソースリクエスト | E-04 (line 173-254) | ○ |
| C-41 | requestResource: Pod作成失敗 | E-04 (line 200-209) | ○ |
| C-42 | releaseResource: リソースリリース | E-04 (line 256-263) | ○ |
| C-43 | deregisterApplication: アプリケーション登録解除 | E-04 (line 163-171) | ○ |

### KubernetesJobManagerParameters（C-44 〜 C-53）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | getLabels: ラベル取得 | E-05 (line 60-68) | ○ |
| C-45 | getJobManagerMemoryMB: メモリ取得 | E-05 (line 139-141) | ○ |
| C-46 | getJobManagerCPU: CPU取得 | E-05 (line 143-145) | ○ |
| C-47 | getJobManagerCPULimitFactor: リミットファクター取得 | E-05 (line 147-155) | ○ |
| C-48 | getJobManagerCPULimitFactor: 1未満エラー | E-05 (line 150-154) | ○ |
| C-49 | getEntrypointClass: エントリポイント取得 | E-05 (line 189-197) | ○ |
| C-50 | getEntrypointClass: 未設定エラー | E-05 (line 192-195) | ○ |
| C-51 | getReplicas: レプリカ数取得 | E-05 (line 207-221) | ○ |
| C-52 | getReplicas: 0以下エラー | E-05 (line 210-214) | ○ |
| C-53 | getReplicas: HA無効で2以上エラー | E-05 (line 215-219) | ○ |

### KubernetesTaskManagerParameters（C-54 〜 C-58）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | getPodName: Pod名取得 | E-06 (line 116-118) | ○ |
| C-55 | getTaskManagerMemoryMB: メモリ取得 | E-06 (line 120-125) | ○ |
| C-56 | getTaskManagerCPU: CPU取得 | E-06 (line 127-133) | ○ |
| C-57 | getBlockedNodes: ブロックノード取得 | E-06 (line 187-189) | ○ |
| C-58 | getBlockedNodes: 空ブロックノード | E-06 | ○ |

### AbstractKubernetesParameters（C-59 〜 C-67）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | getClusterId: クラスタID取得 | E-07 (line 67-82) | ○ |
| C-60 | getClusterId: 空クラスタID検証 | E-07 (line 70-72) | ○ |
| C-61 | getClusterId: 最大文字数検証 | E-07 (line 73-79) | ○ |
| C-62 | getNamespace: 名前空間取得 | E-07 (line 84-91) | ○ |
| C-63 | getNamespace: 空白名前空間検証 | E-07 (line 87-88) | ○ |
| C-64 | getImage: イメージ取得 | E-07 (line 93-100) | ○ |
| C-65 | getImage: 空イメージ検証 | E-07 (line 96-98) | ○ |
| C-66 | getImagePullSecrets: シークレット取得 | E-07 (line 107-119) | ○ |
| C-67 | getImagePullSecrets: nullシークレット | E-07 (line 111-113) | ○ |

### Factory Classes（C-68 〜 C-71）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | KubernetesJobManagerFactory.build: JM仕様ビルド | E-08 (line 63-101) | ○ |
| C-69 | KubernetesJobManagerFactory.build: null podTemplateエラー | E-08 (line 66) | ○ |
| C-70 | KubernetesTaskManagerFactory.build: TM Podビルド | E-09 (line 48-82) | ○ |
| C-71 | KubernetesTaskManagerFactory.build: null podTemplateエラー | E-09 (line 50) | ○ |

### KubernetesPod / FlinkPod（C-72 〜 C-80）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | getName: 名前取得 | E-10 (line 36-38) | ○ |
| C-73 | isTerminated: failed状態検出 | E-10 (line 40-53) | ○ |
| C-74 | isTerminated: コンテナ終了検出 | E-10 (line 45-49) | ○ |
| C-75 | isTerminated: nullステータス | E-10 (line 41) | ○ |
| C-76 | isScheduled: スケジュール済み検出 | E-10 (line 55-64) | ○ |
| C-77 | isScheduled: 未スケジュール検出 | E-10 | ○ |
| C-78 | getTerminatedDiagnostics: 診断情報取得 | E-10 (line 66-99) | ○ |
| C-79 | FlinkPod.copy: コピー | E-11 (line 51-55) | ○ |
| C-80 | FlinkPod.Builder.build: ビルダー | E-11 (line 57-93) | ○ |

### KubernetesStateHandleStore（C-81 〜 C-94）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | addAndLock: 状態追加 | E-12 (line 206-249) | ○ |
| C-82 | addAndLock: 重複キーエラー | E-12 (line 605-607) | ○ |
| C-83 | replace: 状態置換 | E-12 (line 266-326) | ○ |
| C-84 | replace: 存在しないキー置換エラー | E-12 (line 651) | ○ |
| C-85 | exists: 存在確認 | E-12 (line 336-362) | ○ |
| C-86 | exists: 不在確認 | E-12 (line 349, 359) | ○ |
| C-87 | getAndLock: 状態取得 | E-12 (line 374-393) | ○ |
| C-88 | getAndLock: 存在しないキー取得エラー | E-12 (line 387-389) | ○ |
| C-89 | getAndLock: ConfigMap不在エラー | E-12 (line 390-392) | ○ |
| C-90 | getAllAndLock: 全取得 | E-12 (line 401-433) | ○ |
| C-91 | getAllAndLock: 空結果 | E-12 (line 432) | ○ |
| C-92 | releaseAndTryRemove: 状態削除 | E-12 (line 475-530) | ○ |
| C-93 | releaseAndTryRemove: 冪等削除 | E-12 (line 504-506) | ○ |
| C-94 | clearEntries: エントリクリア | E-12 (line 538-545) | ○ |

### KubernetesCheckpointIDCounter（C-95 〜 C-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | start: カウンタ開始 | E-13 (line 68-73) | ○ |
| C-96 | shutdown: 終了ステータスでカウンタ削除 | E-13 (line 76-102) | ○ |
| C-97 | shutdown: 非終了ステータスでカウンタ保持 | E-13 (line 100-101) | ○ |
| C-98 | getAndIncrement: 取得・インクリメント | E-13 (line 110-139) | ○ |
| C-99 | getAndIncrement: リーダーシップ検証 | E-13 (line 131-138) | ○ |
| C-100 | get: 値取得 | E-13 (line 142-153) | ○ |
| C-101 | get: ConfigMap不在エラー | E-13 (line 145-152) | ○ |
| C-102 | setCount: 値設定 | E-13 (line 156-175) | ○ |

### KubernetesLeaderElectionDriver / RetrievalDriver（C-103 〜 C-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | hasLeadership: リーダーシップ確認（true） | E-14 (line 107-123) | ○ |
| C-104 | hasLeadership: リーダーシップ確認（false） | E-14 (line 114) | ○ |
| C-105 | hasLeadership: ConfigMap不在エラー | E-14 (line 115-122) | ○ |
| C-106 | publishLeaderInformation: リーダー情報公開 | E-14 (line 126-144) | ○ |
| C-107 | deleteLeaderInformation: リーダー情報削除 | E-14 (line 147-149) | ○ |
| C-108 | close: ドライバクローズ | E-14 (line 98-105) | ○ |
| C-109 | KubernetesLeaderRetrievalDriver.close: ドライバクローズ | E-15 (line 84-94) | ○ |
| C-110 | KubernetesLeaderRetrievalDriver.close: 冪等クローズ | E-15 (line 86-88) | ○ |
| C-111 | KubernetesLeaderElector.run: 選出開始 | E-16 (line 144-153) | ○ |
| C-112 | KubernetesLeaderElector.run: 停止後呼び出し | E-16 (line 146-148) | ○ |
| C-113 | KubernetesLeaderElector.stop: 選出停止 | E-16 (line 155-174) | ○ |
| C-114 | KubernetesLeaderElector.hasLeadership: リーダーシップ確認（true） | E-16 (line 176-179) | ○ |
| C-115 | KubernetesLeaderElector.hasLeadership: リーダーシップ確認（false） | E-16 | ○ |

### Decorators（C-116 〜 C-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | InitJobManagerDecorator.decorateFlinkPod: JM Podデコレーション | E-17 (line 61-125) | ○ |
| C-117 | InitJobManagerDecorator.decorateFlinkPod: HostNetwork有効時 | E-17 (line 187-189) | ○ |
| C-118 | InitTaskManagerDecorator.decorateFlinkPod: TM Podデコレーション | E-18 (line 65-137) | ○ |
| C-119 | InitTaskManagerDecorator.decorateFlinkPod: NodeAffinity設定 | E-18 (line 118-129) | ○ |

### KubernetesUtils（C-120 〜 C-143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | checkAndUpdatePortConfigOption: フォールバックポート設定 | E-19 (line 113-123) | ○ |
| C-121 | checkAndUpdatePortConfigOption: 固定ポート維持 | E-19 (line 116) | ○ |
| C-122 | parsePort: ポート解析 | E-19 (line 133-144) | ○ |
| C-123 | parsePort: 範囲ポートエラー | E-19 (line 139-143) | ○ |
| C-124 | getDeploymentName: Deployment名生成 | E-19 (line 147-149) | ○ |
| C-125 | getTaskManagerSelectors: TMセレクタ生成 | E-19 (line 157-161) | ○ |
| C-126 | getJobManagerSelectors: JMセレクタ生成 | E-19 (line 168-172) | ○ |
| C-127 | getLeaderInformationFromConfigMap: リーダー情報取得 | E-19 (line 226-235) | ○ |
| C-128 | getLeaderInformationFromConfigMap: 空リーダー情報 | E-19 (line 231-233) | ○ |
| C-129 | getResourceRequirements: リソース要件生成 | E-19 (line 357-396) | ○ |
| C-130 | loadPodFromTemplateFile: テンプレート読込 | E-19 (line 411-439) | ○ |
| C-131 | loadPodFromTemplateFile: コンテナ不在時 | E-19 (line 431-436) | ○ |
| C-132 | resolveUserDefinedValue: 明示設定優先 | E-19 (line 459-482) | ○ |
| C-133 | resolveUserDefinedValue: テンプレート値使用 | E-19 (line 475-477) | ○ |
| C-134 | resolveDNSPolicy: HostNetwork時DNS解決 | E-19 (line 492-500) | ○ |
| C-135 | resolveDNSPolicy: オーバーライドDNS解決 | E-19 (line 496-498) | ○ |
| C-136 | createConfigMapIfItDoesNotExist: ConfigMap作成 | E-19 (line 550-583) | ○ |
| C-137 | createConfigMapIfItDoesNotExist: 既存ConfigMap | E-19 (line 567) | ○ |
| C-138 | createConfigMapIfItDoesNotExist: リトライ超過 | E-19 (line 578-582) | ○ |
| C-139 | encodeLeaderInformation: エンコード | E-19 (line 585-592) | ○ |
| C-140 | encodeLeaderInformation: nullセッションID | E-19 (line 586-587) | ○ |
| C-141 | parseLeaderInformationSafely: パース | E-19 (line 594-601) | ○ |
| C-142 | parseLeaderInformationSafely: パース失敗 | E-19 (line 597-600) | ○ |
| C-143 | KubernetesWorkerNode.getAttempt: attemptID抽出 | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースはソースコードの実装に基づいて作成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいており、明確な根拠があります。
- 以下の点に注意してレビューを行ってください：
  1. **高可用性テスト（C-81〜C-115）**: ConfigMapの状態管理とリーダー選出の複雑なシナリオは、実際の分散環境での動作を考慮した追加テストが必要な場合があります。
  2. **非同期処理テスト（C-03, C-04, C-40, C-41）**: CompletableFutureを使用した非同期処理のテストは、タイムアウトやコンカレンシーの考慮が必要です。
  3. **Kubernetesリソース操作（C-14〜C-24）**: Kubernetes APIとの連携テストは、モック/スタブの適切な設定が重要です。

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（優先度「高」）が全て網羅されているか
- [ ] 異常系テストで適切な例外がスローされることが確認されているか
- [ ] 境界値テストで空値やnull値のケースが網羅されているか
- [ ] 高可用性関連テストでリーダー選出の正常系・異常系が網羅されているか
- [ ] ConfigMap操作のトランザクション整合性テストが含まれているか
- [ ] Pod作成・削除の非同期処理が適切にテストされているか
- [ ] クラスタデプロイ時のエラーハンドリングとクリーンアップが確認されているか
