---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 195
  claims_with_evidence: 189
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：flink-libraries_flink-cep 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：189 / 195、根拠なし：6
- 優先レビュー（高）
  1. **UT-CEP-049（nullイベント処理）**：ソースコードにnullチェックの明示的記述なし
  2. **UT-CEP-069（不正文字列パース）**：NumberFormatExceptionの詳細動作要確認
  3. **UT-CEP-007（空文字列境界値）**：空文字列名の許容可否要確認
  4. **タイムアウト境界値テスト**：厳密な境界条件（>=か>か）要確認
  5. **キャッシュ動作テスト**：キャッシュサイズ超過時の詳細動作要確認
  6. **シリアライザテスト**：シリアライザの詳細動作は別モジュール確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/CEP.java`
- E-02: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/pattern/Pattern.java`
- E-03: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/NFA.java`
- E-04: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/DeweyNumber.java`
- E-05: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/NFAState.java`
- E-06: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/ComputationState.java`
- E-07: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/State.java`
- E-08: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/compiler/NFACompiler.java`
- E-09: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/sharedbuffer/SharedBuffer.java`
- E-10: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/sharedbuffer/SharedBufferAccessor.java`
- E-11: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/sharedbuffer/EventId.java`
- E-12: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/nfa/aftermatch/AfterMatchSkipStrategy.java`
- E-13: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/pattern/Quantifier.java`
- E-14: `flink-libraries/flink-cep/src/main/java/org/apache/flink/cep/PatternStream.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### CEP.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CEP.pattern(DataStream, Pattern)でPatternStreamが生成される | E-01 (L38-40) | ○ |
| C-02 | nullのDataStreamで例外がスローされる | E-01 (推定) | ○ |
| C-03 | nullのPatternで例外がスローされる | E-01 (推定) | ○ |
| C-04 | EventComparator付きでPatternStreamが生成される | E-01 (L51-55) | ○ |

### Pattern.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | Pattern.begin(String)でパターンが開始される | E-02 (L138-140) | ○ |
| C-06 | nullの名前で例外がスローされる | E-02 (推定、コンストラクタ経由) | ○ |
| C-07 | 空文字列の名前の処理 | E-02 | △ |
| C-08 | where条件が設定される | E-02 (L165-175) | ○ |
| C-09 | where条件がnullで例外 | E-02 (L166) Preconditions.checkNotNull | ○ |
| C-10 | 複数whereがAND結合 | E-02 (L172) RichAndCondition | ○ |
| C-11 | or条件がOR結合 | E-02 (L193) RichOrCondition | ○ |
| C-12 | or条件がnullで例外 | E-02 (L186) Preconditions.checkNotNull | ○ |
| C-13 | subtype制約が設定される | E-02 (L206-220) | ○ |
| C-14 | subtypeがnullで例外 | E-02 (L207) Preconditions.checkNotNull | ○ |
| C-15 | until条件が設定される | E-02 (L229-245) | ○ |
| C-16 | untilがnullで例外 | E-02 (L230) Preconditions.checkNotNull | ○ |
| C-17 | until非Loopingで例外 | E-02 (L237-238) MalformedPatternException | ○ |
| C-18 | until重複設定で例外 | E-02 (L232-233) MalformedPatternException | ○ |
| C-19 | within(Duration)が設定される | E-02 (L255-257, L267-273) | ○ |
| C-20 | within nullが許容される | E-02 (L268) null check | ○ |
| C-21 | next(String)がSTRICT戦略で追加 | E-02 (L284-286) | ○ |
| C-22 | followedBy(String)がSKIP_TILL_NEXT戦略で追加 | E-02 (L313-315) | ○ |
| C-23 | followedByAny(String)がSKIP_TILL_ANY戦略で追加 | E-02 (L344-346) | ○ |
| C-24 | notNext(String)がNOT_NEXT戦略で追加 | E-02 (L295-303) | ○ |
| C-25 | notNextオプショナル後で例外 | E-02 (L296-301) UnsupportedOperationException | ○ |
| C-26 | notFollowedBy(String)がNOT_FOLLOW戦略で追加 | E-02 (L326-334) | ○ |
| C-27 | optional()が設定される | E-02 (L354-358) | ○ |
| C-28 | optionalがgreedy後で例外 | E-02 (L659-664) MalformedPatternException | ○ |
| C-29 | oneOrMore()が設定される | E-02 (L372-396) | ○ |
| C-30 | oneOrMore NOTパターンで例外 | E-02 (L391) checkIfNoNotPattern | ○ |
| C-31 | times(int)が設定される | E-02 (L419-439) | ○ |
| C-32 | times 0以下で例外 | E-02 (L435) Preconditions.checkArgument | ○ |
| C-33 | times(1)が設定される | E-02 (L419-439) | ○ |
| C-34 | times(int, int)範囲が設定される | E-02 (L449-473) | ○ |
| C-35 | times to<fromで例外 | E-13 (L200-202) Times constructor | ○ |
| C-36 | times from=0でオプショナル | E-02 (L467-469) | ○ |
| C-37 | timesOrMore(int)が設定される | E-02 (L483-505) | ○ |
| C-38 | greedy()が設定される | E-02 (L405-410) | ○ |
| C-39 | greedy Singletonで例外 | E-13 (L131-132) checkPattern | ○ |
| C-40 | allowCombinations()が設定される | E-02 (L520-523) | ○ |
| C-41 | consecutive()が設定される | E-02 (L560-563) | ○ |

### NFA.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | createInitialNFAState()で初期状態作成 | E-03 (L131-139) | ○ |
| C-47 | process()でマッチ検出 | E-03 (L232-248) | ○ |
| C-48 | process()で非マッチイベント処理 | E-03 (L350-428) | ○ |
| C-49 | process() nullイベント処理 | E-03 | △ |
| C-50 | advanceTime()でタイムアウト処理 | E-03 (L262-340) | ○ |
| C-51 | advanceTime()境界値タイムアウト | E-03 (L342-348) | ○ |
| C-52 | open()で初期化 | E-03 (L191-199) | ○ |
| C-53 | close()でクローズ | E-03 (L202-209) | ○ |
| C-54 | getStates()で状態取得 | E-03 (L127-129) | ○ |
| C-55 | getWindowTime()でウィンドウ時間取得 | E-03 (L122-124) | ○ |

### DeweyNumber.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | DeweyNumber(int)コンストラクタ | E-04 (L46-48) | ○ |
| C-57 | DeweyNumber(DeweyNumber)コピーコンストラクタ | E-04 (L50-52) | ○ |
| C-58 | isCompatibleWith prefix | E-04 (L67-91) | ○ |
| C-59 | isCompatibleWith 同じ長さ | E-04 (L77-87) | ○ |
| C-60 | isCompatibleWith false | E-04 (L88-90) | ○ |
| C-61 | isCompatibleWith 同一値 | E-04 (L67-91) | ○ |
| C-62 | increase() | E-04 (L106-108) | ○ |
| C-63 | increase(int) | E-04 (L117-122) | ○ |
| C-64 | addStage() | E-04 (L129-133) | ○ |
| C-65 | length() | E-04 (L97-99) | ○ |
| C-66 | getRun() | E-04 (L93-95) | ○ |
| C-67 | fromString() | E-04 (L173-190) | ○ |
| C-68 | fromString単一数字 | E-04 (L176-177) | ○ |
| C-69 | fromString不正文字列 | E-04 (L187-188) | △ |
| C-70 | equals() true | E-04 (L136-144) | ○ |
| C-71 | equals() false | E-04 (L136-144) | ○ |
| C-72 | hashCode() | E-04 (L147-149) | ○ |
| C-73 | toString() | E-04 (L152-164) | ○ |

### NFAState.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | NFAState(Iterable)コンストラクタ | E-05 (L57-64) | ○ |
| C-75 | NFAState空Iterable | E-05 (L57-64) | ○ |
| C-76 | isStateChanged() | E-05 (L77-79) | ○ |
| C-77 | resetStateChanged() | E-05 (L82-84) | ○ |
| C-78 | setStateChanged() | E-05 (L87-89) | ○ |
| C-79 | getPartialMatches() | E-05 (L91-93) | ○ |
| C-80 | getCompletedMatches() | E-05 (L95-97) | ○ |
| C-81 | setNewPartialMatches() | E-05 (L99-101) | ○ |
| C-82 | equals() | E-05 (L116-126) | ○ |

### ComputationState.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | createStartState(String) | E-06 (L135-137) | ○ |
| C-84 | createStartState(String, DeweyNumber) | E-06 (L139-141) | ○ |
| C-85 | createState() | E-06 (L143-157) | ○ |
| C-86 | getCurrentStateName() | E-06 (L82-84) | ○ |
| C-87 | getVersion() | E-06 (L86-88) | ○ |
| C-88 | getStartTimestamp() | E-06 (L74-76) | ○ |
| C-89 | getPreviousTimestamp() | E-06 (L78-80) | ○ |
| C-90 | getPreviousBufferEntry() | E-06 (L70-72) | ○ |
| C-91 | getStartEventID() | E-06 (L66-68) | ○ |
| C-92 | equals() | E-06 (L91-103) | ○ |

### State.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | State(String, StateType) | E-07 (L44-49) | ○ |
| C-94 | isFinal() Final | E-07 (L55-57) | ○ |
| C-95 | isFinal() Normal | E-07 (L55-57) | ○ |
| C-96 | isStart() | E-07 (L59-61) | ○ |
| C-97 | isStop() | E-07 (L134-136) | ○ |
| C-98 | isPending() | E-07 (L138-140) | ○ |
| C-99 | makeStart() | E-07 (L71-73) | ○ |
| C-100 | addStateTransition() | E-07 (L75-80) | ○ |
| C-101 | addIgnore(IterativeCondition) | E-07 (L82-84) | ○ |
| C-102 | addTake(State, IterativeCondition) | E-07 (L90-92) | ○ |
| C-103 | addProceed() | E-07 (L94-96) | ○ |
| C-104 | getName() | E-07 (L63-65) | ○ |
| C-105 | getStateType() | E-07 (L51-53) | ○ |
| C-106 | getStateTransitions() | E-07 (L67-69) | ○ |

### NFACompiler.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | compileFactory(Pattern, boolean) | E-08 (L72-90) | ○ |
| C-108 | compileFactory null Pattern | E-08 (L74-80) | ○ |
| C-109 | compileFactory 複雑パターン | E-08 (L167-194) | ○ |
| C-110 | compileFactory 重複パターン名 | E-08 (L245-254) checkPatternNameUniqueness | ○ |
| C-111 | compileFactory notFollowedBy最後ウィンドウなし | E-08 (L186-193) | ○ |
| C-112 | canProduceEmptyMatches true | E-08 (L99-134) | ○ |
| C-113 | canProduceEmptyMatches false | E-08 (L99-134) | ○ |
| C-114 | NFAFactory.createNFA() | E-08 (L1088-1090) | ○ |

### SharedBuffer.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | SharedBufferコンストラクタ | E-09 (L90-175) | ○ |
| C-116 | getAccessor() | E-09 (L182-184) | ○ |
| C-117 | isEmpty() empty | E-09 (L219-222) | ○ |
| C-118 | isEmpty() non-empty | E-09 (L219-222) | ○ |
| C-119 | registerEvent() | E-09 (L201-211) | ○ |
| C-120 | getEvent() 存在 | E-09 (L299-314) | ○ |
| C-121 | getEvent() 存在しない | E-09 (L299-314) | ○ |
| C-122 | getEntry() | E-09 (L276-291) | ○ |
| C-123 | upsertEvent() | E-09 (L236-238) | ○ |
| C-124 | upsertEntry() | E-09 (L246-248) | ○ |
| C-125 | removeEvent() | E-09 (L255-258) | ○ |
| C-126 | removeEntry() | E-09 (L265-268) | ○ |
| C-127 | advanceTime() | E-09 (L186-199) | ○ |
| C-128 | flushCache() | E-09 (L321-330) | ○ |
| C-129 | releaseCacheStatisticsTimer() | E-09 (L224-228) | ○ |

### SharedBufferAccessor.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | registerEvent() | E-10 (L76-78) | ○ |
| C-131 | put() | E-10 (L90-111) | ○ |
| C-132 | put() previousNodeId null | E-10 (L96-98) | ○ |
| C-133 | extractPatterns() | E-10 (L120-199) | ○ |
| C-134 | extractPatterns() 存在しないNodeId | E-10 (L131) entryLock null check | ○ |
| C-135 | materializeMatch() | E-10 (L207-225) | ○ |
| C-136 | lockNode() | E-10 (L233-244) | ○ |
| C-137 | releaseNode() | E-10 (L254-295) | ○ |
| C-138 | releaseNode() 参照カウント0で削除 | E-10 (L287-293) | ○ |
| C-139 | releaseEvent() | E-10 (L316-325) | ○ |
| C-140 | advanceTime() | E-10 (L60-62) | ○ |
| C-141 | close() | E-10 (L332-334) | ○ |

### EventId.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | EventId(int, long) | E-11 (L37-40) | ○ |
| C-143 | getId() | E-11 (L42-44) | ○ |
| C-144 | getTimestamp() | E-11 (L46-48) | ○ |
| C-145 | compareTo() timestamp | E-11 (L50-51, L76-78) | ○ |
| C-146 | compareTo() same timestamp | E-11 (L50-51) | ○ |
| C-147 | equals() true | E-11 (L54-63) | ○ |
| C-148 | equals() false | E-11 (L54-63) | ○ |
| C-149 | hashCode() | E-11 (L66-68) | ○ |

### AfterMatchSkipStrategy.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | skipToFirst() | E-12 (L44-46) | ○ |
| C-151 | skipToLast() | E-12 (L55-57) | ○ |
| C-152 | skipPastLastEvent() | E-12 (L64-66) | ○ |
| C-153 | skipToNext() | E-12 (L73-75) | ○ |
| C-154 | noSkip() | E-12 (L82-84) | ○ |
| C-155 | isSkipStrategy() NoSkip | E-12 (L91) abstract | ○ |
| C-156 | isSkipStrategy() SkipToFirst | E-12 (L91) abstract | ○ |
| C-157 | prune() | E-12 (L101-124) | ○ |
| C-158 | prune() NoSkip | E-12 (L106-108) | ○ |
| C-159 | getPatternName() SkipToFirst | E-12 (L145-147) | ○ |
| C-160 | getPatternName() NoSkip | E-12 (L145-147) | ○ |

### Quantifier.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-161 | one() | E-13 (L59-61) | ○ |
| C-162 | looping() | E-13 (L63-65) | ○ |
| C-163 | times() | E-13 (L67-69) | ○ |
| C-164 | hasProperty() true | E-13 (L71-73) | ○ |
| C-165 | hasProperty() false | E-13 (L71-73) | ○ |
| C-166 | optional() | E-13 (L116-124) | ○ |
| C-167 | optional() 重複 | E-13 (L117) | ○ |
| C-168 | optional() NOT | E-13 (L118-121) | ○ |
| C-169 | greedy() | E-13 (L126-135) | ○ |
| C-170 | greedy() SINGLE | E-13 (L131-132) | ○ |
| C-171 | combinations() | E-13 (L89-101) | ○ |
| C-172 | combinations() SINGLE | E-13 (L91-92) | ○ |
| C-173 | consecutive() | E-13 (L103-114) | ○ |
| C-174 | consecutive() after combinations | E-13 (L108-109) | ○ |
| C-175 | getConsumingStrategy() | E-13 (L79-81) | ○ |
| C-176 | getInnerConsumingStrategy() | E-13 (L75-77) | ○ |
| C-177 | Times.of(int, int, Duration) | E-13 (L219-221) | ○ |
| C-178 | Times.of() from<=0 | E-13 (L197-198) | ○ |
| C-179 | Times.of() to<from | E-13 (L199-202) | ○ |
| C-180 | Times.of(int, Duration) | E-13 (L223-225) | ○ |
| C-181 | Times.getFrom() | E-13 (L207-209) | ○ |
| C-182 | Times.getTo() | E-13 (L211-213) | ○ |
| C-183 | Times.getWindowSize() | E-13 (L215-217) | ○ |
| C-184 | Times.getWindowSize() null | E-13 (L215-217) | ○ |

### PatternStream.java関連テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-185 | sideOutputLateData() | E-14 (L70-72) | ○ |
| C-186 | inProcessingTime() | E-14 (L75-77) | ○ |
| C-187 | inEventTime() | E-14 (L80-82) | ○ |
| C-188 | process(PatternProcessFunction) | E-14 (L95-109) | ○ |
| C-189 | process(PatternProcessFunction, TypeInformation) | E-14 (L123-128) | ○ |
| C-190 | select(PatternSelectFunction) | E-14 (L141-158) | ○ |
| C-191 | select(PatternSelectFunction, TypeInformation) | E-14 (L172-180) | ○ |
| C-192 | select with timeout | E-14 (L207-269) | ○ |
| C-193 | flatSelect(PatternFlatSelectFunction) | E-14 (L282-299) | ○ |
| C-194 | flatSelect(PatternFlatSelectFunction, TypeInformation) | E-14 (L313-321) | ○ |
| C-195 | flatSelect with timeout | E-14 (L348-411) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CEP-007（空文字列境界値）**：空文字列名がパターン名として許容されるか、コード上で明示的なバリデーションが見当たらない
  - 候補：既存テストコード / Javadoc / 仕様書
- **UT-CEP-049（nullイベント処理）**：NFA.process()にnullイベントが渡された場合の明示的なハンドリングがコード上で確認できない
  - 候補：既存テストコード / エラーハンドリングドキュメント
- **UT-CEP-069（不正文字列パース）**：NumberFormatExceptionがスローされる動作は推測だが、IllegalArgumentExceptionにラップされる可能性あり
  - 候補：既存テストコード / 実行確認
- **キャッシュ動作の詳細**：キャッシュサイズ超過時のエビクション動作の詳細
  - 候補：Guava Cache仕様 / 設定ファイル
- **タイムアウト境界条件**：>=か>かの厳密な境界条件
  - 候補：既存テストコード / 仕様書
- **シリアライザ動作**：DeweyNumber.DeweyNumberSerializer等の詳細シリアライズ動作
  - 候補：シリアライザテストコード

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: 境界値テスト（タイムアウト、回数指定）の厳密な条件確認が必要
- **0 (低リスク)**: 大部分のテストケースはソースコードから直接根拠が確認できる
- **1 (中リスク)**: キャッシュ関連テストは外部ライブラリ（Guava）依存のため詳細確認推奨
- **0 (低リスク)**: 基本的なgetter/setterテストは低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 境界値テスト（UT-CEP-007, UT-CEP-032, UT-CEP-033, UT-CEP-051）の条件が正確か確認
- [ ] nullハンドリングテスト（UT-CEP-002, UT-CEP-003, UT-CEP-049等）が実装時に正しく動作するか確認
- [ ] MalformedPatternException系テストの例外メッセージが適切か確認
- [ ] キャッシュ動作テスト（UT-CEP-123-128）がGuava Cacheの仕様と整合しているか確認
- [ ] シリアライザテストがFlink TypeSerializer仕様に準拠しているか確認
- [ ] タイムアウト処理テスト（UT-CEP-050, UT-CEP-051）の境界条件（>=か>か）を確認
- [ ] 既存テストコード（flink-cep/src/test/java/）との重複・不足を確認
