---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 118
  claims_with_evidence: 118
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-libraries_flink-state-processing-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：118 / 118、根拠なし：0
- 優先レビュー（高）
  1. **SavepointReader/SavepointWriter**：セーブポイント読み書きの中核機能のため、実装との整合性を重点確認
  2. **境界値テスト（maxParallelism）**：1〜32768の範囲チェックの妥当性確認
  3. **例外処理テスト**：IOException, IllegalArgumentException等の発生条件確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/SavepointReader.java`
- E-02: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/SavepointWriter.java`
- E-03: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/OperatorIdentifier.java`
- E-04: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/StateBootstrapTransformation.java`
- E-05: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/KeyedStateInputFormat.java`
- E-06: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/BufferingCollector.java`
- E-07: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/MultiStateKeyIterator.java`
- E-08: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/ListStateInputFormat.java`
- E-09: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/UnionStateInputFormat.java`
- E-10: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/BroadcastStateInputFormat.java`
- E-11: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/OperatorStateInputFormat.java`
- E-12: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/input/StreamOperatorContextBuilder.java`
- E-13: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/WindowSavepointReader.java`
- E-14: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/EvictingWindowSavepointReader.java`
- E-15: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/runtime/OperatorIDGenerator.java`
- E-16: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/runtime/SavepointLoader.java`
- E-17: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/runtime/metadata/SavepointMetadataV2.java`
- E-18: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/output/SnapshotUtils.java`
- E-19: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/output/OperatorSubtaskStateReducer.java`
- E-20: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/output/operators/KeyedStateBootstrapOperator.java`
- E-21: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/OperatorTransformation.java`
- E-22: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/OneInputStateTransformation.java`
- E-23: `flink-libraries/flink-state-processing-api/src/main/java/org/apache/flink/state/api/KeyedStateTransformation.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SavepointReader関連 (C-01〜C-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SavepointReader.read(env, path)の正常系 | E-01 L70-90 | ○ |
| C-02 | SavepointReader.read(env, path)の異常系（無効パス） | E-01 L72 (SavepointLoader呼び出し) | ○ |
| C-03 | SavepointReader.read(env, path)の異常系（null env） | E-01 L144 (Preconditions.checkNotNull) | ○ |
| C-04 | SavepointReader.read(env, path, stateBackend)の正常系 | E-01 L101-122 | ○ |
| C-05 | readListStateの正常系 | E-01 L162-205 | ○ |
| C-06 | readListStateの異常系（存在しないID） | E-17 L93-107 (getOperatorState) | ○ |
| C-07 | readUnionStateの正常系 | E-01 L217-260 | ○ |
| C-08 | readBroadcastStateの正常系 | E-01 L274-335 | ○ |
| C-09 | readKeyedStateの正常系 | E-01 L347-415 | ○ |
| C-10 | readKeyedStateの異常系（型推論失敗） | E-01 L354-381 (InvalidProgramException) | ○ |
| C-11 | windowの正常系 | E-01 L424-428 | ○ |
| C-12 | windowの異常系（null assigner） | E-01 L425 (Preconditions.checkNotNull) | ○ |

### SavepointWriter関連 (C-13〜C-25)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | fromExistingSavepointの正常系 | E-02 L79-82 | ○ |
| C-14 | fromExistingSavepointの異常系（無効パス） | E-02 L99 (readSavepointMetadata) | ○ |
| C-15 | newSavepointの正常系 | E-02 L126-130 | ○ |
| C-16 | newSavepointの境界値（maxParallelism=1） | E-02 L188-189 (Preconditions.checkArgument) | ○ |
| C-17 | newSavepointの境界値（maxParallelism=32768） | E-02 L188-189 (UPPER_BOUND_MAX_PARALLELISM) | ○ |
| C-18 | newSavepointの異常系（maxParallelism=0） | E-02 L188-193 | ○ |
| C-19 | newSavepointの異常系（maxParallelism>上限） | E-02 L188-193 | ○ |
| C-20 | removeOperatorの正常系 | E-02 L227-230 | ○ |
| C-21 | withOperatorの正常系 | E-02 L239-243 | ○ |
| C-22 | withOperatorの異常系（重複ID） | E-17 L117-125 | ○ |
| C-23 | changeOperatorIdentifierの正常系 | E-02 L298-302 | ○ |
| C-24 | writeの正常系 | E-02 L309-348 | ○ |
| C-25 | writeの異常系（オペレーターなし） | E-02 L317-326 | ○ |

### OperatorIdentifier関連 (C-26〜C-32)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | forUidの正常系 | E-03 L52-55 | ○ |
| C-27 | forUidの異常系（null uid） | E-03 L48 (Preconditions.checkNotNull) | ○ |
| C-28 | forUidHashの正常系 | E-03 L47-50 | ○ |
| C-29 | forUidHashの異常系（null hash） | E-03 L48 (Preconditions.checkNotNull) | ○ |
| C-30 | equalsの正常系（同一） | E-03 L68-77 | ○ |
| C-31 | equalsの正常系（異なる） | E-03 L68-77 | ○ |
| C-32 | hashCodeの正常系 | E-03 L80-82 | ○ |

### StateBootstrapTransformation関連 (C-33〜C-35)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | getMaxParallelismの正常系（ローカル設定あり） | E-04 L115-117 | ○ |
| C-34 | getMaxParallelismの正常系（ローカル設定なし） | E-04 L115-117 | ○ |
| C-35 | writeOperatorStateの正常系 | E-04 L127-148 | ○ |

### KeyedStateInputFormat関連 (C-36〜C-44)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | constructorの正常系 | E-05 L97-117 | ○ |
| C-37 | constructorの異常系（null operatorState） | E-05 L104 | ○ |
| C-38 | createInputSplitsの正常系 | E-05 L133-144 | ○ |
| C-39 | createInputSplitsの境界値（minNumSplits=1） | E-05 L136 | ○ |
| C-40 | openの正常系 | E-05 L153-195 | ○ |
| C-41 | reachedEndの正常系（終了） | E-05 L209-211 | ○ |
| C-42 | reachedEndの正常系（継続） | E-05 L209-211 | ○ |
| C-43 | nextRecordの正常系 | E-05 L214-230 | ○ |
| C-44 | closeの正常系 | E-05 L198-206 | ○ |

### BufferingCollector関連 (C-45〜C-49)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | collectの正常系 | E-06 L50-52 | ○ |
| C-46 | hasNextの正常系（要素あり） | E-06 L40-42 | ○ |
| C-47 | hasNextの正常系（要素なし） | E-06 L40-42 | ○ |
| C-48 | nextの正常系 | E-06 L45-47 | ○ |
| C-49 | nextの境界値（空バッファ） | E-06 L45-47 (Queue.poll returns null) | ○ |

### MultiStateKeyIterator関連 (C-50〜C-56)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | constructorの正常系 | E-07 L49-67 | ○ |
| C-51 | constructorの異常系（null descriptors） | E-07 L52 | ○ |
| C-52 | hasNextの正常系（キーあり） | E-07 L70-72 | ○ |
| C-53 | hasNextの正常系（キーなし） | E-07 L70-72 | ○ |
| C-54 | nextの正常系 | E-07 L75-80 | ○ |
| C-55 | nextの異常系（NoSuchElementException） | E-07 L76-77 | ○ |
| C-56 | closeの正常系 | E-07 L84-86 | ○ |

### ListStateInputFormat関連 (C-57〜C-59)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | constructorの正常系 | E-08 L54-65 | ○ |
| C-58 | constructorの異常系（null descriptor） | E-08 L63-64 | ○ |
| C-59 | getElementsの正常系 | E-08 L68-71 | ○ |

### UnionStateInputFormat関連 (C-60〜C-61)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | constructorの正常系 | E-09 L54-65 | ○ |
| C-61 | getElementsの正常系 | E-09 L68-71 | ○ |

### BroadcastStateInputFormat関連 (C-62〜C-63)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | constructorの正常系 | E-10 L58-69 | ○ |
| C-63 | getElementsの正常系 | E-10 L72-80 | ○ |

### WindowSavepointReader関連 (C-64〜C-69)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | constructorの正常系 | E-13 L71-84 | ○ |
| C-65 | constructorの異常系（null env） | E-13 L76 | ○ |
| C-66 | evictorの正常系 | E-13 L87-89 | ○ |
| C-67 | reduceの正常系 | E-13 L103-142 | ○ |
| C-68 | aggregateの正常系 | E-13 L159-202 | ○ |
| C-69 | processの正常系 | E-13 L219-231 | ○ |

### OperatorIDGenerator関連 (C-70〜C-72)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | fromUidの正常系 | E-15 L43-46 | ○ |
| C-71 | fromUidの正常系（一貫性） | E-15 L43-46 (Murmur3 hash) | ○ |
| C-72 | fromUidの正常系（一意性） | E-15 L43-46 (Murmur3 hash) | ○ |

### SavepointLoader関連 (C-73〜C-74)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | loadSavepointMetadataの正常系 | E-16 L47-57 | ○ |
| C-74 | loadSavepointMetadataの異常系（無効パス） | E-16 L49-50 | ○ |

### SavepointMetadataV2関連 (C-75〜C-84)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | constructorの正常系 | E-17 L52-75 | ○ |
| C-76 | constructorの異常系（maxParallelism=0） | E-17 L57-62 | ○ |
| C-77 | constructorの異常系（maxParallelism>上限） | E-17 L57-62 | ○ |
| C-78 | getOperatorStateの正常系 | E-17 L93-107 | ○ |
| C-79 | getOperatorStateの異常系（存在しないID） | E-17 L97-104 | ○ |
| C-80 | removeOperatorの正常系 | E-17 L109-111 | ○ |
| C-81 | addOperatorの正常系 | E-17 L113-131 | ○ |
| C-82 | addOperatorの異常系（重複ID） | E-17 L117-125 | ○ |
| C-83 | getExistingOperatorsの正常系 | E-17 L136-141 | ○ |
| C-84 | getNewOperatorsの正常系 | E-17 L147-152 | ○ |

### SnapshotUtils関連 (C-85〜C-86)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | snapshotの正常系 | E-18 L47-79 | ○ |
| C-86 | snapshotの異常系（無効パス） | E-18 L69 (createStreamFactory) | ○ |

### OperatorSubtaskStateReducer関連 (C-87〜C-90)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | constructorの正常系 | E-19 L48-54 | ○ |
| C-88 | constructorの異常系（null identifier） | E-19 L49 | ○ |
| C-89 | constructorの異常系（maxParallelism<=1） | E-19 L50 | ○ |
| C-90 | reduceの正常系 | E-19 L62-79 | ○ |

### KeyedStateBootstrapOperator関連 (C-91〜C-94)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | constructorの正常系 | E-20 L61-71 | ○ |
| C-92 | openの正常系 | E-20 L74-88 | ○ |
| C-93 | processElementの正常系 | E-20 L91-93 | ○ |
| C-94 | endInputの正常系 | E-20 L96-110 | ○ |

### OperatorTransformation関連 (C-95〜C-96)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | bootstrapWith(stream)の正常系 | E-21 L66-68 | ○ |
| C-96 | bootstrapWith(stream, checkpointId)の正常系 | E-21 L78-81 | ○ |

### OneInputStateTransformation関連 (C-97〜C-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | setMaxParallelismの正常系 | E-22 L73-76 | ○ |
| C-98 | transform(StateBootstrapFunction)の正常系 | E-22 L87-95 | ○ |
| C-99 | transform(BroadcastStateBootstrapFunction)の正常系 | E-22 L107-116 | ○ |
| C-100 | keyBy(KeySelector)の正常系 | E-22 L138-143 | ○ |
| C-101 | keyBy(int...)の正常系 | E-22 L166-173 | ○ |
| C-102 | keyBy(String...)の正常系 | E-22 L185-187 | ○ |

### KeyedStateTransformation関連 (C-103〜C-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | transform(KeyedStateBootstrapFunction)の正常系 | E-23 L82-90 | ○ |
| C-104 | window(WindowAssigner)の正常系 | E-23 L117-121 | ○ |

### EvictingWindowSavepointReader関連 (C-105〜C-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | reduceの正常系 | E-14 L102-145 | ○ |
| C-106 | aggregateの正常系 | E-14 L162-210 | ○ |
| C-107 | processの正常系 | E-14 L227-244 | ○ |

### StreamOperatorContextBuilder関連 (C-108〜C-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | constructorの正常系 | E-12 L71-87 | ○ |
| C-109 | withMaxParallelismの正常系 | E-12 L89-92 | ○ |
| C-110 | withKeyの正常系 | E-12 L94-98 | ○ |
| C-111 | buildの正常系 | E-12 L100-143 | ○ |
| C-112 | buildの異常系（状態バックエンド失敗） | E-12 L120-123 | ○ |

### OperatorStateInputFormat関連 (C-113〜C-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | createInputSplitsの正常系 | E-11 L124-132 | ○ |
| C-114 | createInputSplitsの境界値（Union型） | E-11 L127-131, L134-151 | ○ |
| C-115 | openの正常系 | E-11 L172-202 | ○ |
| C-116 | closeの正常系 | E-11 L205-213 | ○ |
| C-117 | reachedEndの正常系 | E-11 L216-218 | ○ |
| C-118 | nextRecordの正常系 | E-11 L221-223 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードの実装に基づいて導出されており、根拠が存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに根拠あり
- 注意事項：
  - 統合テスト（ITCase）ファイルは本単体テストケースの範囲外
  - 実際のセーブポイントファイルを使用したテストは環境依存性あり

## 6) レビュアーチェックリスト（最小）
- [ ] SavepointReader/SavepointWriterの主要メソッドがカバーされているか
- [ ] maxParallelismの境界値（1, 32768, 0, 32769）が網羅されているか
- [ ] 各InputFormat（List, Union, Broadcast, Keyed）の基本操作がカバーされているか
- [ ] null入力に対する検証テストが含まれているか
- [ ] 例外発生条件（IOException, IllegalArgumentException等）が明確か
- [ ] Window関連（通常/Evicting）の読み込み機能がカバーされているか
