---
generated_at: 2026-02-02 18:20:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-metrics_flink-metrics-graphite

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. なし（すべてのテストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-metrics/flink-metrics-graphite/src/main/java/org/apache/flink/metrics/graphite/GraphiteReporter.java`
- E-02: `flink-metrics/flink-metrics-graphite/src/main/java/org/apache/flink/metrics/graphite/GraphiteReporterFactory.java`
- E-03: `flink-metrics/flink-metrics-dropwizard/src/main/java/org/apache/flink/dropwizard/ScheduledDropwizardReporter.java`（親クラス）
- E-04: `flink-metrics/flink-metrics-graphite/src/test/java/org/apache/flink/metrics/graphite/GraphiteReporterFactoryTest.java`（既存テスト参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TCPプロトコル指定時にGraphiteを使用したReporterが生成される | E-01 (L91-96: switch文でTCP/defaultはnew Graphite使用) | ○ |
| C-02 | UDPプロトコル指定時にGraphiteUDPを使用したReporterが生成される | E-01 (L92-93: case UDPでnew GraphiteUDP使用) | ○ |
| C-03 | prefix指定時にprefixedWith()で設定される | E-01 (L63-65: prefixがnullでない場合builder.prefixedWith(prefix)) | ○ |
| C-04 | rateConversion指定時にconvertRatesTo()で設定される | E-01 (L67-69: conversionRateがnullでない場合TimeUnit.valueOfで変換) | ○ |
| C-05 | durationConversion指定時にconvertDurationsTo()で設定される | E-01 (L71-73: conversionDurationがnullでない場合TimeUnit.valueOfで変換) | ○ |
| C-06 | protocol省略時はデフォルトでTCPが使用される | E-01 (L58: config.getString(ARG_PROTOCOL, "TCP")) | ○ |
| C-07 | hostがnullの場合IllegalArgumentExceptionがスローされる | E-01 (L50-53: host == null条件でthrow) | ○ |
| C-08 | hostが空文字の場合IllegalArgumentExceptionがスローされる | E-01 (L50-53: host.length() == 0条件でthrow) | ○ |
| C-09 | portが0の場合IllegalArgumentExceptionがスローされる | E-01 (L50-53: port < 1条件でthrow) | ○ |
| C-10 | portが負数の場合IllegalArgumentExceptionがスローされる | E-01 (L50-53: port < 1条件でthrow、-1もこれに該当) | ○ |
| C-11 | 不正なprotocol文字列の場合デフォルトでTCPが使用される | E-01 (L76-84: Protocol.valueOf失敗時にcatch→TCP設定) | ○ |
| C-12 | portが1の場合正常に処理される | E-01 (L50: port < 1で判定、1以上は通過) | ○ |
| C-13 | portが65535の場合正常に処理される | E-01 (上限チェックなし、int範囲内なら受け付け) | ○ |
| C-14 | prefixがnullの場合prefixなしで処理される | E-01 (L63-65: prefix != null条件なのでnullは無視) | ○ |
| C-15 | rateConversionがnullの場合デフォルト設定で処理される | E-01 (L67-69: conversionRate != null条件なのでnullは無視) | ○ |
| C-16 | durationConversionがnullの場合デフォルト設定で処理される | E-01 (L71-73: conversionDuration != null条件なのでnullは無視) | ○ |
| C-17 | 不正なrateConversion値でIllegalArgumentExceptionがスローされる | E-01 (L68: TimeUnit.valueOf()は不正値でIllegalArgumentExceptionをスロー) | ○ |
| C-18 | 不正なdurationConversion値でIllegalArgumentExceptionがスローされる | E-01 (L72: TimeUnit.valueOf()は不正値でIllegalArgumentExceptionをスロー) | ○ |
| C-19 | 全オプション指定時に全設定が適用される | E-01 (L55-73: 各オプションを順次設定するロジック) | ○ |
| C-20 | protocol小文字指定時の挙動確認 | E-01 (L77: Protocol.valueOf()はcase-sensitiveなのでIAE発生→TCP) | ○ |
| C-21 | ファクトリが空Propertiesで新インスタンスを生成する | E-02 (L30-32: 常にnew GraphiteReporter()を返却) | ○ |
| C-22 | ファクトリがプロパティ指定で新インスタンスを生成する | E-02 (L30-32: propertiesは使用されないがインスタンスは返却) | ○ |
| C-23 | ファクトリにnullを渡した場合の挙動 | E-02 (L30-32: propertiesは使用されないのでnullでも動作する可能性) | ○ |
| C-24 | 複数回呼び出しで異なるインスタンスが生成される | E-02 (L31: 毎回new GraphiteReporter()を実行) | ○ |
| C-25 | ServiceLoaderでファクトリがロードできる | E-04 (L30: MetricReporterTestUtils.testMetricReporterSetupViaSPI使用) | ○ |
| C-26 | MetricReporterFactoryインターフェースを実装している | E-02 (L27: implements MetricReporterFactory) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースにソースコードベースの根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいて生成されている

### 確認済みのソースコード構造

**GraphiteReporter.java:**
- 親クラス: `ScheduledDropwizardReporter`（flink-metrics-dropwizardモジュール）
- 主要メソッド: `getReporter(MetricConfig config)`
- 内部enum: `Protocol { TCP, UDP }`
- 定数: `ARG_PROTOCOL = "protocol"`
- 親クラスから継承: `ARG_HOST`, `ARG_PORT`, `ARG_PREFIX`, `ARG_CONVERSION_RATE`, `ARG_CONVERSION_DURATION`

**GraphiteReporterFactory.java:**
- インターフェース実装: `MetricReporterFactory`
- 主要メソッド: `createMetricReporter(Properties properties)`
- 処理内容: 常に新しいGraphiteReporterインスタンスを返却（propertiesは使用しない）

## 6) レビュアーチェックリスト（最小）
- [ ] UT-GRA-007〜010: host/portの検証ロジックが正しくテストされているか確認
- [ ] UT-GRA-011: 不正protocolのフォールバック動作が期待通りか確認
- [ ] UT-GRA-017〜018: TimeUnit変換エラーのハンドリングが適切か確認
- [ ] UT-GRA-023: null Propertiesの扱いが実際の実装と一致するか確認
- [ ] UT-GRA-025: SPIテストが既存テスト（GraphiteReporterFactoryTest）と重複しないか確認
