---
generated_at: 2026-02-02 18:25:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：flink-metrics_flink-metrics-jmx 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-JMX-056**：null入力時の動作が明示されていない
  2. **UT-JMX-011**：不正なObjectName生成の具体的条件が明確でない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-metrics/flink-metrics-jmx/src/main/java/org/apache/flink/metrics/jmx/JMXReporter.java` - JMXReporterクラス本体
- E-02: `flink-metrics/flink-metrics-jmx/src/main/java/org/apache/flink/metrics/jmx/JMXReporterFactory.java` - JMXReporterFactoryクラス
- E-03: JMXReporter.java L57-62 - クラス定義とJMX_DOMAIN_PREFIX定数
- E-04: JMXReporter.java L73-83 - コンストラクタ
- E-05: JMXReporter.java L89-99 - open/close/getPortメソッド
- E-06: JMXReporter.java L106-159 - notifyOfAddedMetricメソッド
- E-07: JMXReporter.java L162-179 - notifyOfRemovedMetricメソッド
- E-08: JMXReporter.java L185-193 - generateJmxTableメソッド
- E-09: JMXReporter.java L195-200 - generateJmxDomainメソッド
- E-10: JMXReporter.java L215-261 - replaceInvalidCharsメソッド
- E-11: JMXReporter.java L273-288 - JmxCounterクラス
- E-12: JMXReporter.java L291-307 - JmxGaugeクラス
- E-13: JMXReporter.java L310-397 - JmxHistogramクラス
- E-14: JMXReporter.java L400-423 - JmxMeterクラス
- E-15: JMXReporterFactory.java L25-34 - createMetricReporterメソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | portsConfig=nullでMBeanServerとregisteredMetricsが初期化される | E-04 | ○ |
| C-02 | portsConfig指定でJMXServiceが開始される | E-04 | ○ |
| C-03 | open呼び出しが正常に完了する | E-05 | ○ |
| C-04 | close呼び出しが正常に完了する | E-05 | ○ |
| C-05 | getPortがJMXService.getPort()を返却する | E-05 | ○ |
| C-06 | JMXService未開始時に空のOptionalが返却される | E-05 | ○ |
| C-07 | GaugeメトリクスがMBeanServerに登録される | E-06 | ○ |
| C-08 | CounterメトリクスがMBeanServerに登録される | E-06 | ○ |
| C-09 | HistogramメトリクスがMBeanServerに登録される | E-06 | ○ |
| C-10 | MeterメトリクスがMBeanServerに登録される | E-06 | ○ |
| C-11 | 不正なObjectNameでMalformedObjectNameExceptionがログ記録される | E-06 | △ |
| C-12 | 未知のメトリクスタイプでエラーログが出力される | E-06 | ○ |
| C-13 | InstanceAlreadyExistsExceptionが警告ログに記録される | E-06 | ○ |
| C-14 | 登録済みメトリクスが正常に削除される | E-07 | ○ |
| C-15 | 未登録メトリクス削除要求で何も起こらない | E-07 | ○ |
| C-16 | InstanceNotFoundExceptionが無視される | E-07 | ○ |
| C-17 | MBeanServer操作例外でシステムが継続する | E-07 | ○ |
| C-18 | 変数マップからHashtableが生成される | E-08 | ○ |
| C-19 | 空のマップで空のHashtableが返却される | E-08 | ○ |
| C-20 | 特殊文字が正しく変換される | E-08, E-10 | ○ |
| C-21 | JMXドメインが正常に生成される | E-09 | ○ |
| C-22 | 論理スコープがドット区切りで連結される | E-09 | ○ |
| C-23 | 無効文字を含まない文字列は変更されない | E-10 | ○ |
| C-24 | ダブルクォートが削除される | E-10 | ○ |
| C-25 | スペースがアンダースコアに置換される | E-10 | ○ |
| C-26 | カンマがハイフンに置換される | E-10 | ○ |
| C-27 | イコールがハイフンに置換される | E-10 | ○ |
| C-28 | セミコロンがハイフンに置換される | E-10 | ○ |
| C-29 | コロンがハイフンに置換される | E-10 | ○ |
| C-30 | クエスチョンマークがハイフンに置換される | E-10 | ○ |
| C-31 | シングルクォートがハイフンに置換される | E-10 | ○ |
| C-32 | アスタリスクがハイフンに置換される | E-10 | ○ |
| C-33 | 大なり記号が削除される | E-10 | ○ |
| C-34 | 小なり記号が削除される | E-10 | ○ |
| C-35 | 複数の無効文字が混在する場合に全て処理される | E-10 | ○ |
| C-36 | 空文字列で空文字列が返却される | E-10 | ○ |
| C-37 | 1文字の無効文字が正しく処理される | E-10 | ○ |
| C-38 | JmxCounter.getCount()がCounter値を返却する | E-11 | ○ |
| C-39 | JmxGauge.getValue()がGauge値を返却する | E-12 | ○ |
| C-40 | JmxHistogram.getCount()がHistogram件数を返却する | E-13 | ○ |
| C-41 | JmxHistogram.getMean()が平均値を返却する | E-13 | ○ |
| C-42 | JmxHistogram.getStdDev()が標準偏差を返却する | E-13 | ○ |
| C-43 | JmxHistogram.getMax()が最大値を返却する | E-13 | ○ |
| C-44 | JmxHistogram.getMin()が最小値を返却する | E-13 | ○ |
| C-45 | JmxHistogram.getMedian()が中央値を返却する | E-13 | ○ |
| C-46 | JmxHistogram.get75thPercentile()が75パーセンタイルを返却する | E-13 | ○ |
| C-47 | JmxHistogram.get95thPercentile()が95パーセンタイルを返却する | E-13 | ○ |
| C-48 | JmxHistogram.get98thPercentile()が98パーセンタイルを返却する | E-13 | ○ |
| C-49 | JmxHistogram.get99thPercentile()が99パーセンタイルを返却する | E-13 | ○ |
| C-50 | JmxHistogram.get999thPercentile()が99.9パーセンタイルを返却する | E-13 | ○ |
| C-51 | JmxMeter.getRate()がレートを返却する | E-14 | ○ |
| C-52 | JmxMeter.getCount()が件数を返却する | E-14 | ○ |
| C-53 | properties.port指定でJMXReporterが生成される | E-15 | ○ |
| C-54 | properties.port未指定でportsConfig=nullのJMXReporterが生成される | E-15 | ○ |
| C-55 | ポート範囲指定でJMXReporterが生成される | E-15 | ○ |
| C-56 | properties=nullでNullPointerExceptionがスローされる可能性 | **根拠なし** | △ |
| C-57 | 複数スレッドからの同時追加でスレッドセーフに動作する | E-06 | ○ |
| C-58 | 複数スレッドからの同時削除でスレッドセーフに動作する | E-07 | ○ |
| C-59 | 追加と削除の同時実行でスレッドセーフに動作する | E-06, E-07 | ○ |
| C-60 | JMX_DOMAIN_PREFIXが"org.apache.flink."である | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-11（UT-JMX-011）**: 不正なObjectNameが生成される具体的な条件がコード上のコメントでは「domain or table does not conform to JMX rules」とあるが、具体的なケースの列挙がない
  - 候補：JMX仕様書 / ObjectNameのJavadoc / 既存テストケース
- **C-56（UT-JMX-056）**: JMXReporterFactory.createMetricReporter()のnull入力時の動作がコード上で明示されていない
  - 候補：Propertiesクラスのnull動作仕様 / メソッドのnull許容に関するドキュメント

## 5) リスクフラグ（レビュー観点）
- **リスク1（中リスク）**: JMXReporterFactory.createMetricReporter()にnull引数が渡された場合の動作が未定義。NullPointerExceptionがスローされる可能性があるが、フレームワーク側でnullチェックがある可能性もある。
- **リスク0（低リスク）**: replaceInvalidCharsメソッドは詳細にドキュメント化されており、テストケースはコードコメントに基づいて生成されているため信頼性が高い。
- **リスク0（低リスク）**: MBean関連クラス（JmxCounter, JmxGauge, JmxHistogram, JmxMeter）は単純なラッパーであり、テストケースは適切。

## 6) レビュアーチェックリスト（最小）
- [ ] JMXReporterFactory.createMetricReporter()のnull引数時の動作を確認（UT-JMX-056）
- [ ] MalformedObjectNameExceptionが発生する具体的条件を確認（UT-JMX-011）
- [ ] 並行テスト（UT-JMX-057〜059）の実装方針を確認（synchronizedブロックの検証）
- [ ] JMXService連携テスト（UT-JMX-005〜006）でモック使用の要否を確認
- [ ] 既存テストコード（JMXReporterTest.java, JMXReporterFactoryTest.java）との整合性確認
