---
generated_at: 2026-02-02 18:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 75
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-metrics_flink-metrics-prometheus.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：75 / 75、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/AbstractPrometheusReporter.java`
- E-02: `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusReporter.java`
- E-03: `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusReporterFactory.java`
- E-04: `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusPushGatewayReporter.java`
- E-05: `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusPushGatewayReporterFactory.java`
- E-06: `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusPushGatewayReporterOptions.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### AbstractPrometheusReporter関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | replaceInvalidChars: 有効な文字のみの場合そのまま返却される | E-01 (L69-74: UNALLOWED_CHAR_PATTERNで[^a-zA-Z0-9:_]を置換) | ○ |
| C-02 | replaceInvalidChars: 無効な文字がアンダースコアに置換される | E-01 (L69-74: replaceAll("_")で置換) | ○ |
| C-03 | replaceInvalidChars: 空文字列の場合空文字列が返却される | E-01 (L69-74: 正規表現置換は空文字でも動作) | ○ |
| C-04 | replaceInvalidChars: コロンは有効文字として保持される | E-01 (L58: パターン[^a-zA-Z0-9:_]にコロン含まれず) | ○ |
| C-05 | open: filterLabelValueCharactersがtrueの場合フィルタリング有効 | E-01 (L81-90: デフォルトでCHARACTER_FILTERを使用) | ○ |
| C-06 | open: filterLabelValueCharactersがfalseの場合フィルタリング無効 | E-01 (L87-89: falseの場合input->inputのラムダ設定) | ○ |
| C-07 | close: レジストリがクリアされる | E-01 (L93-95: registry.clear()呼び出し) | ○ |
| C-08 | notifyOfAddedMetric: Gaugeメトリクス登録 | E-01 (L156-165: GAUGE caseでio.prometheus.client.Gauge作成) | ○ |
| C-09 | notifyOfAddedMetric: Counterメトリクス登録 | E-01 (L156-165: COUNTER caseでGauge作成) | ○ |
| C-10 | notifyOfAddedMetric: Meterメトリクス登録 | E-01 (L156-165: METER caseでGauge作成) | ○ |
| C-11 | notifyOfAddedMetric: Histogramメトリクス登録 | E-01 (L167-175: HISTOGRAM caseでHistogramSummaryProxy作成) | ○ |
| C-12 | notifyOfAddedMetric: 同名メトリクスでカウントインクリメント | E-01 (L117-139: count+1でマップに再登録) | ○ |
| C-13 | notifyOfAddedMetric: ディメンションキーのフィルタリング | E-01 (L105-106: CHARACTER_FILTER.filterCharacters呼び出し) | ○ |
| C-14 | notifyOfAddedMetric: ディメンション値のフィルタリング | E-01 (L107: labelValueCharactersFilter.filterCharacters呼び出し) | ○ |
| C-15 | notifyOfAddedMetric: レジストリ登録エラー時の警告ログ | E-01 (L132-134: catch(Exception)でlog.warn) | ○ |
| C-16 | notifyOfRemovedMetric: Gaugeメトリクス削除 | E-01 (L210-213: GAUGEのremove呼び出し) | ○ |
| C-17 | notifyOfRemovedMetric: Counterメトリクス削除 | E-01 (L214-216: COUNTERのremove呼び出し) | ○ |
| C-18 | notifyOfRemovedMetric: 最後のメトリクス削除時のコレクター登録解除 | E-01 (L248-254: count==1でregistry.unregister) | ○ |
| C-19 | notifyOfRemovedMetric: 複数インスタンス時のカウントデクリメント | E-01 (L256-258: count-1でマップに再登録) | ○ |
| C-20 | notifyOfRemovedMetric: 登録解除エラー時の警告ログ | E-01 (L250-253: catch(Exception)でlog.warn) | ○ |
| C-21 | gaugeFrom(Gauge): Double型の値が正しく返却 | E-01 (L278-280: instanceof Doubleチェック) | ○ |
| C-22 | gaugeFrom(Gauge): Integer型がdoubleに変換 | E-01 (L281-283: instanceof NumberでdoubleValue()) | ○ |
| C-23 | gaugeFrom(Gauge): Long型がdoubleに変換 | E-01 (L281-283: instanceof NumberでdoubleValue()) | ○ |
| C-24 | gaugeFrom(Gauge): Boolean trueで1返却 | E-01 (L284-286: instanceof Booleanで三項演算子) | ○ |
| C-25 | gaugeFrom(Gauge): Boolean falseで0返却 | E-01 (L284-286: instanceof Booleanで三項演算子) | ○ |
| C-26 | gaugeFrom(Gauge): null値で0返却とデバッグログ | E-01 (L274-277: value==nullでlog.debugと0返却) | ○ |
| C-27 | gaugeFrom(Gauge): サポートされない型で0返却 | E-01 (L287-292: デフォルトでlog.debugと0返却) | ○ |

### HistogramSummaryProxy関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | HistogramSummaryProxy constructor初期化 | E-01 (L324-334: コンストラクタでmetricName等設定, histogramsByLabelValues.put) | ○ |
| C-29 | collect: MetricFamilySamplesリスト返却 | E-01 (L337-352: collect()でサンプル収集しMetricFamilySamples作成) | ○ |
| C-30 | collect: quantileサンプル生成 | E-01 (L316: QUANTILES定義, L373-379: quantileごとにサンプル追加) | ○ |
| C-31 | collect: countサンプル生成 | E-01 (L366-371: metricName+"_count"サンプル追加) | ○ |
| C-32 | collect: 空ヒストグラム処理 | E-01 (L343-349: histogramsByLabelValues.entrySet()イテレート、空なら空リスト) | ○ |
| C-33 | addChild: 子ヒストグラム追加 | E-01 (L354-356: histogramsByLabelValues.put) | ○ |
| C-34 | remove: ヒストグラム削除 | E-01 (L358-360: histogramsByLabelValues.remove) | ○ |
| C-35 | remove: 存在しないラベル値削除 | E-01 (L358-360: HashMap.removeは存在しなくてもエラーなし) | ○ |

### PrometheusReporter関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | constructor: 有効ポートでHTTPサーバー起動 | E-02 (L47-65: ポートイテレートしHTTPServer作成、log.info) | ○ |
| C-37 | constructor: ポート範囲から起動 | E-02 (L48-58: portsIterator.hasNextでループ、IOException catchで次ポート) | ○ |
| C-38 | constructor: 全ポート使用中でRuntimeException | E-02 (L60-64: httpServer==nullでRuntimeException throw) | ○ |
| C-39 | getPort: 起動後にポート番号取得 | E-02 (L41-45: portフィールド返却) | ○ |
| C-40 | getPort: サーバー未起動時IllegalStateException | E-02 (L43: Preconditions.checkState) | ○ |
| C-41 | close: HTTPサーバー停止 | E-02 (L68-71: httpServer.stop()呼び出し) | ○ |
| C-42 | close: 親クラスclose呼び出し | E-02 (L73: super.close()) | ○ |
| C-43 | close: null HTTPサーバーでエラーなし | E-02 (L69: httpServer!=nullチェック) | ○ |

### PrometheusReporterFactory関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | createMetricReporter: デフォルトポートでレポーター作成 | E-03 (L30: DEFAULT_PORT="9249", L35: getString(ARG_PORT, DEFAULT_PORT)) | ○ |
| C-45 | createMetricReporter: 指定ポートでレポーター作成 | E-03 (L35: metricConfig.getString(ARG_PORT, ...)) | ○ |
| C-46 | createMetricReporter: ポート範囲解釈 | E-03 (L36: new PortRange(portsConfig)) | ○ |

### PrometheusPushGatewayReporter関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | constructor: PushGatewayレポーター初期化 | E-04 (L46-56: フィールド設定、PushGateway作成) | ○ |
| C-48 | constructor: null jobNameでNullPointerException | E-04 (L53: Preconditions.checkNotNull(jobName)) | ○ |
| C-49 | constructor: null groupingKeyでNullPointerException | E-04 (L54: Preconditions.checkNotNull(groupingKey)) | ○ |
| C-50 | report: メトリクスPushGatewayにプッシュ | E-04 (L59-68: pushGateway.push呼び出し) | ○ |
| C-51 | report: プッシュ失敗時警告ログ | E-04 (L62-68: catch(Exception)でlog.warn) | ○ |
| C-52 | close: deleteOnShutdown=trueでメトリクス削除 | E-04 (L72-76: deleteOnShutdownチェック後pushGateway.delete) | ○ |
| C-53 | close: deleteOnShutdown=falseでメトリクス保持 | E-04 (L73: deleteOnShutdown条件分岐) | ○ |
| C-54 | close: メトリクス削除失敗時警告ログ | E-04 (L76-82: catch(IOException)でlog.warn) | ○ |
| C-55 | close: 親クラスclose呼び出し | E-04 (L84: super.close()) | ○ |

### PrometheusPushGatewayReporterFactory関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | createMetricReporter: デフォルト設定でレポーター作成 | E-05 (L49-87: MetricConfigから各設定取得、デフォルト値使用) | ○ |
| C-57 | createMetricReporter: randomJobNameSuffix=trueでランダムサフィックス | E-05 (L69-71: randomSuffixでAbstractID付与) | ○ |
| C-58 | createMetricReporter: randomJobNameSuffix=falseでサフィックスなし | E-05 (L68-71: randomSuffix条件分岐) | ○ |
| C-59 | createMetricReporter: groupingKey設定 | E-05 (L58-60: parseGroupingKey呼び出し) | ○ |
| C-60 | createMetricReporter: hostUrl空でIllegalArgumentException | E-05 (L64-66: StringUtils.isNullOrWhitespaceOnlyチェック) | ○ |
| C-61 | createMetricReporter: hostUrl nullでIllegalArgumentException | E-05 (L64-66: StringUtils.isNullOrWhitespaceOnlyチェック) | ○ |
| C-62 | createMetricReporter: 不正URLでRuntimeException | E-05 (L84-86: MalformedURLException catchでRuntimeException throw) | ○ |
| C-63 | parseGroupingKey: 有効なgroupingKeyパース | E-05 (L90-118: セミコロン分割、イコール分割でMap作成) | ○ |
| C-64 | parseGroupingKey: 単一ペアパース | E-05 (L93-111: kvsループで各エントリ処理) | ○ |
| C-65 | parseGroupingKey: 空文字列で空Map返却 | E-05 (L91, L117: groupingKeyConfig.isEmpty()チェック) | ○ |
| C-66 | parseGroupingKey: =なしエントリ無視と警告ログ | E-05 (L96-99: idx<0でlog.warnとcontinue) | ○ |
| C-67 | parseGroupingKey: 空キーで無視と警告ログ | E-05 (L103-110: isNullOrWhitespaceOnlyでlog.warnとcontinue) | ○ |
| C-68 | parseGroupingKey: 空値で無視と警告ログ | E-05 (L103-110: isNullOrWhitespaceOnlyでlog.warnとcontinue) | ○ |
| C-69 | parseGroupingKey: 混合入力で有効エントリのみパース | E-05 (L93-111: 各エントリ個別処理、無効はcontinue) | ○ |

### PrometheusPushGatewayReporterOptions関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | HOST_URL: デフォルト値なし | E-06 (L35-40: noDefaultValue()) | ○ |
| C-71 | JOB_NAME: デフォルト値空文字列 | E-06 (L42-46: defaultValue("")) | ○ |
| C-72 | RANDOM_JOB_NAME_SUFFIX: デフォルト値true | E-06 (L48-53: defaultValue(true)) | ○ |
| C-73 | DELETE_ON_SHUTDOWN: デフォルト値true | E-06 (L55-67: defaultValue(true)) | ○ |
| C-74 | FILTER_LABEL_VALUE_CHARACTER: デフォルト値true | E-06 (L69-84: defaultValue(true)) | ○ |
| C-75 | GROUPING_KEY: デフォルト値空文字列 | E-06 (L86-100: defaultValue("")) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースはソースコードの実装に基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード根拠あり
- 0: 低リスク - PrometheusReporter/PushGatewayReporterは外部依存(io.prometheus.client)があるため、モック化が必要な可能性あり
- 1: 中リスク - HTTPServerやPushGateway接続のテストは統合テスト的な側面があり、ユニットテストの範囲を超える可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractPrometheusReporterのreplaceInvalidCharsが正規表現パターン[^a-zA-Z0-9:_]に基づくことを確認
- [ ] HistogramSummaryProxyのQUANTILES定数(0.5, 0.75, 0.95, 0.98, 0.99, 0.999)が正しいことを確認
- [ ] PrometheusReporterのコンストラクタでポート競合時のフォールバック動作を確認
- [ ] PrometheusPushGatewayReporterのdeleteOnShutdownフラグの動作を確認
- [ ] parseGroupingKeyの区切り文字(セミコロン、イコール)が仕様と一致することを確認
- [ ] 外部ライブラリ(io.prometheus.client)のモック戦略を検討
