---
generated_at: 2026-02-02 18:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 107
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：flink-models.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：107 / 110、根拠なし：3
- 優先レビュー（高）
  1. **UT-MOD-108**: baseUrlがnullの場合の挙動 - SDK内部実装依存
  2. **UT-MOD-109**: apiKeyがnullの場合の挙動 - SDK内部実装依存
  3. **UT-MOD-110**: 並行性テスト - synchronizedブロックで推定されるが実際の動作確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/ContextOverflowAction.java`
- E-02: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIUtils.java`
- E-03: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/AbstractOpenAIModelFunction.java`
- E-04: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIOptions.java`
- E-05: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIEmbeddingModelFunction.java`
- E-06: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIModelProviderFactory.java`
- E-07: `flink-models/flink-model-openai/src/main/java/org/apache/flink/model/openai/OpenAIChatModelFunction.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ContextOverflowAction.initializeEncodingForContextLimit: 有効なモデル名でエンコーディング初期化 | E-01 (L130-146) | ○ |
| C-02 | ContextOverflowAction.initializeEncodingForContextLimit: maxContextSizeがnullの場合早期リターン | E-01 (L131-133) | ○ |
| C-03 | ContextOverflowAction.initializeEncodingForContextLimit: 不正モデル名で例外 | E-01 (L142-145) | ○ |
| C-04 | ContextOverflowAction.processTokensWithLimit: maxContextSizeがnullで入力そのまま | E-01 (L158-159) | ○ |
| C-05 | ContextOverflowAction.processTokensWithLimit: トークン数制限内で入力そのまま | E-01 (L164-166) | ○ |
| C-06 | TRUNCATED_TAIL.processTokensWithLimitInternal: 末尾切り詰め | E-01 (L46-50) | ○ |
| C-07 | TRUNCATED_HEAD.processTokensWithLimitInternal: 先頭切り詰め | E-01 (L68-73) | ○ |
| C-08 | SKIPPED.processTokensWithLimitInternal: nullを返す | E-01 (L91-96) | ○ |
| C-09 | ContextOverflowAction.getDescription: InlineElement返却 | E-01 (L174-177) | ○ |
| C-10 | ContextOverflowAction.toString: value文字列返却 | E-01 (L179-182) | ○ |
| C-11 | ContextOverflowAction.getAllValuesAndDescriptions: 全アクション一覧 | E-01 (L184-197) | ○ |
| C-12 | HeadTrimmedIntArrayList.get: オフセット適用 | E-01 (L220-222) | ○ |
| C-13 | HeadTrimmedIntArrayList.size: オフセット考慮サイズ | E-01 (L235-237) | ○ |
| C-14 | HeadTrimmedIntArrayList.isEmpty: 空判定true | E-01 (L239-242) | ○ |
| C-15 | HeadTrimmedIntArrayList.isEmpty: 空判定false | E-01 (L239-242) | ○ |
| C-16 | HeadTrimmedIntArrayList.toArray: オフセット適用配列 | E-01 (L244-247) | ○ |
| C-17 | HeadTrimmedIntArrayList.equals: 同一内容でtrue | E-01 (L254-261) | ○ |
| C-18 | HeadTrimmedIntArrayList.equals: 異なる型でfalse | E-01 (L255-257) | ○ |
| C-19 | HeadTrimmedIntArrayList.hashCode: 同一hashCode | E-01 (L263-266) | ○ |
| C-20 | OpenAIUtils.createAsyncClient: 新規クライアント作成 | E-02 (L42-62) | ○ |
| C-21 | OpenAIUtils.createAsyncClient: 既存クライアント再利用 | E-02 (L45-50) | ○ |
| C-22 | OpenAIUtils.createAsyncClient: 参照カウントインクリメント | E-02 (L48) | ○ |
| C-23 | OpenAIUtils.releaseAsyncClient: 参照カウントデクリメント | E-02 (L64-77) | ○ |
| C-24 | OpenAIUtils.releaseAsyncClient: カウント0でクローズ | E-02 (L71-75) | ○ |
| C-25 | OpenAIUtils.releaseAsyncClient: 存在しないクライアントでエラー | E-02 (L68-69) | ○ |
| C-26 | ReferenceKey.equals: 同一baseUrl/apiKeyでtrue | E-02 (L104-108) | ○ |
| C-27 | ReferenceKey.equals: 異なるbaseUrlでfalse | E-02 (L104-108) | ○ |
| C-28 | ReferenceKey.hashCode: 同一hashCode | E-02 (L98-101) | ○ |
| C-29 | AbstractOpenAIModelFunction.コンストラクタ: 設定値読み込み | E-03 (L79-102) | ○ |
| C-30 | AbstractOpenAIModelFunction.コンストラクタ: エンドポイントサフィックス除去 | E-03 (L82) | ○ |
| C-31 | AbstractOpenAIModelFunction.open: クライアント初期化 | E-03 (L104-110) | ○ |
| C-32 | AbstractOpenAIModelFunction.close: クライアントリリース | E-03 (L129-137) | ○ |
| C-33 | AbstractOpenAIModelFunction.close: clientがnullで何もしない | E-03 (L132) | ○ |
| C-34 | AbstractOpenAIModelFunction.asyncPredict: null入力で空リスト | E-03 (L113-117) | ○ |
| C-35 | AbstractOpenAIModelFunction.asyncPredict: スキップ時空リスト | E-03 (L122-124) | ○ |
| C-36 | AbstractOpenAIModelFunction.validateSingleColumnSchema: 単一カラム検証成功 | E-03 (L143-167) | ○ |
| C-37 | AbstractOpenAIModelFunction.validateSingleColumnSchema: 複数カラムエラー | E-03 (L151-156) | ○ |
| C-38 | AbstractOpenAIModelFunction.validateSingleColumnSchema: 型不一致エラー | E-03 (L159-167) | ○ |
| C-39 | AbstractOpenAIModelFunction.validateSingleColumnSchema: メタデータカラム検証成功 | E-03 (L169-194) | ○ |
| C-40 | AbstractOpenAIModelFunction.validateSingleColumnSchema: 不正メタデータカラムエラー | E-03 (L180-185) | ○ |
| C-41 | AbstractOpenAIModelFunction.handleErrorsAndRespond: FAILOVER例外 | E-03 (L203-204) | ○ |
| C-42 | AbstractOpenAIModelFunction.handleErrorsAndRespond: IGNOREメタデータ付き | E-03 (L205-219) | ○ |
| C-43 | AbstractOpenAIModelFunction.handleErrorsAndRespond: IGNOREメタデータなし空リスト | E-03 (L219) | ○ |
| C-44 | AbstractOpenAIModelFunction.handleErrorsAndRespond: RETRYフォールバック | E-03 (L198-201) | ○ |
| C-45 | ErrorHandlingStrategy.getDescription: InlineElement返却 | E-03 (L239-242) | ○ |
| C-46 | RetryFallbackStrategy.getDescription: InlineElement返却 | E-03 (L258-261) | ○ |
| C-47 | ErrorMessageMetadata.get: 有効キーでメタデータ | E-03 (L322-329) | ○ |
| C-48 | ErrorMessageMetadata.get: 無効キーでnull | E-03 (L327) | ○ |
| C-49 | ErrorMessageMetadata.getAllKeysAndDescriptions: 一覧取得 | E-03 (L331-335) | ○ |
| C-50 | ErrorMessageMetadata.ERROR_STRING.converter: エラーメッセージ抽出 | E-03 (L272) | ○ |
| C-51 | ErrorMessageMetadata.HTTP_STATUS_CODE.converter: ステータスコード抽出 | E-03 (L277-280) | ○ |
| C-52 | ErrorMessageMetadata.HTTP_STATUS_CODE.converter: 非OpenAI例外でnull | E-03 (L280) | ○ |
| C-53 | ErrorMessageMetadata.HTTP_HEADERS_MAP.converter: ヘッダーマップ抽出 | E-03 (L284-303) | ○ |
| C-54 | OpenAIOptions.ENDPOINT: デフォルト値なし | E-04 (L37-47) | ○ |
| C-55 | OpenAIOptions.API_KEY: デフォルト値なし | E-04 (L50-54) | ○ |
| C-56 | OpenAIOptions.MODEL: デフォルト値なし | E-04 (L57-66) | ○ |
| C-57 | OpenAIOptions.RETRY_NUM: デフォルト値100 | E-04 (L97-101) | ○ |
| C-58 | OpenAIOptions.SYSTEM_PROMPT: デフォルト値あり | E-04 (L119-124) | ○ |
| C-59 | OpenAIOptions.ERROR_HANDLING_STRATEGY: RETRYデフォルト | E-04 (L87-92) | ○ |
| C-60 | OpenAIOptions.CONTEXT_OVERFLOW_ACTION: TRUNCATED_TAILデフォルト | E-04 (L77-84) | ○ |
| C-61 | OpenAIEmbeddingModelFunction.コンストラクタ: 設定読み込み | E-05 (L49-60) | ○ |
| C-62 | OpenAIEmbeddingModelFunction.コンストラクタ: 出力スキーマ検証 | E-05 (L55-58) | ○ |
| C-63 | OpenAIEmbeddingModelFunction.getEndpointSuffix: embeddings返却 | E-05 (L76-79) | ○ |
| C-64 | OpenAIEmbeddingModelFunction.getOutputColumnIndex: インデックス取得 | E-05 (L62-74) | ○ |
| C-65 | OpenAIEmbeddingModelFunction.getOutputColumnIndex: 物理カラムなしエラー | E-05 (L71-73) | ○ |
| C-66 | OpenAIEmbeddingModelFunction.asyncPredictInternal: dimensions未設定 | E-05 (L87-89) | ○ |
| C-67 | OpenAIEmbeddingModelFunction.asyncPredictInternal: dimensions設定 | E-05 (L87-89) | ○ |
| C-68 | OpenAIEmbeddingModelFunction.convertToRowData: 正常レスポンス変換 | E-05 (L94-114) | ○ |
| C-69 | OpenAIEmbeddingModelFunction.convertToRowData: 例外時エラーハンドリング | E-05 (L96-98) | ○ |
| C-70 | OpenAIModelProviderFactory.factoryIdentifier: openai返却 | E-06 (L54-56) | ○ |
| C-71 | OpenAIModelProviderFactory.requiredOptions: 必須オプションセット | E-06 (L58-65) | ○ |
| C-72 | OpenAIModelProviderFactory.optionalOptions: オプショナルセット | E-06 (L67-86) | ○ |
| C-73 | OpenAIModelProviderFactory.createModelProvider: embeddings分岐 | E-06 (L43-44) | ○ |
| C-74 | OpenAIModelProviderFactory.createModelProvider: chat/completions分岐 | E-06 (L45-46) | ○ |
| C-75 | OpenAIModelProviderFactory.createModelProvider: 不正エンドポイント例外 | E-06 (L47-48) | ○ |
| C-76 | OpenAIModelProviderFactory.createModelProvider: 末尾スラッシュ除去 | E-06 (L40) | ○ |
| C-77 | Provider.createAsyncPredictFunction: function返却 | E-06 (L96-99) | ○ |
| C-78 | Provider.copy: 新Providerインスタンス | E-06 (L101-104) | ○ |
| C-79 | OpenAIChatModelFunction.コンストラクタ: 設定読み込み | E-07 (L53-64) | ○ |
| C-80 | OpenAIChatModelFunction.コンストラクタ: 出力スキーマ検証 | E-07 (L59-62) | ○ |
| C-81 | OpenAIChatModelFunction.getEndpointSuffix: chat/completions返却 | E-07 (L80-83) | ○ |
| C-82 | OpenAIChatModelFunction.getOutputColumnIndex: インデックス取得 | E-07 (L66-78) | ○ |
| C-83 | OpenAIChatModelFunction.asyncPredictInternal: 基本パラメータ | E-07 (L86-91) | ○ |
| C-84 | OpenAIChatModelFunction.asyncPredictInternal: temperature設定 | E-07 (L92) | ○ |
| C-85 | OpenAIChatModelFunction.asyncPredictInternal: topP設定 | E-07 (L93) | ○ |
| C-86 | OpenAIChatModelFunction.asyncPredictInternal: stop設定カンマ区切り | E-07 (L94-96) | ○ |
| C-87 | OpenAIChatModelFunction.asyncPredictInternal: maxTokens設定 | E-07 (L97) | ○ |
| C-88 | OpenAIChatModelFunction.asyncPredictInternal: presencePenalty設定 | E-07 (L98) | ○ |
| C-89 | OpenAIChatModelFunction.asyncPredictInternal: n設定 | E-07 (L99) | ○ |
| C-90 | OpenAIChatModelFunction.asyncPredictInternal: seed設定 | E-07 (L100) | ○ |
| C-91 | OpenAIChatModelFunction.asyncPredictInternal: responseFormat設定 | E-07 (L101-103) | ○ |
| C-92 | OpenAIChatModelFunction.convertToRowData: 正常レスポンス変換 | E-07 (L108-126) | ○ |
| C-93 | OpenAIChatModelFunction.convertToRowData: 複数choices | E-07 (L114-125) | ○ |
| C-94 | OpenAIChatModelFunction.convertToRowData: contentがemptyで空文字 | E-07 (L122) | ○ |
| C-95 | OpenAIChatModelFunction.convertToRowData: 例外時エラーハンドリング | E-07 (L110-112) | ○ |
| C-96 | ChatModelResponseFormat.TEXT.getResponseFormat: TEXT形式 | E-07 (L133-137) | ○ |
| C-97 | ChatModelResponseFormat.JSON_OBJECT.getResponseFormat: JSON形式 | E-07 (L139-143) | ○ |
| C-98 | ChatModelResponseFormat.toString: value文字列 | E-07 (L154-157) | ○ |
| C-99 | ContextOverflowAction.processTokensWithLimit: maxContextSize=0境界値 | E-01 (L164-166) | ○ |
| C-100 | ContextOverflowAction.processTokensWithLimit: 空文字入力境界値 | E-01 (L163) | ○ |
| C-101 | ContextOverflowAction.processTokensWithLimit: ちょうど制限値境界値 | E-01 (L164) | ○ |
| C-102 | HeadTrimmedIntArrayList.clear: サイズ0 | E-01 (L209-212) | ○ |
| C-103 | HeadTrimmedIntArrayList.add: 要素追加 | E-01 (L214-217) | ○ |
| C-104 | HeadTrimmedIntArrayList.set: 要素更新 | E-01 (L224-227) | ○ |
| C-105 | HeadTrimmedIntArrayList.ensureCapacity: 容量確保 | E-01 (L229-232) | ○ |
| C-106 | HeadTrimmedIntArrayList.boxed: オフセット適用リスト | E-01 (L249-252) | ○ |
| C-107 | OpenAIUtils.createAsyncClient: numRetry=0境界値 | E-02 (L57) | ○ |
| C-108 | OpenAIUtils.createAsyncClient: baseUrl=null | **根拠なし** | △ |
| C-109 | OpenAIUtils.createAsyncClient: apiKey=null | **根拠なし** | △ |
| C-110 | OpenAIUtils.createAsyncClient: 並行性テスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-108, C-109: OpenAIOkHttpClientAsync.builderの内部実装に依存。nullパラメータ時の挙動はSDKのドキュメントまたはソースコードを確認する必要がある
  - 候補：OpenAI Java SDKドキュメント / OpenAIOkHttpClientAsyncソースコード
- C-110: synchronizedブロックによりスレッドセーフ性が期待されるが、実際の並行テストは統合テストで確認が必要
  - 候補：並行テストフレームワーク（JUnit5 @RepeatedTest + ExecutorService）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ConfigOption定義、enum定義、getter/setter系（UT-MOD-054〜060, UT-MOD-009〜011等）
- 1: 中リスク - 内部クラスHeadTrimmedIntArrayListの動作（UT-MOD-012〜019等）
- 2: 高リスク - 外部API連携・リソース管理（UT-MOD-020〜025, UT-MOD-031〜035）- 実際のOpenAI APIとの統合テストが推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] OpenAIUtils.createAsyncClientのnullパラメータ時の挙動をSDKドキュメントで確認
- [ ] 参照カウント管理の並行性が実環境で問題ないか確認
- [ ] ContextOverflowActionの各アクションがトークン境界で正しく動作するか確認
- [ ] ErrorMessageMetadata.HTTP_HEADERS_MAPのヘッダー変換が正しいか確認
- [ ] OpenAIChatModelFunctionのstopオプションのカンマ区切り処理がエッジケースで正しいか確認（例：カンマを含む文字列）
