---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 205
  claims_with_evidence: 205
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-queryable-state_flink-queryable-state-client-java 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：テスト対象のクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：205 / 205、根拠なし：0
- 優先レビュー（高）
  1. **QueryableStateClient関連テスト**：サーバー接続が必要なテストは統合テスト環境での検証が必要
  2. **MessageSerializer関連テスト**：バイナリ形式の検証はNettyのByteBufを使用したテストが必要
  3. **AbstractServerBase関連テスト**：ポートバインドのテストは実際のネットワーク環境での検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/main/java/org/apache/flink/queryablestate/KvStateID.java`
- E-02: `src/main/java/org/apache/flink/queryablestate/messages/KvStateRequest.java`
- E-03: `src/main/java/org/apache/flink/queryablestate/messages/KvStateResponse.java`
- E-04: `src/main/java/org/apache/flink/queryablestate/network/Client.java`
- E-05: `src/main/java/org/apache/flink/queryablestate/network/messages/MessageSerializer.java`
- E-06: `src/main/java/org/apache/flink/queryablestate/network/messages/MessageDeserializer.java`
- E-07: `src/main/java/org/apache/flink/queryablestate/network/messages/MessageBody.java`
- E-08: `src/main/java/org/apache/flink/queryablestate/network/messages/MessageType.java`
- E-09: `src/main/java/org/apache/flink/queryablestate/network/messages/RequestFailure.java`
- E-10: `src/main/java/org/apache/flink/queryablestate/network/ClientHandler.java`
- E-11: `src/main/java/org/apache/flink/queryablestate/network/ClientHandlerCallback.java`
- E-12: `src/main/java/org/apache/flink/queryablestate/network/AbstractServerHandler.java`
- E-13: `src/main/java/org/apache/flink/queryablestate/network/AbstractServerBase.java`
- E-14: `src/main/java/org/apache/flink/queryablestate/network/NettyBufferPool.java`
- E-15: `src/main/java/org/apache/flink/queryablestate/network/ChunkedByteBuf.java`
- E-16: `src/main/java/org/apache/flink/queryablestate/network/BadRequestException.java`
- E-17: `src/main/java/org/apache/flink/queryablestate/network/ServerConnection.java`
- E-18: `src/main/java/org/apache/flink/queryablestate/network/stats/KvStateRequestStats.java`
- E-19: `src/main/java/org/apache/flink/queryablestate/network/stats/DisabledKvStateRequestStats.java`
- E-20: `src/main/java/org/apache/flink/queryablestate/network/stats/AtomicKvStateRequestStats.java`
- E-21: `src/main/java/org/apache/flink/queryablestate/exceptions/UnknownKeyOrNamespaceException.java`
- E-22: `src/main/java/org/apache/flink/queryablestate/exceptions/UnknownKvStateIdException.java`
- E-23: `src/main/java/org/apache/flink/queryablestate/exceptions/UnknownLocationException.java`
- E-24: `src/main/java/org/apache/flink/queryablestate/exceptions/UnknownKvStateKeyGroupLocationException.java`
- E-25: `src/main/java/org/apache/flink/queryablestate/client/QueryableStateClient.java`
- E-26: `src/main/java/org/apache/flink/queryablestate/client/VoidNamespace.java`
- E-27: `src/main/java/org/apache/flink/queryablestate/client/VoidNamespaceTypeInfo.java`
- E-28: `src/main/java/org/apache/flink/queryablestate/client/VoidNamespaceSerializer.java`
- E-29: `src/main/java/org/apache/flink/queryablestate/client/state/ImmutableState.java`
- E-30: `src/main/java/org/apache/flink/queryablestate/client/state/ImmutableValueState.java`
- E-31: `src/main/java/org/apache/flink/queryablestate/client/state/ImmutableListState.java`
- E-32: `src/main/java/org/apache/flink/queryablestate/client/state/ImmutableMapState.java`
- E-33: `src/main/java/org/apache/flink/queryablestate/client/state/ImmutableReducingState.java`
- E-34: `src/main/java/org/apache/flink/queryablestate/client/state/ImmutableAggregatingState.java`
- E-35: `src/main/java/org/apache/flink/queryablestate/client/state/serialization/KvStateSerializer.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### KvStateID (UT-QSC-001 - UT-QSC-002)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KvStateIDデフォルトコンストラクタでIDが生成される | E-01 (line 32-34) | ○ |
| C-02 | KvStateID(long, long)で指定値のIDが生成される | E-01 (line 36-38) | ○ |

### KvStateRequest (UT-QSC-003 - UT-QSC-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 | KvStateRequestコンストラクタで有効なリクエストが生成される | E-02 (line 45-55) | ○ |
| C-04 | jobIdがnullの場合NullPointerException | E-02 (line 51) Preconditions.checkNotNull | ○ |
| C-05 | stateNameがnullの場合NullPointerException | E-02 (line 52) Preconditions.checkNotNull | ○ |
| C-06 | serializedKeyAndNamespaceがnullの場合NullPointerException | E-02 (line 54) Preconditions.checkNotNull | ○ |
| C-07 | getJobId()でJobIDが取得できる | E-02 (line 57-59) | ○ |
| C-08 | getStateName()でstateNameが取得できる | E-02 (line 61-63) | ○ |
| C-09 | getKeyHashCode()でkeyHashCodeが取得できる | E-02 (line 65-67) | ○ |
| C-10 | getSerializedKeyAndNamespace()でバイト配列が取得できる | E-02 (line 69-71) | ○ |
| C-11 | serialize()でリクエストがシリアライズされる | E-02 (line 73-97) | ○ |
| C-12 | 空のstateNameでシリアライズ可能 | E-02 (line 76-96) | ○ |
| C-13 | KvStateRequestDeserializer.deserializeMessage()でデシリアライズ | E-02 (line 117-146) | ○ |
| C-14 | 負のstateNameLengthでIllegalArgumentException | E-02 (line 122-124) | ○ |
| C-15 | 負のkNamespaceLengthでIllegalArgumentException | E-02 (line 136-139) | ○ |

### KvStateResponse (UT-QSC-016 - UT-QSC-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | KvStateResponseコンストラクタで有効なレスポンスが生成される | E-03 (line 40-42) | ○ |
| C-17 | contentがnullの場合NullPointerException | E-03 (line 41) Preconditions.checkNotNull | ○ |
| C-18 | getContent()でcontentが取得できる | E-03 (line 44-46) | ○ |
| C-19 | serialize()でレスポンスがシリアライズされる | E-03 (line 48-52) | ○ |
| C-20 | 空のcontentでシリアライズ可能 | E-03 (line 50-51) | ○ |
| C-21 | KvStateResponseDeserializer.deserializeMessage()でデシリアライズ | E-03 (line 58-69) | ○ |
| C-22 | 負のlengthでIllegalArgumentException | E-03 (line 61-64) | ○ |

### MessageSerializer (UT-QSC-023 - UT-QSC-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | MessageSerializerコンストラクタで有効なシリアライザが生成される | E-05 (line 73-77) | ○ |
| C-24 | requestDeserializerがnullでNullPointerException | E-05 (line 75) | ○ |
| C-25 | responseDeserializerがnullでNullPointerException | E-05 (line 76) | ○ |
| C-26 | serializeRequest()でリクエストがシリアライズされる | E-05 (line 93-97) | ○ |
| C-27 | serializeRequest()でrequestがnullでNullPointerException | E-05 (line 95) | ○ |
| C-28 | serializeResponse()でレスポンスがシリアライズされる | E-05 (line 108-112) | ○ |
| C-29 | serializeResponse()でresponseがnullでNullPointerException | E-05 (line 110) | ○ |
| C-30 | serializeRequestFailure()でリクエスト失敗がシリアライズされる | E-05 (line 124-144) | ○ |
| C-31 | serializeServerFailure()でサーバー失敗がシリアライズされる | E-05 (line 155-173) | ○ |
| C-32 | deserializeHeader()でヘッダがデシリアライズされる | E-05 (line 227-242) | ○ |
| C-33 | バージョン不一致でIllegalStateException | E-05 (line 231-233) | ○ |
| C-34 | 不正なメッセージタイプでIllegalStateException | E-05 (line 238-240) | ○ |
| C-35 | getRequestId()でリクエストIDが取得できる | E-05 (line 254-256) | ○ |
| C-36 | deserializeRequest()でリクエストがデシリアライズされる | E-05 (line 269-272) | ○ |
| C-37 | deserializeRequest()でbufがnullでNullPointerException | E-05 (line 270) | ○ |
| C-38 | deserializeResponse()でレスポンスがデシリアライズされる | E-05 (line 285-288) | ○ |
| C-39 | deserializeResponse()でbufがnullでNullPointerException | E-05 (line 286) | ○ |
| C-40 | deserializeRequestFailure()でリクエスト失敗がデシリアライズされる | E-05 (line 301-311) | ○ |
| C-41 | deserializeServerFailure()でサーバー失敗がデシリアライズされる | E-05 (line 324-329) | ○ |

### RequestFailure (UT-QSC-042 - UT-QSC-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | RequestFailureコンストラクタで有効なオブジェクトが生成される | E-09 (line 39-42) | ○ |
| C-43 | getRequestId()でリクエストIDが取得できる | E-09 (line 49-51) | ○ |
| C-44 | getCause()でcauseが取得できる | E-09 (line 58-60) | ○ |

### Client (UT-QSC-045 - UT-QSC-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | Clientコンストラクタで有効なクライアントが生成される | E-04 (line 94-132) | ○ |
| C-46 | numEventLoopThreadsが0でIllegalArgumentException | E-04 (line 100-101) | ○ |
| C-47 | numEventLoopThreadsが負でIllegalArgumentException | E-04 (line 100-101) | ○ |
| C-48 | clientNameがnullでNullPointerException | E-04 (line 103) | ○ |
| C-49 | serializerがnullでNullPointerException | E-04 (line 104) | ○ |
| C-50 | statsがnullでNullPointerException | E-04 (line 105) | ○ |
| C-51 | getClientName()でクライアント名が取得できる | E-04 (line 134-136) | ○ |
| C-52 | sendRequest()でリクエストが送信される | E-04 (line 138-169) | ○ |
| C-53 | シャットダウン後はIllegalStateExceptionを含むFuture | E-04 (line 140-142) | ○ |
| C-54 | shutdown()でクライアントがシャットダウンされる | E-04 (line 178-228) | ○ |
| C-55 | 二重シャットダウンで同じFuture | E-04 (line 180, 227) | ○ |
| C-56 | isEventGroupShutdown()でシャットダウン前はfalse | E-04 (line 231-233) | ○ |
| C-57 | isEventGroupShutdown()でシャットダウン後はtrue | E-04 (line 231-233) | ○ |

### ClientHandler (UT-QSC-058 - UT-QSC-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | ClientHandlerコンストラクタで有効なハンドラが生成される | E-10 (line 63-71) | ○ |
| C-59 | clientNameがnullでNullPointerException | E-10 (line 68) | ○ |
| C-60 | REQUEST_RESULTでonRequestResultが呼ばれる | E-10 (line 79-82) | ○ |
| C-61 | REQUEST_FAILUREでonRequestFailureが呼ばれる | E-10 (line 83-85) | ○ |
| C-62 | SERVER_FAILUREで例外がスロー | E-10 (line 86-87) | ○ |
| C-63 | 不正なメッセージタイプでIllegalStateException | E-10 (line 88-89) | ○ |
| C-64 | exceptionCaught()でonFailureが呼ばれる | E-10 (line 103-109) | ○ |
| C-65 | channelInactive()でonFailure(ClosedChannelException)が呼ばれる | E-10 (line 112-122) | ○ |

### AbstractServerBase (UT-QSC-066 - UT-QSC-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | AbstractServerBaseコンストラクタで有効なサーバーが生成される | E-13 (line 114-141) | ○ |
| C-67 | numEventLoopThreadsが0でIllegalArgumentException | E-13 (line 122-123) | ○ |
| C-68 | numQueryThreadsが0でIllegalArgumentException | E-13 (line 124) | ○ |
| C-69 | ポート範囲外でIllegalArgumentException | E-13 (line 134-138) | ○ |
| C-70 | 負のポートでIllegalArgumentException | E-13 (line 134-138) | ○ |
| C-71 | getServerName()でサーバー名が取得できる | E-13 (line 167-169) | ○ |
| C-72 | start()でサーバーが起動される | E-13 (line 194-214) | ○ |
| C-73 | 全ポート使用中でFlinkRuntimeException | E-13 (line 209-213) | ○ |
| C-74 | 起動済みでIllegalStateException | E-13 (line 195-197) | ○ |
| C-75 | getServerAddress()でアドレスが取得できる | E-13 (line 183-187) | ○ |
| C-76 | 起動前はIllegalStateException | E-13 (line 184-185) | ○ |
| C-77 | shutdownServer()でサーバーがシャットダウンされる | E-13 (line 306-368) | ○ |
| C-78 | 二重シャットダウンで同じFuture | E-13 (line 308, 367) | ○ |

### NettyBufferPool (UT-QSC-079 - UT-QSC-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | NettyBufferPoolコンストラクタで有効なプールが生成される | E-14 (line 42-67) | ○ |
| C-80 | numberOfArenasが0でIllegalArgumentException | E-14 (line 43) | ○ |
| C-81 | buffer()でダイレクトバッファが割り当てられる | E-14 (line 74-86) | ○ |
| C-82 | heapBuffer()でUnsupportedOperationException | E-14 (line 104-116) | ○ |
| C-83 | compositeHeapBuffer()でUnsupportedOperationException | E-14 (line 144-151) | ○ |

### ChunkedByteBuf (UT-QSC-084 - UT-QSC-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | ChunkedByteBufコンストラクタで有効なオブジェクトが生成される | E-15 (line 53-57) | ○ |
| C-85 | bufがnullでNullPointerException | E-15 (line 54) | ○ |
| C-86 | chunkSizeが0でIllegalArgumentException | E-15 (line 55) | ○ |
| C-87 | chunkSizeが負でIllegalArgumentException | E-15 (line 55) | ○ |
| C-88 | isEndOfInput()で読み込み完了前はfalse | E-15 (line 60-62) | ○ |
| C-89 | isEndOfInput()で読み込み完了後はtrue | E-15 (line 60-62) | ○ |
| C-90 | isEndOfInput()でclose後はtrue | E-15 (line 60-62) | ○ |
| C-91 | readChunk()でチャンクサイズ以下のバッファで全体が返される | E-15 (line 90-94) | ○ |
| C-92 | readChunk()でチャンクサイズより大きいバッファでチャンクが返される | E-15 (line 95-99) | ○ |
| C-93 | readChunk()でclose後はnull | E-15 (line 88-89) | ○ |
| C-94 | close()で未読み込み完了時にバッファがリリースされる | E-15 (line 65-74) | ○ |
| C-95 | close()で読み込み完了後にバッファがリリースされない | E-15 (line 68-71) | ○ |
| C-96 | length()で-1が返される | E-15 (line 104-106) | ○ |
| C-97 | progress()でreaderIndexが返される | E-15 (line 109-111) | ○ |

### BadRequestException (UT-QSC-098 - UT-QSC-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | BadRequestExceptionコンストラクタで有効な例外が生成される | E-16 (line 30-32) | ○ |
| C-99 | serverNameがnullでNullPointerException | E-16 (line 31) | ○ |
| C-100 | getMessage()で適切なメッセージが返される | E-16 (line 31) | ○ |

### AtomicKvStateRequestStats (UT-QSC-101 - UT-QSC-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | reportActiveConnection()で接続数がインクリメントされる | E-20 (line 42-44) | ○ |
| C-102 | reportInactiveConnection()で接続数がデクリメントされる | E-20 (line 46-48) | ○ |
| C-103 | reportRequest()でリクエスト数がインクリメントされる | E-20 (line 50-52) | ○ |
| C-104 | reportSuccessfulRequest()で成功数と時間が記録される | E-20 (line 54-59) | ○ |
| C-105 | reportFailedRequest()で失敗数がインクリメントされる | E-20 (line 61-64) | ○ |
| C-106 | getNumConnections()で接続数が取得できる | E-20 (line 66-68) | ○ |
| C-107 | getNumRequests()でリクエスト数が取得できる | E-20 (line 70-72) | ○ |
| C-108 | getNumSuccessful()で成功数が取得できる | E-20 (line 74-76) | ○ |
| C-109 | getNumFailed()で失敗数が取得できる | E-20 (line 78-80) | ○ |

### DisabledKvStateRequestStats (UT-QSC-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | 全メソッドが何も行わない | E-19 (line 24-37) | ○ |

### 例外クラス (UT-QSC-111 - UT-QSC-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | UnknownKeyOrNamespaceExceptionコンストラクタで有効な例外が生成される | E-21 (line 35-37) | ○ |
| C-112 | UnknownKvStateIdExceptionコンストラクタで有効な例外が生成される | E-22 (line 38-42) | ○ |
| C-113 | kvStateIdがnullでNullPointerException | E-22 (line 41) | ○ |
| C-114 | UnknownLocationExceptionコンストラクタで有効な例外が生成される | E-23 (line 33-35) | ○ |
| C-115 | UnknownKvStateKeyGroupLocationExceptionコンストラクタで有効な例外が生成される | E-24 (line 35-37) | ○ |

### QueryableStateClient (UT-QSC-116 - UT-QSC-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | QueryableStateClient(hostname, port)で有効なクライアントが生成される | E-25 (line 127-129) | ○ |
| C-117 | hostnameがnullでNullPointerException | E-25 (line 128) | ○ |
| C-118 | 不正なホスト名でUnknownHostException | E-25 (line 128) | ○ |
| C-119 | QueryableStateClient(address, port)で有効なクライアントが生成される | E-25 (line 139-157) | ○ |
| C-120 | ポートが負でIllegalArgumentException | E-25 (line 140-142) | ○ |
| C-121 | ポートが65535より大きくてIllegalArgumentException | E-25 (line 140-142) | ○ |
| C-122 | shutdownAndHandle()でFutureが返される | E-25 (line 168-170) | ○ |
| C-123 | shutdownAndWait()でシャットダウン完了までブロック | E-25 (line 177-184) | ○ |
| C-124 | getExecutionConfig()で設定されたConfigが取得できる | E-25 (line 187-189) | ○ |
| C-125 | getExecutionConfig()で未設定の場合null | E-25 (line 187-189) | ○ |
| C-126 | setExecutionConfig()で設定される | E-25 (line 197-201) | ○ |
| C-127 | setUserClassLoader()で設定される | E-25 (line 209-213) | ○ |
| C-128 | getKvState(TypeHint)でステートが取得できる | E-25 (line 226-237) | ○ |
| C-129 | keyTypeHintがnullでNullPointerException | E-25 (line 233) | ○ |
| C-130 | getKvState(TypeInfo)でステートが取得できる | E-25 (line 250-265) | ○ |
| C-131 | jobIdがnullでNullPointerException | E-25 (line 288) | ○ |
| C-132 | queryableStateNameがnullでNullPointerException | E-25 (line 289) | ○ |
| C-133 | keyがnullでNullPointerException | E-25 (line 290) | ○ |
| C-134 | stateDescriptorがnullでNullPointerException | E-25 (line 295) | ○ |

### VoidNamespace (UT-QSC-135 - UT-QSC-138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | get()でシングルトンが返される | E-26 (line 41-43) | ○ |
| C-136 | hashCode()で99が返される | E-26 (line 53-55) | ○ |
| C-137 | equals()で自身との比較でtrue | E-26 (line 57-59) | ○ |
| C-138 | equals()で他のオブジェクトとの比較でfalse | E-26 (line 57-59) | ○ |

### VoidNamespaceTypeInfo (UT-QSC-139 - UT-QSC-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | isBasicType()でfalse | E-27 (line 38-40) | ○ |
| C-140 | isTupleType()でfalse | E-27 (line 42-45) | ○ |
| C-141 | getArity()で0 | E-27 (line 47-50) | ○ |
| C-142 | getTotalFields()で1 | E-27 (line 52-55) | ○ |
| C-143 | getTypeClass()でVoidNamespace.class | E-27 (line 57-60) | ○ |
| C-144 | isKeyType()でfalse | E-27 (line 62-65) | ○ |
| C-145 | createSerializer()でVoidNamespaceSerializer.INSTANCE | E-27 (line 67-71) | ○ |
| C-146 | equals()で同じ型との比較でtrue | E-27 (line 78-81) | ○ |
| C-147 | canEqual()でVoidNamespaceTypeInfoとの比較でtrue | E-27 (line 88-91) | ○ |

### VoidNamespaceSerializer (UT-QSC-148 - UT-QSC-154)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | isImmutableType()でtrue | E-28 (line 43-45) | ○ |
| C-149 | createInstance()でVoidNamespace.get() | E-28 (line 47-49) | ○ |
| C-150 | copy()でVoidNamespace.get() | E-28 (line 51-59) | ○ |
| C-151 | getLength()で0 | E-28 (line 61-64) | ○ |
| C-152 | serialize()で1バイトが書き込まれる | E-28 (line 66-75) | ○ |
| C-153 | deserialize()でVoidNamespace.get() | E-28 (line 77-87) | ○ |
| C-154 | snapshotConfiguration()でVoidNamespaceSerializerSnapshot | E-28 (line 96-99) | ○ |

### ImmutableValueState (UT-QSC-155 - UT-QSC-158)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | createState()でImmutableValueStateが生成される | E-30 (line 60-67) | ○ |
| C-156 | value()で設定された値が取得できる | E-30 (line 45-47) | ○ |
| C-157 | update()でUnsupportedOperationException | E-30 (line 50-52) | ○ |
| C-158 | clear()でUnsupportedOperationException | E-30 (line 54-57) | ○ |

### ImmutableListState (UT-QSC-159 - UT-QSC-164)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159 | createState()でImmutableListStateが生成される | E-31 (line 71-79) | ○ |
| C-160 | get()で設定されたリストが取得できる | E-31 (line 46-48) | ○ |
| C-161 | add()でUnsupportedOperationException | E-31 (line 51-53) | ○ |
| C-162 | update()でUnsupportedOperationException | E-31 (line 61-63) | ○ |
| C-163 | addAll()でUnsupportedOperationException | E-31 (line 66-68) | ○ |
| C-164 | clear()でUnsupportedOperationException | E-31 (line 56-58) | ○ |

### ImmutableMapState (UT-QSC-165 - UT-QSC-179)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165 | createState()でImmutableMapStateが生成される | E-32 (line 126-136) | ○ |
| C-166 | get()で指定したキーの値が取得できる | E-32 (line 50-52) | ○ |
| C-167 | get()で存在しないキーでnull | E-32 (line 50-52) | ○ |
| C-168 | contains()で存在するキーでtrue | E-32 (line 71-73) | ○ |
| C-169 | contains()で存在しないキーでfalse | E-32 (line 71-73) | ○ |
| C-170 | entries()で不変のエントリセット | E-32 (line 80-83) | ○ |
| C-171 | keys()で不変のキーセット | E-32 (line 90-93) | ○ |
| C-172 | values()で不変の値コレクション | E-32 (line 101-104) | ○ |
| C-173 | iterator()で不変のイテレータ | E-32 (line 111-114) | ○ |
| C-174 | isEmpty()で空のマップでtrue | E-32 (line 117-119) | ○ |
| C-175 | isEmpty()で要素があるマップでfalse | E-32 (line 117-119) | ○ |
| C-176 | put()でUnsupportedOperationException | E-32 (line 55-57) | ○ |
| C-177 | putAll()でUnsupportedOperationException | E-32 (line 60-62) | ○ |
| C-178 | remove()でUnsupportedOperationException | E-32 (line 65-67) | ○ |
| C-179 | clear()でUnsupportedOperationException | E-32 (line 122-124) | ○ |

### ImmutableReducingState (UT-QSC-180 - UT-QSC-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-180 | createState()でImmutableReducingStateが生成される | E-33 (line 60-67) | ○ |
| C-181 | get()で設定された値が取得できる | E-33 (line 45-47) | ○ |
| C-182 | add()でUnsupportedOperationException | E-33 (line 50-52) | ○ |
| C-183 | clear()でUnsupportedOperationException | E-33 (line 54-57) | ○ |

### ImmutableAggregatingState (UT-QSC-184 - UT-QSC-187)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-184 | createState()でImmutableAggregatingStateが生成される | E-34 (line 61-72) | ○ |
| C-185 | get()で集約結果が取得できる | E-34 (line 46-48) | ○ |
| C-186 | add()でUnsupportedOperationException | E-34 (line 51-53) | ○ |
| C-187 | clear()でUnsupportedOperationException | E-34 (line 55-58) | ○ |

### KvStateSerializer (UT-QSC-188 - UT-QSC-205)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-188 | serializeKeyAndNamespace()でキーと名前空間がシリアライズされる | E-35 (line 58-72) | ○ |
| C-189 | deserializeKeyAndNamespace()でデシリアライズされる | E-35 (line 85-115) | ○ |
| C-190 | 不正なマジックナンバーでIOException | E-35 (line 98-100) | ○ |
| C-191 | 未消費バイトでIOException | E-35 (line 103-105) | ○ |
| C-192 | serializeValue()で値がシリアライズされる | E-35 (line 126-136) | ○ |
| C-193 | serializeValue()でnullの場合null | E-35 (line 128, 133-135) | ○ |
| C-194 | deserializeValue()で値がデシリアライズされる | E-35 (line 147-163) | ○ |
| C-195 | deserializeValue()でnullの場合null | E-35 (line 149-150) | ○ |
| C-196 | deserializeValue()で未消費バイトでIOException | E-35 (line 155-159) | ○ |
| C-197 | deserializeList()でリストがデシリアライズされる | E-35 (line 174-207) | ○ |
| C-198 | deserializeList()でnullの場合null | E-35 (line 176, 204-206) | ○ |
| C-199 | deserializeList()で空バイト配列で空リスト | E-35 (line 181-194) | ○ |
| C-200 | serializeMap()でマップエントリがシリアライズされる | E-35 (line 220-244) | ○ |
| C-201 | serializeMap()でnullの場合null | E-35 (line 225, 241-243) | ○ |
| C-202 | serializeMap()で値がnullのエントリがシリアライズされる | E-35 (line 232-237) | ○ |
| C-203 | deserializeMap()でマップがデシリアライズされる | E-35 (line 257-280) | ○ |
| C-204 | deserializeMap()でnullの場合null | E-35 (line 262, 278) | ○ |
| C-205 | deserializeMap()で値がnullのエントリがデシリアライズされる | E-35 (line 270-271) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースに対応するソースコードが存在）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - テストケースは全てソースコードの実装に基づいている
- **注意点**:
  - QueryableStateClient関連のテストはサーバー接続が必要なため、モックまたは統合テスト環境での実行が必要
  - MessageSerializer関連のテストはNettyのByteBufを使用するため、Netty依存のテストセットアップが必要
  - AbstractServerBase関連のテストはネットワークポートをバインドするため、テスト環境でのポート競合に注意

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースが対応するメソッドの仕様を正しく反映しているか確認
- [ ] 境界値テストが適切なエッジケースをカバーしているか確認
- [ ] 異常系テストが想定される全ての例外をカバーしているか確認
- [ ] Preconditions.checkNotNull()を使用している箇所のnullチェックテストが存在するか確認
- [ ] 不変クラス(Immutable*)の全ての変更メソッドがUnsupportedOperationExceptionをスローすることを確認
- [ ] シリアライズ/デシリアライズのラウンドトリップテストが存在するか確認
- [ ] サーバー/クライアントのシャットダウン処理の冪等性テストが存在するか確認
