---
generated_at: 2026-02-02 18:15:00
metrics:
  claims_total: 54
  claims_with_evidence: 54
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-queryable-state_flink-queryable-state-runtime.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：54 / 54、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-queryable-state/flink-queryable-state-runtime/src/main/java/org/apache/flink/queryablestate/messages/KvStateInternalRequest.java`
- E-02: `flink-queryable-state/flink-queryable-state-runtime/src/main/java/org/apache/flink/queryablestate/server/KvStateServerImpl.java`
- E-03: `flink-queryable-state/flink-queryable-state-runtime/src/main/java/org/apache/flink/queryablestate/server/KvStateServerHandler.java`
- E-04: `flink-queryable-state/flink-queryable-state-runtime/src/main/java/org/apache/flink/queryablestate/client/proxy/KvStateClientProxyImpl.java`
- E-05: `flink-queryable-state/flink-queryable-state-runtime/src/main/java/org/apache/flink/queryablestate/client/proxy/KvStateClientProxyHandler.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### KvStateInternalRequest (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタで有効なパラメータでインスタンス生成 | E-01 L42-46: `Preconditions.checkNotNull(stateId)`, `Preconditions.checkNotNull(serializedKeyAndNamespace)` | ○ |
| C-02 | stateIdがnullでNullPointerException | E-01 L44: `Preconditions.checkNotNull(stateId)` | ○ |
| C-03 | serializedKeyAndNamespaceがnullでNullPointerException | E-01 L45: `Preconditions.checkNotNull(serializedKeyAndNamespace)` | ○ |
| C-04 | getKvStateIdでKvStateID取得 | E-01 L48-50: `return kvStateId` | ○ |
| C-05 | getSerializedKeyAndNamespaceでバイト配列取得 | E-01 L52-54: `return serializedKeyAndNamespace` | ○ |
| C-06 | serializeで正しい形式にシリアライズ | E-01 L57-68: ByteBuffer使用のシリアライズ実装 | ○ |
| C-07 | 空のシリアライズデータでも正しくシリアライズ | E-01 L60: `serializedKeyAndNamespace.length` が0でも処理可能 | ○ |
| C-08 | deserializeMessageで正しくデシリアライズ | E-01 L75-88: デシリアライズ実装 | ○ |
| C-09 | 負の長さでIllegalArgumentException | E-01 L79-82: `Preconditions.checkArgument(length >= 0, ...)` | ○ |
| C-10 | 長さ0で空のシリアライズデータ | E-01 L85-87: `if (length > 0)` の条件分岐 | ○ |

### KvStateServerImpl (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | コンストラクタで有効なパラメータでサーバー生成 | E-02 L67-83: コンストラクタ実装 | ○ |
| C-12 | statsがnullでNullPointerException | E-02 L81: `Preconditions.checkNotNull(stats)` | ○ |
| C-13 | kvStateRegistryがnullでNullPointerException | E-02 L82: `Preconditions.checkNotNull(kvStateRegistry)` | ○ |
| C-14 | initializeHandlerでハンドラ初期化 | E-02 L86-92: `return new KvStateServerHandler(...)` | ○ |
| C-15 | getSerializerでサーバー起動後にシリアライザ取得 | E-02 L94-98: シリアライザ返却実装 | ○ |
| C-16 | getSerializerでサーバー未起動時にIllegalStateException | E-02 L95-96: `Preconditions.checkState(serializer != null, ...)` | ○ |
| C-17 | startでサーバー起動 | E-02 L101-103: `super.start()` | ○ |
| C-18 | getServerAddressでアドレス取得 | E-02 L106-108: `return super.getServerAddress()` | ○ |
| C-19 | shutdownでサーバー停止 | E-02 L111-118: `shutdownServer().get(10L, TimeUnit.SECONDS)` | ○ |
| C-20 | シャットダウンタイムアウト時にログ出力 | E-02 L115-117: `catch (Exception e) { log.warn(...) }` | ○ |

### KvStateServerHandler (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コンストラクタで有効なパラメータでハンドラ生成 | E-03 L66-74: コンストラクタ実装 | ○ |
| C-22 | kvStateRegistryがnullでNullPointerException | E-03 L73: `Preconditions.checkNotNull(kvStateRegistry)` | ○ |
| C-23 | handleRequestで有効なリクエストの処理 | E-03 L77-107: handleRequest実装 | ○ |
| C-24 | 存在しないKvStateIDでUnknownKvStateIdException | E-03 L83-85: `if (kvState == null) { responseFuture.completeExceptionally(new UnknownKvStateIdException(...)) }` | ○ |
| C-25 | キー/名前空間不一致でUnknownKeyOrNamespaceException | E-03 L92-95: `if (serializedResult == null) { responseFuture.completeExceptionally(new UnknownKeyOrNamespaceException(...)) }` | ○ |
| C-26 | 処理中例外でRuntimeException | E-03 L98-105: `catch (Throwable t) { responseFuture.completeExceptionally(new RuntimeException(errMsg)) }` | ○ |
| C-27 | shutdownで完了済みCompletableFuture返却 | E-03 L129-131: `return CompletableFuture.completedFuture(null)` | ○ |

### KvStateClientProxyImpl (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | コンストラクタで有効なパラメータでプロキシ生成 | E-04 L71-89: コンストラクタ実装 | ○ |
| C-29 | numQueryThreadsが0以下でIllegalArgumentException | E-04 L84: `Preconditions.checkArgument(numQueryThreads >= 1, ...)` | ○ |
| C-30 | statsがnullでNullPointerException | E-04 L86: `Preconditions.checkNotNull(stats)` | ○ |
| C-31 | getServerAddressでアドレス取得 | E-04 L92-94: `return super.getServerAddress()` | ○ |
| C-32 | startでプロキシ起動 | E-04 L97-99: `super.start()` | ○ |
| C-33 | shutdownでプロキシ停止 | E-04 L102-109: `shutdownServer().get(10L, TimeUnit.SECONDS)` | ○ |
| C-34 | updateKvStateLocationOracleでオラクル登録 | E-04 L112-118: `kvStateLocationOracles.put(jobId, kvStateLocationOracle)` | ○ |
| C-35 | updateKvStateLocationOracleでnullオラクルで削除 | E-04 L114-115: `if (kvStateLocationOracle == null) { kvStateLocationOracles.remove(jobId) }` | ○ |
| C-36 | getKvStateLocationOracleでオラクル取得 | E-04 L123-134: getKvStateLocationOracle実装 | ○ |
| C-37 | デフォルトJobIDのオラクル優先 | E-04 L124-130: `if (legacyKvStateLocationOracle != null) { return legacyKvStateLocationOracle }` | ○ |
| C-38 | 未登録JobIDでnull返却 | E-04 L132: `return kvStateLocationOracles.get(jobId)` (ConcurrentHashMapはキー不存在でnull) | ○ |
| C-39 | initializeHandlerでハンドラ初期化 | E-04 L137-143: `return new KvStateClientProxyHandler(...)` | ○ |

### KvStateClientProxyHandler (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | コンストラクタで有効なパラメータでハンドラ生成 | E-05 L92-101: コンストラクタ実装 | ○ |
| C-41 | proxyがnullでNullPointerException | E-05 L99: `Preconditions.checkNotNull(proxy)` | ○ |
| C-42 | handleRequestで有効なリクエストの処理 | E-05 L118-123: handleRequest実装 | ○ |
| C-43 | キャッシュされた位置情報の再利用 | E-05 L209-216: `if (!forceUpdate && cachedFuture != null && !cachedFuture.isCompletedExceptionally()) { return cachedFuture }` | ○ |
| C-44 | UnknownKvStateIdExceptionでリトライ | E-05 L135-147: `if (throwable.getCause() instanceof UnknownKvStateIdException ... executeActionAsync(result, request, true)` | ○ |
| C-45 | UnknownKvStateKeyGroupLocationExceptionでリトライ | E-05 L136-137: `throwable.getCause() instanceof UnknownKvStateKeyGroupLocationException` | ○ |
| C-46 | ConnectExceptionでリトライ | E-05 L138: `throwable.getCause() instanceof ConnectException` | ○ |
| C-47 | その他の例外でリトライなし | E-05 L148-149: `else { result.completeExceptionally(throwable) }` | ○ |
| C-48 | オラクルから位置情報取得 | E-05 L219-245: オラクルへのリクエスト実装 | ○ |
| C-49 | forceUpdateでキャッシュ更新 | E-05 L211: `!forceUpdate` の条件チェック | ○ |
| C-50 | オラクル未登録でUnknownLocationException | E-05 L246-254: `if (kvStateLocationOracle != null) { ... } else { return FutureUtils.completedExceptionally(new UnknownLocationException(...)) }` | ○ |
| C-51 | FlinkJobNotFoundExceptionでキャッシュ削除 | E-05 L233-238: `if (... instanceof FlinkJobNotFoundException) { lookupCache.remove(cacheKey) }` | ○ |
| C-52 | 状態サーバーから値取得 | E-05 L161-192: getState実装 | ○ |
| C-53 | サーバーアドレスnullでUnknownKvStateKeyGroupLocationException | E-05 L175-178: `if (serverAddress == null) { return FutureUtils.completedExceptionally(new UnknownKvStateKeyGroupLocationException(...)) }` | ○ |
| C-54 | shutdownで内部クライアントシャットダウン | E-05 L258-260: `return kvStateClient.shutdown()` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコードからの明確な根拠があります。
- 本モジュールは分散状態クエリ処理に関わるため、以下の点に注意：
  - ネットワーク関連のエラー処理（リトライロジック）
  - キャッシュの一貫性
  - 並行アクセス（ConcurrentHashMap使用）

## 6) レビュアーチェックリスト（最小）
- [ ] KvStateInternalRequestのシリアライズ/デシリアライズがラウンドトリップで正しく動作するか確認
- [ ] KvStateServerImplのライフサイクル（起動→シャットダウン）が正しいか確認
- [ ] KvStateServerHandlerの例外処理が網羅的か確認
- [ ] KvStateClientProxyImplのオラクル管理（登録/削除/取得）が正しいか確認
- [ ] KvStateClientProxyHandlerのリトライロジック（3種類の例外）が適切か確認
- [ ] キャッシュのforceUpdate動作が期待通りか確認
- [ ] FlinkJobNotFoundException時のキャッシュクリア動作を確認
