---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 161
  claims_with_evidence: 161
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: flink-rpc_flink-rpc-akka 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：161 / 161、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースがソースコードを根拠としている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoRpcService.java`
- E-02: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoRpcActor.java`
- E-03: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoInvocationHandler.java`
- E-04: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/FencedPekkoRpcActor.java`
- E-05: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/FencedPekkoInvocationHandler.java`
- E-06: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoUtils.java`
- E-07: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/RpcSerializedValue.java`
- E-08: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/SupervisorActor.java`
- E-09: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoRpcServiceConfiguration.java`
- E-10: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/ActorSystemBootstrapTools.java`
- E-11: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/RobustActorSystem.java`
- E-12: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoRpcServiceUtils.java`
- E-13: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoRpcSystem.java`
- E-14: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/concurrent/pekko/ScalaFutureUtils.java`
- E-15: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/concurrent/pekko/ActorSystemScheduledExecutorAdapter.java`
- E-16: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/HostAndPort.java`
- E-17: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/DeadLettersActor.java`
- E-18: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/EscalatingSupervisorStrategy.java`
- E-19: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PrioritySettingThreadFactory.java`
- E-20: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PriorityThreadsDispatcher.java`
- E-21: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/RemoteAddressExtension.java`
- E-22: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/PekkoBasedEndpoint.java`
- E-23: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/ControlMessages.java`
- E-24: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/CustomSSLEngineProvider.java`
- E-25: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/exceptions/RpcInvalidStateException.java`
- E-26: `flink-rpc/flink-rpc-akka/src/main/java/org/apache/flink/runtime/rpc/pekko/exceptions/UnknownMessageException.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### PekkoRpcService（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタで有効なパラメータでインスタンス生成 | E-01 L116-160 | ○ |
| C-02 | コンストラクタでactorSystemがnullの場合にNPE | E-01 L125 checkNotNull | ○ |
| C-03 | コンストラクタでconfigurationがnullの場合にNPE | E-01 L126 checkNotNull | ○ |
| C-04 | getAddressでホスト設定時にアドレス返却 | E-01 L131-135 | ○ |
| C-05 | getAddressでホスト未設定時に空文字 | E-01 L133-134 | ○ |
| C-06 | getPortでポート設定時に番号返却 | E-01 L137-141 | ○ |
| C-07 | getPortでポート未設定時に-1 | E-01 L139-140 | ○ |
| C-08 | connectで有効アドレスでゲートウェイ取得 | E-01 L214-235 | ○ |
| C-09 | connectで存在しないアドレスでRpcConnectionException | E-01 L546-560 resolveActorAddress | ○ |
| C-10 | connect(fenced)でフェンシングトークン付き接続 | E-01 L238-259 | ○ |
| C-11 | startServerでRpcServerが開始 | E-01 L262-337 | ○ |
| C-12 | startServerでnull引数でNPE | E-01 L264 checkNotNull | ○ |
| C-13 | startServerでサービス停止時にIllegalStateException | E-01 L350 checkState | ○ |
| C-14 | stopServerでサーバー停止 | E-01 L383-405 | ○ |
| C-15 | stopServerで停止済みでも例外なし | E-01 L390-391 | ○ |
| C-16 | closeAsyncでサービス終了 | E-01 L407-441 | ○ |
| C-17 | closeAsyncで既に停止時に同じfuture | E-01 L412-414 | ○ |
| C-18 | getSelfGatewayで実装済みインターフェースでゲートウェイ | E-01 L199-211 | ○ |
| C-19 | getSelfGatewayで未実装時にClassCastException | E-01 L206-209 | ○ |

### PekkoRpcActor（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | コンストラクタで有効パラメータでインスタンス生成 | E-02 L113-139 | ○ |
| C-21 | maximumFramesize<=0でIllegalArgumentException | E-02 L123 checkArgument | ○ |
| C-22 | STARTでStartedState遷移 | E-02 L196-198 | ○ |
| C-23 | STOPでStoppedState遷移 | E-02 L199-200 | ○ |
| C-24 | TERMINATEでTerminatingState遷移 | E-02 L201-203 | ○ |
| C-25 | 実行中でメッセージ正常処理 | E-02 L168-191 | ○ |
| C-26 | 停止中でEndpointNotStartedException | E-02 L178-189 | ○ |
| C-27 | ハンドシェイク成功 | E-02 L260-262 | ○ |
| C-28 | バージョン不一致でHandshakeException | E-02 L248-253 | ○ |
| C-29 | 未サポートゲートウェイでHandshakeException | E-02 L254-259 | ○ |
| C-30 | RPC呼び出し正常実行 | E-02 L285-347 | ○ |
| C-31 | 存在しないメソッドでRpcConnectionException | E-02 L293-299 | ○ |
| C-32 | Void戻り値で応答なし | E-02 L307-311 | ○ |
| C-33 | CompletableFuture戻り値で非同期 | E-02 L334-336 | ○ |
| C-34 | 結果サイズ超過でRpcException | E-02 L408-417 | ○ |
| C-35 | 即時実行Runnable正常実行 | E-02 L457-464 | ○ |
| C-36 | 遅延実行Runnableスケジュール | E-02 L465-482 | ○ |
| C-37 | Callable正常実行 | E-02 L435-444 | ○ |
| C-38 | Callable例外でFailure返却 | E-02 L442-443 | ○ |
| C-39 | postStop成功時にterminationFuture完了 | E-02 L145-147 | ○ |
| C-40 | postStop失敗時に例外完了 | E-02 L148-154 | ○ |

### PekkoInvocationHandler（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | コンストラクタでインスタンス生成 | E-03 L101-122 | ○ |
| C-42 | invokeでRPC呼び出し | E-03 L144-146 | ○ |
| C-43 | Objectメソッドがローカル処理 | E-03 L131-136 | ○ |
| C-44 | FencedRpcGatewayでUnsupportedOperationException | E-03 L137-143 | ○ |
| C-45 | runAsyncでローカル送信 | E-03 L157-175 | ○ |
| C-46 | runAsyncでリモートでRuntimeException | E-03 L169-174 | ○ |
| C-47 | scheduleRunAsyncでスケジュール | E-03 L162-175 | ○ |
| C-48 | scheduleRunAsyncで負delay時にIllegalArgumentException | E-03 L164 checkArgument | ○ |
| C-49 | callAsyncでローカル送信 | E-03 L178-191 | ○ |
| C-50 | callAsyncでリモートでRuntimeException | E-03 L185-190 | ○ |
| C-51 | startでSTARTメッセージ送信 | E-03 L194-196 | ○ |
| C-52 | stopでSTOPメッセージ送信 | E-03 L199-201 | ○ |
| C-53 | resolveTimeoutExceptionで非AskTimeoutをそのまま返却 | E-03 L383-385 | ○ |
| C-54 | 受信者終了でRecipientUnreachableException | E-03 L389-392 | ○ |
| C-55 | 通常タイムアウトでTimeoutException | E-03 L393-403 | ○ |

### FencedPekkoRpcActor（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | トークン一致でメッセージ処理 | E-04 L87-88 | ○ |
| C-57 | トークン不一致でFencingTokenException | E-04 L89-108 | ○ |
| C-58 | トークンnullでFencingTokenException | E-04 L69-81 | ○ |
| C-59 | 非FencedMessageでUnknownMessageException | E-04 L110-127 | ○ |
| C-60 | envelopeSelfMessageでLocalFencedMessageラップ | E-04 L131-135 | ○ |

### FencedPekkoInvocationHandler（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | getFencingTokenで取得 | E-05 L99-101 | ○ |
| C-62 | tellでローカルLocalFencedMessage | E-05 L104-105 | ○ |
| C-63 | tellでリモートRemoteFencedMessage | E-05 L106-115 | ○ |
| C-64 | 非SerializableでRuntimeException | E-05 L116-121 | ○ |

### PekkoUtils（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | getFlinkActorSystemNameで'flink' | E-06 L61-65 | ○ |
| C-66 | createLocalActorSystemで作成 | E-06 L420-422 | ○ |
| C-67 | createActorSystemで指定名作成 | E-06 L441-445 | ○ |
| C-68 | getAddressでアドレス取得 | E-06 L543-545 | ○ |
| C-69 | getRpcURLでURL取得 | E-06 L555-558 | ○ |
| C-70 | getAddressFromRpcURLでAddress抽出 | E-06 L569-571 | ○ |
| C-71 | 無効URLでMalformedURLException | E-06 L568-569 | ○ |
| C-72 | getInetSocketAddressFromRpcURLでアドレス取得 | E-06 L583-596 | ○ |
| C-73 | ローカルURLでException | E-06 L590-595 | ○ |
| C-74 | terminateActorSystemで終了 | E-06 L604-607 | ○ |
| C-75 | getConfigでローカル設定 | E-06 L477-485 | ○ |
| C-76 | getConfigでリモート設定 | E-06 L500-534 | ○ |
| C-77 | getThreadPoolExecutorConfigでスレッドプール設定 | E-06 L134-155 | ○ |
| C-78 | getForkJoinExecutorConfigでForkJoin設定 | E-06 L157-177 | ○ |

### RpcSerializedValue（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | valueOfでシリアライズ | E-07 L65-68 | ○ |
| C-80 | nullでnullデータインスタンス | E-07 L66 | ○ |
| C-81 | 非SerializableでIOException | E-07 L66 InstantiationUtil.serializeObject | ○ |
| C-82 | deserializeValueでデシリアライズ | E-07 L51-56 | ○ |
| C-83 | serializedData nullでnull返却 | E-07 L53-54 | ○ |
| C-84 | ClassLoader nullでNPE | E-07 L52 checkNotNull | ○ |
| C-85 | getSerializedDataLengthで長さ | E-07 L46-48 | ○ |
| C-86 | serializedData nullで0 | E-07 L47 | ○ |
| C-87 | equalsで等価 | E-07 L71-77 | ○ |
| C-88 | equalsで非等価 | E-07 L74 Arrays.equals | ○ |

### SupervisorActor（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | startSupervisorActorで開始 | E-08 L190-196 | ○ |
| C-90 | startRpcActorでRpcActor開始 | E-08 L198-207 | ○ |
| C-91 | Actor作成失敗でエラーレスポンス | E-08 L131-133 | ○ |
| C-92 | postStopで全Actor終了処理 | E-08 L78-89 | ○ |
| C-93 | 不明メッセージでUnknownMessageException | E-08 L178-184 | ○ |
| C-94 | ActorRegistration.createで登録作成 | E-08 L370-373 | ○ |
| C-95 | StartRpcActorResponse.successで成功レスポンス | E-08 L396-398 | ○ |
| C-96 | StartRpcActorResponse.failureで失敗レスポンス | E-08 L400-402 | ○ |

### PekkoRpcServiceConfiguration（E-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | fromConfigurationで設定読み込み | E-09 L79-95 | ○ |
| C-98 | maximumFramesize<=0でIllegalArgumentException | E-09 L49 checkArgument | ○ |
| C-99 | defaultConfigurationでデフォルト | E-09 L97-99 | ○ |
| C-100 | getTimeoutでタイムアウト取得 | E-09 L62-65 | ○ |
| C-101 | getMaximumFramesizeでフレームサイズ取得 | E-09 L67-69 | ○ |

### ActorSystemBootstrapTools（E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | startRemoteActorSystemでリモート起動 | E-10 L50-67, L87-137 | ○ |
| C-103 | 無効ポート範囲でIllegalArgumentException | E-10 L103-106 | ○ |
| C-104 | 全ポート使用済みでBindException | E-10 L135-136 | ○ |
| C-105 | startLocalActorSystemでローカル起動 | E-10 L219-242 | ○ |
| C-106 | getForkJoinExecutorConfigurationで設定取得 | E-10 L266-275 | ○ |
| C-107 | getRemoteForkJoinExecutorConfigurationで設定取得 | E-10 L277-288 | ○ |

### RobustActorSystem（E-11）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | createでRobustActorSystem作成 | E-11 L53-54 | ○ |
| C-109 | カスタムUncaughtExceptionHandler設定 | E-11 L58-69, L72-104 | ○ |
| C-110 | シャットダウン後ClassNotFoundError無視 | E-11 L122-130 | ○ |
| C-111 | シャットダウン前例外伝播 | E-11 L131 | ○ |

### PekkoRpcServiceUtils（E-12）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | getRpcUrlでURL生成 | E-12 L122-174 | ○ |
| C-113 | hostname nullでNPE | E-12 L160 checkNotNull | ○ |
| C-114 | 無効ポートでIllegalArgumentException | E-12 L162 checkArgument | ○ |
| C-115 | アドレス解決失敗でUnknownHostException | E-12 L164-168 | ○ |
| C-116 | getLocalRpcUrlでローカルURL | E-12 L176-178 | ○ |
| C-117 | isRecipientTerminatedExceptionでtrue | E-12 L180-182 | ○ |
| C-118 | isRecipientTerminatedExceptionでfalse | E-12 L181 | ○ |
| C-119 | extractMaximumFramesizeでサイズ抽出 | E-12 L234-239 | ○ |
| C-120 | createAndStartでサービス作成 | E-12 L325-375 | ○ |
| C-121 | withComponentNameで名前設定 | E-12 L285-288 | ○ |
| C-122 | withBindAddressでアドレス設定 | E-12 L296-299 | ○ |
| C-123 | withBindPortでポート設定 | E-12 L302-306 | ○ |
| C-124 | 無効ポートでIllegalArgumentException | E-12 L303-304 | ○ |

### PekkoRpcSystem（E-13）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | localServiceBuilderでローカルビルダー | E-13 L33-35 | ○ |
| C-126 | remoteServiceBuilderでリモートビルダー | E-13 L38-44 | ○ |
| C-127 | getInetSocketAddressFromRpcUrlでアドレス取得 | E-13 L47-49 | ○ |
| C-128 | getMaximumMessageSizeInBytesでサイズ取得 | E-13 L64-66 | ○ |

### ScalaFutureUtils（E-14）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | toJavaで成功Future変換 | E-14 L37-54 | ○ |
| C-130 | toJavaで失敗Future変換 | E-14 L44-46 | ○ |

### ActorSystemScheduledExecutorAdapter（E-15）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | schedule(Runnable)でスケジュール | E-15 L56-66 | ○ |
| C-132 | schedule(Callable)でスケジュール | E-15 L70-80 | ○ |
| C-133 | scheduleAtFixedRateで固定レート | E-15 L84-103 | ○ |
| C-134 | scheduleWithFixedDelayで固定遅延 | E-15 L107-118 | ○ |
| C-135 | executeで即時実行 | E-15 L121-125 | ○ |

### HostAndPort（E-16）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | コンストラクタで有効パラメータ | E-16 L27-31 | ○ |
| C-137 | host nullでNPE | E-16 L28 checkNotNull | ○ |
| C-138 | 負ポートでIllegalArgumentException | E-16 L29 checkArgument | ○ |

### DeadLettersActor（E-17）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | Messageで送信者存在時にFailure返却 | E-17 L54-62 | ○ |
| C-140 | Messageで送信者なし時にログのみ | E-17 L47-53 | ○ |
| C-141 | 非Message無視 | E-17 L46 if条件 | ○ |
| C-142 | getPropsでProps取得 | E-17 L67-69 | ○ |

### EscalatingSupervisorStrategy（E-18）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | createでOneForOneStrategy作成 | E-18 L30-36 | ○ |
| C-144 | 全例外エスカレート | E-18 L34 | ○ |

### PrioritySettingThreadFactory（E-19）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | newThreadで指定優先度スレッド | E-19 L36-40 | ○ |

### PriorityThreadsDispatcher（E-20）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | コンストラクタで優先度Dispatcher作成 | E-20 L61-66 | ○ |

### RemoteAddressExtension（E-21）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | createExtensionでExtension作成 | E-21 L37-39 | ○ |
| C-148 | getAddressでアドレス取得 | E-21 L50-52 | ○ |

### CustomSSLEngineProvider（E-24）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149 | コンストラクタでSSL設定読み込み | E-24 L49-58 | ○ |
| C-150 | trustManagersでTrustManager取得 | E-24 L61-79 | ○ |
| C-151 | フィンガープリント指定でFingerprintTrustManager | E-24 L64-69 | ○ |
| C-152 | トラストストア読み込み失敗でRemoteTransportException | E-24 L74-78 | ○ |
| C-153 | loadKeystoreでキーストア読み込み | E-24 L83-91 | ○ |
| C-154 | キーストア存在しない場合RemoteTransportException | E-24 L86-89 | ○ |

### 例外クラス（E-25, E-26）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | RpcInvalidStateException(message)で例外作成 | E-25 L27-29 | ○ |
| C-156 | RpcInvalidStateException(cause)で例外作成 | E-25 L31-33 | ○ |
| C-157 | UnknownMessageException(message)で例外作成 | E-26 L31-33 | ○ |
| C-158 | UnknownMessageException(message, cause)で例外作成 | E-26 L35-37 | ○ |

### ControlMessages（E-23）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159 | START定数存在 | E-23 L23 | ○ |
| C-160 | STOP定数存在 | E-23 L24 | ○ |
| C-161 | TERMINATE定数存在 | E-23 L25 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードを根拠として生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] PekkoRpcServiceのconnect/startServer/closeAsyncメソッドのテストケースが実際のユースケースを網羅しているか確認
- [ ] PekkoRpcActorの状態遷移（Stopped/Started/Terminating/Terminated）のテストケースが全パターンをカバーしているか確認
- [ ] FencedPekkoRpcActorのフェンシングトークン検証のテストケースが境界条件を含んでいるか確認
- [ ] RpcSerializedValueのシリアライズ/デシリアライズのテストケースがエッジケースを含んでいるか確認
- [ ] SupervisorActorのActor起動/停止のテストケースがエラーハンドリングを網羅しているか確認
- [ ] SSL/TLS関連（CustomSSLEngineProvider）のテストケースがセキュリティ要件を満たしているか確認
