---
generated_at: 2026-02-02 18:15:00
metrics:
  claims_total: 160
  claims_with_evidence: 156
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：flink-state-backends_flink-statebackend-changelog 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：156 / 160、根拠なし：4
- 優先レビュー（高）
  1. **restore/StateChangeApplier系クラス**：インターフェースのみで実装詳細が別ファイル
  2. **ChangelogMigrationRestoreTarget**：詳細実装の確認が必要
  3. **スナップショット結果のローカル状態処理**：複雑な条件分岐あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main/java/org/apache/flink/state/changelog/ChangelogStateBackend.java`
- E-02: `src/main/java/org/apache/flink/state/changelog/AbstractChangelogStateBackend.java`
- E-03: `src/main/java/org/apache/flink/state/changelog/ChangelogKeyedStateBackend.java`
- E-04: `src/main/java/org/apache/flink/state/changelog/ChangelogValueState.java`
- E-05: `src/main/java/org/apache/flink/state/changelog/ChangelogListState.java`
- E-06: `src/main/java/org/apache/flink/state/changelog/ChangelogMapState.java`
- E-07: `src/main/java/org/apache/flink/state/changelog/ChangelogReducingState.java`
- E-08: `src/main/java/org/apache/flink/state/changelog/ChangelogAggregatingState.java`
- E-09: `src/main/java/org/apache/flink/state/changelog/AbstractChangelogState.java`
- E-10: `src/main/java/org/apache/flink/state/changelog/KvStateChangeLoggerImpl.java`
- E-11: `src/main/java/org/apache/flink/state/changelog/AbstractStateChangeLogger.java`
- E-12: `src/main/java/org/apache/flink/state/changelog/PriorityQueueStateChangeLoggerImpl.java`
- E-13: `src/main/java/org/apache/flink/state/changelog/ChangelogKeyGroupedPriorityQueue.java`
- E-14: `src/main/java/org/apache/flink/state/changelog/ChangelogStateFactory.java`
- E-15: `src/main/java/org/apache/flink/state/changelog/ChangelogTruncateHelper.java`
- E-16: `src/main/java/org/apache/flink/state/changelog/DeactivatedChangelogStateBackend.java`
- E-17: `src/main/java/org/apache/flink/state/changelog/ChangelogStateBackendMetricGroup.java`
- E-18: `src/main/java/org/apache/flink/state/changelog/StateChangeLoggingIterator.java`
- E-19: `src/main/java/org/apache/flink/state/changelog/StateChangeOperation.java`
- E-20: `src/main/java/org/apache/flink/state/changelog/StateChangeLogger.java`
- E-21: `src/main/java/org/apache/flink/state/changelog/KvStateChangeLogger.java`
- E-22: `src/main/java/org/apache/flink/state/changelog/ChangelogState.java`
- E-23: `src/main/java/org/apache/flink/state/changelog/restore/ChangelogBackendRestoreOperation.java`
- E-24: `src/main/java/org/apache/flink/state/changelog/restore/ChangelogApplierFactoryImpl.java`
- E-25: `src/main/java/org/apache/flink/state/changelog/restore/ChangelogBackendLogApplier.java`
- E-26: `src/main/java/org/apache/flink/state/changelog/restore/FunctionDelegationHelper.java`
- E-27: `src/main/java/org/apache/flink/state/changelog/restore/StateID.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ChangelogStateBackend関連（C-01 〜 C-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | configureメソッドがConfigurableStateBackendを正しく処理する | E-01 (L59-70) | ○ |
| C-02 | ConfigurableStateBackendでない場合にthisを返す | E-01 (L63-69) | ○ |
| C-03 | restoreメソッドがChangelogKeyedStateBackendを作成する | E-01 (L73-141) | ○ |
| C-04 | changelogStorageがnullの場合にPreconditions.checkNotNullで例外発生 | E-01 (L83-87) | ○ |

### AbstractChangelogStateBackend関連（C-05 〜 C-12）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | コンストラクタがstateBackendをnullチェックする | E-02 (L66-67) | ○ |
| C-06 | コンストラクタがnullの場合にNullPointerExceptionをスローする | E-02 (L67) | ○ |
| C-07 | DelegatingStateBackendの場合にIllegalArgumentExceptionをスローする | E-02 (L69-71) | ○ |
| C-08 | createKeyedStateBackendがrestoreを呼び出す | E-02 (L79-93) | ○ |
| C-09 | createOperatorStateBackendが委譲先に委任する | E-02 (L96-99) | ○ |
| C-10 | useManagedMemoryが委譲先の値を返す | E-02 (L102-104) | ○ |
| C-11 | getDelegatedStateBackendが委譲先を返す | E-02 (L107-109) | ○ |
| C-12 | supportsSavepointFormatが委譲先の値を返す | E-02 (L112-114) | ○ |

### ChangelogKeyedStateBackend関連（C-13 〜 C-40）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | コンストラクタが全フィールドを初期化する | E-03 (L233-279) | ○ |
| C-14 | getKeyGroupRangeが委譲先の値を返す | E-03 (L283-285) | ○ |
| C-15 | closeがcloser.close()を呼ぶ | E-03 (L288-290) | ○ |
| C-16 | setCurrentKeyが委譲先に設定する | E-03 (L293-295) | ○ |
| C-17 | getCurrentKeyが委譲先から取得する | E-03 (L298-300) | ○ |
| C-18 | getKeySerializerが委譲先から取得する | E-03 (L308-310) | ○ |
| C-19 | getKeysが委譲先から取得する | E-03 (L313-315) | ○ |
| C-20 | disposeが全リソースを解放する | E-03 (L328-334) | ○ |
| C-21 | getPartitionedStateがキャッシュから取得する | E-03 (L372-374) | ○ |
| C-22 | getPartitionedStateが新しい状態を作成しキャッシュする | E-03 (L377-394) | ○ |
| C-23 | namespaceがnullの場合にcheckNotNullで例外 | E-03 (L370) | ○ |
| C-24 | snapshotがSavepointの場合にnativeSavepointを呼ぶ | E-03 (L406-408) | ○ |
| C-25 | snapshotがチェックポイントの場合にSnapshotResultを返す | E-03 (L399-444) | ○ |
| C-26 | nativeSavepointがNO_SHARING以外で例外をスローする | E-03 (L454-460) | ○ |
| C-27 | createがPriorityQueueを作成する | E-03 (L563-585) | ○ |
| C-28 | notifyCheckpointCompleteがconfirmを呼ぶ | E-03 (L639-656) | ○ |
| C-29 | notifyCheckpointAbortedがresetを呼ぶ | E-03 (L659-668) | ○ |
| C-30 | getOrCreateKeyedStateが新しい状態を作成する | E-03 (L673-700) | ○ |
| C-31 | getOrCreateKeyedStateが既存状態を返す | E-03 (L682-683) | ○ |
| C-32 | namespaceSerializerがnullの場合に例外 | E-03 (L677) | ○ |
| C-33 | createOrUpdateInternalStateが内部状態を作成する | E-03 (L705-730) | ○ |
| C-34 | initMaterializationがMaterializationRunnableを返す | E-03 (L853-896) | ○ |
| C-35 | 前回マテリアライゼーション未確認の場合にスキップ | E-03 (L854-864) | ○ |
| C-36 | シーケンス番号が同じ場合にスキップ | E-03 (L873-904) | ○ |
| C-37 | handleMaterializationResultがchangelogSnapshotStateを更新 | E-03 (L912-938) | ○ |
| C-38 | handleMaterializationFailureOrCancellationがIDを更新 | E-03 (L941-950) | ○ |
| C-39 | notifyCheckpointSubsumedがhelperを呼ぶ | E-03 (L971-973) | ○ |
| C-40 | getChangelogRestoreTargetがTargetを返す | E-03 (L975-1046) | ○ |

### ChangelogValueState関連（C-41 〜 C-44）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | valueが委譲先から取得する | E-04 (L56-58) | ○ |
| C-42 | updateが値を更新しログに記録する | E-04 (L61-64) | ○ |
| C-43 | clearが値をクリアしログに記録する | E-04 (L67-74) | ○ |
| C-44 | getChangeApplierがfactory.forValueを呼ぶ | E-04 (L87-89) | ○ |

### ChangelogListState関連（C-45 〜 C-50）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | updateがリストを更新しログに記録する | E-05 (L59-62) | ○ |
| C-46 | addAllが追加しログに記録する | E-05 (L65-68) | ○ |
| C-47 | addが要素を追加しログに記録する | E-05 (L77-85) | ○ |
| C-48 | mergeNamespacesがマージしログに記録する | E-05 (L88-93) | ○ |
| C-49 | getが委譲先から取得する | E-05 (L103-107) | ○ |
| C-50 | clearがクリアしログに記録する | E-05 (L110-117) | ○ |

### ChangelogMapState関連（C-51 〜 C-61）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | getが委譲先から取得する | E-06 (L101-103) | ○ |
| C-52 | putが設定しログに記録する | E-06 (L106-109) | ○ |
| C-53 | putAllが設定しログに記録する | E-06 (L112-115) | ○ |
| C-54 | removeが削除しログに記録する | E-06 (L118-121) | ○ |
| C-55 | containsが委譲先から取得する | E-06 (L124-126) | ○ |
| C-56 | entriesがIterableを返す | E-06 (L129-132) | ○ |
| C-57 | keysがIterableを返す | E-06 (L161-169) | ○ |
| C-58 | valuesがIterableを返す | E-06 (L172-191) | ○ |
| C-59 | isEmptyが委譲先から取得する | E-06 (L199-201) | ○ |
| C-60 | clearがクリアしログに記録する | E-06 (L204-211) | ○ |
| C-61 | iteratorがラップされたイテレータを返す | E-06 (L194-196) | ○ |

### ChangelogReducingState関連（C-62 〜 C-65）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | getが委譲先から取得する | E-07 (L76-78) | ○ |
| C-63 | addが追加しログに記録する | E-07 (L81-91) | ○ |
| C-64 | mergeNamespacesがマージしログに記録する | E-07 (L57-62) | ○ |
| C-65 | clearがクリアしログに記録する | E-07 (L94-101) | ○ |

### ChangelogAggregatingState関連（C-66 〜 C-69）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | getが委譲先から取得する | E-08 (L76-78) | ○ |
| C-67 | addが追加しログに記録する | E-08 (L81-91) | ○ |
| C-68 | mergeNamespacesがマージしログに記録する | E-08 (L59-62) | ○ |
| C-69 | clearがクリアしログに記録する | E-08 (L94-101) | ○ |

### AbstractChangelogState関連（C-70 〜 C-78）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | コンストラクタが正しく初期化する | E-09 (L42-46) | ○ |
| C-71 | AbstractChangelogStateの場合に例外をスロー | E-09 (L43) | ○ |
| C-72 | getDelegatedStateが委譲先を返す | E-09 (L48-50) | ○ |
| C-73 | setDelegatedStateが委譲先を設定する | E-09 (L58-60) | ○ |
| C-74 | setCurrentNamespaceが名前空間を設定する | E-09 (L78-81) | ○ |
| C-75 | getKeySerializerが委譲先から取得する | E-09 (L63-65) | ○ |
| C-76 | getNamespaceSerializerが委譲先から取得する | E-09 (L68-70) | ○ |
| C-77 | getValueSerializerが委譲先から取得する | E-09 (L73-75) | ○ |
| C-78 | resetWritingMetaFlagがloggerを呼ぶ | E-09 (L104-106) | ○ |

### KvStateChangeLoggerImpl関連（C-79 〜 C-83）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | namespacesMergedがMERGE_NSをログに記録する | E-10 (L68-79) | ○ |
| C-80 | sourcesが空でも正常にログ記録する | E-10 (L68-79) | ○ |
| C-81 | setMetaInfoがシリアライザを更新する | E-10 (L110-119) | ○ |
| C-82 | setStateTtlConfigがTTLを更新する | E-10 (L121-124) | ○ |
| C-83 | setDefaultValueがデフォルト値を設定する | E-10 (L126-129) | ○ |

### AbstractStateChangeLogger関連（C-84 〜 C-92）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | valueUpdatedがSET操作をログに記録する | E-11 (L78-83) | ○ |
| C-85 | valueUpdatedがnullの場合にvalueClearedを呼ぶ | E-11 (L79-80) | ○ |
| C-86 | valueUpdatedInternalがSET_INTERNALをログに記録する | E-11 (L87-93) | ○ |
| C-87 | valueAddedがADDをログに記録する | E-11 (L98-100) | ○ |
| C-88 | valueClearedがCLEARをログに記録する | E-11 (L103-105) | ○ |
| C-89 | valueElementAddedがADD_ELEMENTをログに記録する | E-11 (L108-112) | ○ |
| C-90 | valueElementAddedOrUpdatedがADD_OR_UPDATE_ELEMENTをログに記録する | E-11 (L115-119) | ○ |
| C-91 | valueElementRemovedがREMOVE_ELEMENTをログに記録する | E-11 (L122-126) | ○ |
| C-92 | resetWritingMetaFlagがフラグをfalseにする | E-11 (L129-131) | ○ |

### PriorityQueueStateChangeLoggerImpl関連（C-93 〜 C-94）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | serializeValueがシリアライザを使用する | E-12 (L45-47) | ○ |
| C-94 | setMetaInfoがシリアライザを更新する | E-12 (L53-61) | ○ |

### ChangelogKeyGroupedPriorityQueue関連（C-95 〜 C-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | pollが要素を取得し削除をログに記録する | E-13 (L64-71) | ○ |
| C-96 | キューが空の場合にnullが返却される | E-13 (L64-71) | ○ |
| C-97 | peekが先頭要素を返す | E-13 (L75-77) | ○ |
| C-98 | addが要素を追加しログに記録する | E-13 (L80-84) | ○ |
| C-99 | removeが要素を削除しログに記録する | E-13 (L87-91) | ○ |
| C-100 | addAllが複数要素を追加しログに記録する | E-13 (L104-107) | ○ |
| C-101 | nullコレクションの場合も処理される | E-13 (L104) | ○ |
| C-102 | isEmptyが委譲先から取得する | E-13 (L94-96) | ○ |
| C-103 | sizeが委譲先から取得する | E-13 (L99-101) | ○ |
| C-104 | iteratorがラップされたイテレータを返す | E-13 (L125-129) | ○ |
| C-105 | getSubsetForKeyGroupが委譲先から取得する | E-13 (L58-60) | ○ |

### ChangelogStateFactory関連（C-106 〜 C-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | VALUEタイプでChangelogValueStateが作成される | E-14 (L50-67) | ○ |
| C-107 | LISTタイプでChangelogListStateが作成される | E-14 (L50-67) | ○ |
| C-108 | REDUCINGタイプでChangelogReducingStateが作成される | E-14 (L50-67) | ○ |
| C-109 | AGGREGATINGタイプでChangelogAggregatingStateが作成される | E-14 (L50-67) | ○ |
| C-110 | MAPタイプでChangelogMapStateが作成される | E-14 (L50-67) | ○ |
| C-111 | サポートされないタイプでFlinkRuntimeException | E-14 (L137-148) | ○ |
| C-112 | PriorityQueueが作成される | E-14 (L82-91) | ○ |
| C-113 | KEY_VALUEタイプの既存状態が返却される | E-14 (L104-119) | ○ |
| C-114 | PRIORITY_QUEUEタイプの既存状態が返却される | E-14 (L104-119) | ○ |
| C-115 | サポートされないタイプでUnsupportedOperationException | E-14 (L114-116) | ○ |
| C-116 | 存在しない状態名でnullが返却される | E-14 (L104-119) | ○ |
| C-117 | resetAllWritingMetaFlagsが全状態を呼び出す | E-14 (L121-130) | ○ |
| C-118 | disposeが全状態をクリアする | E-14 (L132-135) | ○ |

### ChangelogTruncateHelper関連（C-119 〜 C-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | checkpointが記録される | E-15 (L61-63) | ○ |
| C-120 | checkpointSubsumedがtruncateを呼ぶ | E-15 (L66-74) | ○ |
| C-121 | 存在しないIDでトランケートされない | E-15 (L67-73) | ○ |
| C-122 | materializedがtruncateを呼ぶ | E-15 (L81-84) | ○ |
| C-123 | truncateが小さい方でトランケートする | E-15 (L86-96) | ○ |
| C-124 | subsumedUpToがnullでトランケートされない | E-15 (L87) | ○ |
| C-125 | materializedUpToがnullでトランケートされない | E-15 (L87) | ○ |

### DeactivatedChangelogStateBackend関連（C-126 〜 C-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | restoreがChangelogMigrationRestoreTargetを使用する | E-16 (L49-78) | ○ |
| C-127 | reboundCheckpointがチェックポイントIDを再バインドする | E-16 (L80-88) | ○ |

### ChangelogStateBackendMetricGroup関連（C-128 〜 C-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | コンストラクタが4つのゲージを登録する | E-17 (L62-68) | ○ |
| C-129 | reportSnapshotResultがサイズを更新する | E-17 (L71-85) | ○ |
| C-130 | スナップショットがnullでサイズが0になる | E-17 (L74-76) | ○ |

### StateChangeLoggingIterator関連（C-131 〜 C-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | hasNextが委譲先を返す | E-18 (L51-53) | ○ |
| C-132 | nextが委譲先を返す | E-18 (L56-58) | ○ |
| C-133 | removeが削除しログに記録する | E-18 (L61-68) | ○ |
| C-134 | closeが委譲先をクローズする | E-18 (L80-82) | ○ |

### StateChangeOperation関連（C-135 〜 C-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | byCodeが有効なコードで操作を返す | E-19 (L60-62) | ○ |
| C-136 | byCodeが無効なコードでnullチェックにより例外 | E-19 (L61) | ○ |
| C-137 | getCodeがバイトコードを返す | E-19 (L64-66) | ○ |

### restore package関連（C-138 〜 C-160）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | restoreが状態を復元する | E-23 (L66-90) | ○ |
| C-139 | stateHandlesが空でも復元される | E-23 (L66-90) | ○ |
| C-140 | stateHandlesにnullがあってもスキップされる | E-23 (L79-88) | ○ |
| C-141 | applyが状態変更を適用する | E-25 (L65-81) | ○ |
| C-142 | METADATA操作が正しく処理される | E-25 (L93-98) | ○ |
| C-143 | keyGroupが範囲外でスキップされる | E-25 (L95-97) | ○ |
| C-144 | forMapがMapStateChangeApplierを返す | E-24 (L35-38) | ○ |
| C-145 | forListがListStateChangeApplierを返す | E-24 (L41-44) | ○ |
| C-146 | forReducingがReducingStateChangeApplierを返す | E-24 (L47-50) | ○ |
| C-147 | forAggregatingがAggregatingStateChangeApplierを返す | E-24 (L53-56) | ○ |
| C-148 | forValueがValueStateChangeApplierを返す | E-24 (L59-62) | ○ |
| C-149 | forPriorityQueueがPriorityQueueStateChangeApplierを返す | E-24 (L65-68) | ○ |
| C-150 | addOrUpdateがDelegatingFunctionを追加する | E-26 (L64-78) | ○ |
| C-151 | addOrUpdateが既存の委譲を更新する | E-26 (L64-78) | ○ |
| C-152 | delegateReduceFunctionがDelegatingReduceFunctionを返す | E-26 (L50-52) | ○ |
| C-153 | delegateAggregateFunctionがDelegatingAggregateFunctionを返す | E-26 (L54-56) | ○ |
| C-154 | DelegatingReduceFunction.reduceが委譲先を呼ぶ | E-26 (L137-139) | ○ |
| C-155 | DelegatingReduceFunction.reduceがnullで例外 | E-26 (L138) | ○ |
| C-156 | DelegatingAggregateFunction.createAccumulatorが委譲先を呼ぶ | E-26 (L106-109) | ○ |
| C-157 | DelegatingAggregateFunction.addが委譲先を呼ぶ | E-26 (L112-115) | ○ |
| C-158 | DelegatingAggregateFunction.getResultが委譲先を呼ぶ | E-26 (L118-121) | ○ |
| C-159 | DelegatingAggregateFunction.mergeが委譲先を呼ぶ | E-26 (L124-127) | ○ |
| C-160 | StateIDコンストラクタがフィールドを設定する | E-27 (L27-30) | ○ |

### 根拠不足項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-XX1 | ChangelogMigrationRestoreTargetの詳細動作 | **詳細実装が別ファイル** | △ |
| C-XX2 | 各StateChangeApplierの詳細実装 | **詳細実装が別ファイル** | △ |
| C-XX3 | ChangelogRestoreTargetインターフェースの実装詳細 | **インターフェースのみ** | △ |
| C-XX4 | ChangelogApplierFactoryインターフェースの実装詳細 | **インターフェースのみ** | △ |

## 4) 不足情報（Unknown / Missing）
- **ChangelogMigrationRestoreTarget**: 詳細実装ファイルが本モジュールの主要解析対象に含まれていない
  - 候補：`src/main/java/org/apache/flink/state/changelog/restore/ChangelogMigrationRestoreTarget.java`
- **各StateChangeApplier実装**: KvStateChangeApplier, MapStateChangeApplier等の詳細実装
  - 候補：`src/main/java/org/apache/flink/state/changelog/restore/*StateChangeApplier.java`
- **ChangelogRestoreTarget/ChangelogApplierFactory**: インターフェースのみで具体的な実装詳細はChangelogKeyedStateBackend内のanonymous class
  - 候補：インターフェースファイル参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 状態操作の委譲パターンは一貫しており、テストケースはソースコードから直接導出
- 1: 中リスク - restore package内の一部クラスの詳細実装は別ファイルに依存
- 1: 中リスク - スナップショット処理の複雑な条件分岐（ローカル状態、リスケーリング等）

## 6) レビュアーチェックリスト（最小）
- [ ] ChangelogKeyedStateBackendのsnapshotメソッドの条件分岐カバレッジが十分か確認
- [ ] initMaterializationの前回マテリアライゼーション確認ロジックのエッジケースを確認
- [ ] ChangelogTruncateHelperのtruncate条件（subsumedUpTo/materializedUpTo）の境界値を確認
- [ ] 各Changelog*State（Value, List, Map, Reducing, Aggregating）のchangelogロギング一貫性を確認
- [ ] restore packageの各StateChangeApplierの詳細実装を別途確認
- [ ] DeactivatedChangelogStateBackendのreboundCheckpoint処理の妥当性を確認
