---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 156
  claims_with_evidence: 156
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: flink-state-backends_flink-statebackend-heap-spillable 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **1.00**
  - 根拠あり: 156 / 156、根拠なし: 0
- 優先レビュー（高）
  1. **なし**: すべてのテストケースはソースコードから直接導出されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/CopyOnWriteSkipListStateMap.java`
- E-02: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/CopyOnWriteSkipListStateMapSnapshot.java`
- E-03: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/LevelIndexHeader.java`
- E-04: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/OnHeapLevelIndexHeader.java`
- E-05: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/NodeStatus.java`
- E-06: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/SkipListKeySerializer.java`
- E-07: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/SkipListValueSerializer.java`
- E-08: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/SkipListUtils.java`
- E-09: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/SkipListKeyComparator.java`
- E-10: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/space/Allocator.java`
- E-11: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/space/SpaceUtils.java`
- E-12: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/space/Chunk.java`
- E-13: `flink-state-backends/flink-statebackend-heap-spillable/src/main/java/org/apache/flink/runtime/state/heap/space/Constants.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### CopyOnWriteSkipListStateMap (UT-HSP-001 - UT-HSP-039)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタの正常系テスト | E-01 (line 141-181) | ○ |
| C-02 | numKeysToDeleteOneTimeが負の場合の異常系 | E-01 (line 152-154) Preconditions.checkArgument | ○ |
| C-03 | logicalRemovedKeysRatioが範囲外の場合の異常系 | E-01 (line 156-158) Preconditions.checkArgument | ○ |
| C-04 | size()メソッドの正常系（空マップ） | E-01 (line 184-186) totalSize - logicallyRemovedNodes.size() | ○ |
| C-05 | size()メソッドの正常系（要素あり） | E-01 (line 184-186) | ○ |
| C-06 | size()メソッドで論理削除を除外 | E-01 (line 184-186) logicallyRemovedNodes.size()を減算 | ○ |
| C-07 | get()の正常系テスト | E-01 (line 198-202) | ○ |
| C-08 | get()で存在しないキーにnull返却 | E-01 (line 277-288) getNode()の実装 | ○ |
| C-09 | get()で削除済みキーにnull返却 | E-01 (line 283-285) isRemoved判定 | ○ |
| C-10 | containsKey()の正常系 | E-01 (line 205-211) | ○ |
| C-11 | containsKey()で存在しないキー | E-01 (line 209) return node != null | ○ |
| C-12 | put()の正常系 | E-01 (line 214-221) | ○ |
| C-13 | put()の更新機能 | E-01 (line 356-383) putValue()の実装 | ○ |
| C-14 | put()のCopy-on-Write動作 | E-01 (line 358, 361-364) needCopyOnWrite判定 | ○ |
| C-15 | putAndGetOld()の新規キー | E-01 (line 224-231) returnOldState=true | ○ |
| C-16 | putAndGetOld()の更新時古い値返却 | E-01 (line 372-375) | ○ |
| C-17 | remove()の正常系 | E-01 (line 234-239) | ○ |
| C-18 | remove()で存在しないキー | E-01 (line 406) isKeyFound判定 | ○ |
| C-19 | remove()でスナップショット中論理削除 | E-01 (line 439-453) | ○ |
| C-20 | removeAndGetOld()の古い値返却 | E-01 (line 243-249) returnOldState=true | ○ |
| C-21 | removeAndGetOld()で存在しないキー | E-01 (line 406) | ○ |
| C-22 | transform()の正常系 | E-01 (line 252-263) | ○ |
| C-23 | transform()で存在しないキー | E-01 (line 259-260) oldState=null, transformation適用 | ○ |
| C-24 | getKeys()の正常系 | E-01 (line 1164-1172) | ○ |
| C-25 | getKeys()で存在しないnamespace | E-01 (line 1169-1170) Iterator返却 | ○ |
| C-26 | sizeOfNamespace()の正常系 | E-01 (line 1176-1189) | ○ |
| C-27 | sizeOfNamespace()で存在しないnamespace | E-01 (line 1182-1186) size=0 | ○ |
| C-28 | iterator()の正常系 | E-01 (line 1193-1207) | ○ |
| C-29 | iterator()の空マップ | E-01 (line 1322-1355) NodeIteratorの実装 | ○ |
| C-30 | iterator()で論理削除スキップ | E-01 (line 1331-1334) isNodeRemoved判定 | ○ |
| C-31 | getStateIncrementalVisitor()の正常系 | E-01 (line 1210-1213) | ○ |
| C-32 | stateSnapshot()の正常系 | E-01 (line 1217-1241) | ○ |
| C-33 | stateSnapshot()でバージョンインクリメント | E-01 (line 1229-1230) stateMapVersion++ | ○ |
| C-34 | stateSnapshot()でクローズ済み例外 | E-01 (line 1220-1226) resourceGuard.acquireResource | ○ |
| C-35 | releaseSnapshot()の正常系 | E-01 (line 1245-1264) | ○ |
| C-36 | releaseSnapshot()で他マップの例外 | E-01 (line 1251-1253) Preconditions.checkArgument | ○ |
| C-37 | close()のリソース解放 | E-01 (line 1309-1319) | ○ |
| C-38 | close()の二重クローズ | E-01 (line 1310-1312) compareAndSet | ○ |
| C-39 | isClosed()の状態確認 | E-01 (line 1304-1306) | ○ |

### CopyOnWriteSkipListStateMapSnapshot (UT-HSP-040 - UT-HSP-046)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | コンストラクタの正常系 | E-02 (line 74-81) | ○ |
| C-41 | getSnapshotVersion()の正常系 | E-02 (line 84-86) | ○ |
| C-42 | release()の正常系 | E-02 (line 89-92) | ○ |
| C-43 | getIterator()の正常系（変換なし） | E-02 (line 95-119) | ○ |
| C-44 | getIterator()の正常系（変換あり） | E-02 (line 131-132) stateSnapshotTransformer使用 | ○ |
| C-45 | writeState()の変換なし書き込み | E-02 (line 167-175) | ○ |
| C-46 | writeState()の変換あり書き込み | E-02 (line 177-210) | ○ |

### LevelIndexHeader (UT-HSP-047 - UT-HSP-050)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | getLevel()インターフェース仕様 | E-03 (line 24-29) | ○ |
| C-48 | updateLevel()インターフェース仕様 | E-03 (line 31-36) | ○ |
| C-49 | getNextNode()インターフェース仕様 | E-03 (line 38-44) | ○ |
| C-50 | updateNextNode()インターフェース仕様 | E-03 (line 46-52) | ○ |

### OnHeapLevelIndexHeader (UT-HSP-051 - UT-HSP-063)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | コンストラクタのデフォルト初期化 | E-04 (line 40-42) | ○ |
| C-52 | getLevel()の初期値 | E-04 (line 48, 61-63) topLevel=1 | ○ |
| C-53 | updateLevel()の正常系 | E-04 (line 66-87) | ○ |
| C-54 | updateLevel()の負レベル例外 | E-04 (line 67-69) Preconditions.checkArgument | ○ |
| C-55 | updateLevel()のMAX_LEVEL超過例外 | E-04 (line 67-69) | ○ |
| C-56 | updateLevel()の2レベルジャンプ例外 | E-04 (line 70-75) | ○ |
| C-57 | updateLevel()の配列拡張 | E-04 (line 77-82) | ○ |
| C-58 | getNextNode()のレベル0 | E-04 (line 95-97) | ○ |
| C-59 | getNextNode()のレベル1以上 | E-04 (line 98) | ○ |
| C-60 | getNextNode()の無効レベル例外 | E-04 (line 91-93) | ○ |
| C-61 | updateNextNode()のレベル0 | E-04 (line 107-108) | ○ |
| C-62 | updateNextNode()のレベル1以上 | E-04 (line 109-111) | ○ |
| C-63 | updateNextNode()の無効レベル例外 | E-04 (line 103-105) | ○ |

### NodeStatus (UT-HSP-064 - UT-HSP-068)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | getValue()のPUT値 | E-05 (line 23) PUT((byte) 0) | ○ |
| C-65 | getValue()のREMOVE値 | E-05 (line 24) REMOVE((byte) 1) | ○ |
| C-66 | valueOf()の0からPUT | E-05 (line 38-39) | ○ |
| C-67 | valueOf()の1からREMOVE | E-05 (line 40-41) | ○ |
| C-68 | valueOf()の不正値例外 | E-05 (line 42-43) IllegalArgumentException | ○ |

### SkipListKeySerializer (UT-HSP-069 - UT-HSP-076)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | コンストラクタの初期化 | E-06 (line 46-51) | ○ |
| C-70 | serialize()の正常系 | E-06 (line 57-61) | ○ |
| C-71 | serializeToSegment()の正常系 | E-06 (line 67-94) | ○ |
| C-72 | deserializeNamespace()の正常系 | E-06 (line 103-113) | ○ |
| C-73 | deserializeKey()の正常系 | E-06 (line 122-133) | ○ |
| C-74 | getSerializedKeyAndNamespace()の正常系 | E-06 (line 142-155) | ○ |
| C-75 | serializeNamespace()の正常系 | E-06 (line 158-166) | ○ |
| C-76 | serializeNamespaceToSegment()の正常系 | E-06 (line 168-170) | ○ |

### SkipListValueSerializer (UT-HSP-077 - UT-HSP-079)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | コンストラクタの初期化 | E-07 (line 42-45) | ○ |
| C-78 | serialize()の正常系 | E-07 (line 47-56) | ○ |
| C-79 | deserializeState()の正常系 | E-07 (line 65-75) | ○ |

### SkipListUtils (UT-HSP-080 - UT-HSP-132)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | getLevel()の正常系 | E-08 (line 82-84) | ○ |
| C-81 | getNodeStatus()の正常系 | E-08 (line 92-95) | ○ |
| C-82 | putLevelAndNodeStatus()の正常系 | E-08 (line 105-109) | ○ |
| C-83 | getKeyLen()の正常系 | E-08 (line 117-119) | ○ |
| C-84 | putKeyLen()の正常系 | E-08 (line 128-130) | ○ |
| C-85 | getValuePointer()の正常系 | E-08 (line 138-140) | ○ |
| C-86 | putValuePointer()の正常系 | E-08 (line 149-151) | ○ |
| C-87 | getNextKeyPointer()の正常系 | E-08 (line 159-161) | ○ |
| C-88 | putNextKeyPointer()の正常系 | E-08 (line 170-173) | ○ |
| C-89 | getNextIndexNode()の正常系 | E-08 (line 182-184) | ○ |
| C-90 | putNextIndexNode()の正常系 | E-08 (line 194-197) | ○ |
| C-91 | getPrevIndexNode()の正常系 | E-08 (line 207-211) | ○ |
| C-92 | putPrevIndexNode()の正常系 | E-08 (line 226-234) | ○ |
| C-93 | getKeyMetaLen()の正常系 | E-08 (line 241-246) | ○ |
| C-94 | getKeyMetaLen()の範囲外例外 | E-08 (line 242-244) Preconditions.checkArgument | ○ |
| C-95 | getKeyDataOffset()の正常系 | E-08 (line 253-255) | ○ |
| C-96 | putKeyData()の正常系 | E-08 (line 267-275) | ○ |
| C-97 | getValueVersion()の正常系 | E-08 (line 296-298) | ○ |
| C-98 | putValueVersion()の正常系 | E-08 (line 307-309) | ○ |
| C-99 | getKeyPointer()の正常系 | E-08 (line 317-319) | ○ |
| C-100 | putKeyPointer()の正常系 | E-08 (line 328-330) | ○ |
| C-101 | getNextValuePointer()の正常系 | E-08 (line 338-340) | ○ |
| C-102 | putNextValuePointer()の正常系 | E-08 (line 349-352) | ○ |
| C-103 | getValueLen()の正常系 | E-08 (line 360-362) | ○ |
| C-104 | putValueLen()の正常系 | E-08 (line 371-373) | ○ |
| C-105 | getValueMetaLen()の正常系 | E-08 (line 376-378) | ○ |
| C-106 | putValueData()の正常系 | E-08 (line 387-390) | ○ |
| C-107 | helpSetNextNode()のHEAD_NODE | E-08 (line 407-409) | ○ |
| C-108 | helpSetNextNode()の通常ノード | E-08 (line 411-421) | ○ |
| C-109 | helpGetNextNode()のHEAD_NODE | E-08 (line 435-437) | ○ |
| C-110 | helpGetNextNode()の通常ノード | E-08 (line 439-447) | ○ |
| C-111 | helpSetPrevNode()の正常系 | E-08 (line 457-472) | ○ |
| C-112 | helpSetPrevNode()のlevel=0例外 | E-08 (line 458) Preconditions.checkArgument | ○ |
| C-113 | helpSetPrevAndNextNode()の正常系 | E-08 (line 484-498) | ○ |
| C-114 | helpSetPrevAndNextNode()のHEAD_NODE例外 | E-08 (line 486) Preconditions.checkArgument | ○ |
| C-115 | isNodeRemoved()の削除済みノード | E-08 (line 507-517) | ○ |
| C-116 | isNodeRemoved()の未削除ノード | E-08 (line 516) | ○ |
| C-117 | isNodeRemoved()のNIL_NODE | E-08 (line 508-510) | ○ |
| C-118 | compareSegmentAndNode()の同一キー | E-08 (line 530-545) | ○ |
| C-119 | compareSegmentAndNode()の小さいキー | E-08 (line 543-544) | ○ |
| C-120 | compareSegmentAndNode()の大きいキー | E-08 (line 543-544) | ○ |
| C-121 | findPredecessor(node)の正常系 | E-08 (line 556-570) | ○ |
| C-122 | findPredecessor(keySegment)の正常系 | E-08 (line 583-612) | ○ |
| C-123 | helpGetNextValuePointer()の正常系 | E-08 (line 620-627) | ○ |
| C-124 | helpSetNextValuePointer()の正常系 | E-08 (line 636-644) | ○ |
| C-125 | buildLevelIndex()の正常系 | E-08 (line 656-691) | ○ |
| C-126 | removeLevelIndex()の正常系 | E-08 (line 700-715) | ○ |
| C-127 | removeAllValues()の正常系 | E-08 (line 723-730) | ○ |
| C-128 | removeAllValues()のNIL_VALUE_POINTER | E-08 (line 725) while条件 | ○ |
| C-129 | helpGetValuePointer()の正常系 | E-08 (line 738-745) | ○ |
| C-130 | helpGetValueVersion()の正常系 | E-08 (line 753-760) | ○ |
| C-131 | helpGetValueLen()の正常系 | E-08 (line 768-775) | ○ |
| C-132 | helpGetNodeLatestVersion()の正常系 | E-08 (line 783-791) | ○ |

### SkipListKeyComparator (UT-HSP-133 - UT-HSP-137)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | compareTo()の同一キー | E-09 (line 36-65) | ○ |
| C-134 | compareTo()の異なるnamespace | E-09 (line 41-51) namespace比較 | ○ |
| C-135 | compareTo()の同namespace異key | E-09 (line 53-65) key比較 | ○ |
| C-136 | compareNamespaceAndNode()の同一namespace | E-09 (line 79-93) | ○ |
| C-137 | compareNamespaceAndNode()の異なるnamespace | E-09 (line 87-92) | ○ |

### space パッケージ (UT-HSP-138 - UT-HSP-156)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | Allocator.allocate()の正常系 | E-10 (line 27-32) | ○ |
| C-139 | Allocator.allocate()の空間不足 | E-10 (line 31) throws Exception | ○ |
| C-140 | Allocator.free()の正常系 | E-10 (line 34-40) | ○ |
| C-141 | Allocator.getChunkById()の正常系 | E-10 (line 42-48) | ○ |
| C-142 | SpaceUtils.getChunkIdByAddress()の正常系 | E-11 (line 27-29) | ○ |
| C-143 | SpaceUtils.getChunkIdByAddress()の0アドレス | E-11 (line 28) | ○ |
| C-144 | SpaceUtils.getChunkOffsetByAddress()の正常系 | E-11 (line 31-33) | ○ |
| C-145 | SpaceUtils.getChunkOffsetByAddress()の0アドレス | E-11 (line 32) | ○ |
| C-146 | Chunk.allocate()の正常系 | E-12 (line 34-39) | ○ |
| C-147 | Chunk.allocate()の空間不足 | E-12 (line 37) returns -1 | ○ |
| C-148 | Chunk.free()の正常系 | E-12 (line 41-46) | ○ |
| C-149 | Chunk.getChunkId()の正常系 | E-12 (line 48-51) | ○ |
| C-150 | Chunk.getChunkCapacity()の正常系 | E-12 (line 53) | ○ |
| C-151 | Chunk.getMemorySegment()の正常系 | E-12 (line 55-58) | ○ |
| C-152 | Chunk.getOffsetInSegment()の正常系 | E-12 (line 60-65) | ○ |
| C-153 | Constants.NO_SPACE定数 | E-13 (line 23) | ○ |
| C-154 | Constants.BUCKET_SIZE定数 | E-13 (line 24) | ○ |
| C-155 | Constants.FOUR_BYTES_BITS定数 | E-13 (line 25) | ○ |
| C-156 | Constants.FOUR_BYTES_MARK定数 | E-13 (line 26) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし: すべてのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードの実装に基づいて生成されています
- 注意点:
  - インターフェース（LevelIndexHeader, Allocator, Chunk）の実装クラスは本モジュールに含まれないものがあるため、統合テストでの確認が必要
  - CopyOnWriteSkipListStateMapの並行処理に関するテストは、本一覧では同期的なテストケースのみ記載

## 6) レビュアーチェックリスト（最小）
- [ ] CopyOnWriteSkipListStateMapの主要メソッド（get, put, remove）のテストケースが網羅されているか
- [ ] スナップショット機能（Copy-on-Write）のテストケースが適切か
- [ ] 境界値テスト（空マップ、1要素、最大値等）が網羅されているか
- [ ] 異常系テスト（無効パラメータ、例外発生条件）が網羅されているか
- [ ] SkipListUtilsのヘルパーメソッドのテストケースが網羅されているか
- [ ] spaceパッケージのインターフェース仕様に基づくテストケースが適切か
