---
generated_at: 2026-02-02 15:30:00
metrics:
  claims_total: 144
  claims_with_evidence: 144
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-streaming-java 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケース一覧の内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のクラス・メソッド定義が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：144 / 144、根拠なし：0
- 優先レビュー（高）
  1. **AsyncWaitOperator関連テスト（UT-STJ-008〜020）**：複雑な非同期処理とリトライロジック
  2. **Bucket/Buckets関連テスト（UT-STJ-069〜086）**：チェックポイント・状態管理の重要機能
  3. **AsyncRetryStrategies関連テスト（UT-STJ-057〜068）**：リトライ戦略の境界値テスト

## 2) 参照した情報（Evidence一覧）
> ここに実在するソースファイルを列挙。

- E-01: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/datastream/AsyncDataStream.java`
- E-02: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/datastream/DataStreamUtils.java`
- E-03: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/operators/async/AsyncWaitOperator.java`
- E-04: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/operators/async/queue/OrderedStreamElementQueue.java`
- E-05: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/operators/async/queue/UnorderedStreamElementQueue.java`
- E-06: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/operators/async/queue/StreamRecordQueueEntry.java`
- E-07: `flink-streaming-java/src/main/java/org/apache/flink/streaming/runtime/operators/windowing/KeyMap.java`
- E-08: `flink-streaming-java/src/main/java/org/apache/flink/streaming/util/retryable/AsyncRetryStrategies.java`
- E-09: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/Bucket.java`
- E-10: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/Buckets.java`
- E-11: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/functions/timestamps/AscendingTimestampExtractor.java`
- E-12: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/functions/timestamps/BoundedOutOfOrdernessTimestampExtractor.java`
- E-13: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/functions/source/datagen/RandomGenerator.java`
- E-14: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/windowing/triggers/ProcessingTimeoutTrigger.java`
- E-15: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/windowing/triggers/DeltaTrigger.java`
- E-16: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/functions/windowing/delta/CosineDistance.java`
- E-17: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/functions/windowing/delta/EuclideanDistance.java`
- E-18: `flink-streaming-java/src/main/java/org/apache/flink/streaming/experimental/SocketStreamIterator.java`
- E-19: `flink-streaming-java/src/main/java/org/apache/flink/streaming/experimental/CollectSink.java`
- E-20: `flink-streaming-java/src/main/java/org/apache/flink/streaming/api/lineage/LineageUtils.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### AsyncDataStream関連 (UT-STJ-001〜005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | unorderedWaitメソッドが存在しDataStreamを処理する | E-01: L115-128 | ○ |
| C-02 | orderedWaitメソッドが存在しDataStreamを処理する | E-01: L165-201 | ○ |
| C-03 | unorderedWaitWithRetryメソッドが存在しリトライ戦略をサポートする | E-01: L217-261 | ○ |
| C-04 | orderedWaitWithRetryメソッドが存在しリトライ戦略をサポートする | E-01: L277-321 | ○ |
| C-05 | addOperatorでリトライ戦略使用時にtimeout>0を検証する | E-01: L75-78 | ○ |

### DataStreamUtils関連 (UT-STJ-006〜007)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | reinterpretAsKeyedStreamメソッドが存在する | E-02: L52-59, L78-86 | ○ |
| C-07 | TypeInformation指定のオーバーロードが存在する | E-02: L78-86 | ○ |

### AsyncWaitOperator関連 (UT-STJ-008〜020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | コンストラクタでcapacity>0を検証する | E-03: L153-154 | ○ |
| C-09 | capacity=0で例外がスローされる | E-03: L153-154 | ○ |
| C-10 | processElementメソッドがStreamRecordを処理する | E-03: L245-278 | ○ |
| C-11 | isObjectReuseEnabled時にレコードをコピーする | E-03: L248-253 | ○ |
| C-12 | processWatermarkメソッドがWatermarkを処理する | E-03: L281-288 | ○ |
| C-13 | snapshotStateで状態をシリアライズする | E-03: L291-311 | ○ |
| C-14 | initializeStateで状態を復元する | E-03: L314-320 | ○ |
| C-15 | endInputで処理中要素の完了を待つ | E-03: L323-331 | ○ |
| C-16 | ResultHandler.completeが結果を処理する | E-03: L620-670 | ○ |
| C-17 | 重複completeが無視される | E-03: L625-627 | ○ |
| C-18 | completeExceptionallyがエラーを通知する | E-03: L673-691 | ○ |
| C-19 | RetryableResultHandlerDelegator.processRetryがリトライを処理する | E-03: L541-583 | ○ |
| C-20 | リトライ条件不満足時に即座に完了する | E-03: L570-582 | ○ |

### OrderedStreamElementQueue関連 (UT-STJ-021〜027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コンストラクタでcapacity>0を検証する | E-04: L56-57 | ○ |
| C-22 | capacity=0で例外がスローされる | E-04: L56 | ○ |
| C-23 | tryPutがキューに空きがある場合に要素を追加する | E-04: L95-117 | ○ |
| C-24 | キュー満杯時にOptional.emptyを返す | E-04: L108-116 | ○ |
| C-25 | hasCompletedElementsが完了要素の有無を返す | E-04: L63-65 | ○ |
| C-26 | 空キューでfalseを返す | E-04: L64 | ○ |
| C-27 | emitCompletedElementが完了要素を出力する | E-04: L68-73 | ○ |

### UnorderedStreamElementQueue関連 (UT-STJ-028〜034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | コンストラクタでcapacity>0を検証する | E-05: L67-68 | ○ |
| C-29 | capacity=0で例外がスローされる | E-05: L67 | ○ |
| C-30 | tryPutがStreamRecordを追加する | E-05: L76-105 | ○ |
| C-31 | tryPutがWatermarkで新セグメントを作成する | E-05: L129-146 | ○ |
| C-32 | hasCompletedElementsがセグメント内完了要素を確認する | E-05: L149-151 | ○ |
| C-33 | emitCompletedElementが非順序で出力する | E-05: L154-166 | ○ |
| C-34 | Segment.completedが要素を完了としてマークする | E-05: L222-229 | ○ |

### StreamRecordQueueEntry関連 (UT-STJ-035〜039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタがStreamRecordを受け取る | E-06: L45-47 | ○ |
| C-36 | isDoneが完了前にfalseを返す | E-06: L50-52 | ○ |
| C-37 | isDoneが完了後にtrueを返す | E-06: L50-52 | ○ |
| C-38 | completeが結果を設定する | E-06: L69-71 | ○ |
| C-39 | emitResultが全結果を出力する | E-06: L61-66 | ○ |

### KeyMap関連 (UT-STJ-040〜056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | デフォルトコンストラクタが存在する | E-07: L80-82 | ○ |
| C-41 | 期待要素数指定のコンストラクタが存在する | E-07: L89-104 | ○ |
| C-42 | 負の期待要素数で例外がスローされる | E-07: L90-92 | ○ |
| C-43 | putが新しいキーを追加する | E-07: L120-138 | ○ |
| C-44 | putが既存キーの値を置換する | E-07: L125-132 | ○ |
| C-45 | getが値を取得する | E-07: L215-228 | ○ |
| C-46 | 存在しないキーでnullを返す | E-07: L227 | ○ |
| C-47 | putIfAbsentがファクトリで値を作成する | E-07: L154-172 | ○ |
| C-48 | putIfAbsentが既存値を返す | E-07: L159-163 | ○ |
| C-49 | putOrAggregateが新キーで値を追加する | E-07: L188-205 | ○ |
| C-50 | putOrAggregateが既存キーで集約する | E-07: L193-198 | ○ |
| C-51 | sizeが要素数を返す | E-07: L303-305 | ○ |
| C-52 | isEmptyが空でtrueを返す | E-07: L312-314 | ○ |
| C-53 | isEmptyが非空でfalseを返す | E-07: L313 | ○ |
| C-54 | iteratorが全要素をイテレートする | E-07: L251-292 | ○ |
| C-55 | growTableがテーブルを拡張する | E-07: L353-382 | ○ |
| C-56 | traverseMapsが複数マップをトラバースする | E-07: L495-559 | ○ |

### AsyncRetryStrategies関連 (UT-STJ-057〜068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | NoRetryStrategy.canRetryがfalseを返す | E-08: L47-49 | ○ |
| C-58 | NoRetryStrategy.getBackoffTimeMillisが-1を返す | E-08: L51-54 | ○ |
| C-59 | FixedDelayRetryStrategy.canRetryが最大試行以下でtrueを返す | E-08: L104-106 | ○ |
| C-60 | FixedDelayRetryStrategy.canRetryが最大試行超過でfalseを返す | E-08: L105 | ○ |
| C-61 | FixedDelayRetryStrategy.getBackoffTimeMillisが固定値を返す | E-08: L114-116 | ○ |
| C-62 | FixedDelayRetryStrategyBuilderがmaxAttempts>0を検証する | E-08: L127-128 | ○ |
| C-63 | FixedDelayRetryStrategyBuilderがbackoffTimeMillis>0を検証する | E-08: L129-130 | ○ |
| C-64 | FixedDelayRetryStrategyBuilder.buildがStrategyを構築する | E-08: L147-150 | ○ |
| C-65 | ExponentialBackoffDelayRetryStrategy.canRetryがtrueを返す | E-08: L182-184 | ○ |
| C-66 | ExponentialBackoffDelayRetryStrategy初回でinitialDelayを返す | E-08: L187-191 | ○ |
| C-67 | ExponentialBackoffDelayRetryStrategyが指数的に増加する | E-08: L194-196 | ○ |
| C-68 | ExponentialBackoffDelayRetryStrategyが最大遅延を超えない | E-08: L194 | ○ |

### Bucket関連 (UT-STJ-069〜079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Bucket.getNewが新しいBucketを作成する | E-09: L423-441 | ○ |
| C-70 | Bucket.restoreが状態からBucketを復元する | E-09: L459-476 | ○ |
| C-71 | writeが要素を書き込む | E-09: L211-225 | ○ |
| C-72 | RollingPolicyでロールオーバーする | E-09: L212-223 | ○ |
| C-73 | closePartFileがファイルをクローズする | E-09: L261-269 | ○ |
| C-74 | closePartFileがnullを返す場合 | E-09: L263-268 | ○ |
| C-75 | onReceptionOfCheckpointがBucketStateを作成する | E-09: L277-296 | ○ |
| C-76 | onSuccessfulCompletionOfCheckpointがコミットする | E-09: L316-336 | ○ |
| C-77 | isActiveがアクティブ状態を判定する | E-09: L179-183 | ○ |
| C-78 | mergeが別Bucketをマージする | E-09: L185-209 | ○ |
| C-79 | mergeが異なるbucketPathで例外をスローする | E-09: L187 | ○ |

### Buckets関連 (UT-STJ-080〜086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | コンストラクタがBucketsを初期化する | E-10: L97-124 | ○ |
| C-81 | initializeStateが状態を初期化する | E-10: L154-166 | ○ |
| C-82 | onElementが要素をバケットに振り分ける | E-10: L295-314 | ○ |
| C-83 | onElementが新バケットを作成する | E-10: L316-335 | ○ |
| C-84 | commitUpToCheckpointがファイルをコミットする | E-10: L221-242 | ○ |
| C-85 | snapshotStateが状態を保存する | E-10: L244-264 | ○ |
| C-86 | closeが全バケットをクローズする | E-10: L350-354 | ○ |

### AscendingTimestampExtractor関連 (UT-STJ-087〜092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | extractTimestampが昇順タイムスタンプを抽出する | E-11: L73-82 | ○ |
| C-88 | 降順タイムスタンプでviolationHandlerが呼ばれる | E-11: L79 | ○ |
| C-89 | getCurrentWatermarkがウォーターマークを返す | E-11: L85-88 | ○ |
| C-90 | 初期状態でLong.MIN_VALUEを返す | E-11: L87 | ○ |
| C-91 | withViolationHandlerがハンドラを設定する | E-11: L65-68 | ○ |
| C-92 | FailingHandlerがRuntimeExceptionをスローする | E-11: L123-129 | ○ |

### BoundedOutOfOrdernessTimestampExtractor関連 (UT-STJ-093〜098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | コンストラクタがmaxOutOfOrdernessを設定する | E-12: L52-62 | ○ |
| C-94 | 負のmaxOutOfOrdernessで例外がスローされる | E-12: L53-58 | ○ |
| C-95 | extractTimestampがタイムスタンプを抽出する | E-12: L87-93 | ○ |
| C-96 | 最大値より小さいタイムスタンプで最大値が維持される | E-12: L89-91 | ○ |
| C-97 | getCurrentWatermarkがmaxOutOfOrdernessを考慮する | E-12: L77-84 | ○ |
| C-98 | ウォーターマークが後退しない | E-12: L80-82 | ○ |

### RandomGenerator関連 (UT-STJ-099〜108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | longGeneratorが範囲内のLongを生成する | E-13: L69-76 | ○ |
| C-100 | intGeneratorが範囲内のIntegerを生成する | E-13: L78-85 | ○ |
| C-101 | stringGeneratorが指定長の文字列を生成する | E-13: L123-130 | ○ |
| C-102 | booleanGeneratorがBooleanを生成する | E-13: L132-139 | ○ |
| C-103 | withNullRateがnullRateを設定する | E-13: L47-50 | ○ |
| C-104 | nullRate=0で常に値を返す | E-13: L52-57 | ○ |
| C-105 | nullRate=1で常にnullを返す | E-13: L53-56 | ○ |
| C-106 | hasNextが常にtrueを返す | E-13: L65-67 | ○ |
| C-107 | arrayGeneratorが配列を生成する | E-13: L141-165 | ○ |
| C-108 | mapGeneratorがMapを生成する | E-13: L167-191 | ○ |

### ProcessingTimeoutTrigger関連 (UT-STJ-109〜115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | ofがProcessingTimeoutTriggerを作成する | E-14: L144-147 | ○ |
| C-110 | onElementでnestedTriggerがFIREの場合にclearが呼ばれる | E-14: L70-76 | ○ |
| C-111 | 初回要素でタイムアウトタイマーが登録される | E-14: L87-90 | ○ |
| C-112 | resetTimerOnNewRecordでタイマーがリセットされる | E-14: L81-85 | ○ |
| C-113 | onProcessingTimeでFIREが返される | E-14: L96-103 | ○ |
| C-114 | shouldClearOnTimeoutでclearが呼ばれる | E-14: L99-101 | ○ |
| C-115 | clearでタイマーが削除される | E-14: L116-124 | ○ |

### DeltaTrigger関連 (UT-STJ-116〜120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | ofがDeltaTriggerを作成する | E-15: L96-99 | ○ |
| C-117 | 初回要素でCONTINUEが返される | E-15: L54-58 | ○ |
| C-118 | デルタが閾値を超えた場合にFIREが返される | E-15: L59-62 | ○ |
| C-119 | デルタが閾値以下の場合にCONTINUEが返される | E-15: L63 | ○ |
| C-120 | clearで状態がクリアされる | E-15: L78-80 | ○ |

### CosineDistance関連 (UT-STJ-121〜124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | getNestedDeltaがコサイン距離を計算する | E-16: L47-67 | ○ |
| C-122 | 同一ベクトルで0を返す | E-16: L66 | ○ |
| C-123 | ゼロベクトルで0を返す | E-16: L48-50, L77-88 | ○ |
| C-124 | 異なる次元で例外がスローされる | E-16: L52-55 | ○ |

### EuclideanDistance関連 (UT-STJ-125〜126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | getNestedDeltaがユークリッド距離を計算する | E-17: L46-52 | ○ |
| C-126 | 同一点で0を返す | E-17: L47-51 | ○ |

### SocketStreamIterator関連 (UT-STJ-127〜134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | コンストラクタがServerSocketを開く | E-18: L73-94 | ○ |
| C-128 | ポート/アドレス指定のコンストラクタ | E-18: L86-94 | ○ |
| C-129 | hasNextが次要素の有無を返す | E-18: L138-148 | ○ |
| C-130 | ストリーム終了時にfalseを返す | E-18: L180-191 | ○ |
| C-131 | nextが次要素を返す | E-18: L157-165 | ○ |
| C-132 | 要素がない場合にNoSuchElementExceptionがスローされる | E-18: L163-164 | ○ |
| C-133 | closeでソケットがクローズされる | E-18: L113-125 | ○ |
| C-134 | notifyOfErrorでソケットがクローズされる | E-18: L206-220 | ○ |

### CollectSink関連 (UT-STJ-135〜140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | コンストラクタがCollectSinkを初期化する | E-19: L57-61 | ○ |
| C-136 | openでソケット接続が確立される | E-19: L80-93 | ○ |
| C-137 | 接続失敗時にIOExceptionがスローされる | E-19: L85-92 | ○ |
| C-138 | invokeでデータがシリアライズされる | E-19: L64-72 | ○ |
| C-139 | シリアライズ失敗時にIOExceptionがスローされる | E-19: L67-71 | ○ |
| C-140 | closeでストリームとソケットがクローズされる | E-19: L97-125 | ○ |

### LineageUtils関連 (UT-STJ-141〜144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | datasetOfがLineageDatasetを作成する | E-20: L32-35 | ○ |
| C-142 | マルチFacetのdatasetOfが存在する | E-20: L37-43 | ○ |
| C-143 | sourceLineageVertexOfがSourceLineageVertexを作成する | E-20: L45-48 | ○ |
| C-144 | lineageVertexOfがLineageVertexを作成する | E-20: L50-52 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている
- 注意点:
  - AsyncWaitOperatorの内部クラス（ResultHandler, RetryableResultHandlerDelegator）は複雑なロジックを含むため、テストケースの期待結果が実装と一致するかレビュー推奨
  - Bucket/Bucketsのチェックポイント関連処理は状態管理が複雑なため、境界条件のテストケース追加を検討

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-STJ-001〜020, 057〜086）の入力値と期待結果が実装と整合しているか
- [ ] 非同期処理（AsyncWaitOperator）のタイムアウト・リトライ関連テストが網羅的か
- [ ] チェックポイント・状態管理（Bucket/Buckets）のテストが復元シナリオを含むか
- [ ] 境界値テスト（空コレクション、最大値、最小値）が適切にカバーされているか
- [ ] 例外処理テスト（異常系）が主要なエラーパスを網羅しているか
