---
generated_at: 2026-02-02 18:35:00
metrics:
  claims_total: 124
  claims_with_evidence: 124
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-table_flink-sql-gateway-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：124 / 124、根拠なし：0
- 優先レビュー（高）
  1. なし：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/session/SessionHandle.java`
- E-02: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/session/SessionEnvironment.java`
- E-03: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/operation/OperationHandle.java`
- E-04: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/operation/OperationStatus.java`
- E-05: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/results/ResultSet.java`
- E-06: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/results/ResultSetImpl.java`
- E-07: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/results/FunctionInfo.java`
- E-08: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/results/TableInfo.java`
- E-09: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/results/OperationInfo.java`
- E-10: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/results/GatewayInfo.java`
- E-11: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/results/FetchOrientation.java`
- E-12: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/endpoint/EndpointVersion.java`
- E-13: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/endpoint/SqlGatewayEndpoint.java`
- E-14: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/endpoint/SqlGatewayEndpointFactory.java`
- E-15: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/endpoint/SqlGatewayEndpointFactoryUtils.java`
- E-16: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/utils/SqlGatewayException.java`
- E-17: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/utils/ThreadUtils.java`
- E-18: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/config/SqlGatewayServiceConfigOptions.java`
- E-19: `flink-table/flink-sql-gateway-api/src/main/java/org/apache/flink/table/gateway/api/SqlGatewayService.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SessionHandle関連（C-01〜C-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | create()でランダムなUUIDを持つSessionHandleが生成される | E-01 L32-34 | ○ |
| C-02 | コンストラクタで指定したUUIDが保持される | E-01 L36-38 | ○ |
| C-03 | nullのUUIDでインスタンス化した場合の挙動確認 | E-01 L36-38 | ○ |
| C-04 | 同じUUIDを持つSessionHandle同士が等しい | E-01 L44-54 | ○ |
| C-05 | 異なるUUIDを持つSessionHandle同士が等しくない | E-01 L44-54 | ○ |
| C-06 | 自分自身との比較でtrueが返却される | E-01 L45-47 | ○ |
| C-07 | nullとの比較でfalseが返却される | E-01 L49 | ○ |
| C-08 | 異なる型との比較でfalseが返却される | E-01 L49 | ○ |
| C-09 | 同じUUIDを持つSessionHandleが同じhashCodeを返す | E-01 L56-59 | ○ |
| C-10 | UUIDの文字列表現が返却される | E-01 L61-64 | ○ |

### OperationHandle関連（C-11〜C-16）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | create()でランダムなUUIDを持つOperationHandleが生成される | E-03 L32-34 | ○ |
| C-12 | コンストラクタで指定したUUIDが保持される | E-03 L36-38 | ○ |
| C-13 | 同じUUIDを持つOperationHandle同士が等しい | E-03 L44-54 | ○ |
| C-14 | 異なるUUIDを持つOperationHandle同士が等しくない | E-03 L44-54 | ○ |
| C-15 | 同じUUIDを持つOperationHandleが同じhashCodeを返す | E-03 L56-59 | ○ |
| C-16 | UUIDの文字列表現が返却される | E-03 L61-64 | ○ |

### OperationStatus関連（C-17〜C-32）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | INITIALIZEDが非終端状態 | E-04 L31-32 | ○ |
| C-18 | PENDINGが非終端状態 | E-04 L34-35 | ○ |
| C-19 | RUNNINGが非終端状態 | E-04 L37-38 | ○ |
| C-20 | FINISHEDが終端状態 | E-04 L40-41 | ○ |
| C-21 | CANCELEDが終端状態 | E-04 L43-44 | ○ |
| C-22 | CLOSEDが終端状態 | E-04 L46-47 | ○ |
| C-23 | ERRORが終端状態 | E-04 L49-50 | ○ |
| C-24 | TIMEOUTが終端状態 | E-04 L52-53 | ○ |
| C-25 | INITIALIZEDからPENDINGへの遷移が有効 | E-04 L72-73 | ○ |
| C-26 | INITIALIZEDからCANCELEDへの遷移が有効 | E-04 L73 | ○ |
| C-27 | PENDINGからRUNNINGへの遷移が有効 | E-04 L74-75 | ○ |
| C-28 | RUNNINGからFINISHEDへの遷移が有効 | E-04 L76-77 | ○ |
| C-29 | RUNNINGからERRORへの遷移が有効 | E-04 L77 | ○ |
| C-30 | 終端状態からCLOSEDへの遷移が有効 | E-04 L78-82 | ○ |
| C-31 | CLOSEDから他の状態への遷移が無効 | E-04 L83-84 | ○ |
| C-32 | INITIALIZEDからFINISHEDへの直接遷移が無効 | E-04 L72-73 | ○ |

### SessionEnvironment関連（C-33〜C-55）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | newBuilder()で新しいBuilderインスタンスが返却される | E-02 L127-129 | ○ |
| C-34 | setSessionName()でセッション名が設定される | E-02 L141-144 | ○ |
| C-35 | setSessionEndpointVersion()でバージョンが設定される | E-02 L146-149 | ○ |
| C-36 | addSessionConfig()でセッション設定が追加される | E-02 L151-154 | ○ |
| C-37 | setDefaultCatalog()でデフォルトカタログが設定される | E-02 L156-159 | ○ |
| C-38 | registerCatalog()でカタログが登録される | E-02 L161-169 | ○ |
| C-39 | 同名カタログの重複登録でValidationExceptionがスローされる | E-02 L162-165 | ○ |
| C-40 | registerCatalogCreator()でカタログ作成者が登録される | E-02 L171-178 | ○ |
| C-41 | 同名カタログ作成者の重複登録でValidationExceptionがスローされる | E-02 L172-175 | ○ |
| C-42 | registerModuleAtHead()でモジュールが登録される | E-02 L180-188 | ○ |
| C-43 | 同名モジュールの重複登録でValidationExceptionがスローされる | E-02 L181-184 | ○ |
| C-44 | registerModuleCreatorAtHead()でモジュール作成者が登録される | E-02 L190-198 | ○ |
| C-45 | 同名モジュール作成者の重複登録でValidationExceptionがスローされる | E-02 L191-194 | ○ |
| C-46 | build()でSessionEnvironmentが正常に構築される | E-02 L200-208 | ○ |
| C-47 | バージョン未設定でビルドするとNullPointerExceptionがスローされる | E-02 L203 checkNotNull | ○ |
| C-48 | getSessionName()で設定されたセッション名が返却される | E-02 L69-71 | ○ |
| C-49 | セッション名未設定時に空のOptionalが返却される | E-02 L69-71 | ○ |
| C-50 | getSessionConfig()で変更不可能なMapが返却される | E-02 L77-79 | ○ |
| C-51 | getRegisteredCatalogCreators()で変更不可能なMapが返却される | E-02 L81-83 | ○ |
| C-52 | getRegisteredModuleCreators()で変更不可能なMapが返却される | E-02 L85-87 | ○ |
| C-53 | デフォルトカタログ未設定時に空のOptionalが返却される | E-02 L89-91 | ○ |
| C-54 | equals()で同じ設定を持つSessionEnvironment同士が等しい | E-02 L95-111 | ○ |
| C-55 | hashCode()で同じ設定を持つSessionEnvironmentが同じhashCodeを返す | E-02 L113-121 | ○ |

### ResultSetImpl関連（C-56〜C-71）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | 全パラメータでインスタンスが正常に生成される | E-06 L52-69 | ○ |
| C-57 | getResultType()で設定されたResultTypeが返却される | E-06 L71-74 | ○ |
| C-58 | getNextToken()で設定されたnextTokenが返却される | E-06 L76-79 | ○ |
| C-59 | nextTokenがnullの場合nullが返却される | E-06 L76-79 | ○ |
| C-60 | getResultSchema()で設定されたResolvedSchemaが返却される | E-06 L81-84 | ○ |
| C-61 | getData()で設定されたデータリストが返却される | E-06 L86-89 | ○ |
| C-62 | 空のデータリストが返却される | E-06 L86-89 | ○ |
| C-63 | isQueryResult()で設定されたフラグが返却される | E-06 L95-98 | ○ |
| C-64 | getJobID()で設定されたJobIDが返却される | E-06 L100-103 | ○ |
| C-65 | JobIDがnullの場合nullが返却される | E-06 L100-103 | ○ |
| C-66 | getResultKind()で設定されたResultKindが返却される | E-06 L105-108 | ○ |
| C-67 | getConverter()で設定されたConverterが返却される | E-06 L91-93 | ○ |
| C-68 | equals()で同じ値を持つResultSetImpl同士が等しい | E-06 L131-147 | ○ |
| C-69 | 異なる値を持つResultSetImpl同士が等しくない | E-06 L131-147 | ○ |
| C-70 | hashCode()で同じ値を持つResultSetImplが同じhashCodeを返す | E-06 L149-153 | ○ |
| C-71 | toString()でResultSetの内容を含む文字列が返却される | E-06 L110-129 | ○ |

### FunctionInfo関連（C-72〜C-77）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | 識別子のみでインスタンスが生成される | E-07 L46-48 | ○ |
| C-73 | 識別子とkindでインスタンスが生成される | E-07 L50-53 | ○ |
| C-74 | kindがnullの場合空のOptionalが返却される | E-07 L59-61 | ○ |
| C-75 | equals()で同じ値を持つFunctionInfo同士が等しい | E-07 L63-73 | ○ |
| C-76 | hashCode()で同じ値を持つFunctionInfoが同じhashCodeを返す | E-07 L75-78 | ○ |
| C-77 | toString()でFunctionInfoの内容を含む文字列が返却される | E-07 L80-83 | ○ |

### TableInfo関連（C-78〜C-83）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | identifierとtableKindでインスタンスが生成される | E-08 L41-44 | ○ |
| C-79 | getIdentifier()で設定されたObjectIdentifierが返却される | E-08 L46-48 | ○ |
| C-80 | getTableKind()で設定されたTableKindが返却される | E-08 L50-52 | ○ |
| C-81 | equals()で同じ値を持つTableInfo同士が等しい | E-08 L54-64 | ○ |
| C-82 | hashCode()で同じ値を持つTableInfoが同じhashCodeを返す | E-08 L66-69 | ○ |
| C-83 | toString()でTableInfoの内容を含む文字列が返却される | E-08 L71-74 | ○ |

### OperationInfo関連（C-84〜C-89）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | statusのみでインスタンスが生成される | E-09 L37-39 | ○ |
| C-85 | statusと例外でインスタンスが生成される | E-09 L41-44 | ○ |
| C-86 | exceptionがnullの場合空のOptionalが返却される | E-09 L50-52 | ○ |
| C-87 | equals()で同じ値を持つOperationInfo同士が等しい | E-09 L54-64 | ○ |
| C-88 | hashCode()で同じ値を持つOperationInfoが同じhashCodeを返す | E-09 L66-69 | ○ |
| C-89 | toString()でOperationInfoの内容を含む文字列が返却される | E-09 L71-79 | ○ |

### GatewayInfo関連（C-90〜C-92）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | getProductName()で"Apache Flink"が返却される | E-10 L31-33 | ○ |
| C-91 | getVersion()で現在のFlinkVersionが返却される | E-10 L35-37 | ○ |
| C-92 | INSTANCEでシングルトンインスタンスが取得できる | E-10 L29 | ○ |

### SqlGatewayException関連（C-93〜C-95）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | メッセージ付き例外が生成される | E-16 L28-30 | ○ |
| C-94 | メッセージと原因付き例外が生成される | E-16 L32-34 | ○ |
| C-95 | 原因のみ付き例外が生成される | E-16 L36-38 | ○ |

### ThreadUtils関連（C-96〜C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | ThreadPoolExecutorが正常に生成される | E-17 L37-53 | ○ |
| C-97 | 指定したコアプールサイズが設定される | E-17 L46 | ○ |
| C-98 | 指定した最大プールサイズが設定される | E-17 L47 | ○ |
| C-99 | プールサイズが0の場合の挙動 | E-17 L37-53 | ○ |
| C-100 | 負のプールサイズでIllegalArgumentExceptionがスローされる | E-17 L37-53 ThreadPoolExecutor仕様 | ○ |

### SqlGatewayEndpointFactoryUtils関連（C-101〜C-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | 有効な設定でエンドポイントが生成される | E-15 L50-78 | ○ |
| C-102 | エンドポイントタイプ未設定でValidationExceptionがスローされる | E-15 L54-59 | ○ |
| C-103 | 空のエンドポイントタイプリストでValidationExceptionがスローされる | E-15 L54-59 | ○ |
| C-104 | 重複したエンドポイント識別子でValidationExceptionがスローされる | E-15 L150-163 | ○ |
| C-105 | 指定した識別子のエンドポイント設定が取得される | E-15 L80-84 | ○ |
| C-106 | 正しいプレフィックス文字列が返却される | E-15 L86-88 | ○ |
| C-107 | EndpointFactoryHelperが生成される | E-15 L95-98 | ○ |
| C-108 | getSqlGatewayService()で設定されたServiceが返却される | E-15 L134-136 | ○ |
| C-109 | getFlinkConfiguration()で設定されたConfigurationが返却される | E-15 L138-141 | ○ |
| C-110 | getEndpointOptions()で設定されたオプションが返却される | E-15 L143-146 | ○ |

### SqlGatewayServiceConfigOptions関連（C-111〜C-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | SQL_GATEWAY_SESSION_IDLE_TIMEOUTのデフォルト値が10分 | E-18 L33-39 | ○ |
| C-112 | SQL_GATEWAY_SESSION_CHECK_INTERVALのデフォルト値が1分 | E-18 L41-46 | ○ |
| C-113 | SQL_GATEWAY_SESSION_MAX_NUMのデフォルト値が1000000 | E-18 L48-53 | ○ |
| C-114 | SQL_GATEWAY_SESSION_PLAN_CACHE_ENABLEDのデフォルト値がfalse | E-18 L55-60 | ○ |
| C-115 | SQL_GATEWAY_SESSION_PLAN_CACHE_SIZEのデフォルト値が100 | E-18 L62-68 | ○ |
| C-116 | SQL_GATEWAY_SESSION_PLAN_CACHE_TTLのデフォルト値が1時間 | E-18 L70-77 | ○ |
| C-117 | SQL_GATEWAY_WORKER_THREADS_MAXのデフォルト値が500 | E-18 L79-84 | ○ |
| C-118 | SQL_GATEWAY_WORKER_THREADS_MINのデフォルト値が5 | E-18 L86-91 | ○ |
| C-119 | SQL_GATEWAY_WORKER_KEEPALIVE_TIMEのデフォルト値が5分 | E-18 L93-99 | ○ |

### FetchOrientation/ResultType関連（C-120〜C-124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | FETCH_NEXTが定義されている | E-11 L28 | ○ |
| C-121 | FETCH_PRIORが定義されている | E-11 L31 | ○ |
| C-122 | ResultType.NOT_READYが定義されている | E-05 L88-89 | ○ |
| C-123 | ResultType.PAYLOADが定義されている | E-05 L91-92 | ○ |
| C-124 | ResultType.EOSが定義されている | E-05 L94-95 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースに対してソースコードの根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードから直接導出されており、信頼性が高い
- 注意点：
  - SqlGatewayServiceはインターフェースのため、実装クラスのテストは別モジュール（flink-sql-gateway）で行う必要がある
  - SqlGatewayEndpoint、SqlGatewayEndpointFactory、EndpointVersionはインターフェースのため、実装クラスのテストが別途必要

## 6) レビュアーチェックリスト（最小）
- [ ] SessionHandleとOperationHandleのUUID生成ロジックが適切にテストされているか確認
- [ ] OperationStatusの状態遷移ロジックが全てのパスをカバーしているか確認
- [ ] SessionEnvironment.Builderの重複登録検出が正しく機能するか確認
- [ ] SqlGatewayEndpointFactoryUtilsのエンドポイント生成・検証ロジックが網羅されているか確認
- [ ] 各設定オプションのデフォルト値が仕様と一致しているか確認
- [ ] インターフェース（SqlGatewayService、SqlGatewayEndpoint等）の実装テストが別途計画されているか確認
