---
generated_at: 2026-02-02 18:35:00
metrics:
  claims_total: 143
  claims_with_evidence: 140
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：flink-table_flink-sql-gateway 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：140 / 143、根拠なし：3
- 優先レビュー（高）
  1. **UT-SGW-028**：deployScript両方null時の異常系 - 実装コードで確認済みだが、テスト優先度の妥当性要確認
  2. **UT-SGW-091**：DefaultContext.load異常系 - 設定ファイル不在時の挙動は環境依存
  3. **UT-SGW-143**：getPeriodRefreshPartition scheduleTime null検証 - 静的メソッドの内部ロジック検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/SqlGateway.java`
- E-02: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/SqlGatewayServiceImpl.java`
- E-03: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/session/SessionManager.java`
- E-04: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/session/SessionManagerImpl.java`
- E-05: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/session/Session.java`
- E-06: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/operation/OperationManager.java`
- E-07: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/operation/OperationExecutor.java`
- E-08: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/context/SessionContext.java`
- E-09: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/context/DefaultContext.java`
- E-10: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/result/ResultFetcher.java`
- E-11: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/result/ResultStore.java`
- E-12: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/rest/SqlGatewayRestEndpoint.java`
- E-13: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/workflow/scheduler/EmbeddedQuartzScheduler.java`
- E-14: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/workflow/EmbeddedRefreshHandler.java`
- E-15: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/service/materializedtable/MaterializedTableManager.java`
- E-16: `flink-table/flink-sql-gateway/src/main/java/org/apache/flink/table/gateway/cli/SqlGatewayOptionsParser.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SqlGateway クラス (UT-SGW-001 ~ UT-SGW-006)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SqlGatewayが正しく初期化されること | E-01 (コンストラクタ L56-61) | ○ |
| C-02 | SqlGatewayが正常に起動すること | E-01 (start メソッド L63-78) | ○ |
| C-03 | エンドポイント起動失敗時に例外がスローされること | E-01 (start メソッド L74-77) | ○ |
| C-04 | SqlGatewayが正常に停止すること | E-01 (stop メソッド L80-88) | ○ |
| C-05 | エンドポイント停止失敗時もSessionManagerは停止すること | E-01 (stopEndpointSilently L149-155) | ○ |
| C-06 | 停止まで待機できること | E-01 (waitUntilStop L90-92) | ○ |

### SqlGatewayServiceImpl クラス (UT-SGW-007 ~ UT-SGW-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | SqlGatewayServiceImplが正しく初期化されること | E-02 (コンストラクタ L71-73) | ○ |
| C-08 | セッションが正常にオープンされること | E-02 (openSession L76-83) | ○ |
| C-09 | セッションオープン失敗時に例外がスローされること | E-02 (openSession L79-82) | ○ |
| C-10 | セッションが正常にクローズされること | E-02 (closeSession L86-93) | ○ |
| C-11 | 存在しないセッションのクローズ時に例外がスローされること | E-02 (closeSession L89-92) | ○ |
| C-12 | セッション設定が正常に行われること | E-02 (configureSession L96-119) | ○ |
| C-13 | タイムアウト指定時にUnsupportedOperationExceptionがスローされること | E-02 (configureSession L100-103) | ○ |
| C-14 | セッション設定が取得できること | E-02 (getSessionConfig L122-130) | ○ |
| C-15 | SQL文が正常に実行されること | E-02 (executeStatement L202-226) | ○ |
| C-16 | 不正なSQL文実行時に例外がスローされること | E-02 (executeStatement L222-225) | ○ |
| C-17 | 結果が正常にフェッチできること | E-02 (fetchResults L229-256) | ○ |
| C-18 | maxRowsが0の場合の挙動 | E-10 (fetchResults L259-261) | ○ |
| C-19 | オペレーションが正常にキャンセルされること | E-02 (cancelOperation L155-162) | ○ |
| C-20 | オペレーションが正常にクローズされること | E-02 (closeOperation L165-172) | ○ |
| C-21 | オペレーション情報が取得できること | E-02 (getOperationInfo L175-185) | ○ |
| C-22 | カタログ一覧が取得できること | E-02 (listCatalogs L264-271) | ○ |
| C-23 | データベース一覧が取得できること | E-02 (listDatabases L274-281) | ○ |
| C-24 | テーブル一覧が取得できること | E-02 (listTables L284-297) | ○ |
| C-25 | SQL補完候補が取得できること | E-02 (completeStatement L423-446) | ○ |
| C-26 | スクリプトがデプロイされること | E-02 (deployScript L341-378) | ○ |
| C-27 | scriptUriとscript両方が指定された場合に例外がスローされること | E-02 (deployScript L351-354) | ○ |
| C-28 | scriptUriとscript両方がnullの場合に例外がスローされること | E-02 (deployScript L348-350) | △ |

### SessionManagerImpl クラス (UT-SGW-029 ~ UT-SGW-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | SessionManagerImplが正しく初期化されること | E-04 (コンストラクタ L71-78) | ○ |
| C-30 | SessionManagerが正常に起動すること | E-04 (start L81-115) | ○ |
| C-31 | SessionManagerが正常に停止すること | E-04 (stop L118-127) | ○ |
| C-32 | 新しいセッションが作成されること | E-04 (openSession L142-167) | ○ |
| C-33 | 最大セッション数を超えた場合に例外がスローされること | E-04 (checkSessionCount L178-190) | ○ |
| C-34 | セッションが取得できること | E-04 (getSession L130-139) | ○ |
| C-35 | 存在しないセッションを取得しようとした場合に例外がスローされること | E-04 (getSession L132-136) | ○ |
| C-36 | セッションがクローズされること | E-04 (closeSession L169-172) | ○ |
| C-37 | 期限切れセッションが正しく判定されること | E-04 (isSessionExpired L192-198) | ○ |
| C-38 | 期限内セッションが正しく判定されること | E-04 (isSessionExpired L192-198) | ○ |

### Session クラス (UT-SGW-039 ~ UT-SGW-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Sessionが正しく初期化されること | E-05 (コンストラクタ L43-46) | ○ |
| C-40 | 最終アクセス時間が更新されること | E-05 (touch L48-50) | ○ |
| C-41 | SessionHandleが取得できること | E-05 (getSessionHandle L56-58) | ○ |
| C-42 | セッション設定が取得できること | E-05 (getSessionConfig L60-62) | ○ |
| C-43 | OperationExecutorが作成できること | E-05 (createExecutor L72-78) | ○ |
| C-44 | セッションがオープンされること | E-05 (open L85-87) | ○ |
| C-45 | セッションがクローズされること | E-05 (close L90-92) | ○ |

### OperationManager クラス (UT-SGW-046 ~ UT-SGW-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | OperationManagerが正しく初期化されること | E-06 (コンストラクタ L79-84) | ○ |
| C-47 | オペレーションが正常にサブミットされること(Callable) | E-06 (submitOperation L94-107) | ○ |
| C-48 | オペレーションが正常にサブミットされること(Function) | E-06 (submitOperation L117-123) | ○ |
| C-49 | オペレーションがキャンセルされること | E-06 (cancelOperation L130-132) | ○ |
| C-50 | 存在しないオペレーションのキャンセル時に例外がスローされること | E-06 (getOperation L482-494) | ○ |
| C-51 | オペレーションがクローズされること | E-06 (closeOperation L139-147) | ○ |
| C-52 | オペレーション終了まで待機できること | E-06 (awaitOperationTermination L149-151) | ○ |
| C-53 | オペレーション情報が取得できること | E-06 (getOperationInfo L158-160) | ○ |
| C-54 | 結果スキーマが取得できること | E-06 (getOperationResultSchema L167-170) | ○ |
| C-55 | 結果がフェッチできること | E-06 (fetchResults L180-182) | ○ |
| C-56 | OperationManagerがクローズされること | E-06 (close L190-215) | ○ |
| C-57 | クローズ済みのOperationManagerへの操作で例外がスローされること | E-06 (writeLock/readLock L501-522) | ○ |
| C-58 | オペレーションが正常に実行されること | E-06 (Operation.run L248-309) | ○ |
| C-59 | オペレーション実行中に例外が発生した場合にERRORステータスになること | E-06 (Operation.processThrowable L412-419) | ○ |
| C-60 | オペレーションがキャンセルされること | E-06 (Operation.cancel L311-314) | ○ |
| C-61 | FINISHED状態で結果が取得できること | E-06 (Operation.fetchResultsInternal L357-374) | ○ |
| C-62 | RUNNING状態でNotReadyResultが返却されること | E-06 (Operation.fetchResultsInternal L364-367) | ○ |
| C-63 | ERROR状態で例外がスローされること | E-06 (Operation.fetchResultsInternal L360-361) | ○ |

### OperationExecutor クラス (UT-SGW-064 ~ UT-SGW-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | OperationExecutorが正しく初期化されること | E-07 (コンストラクタ L182-200) | ○ |
| C-65 | セッション設定が実行されること | E-07 (configureSession L202-228) | ○ |
| C-66 | 複数のSQL文が渡された場合に例外がスローされること(configure) | E-07 (configureSession L205-208) | ○ |
| C-67 | SQL文が実行されること | E-07 (executeStatement L230-279) | ○ |
| C-68 | 複数のSQL文が渡された場合に例外がスローされること(execute) | E-07 (executeStatement L252-256) | ○ |
| C-69 | 現在のカタログ名が取得できること | E-07 (getCurrentCatalog L281-283) | ○ |
| C-70 | カタログ一覧が取得できること | E-07 (listCatalogs L285-287) | ○ |
| C-71 | データベース一覧が取得できること | E-07 (listDatabases L289-302) | ○ |
| C-72 | 存在しないカタログ指定時に例外がスローされること | E-07 (listDatabases L294-298) | ○ |
| C-73 | テーブル一覧が取得できること | E-07 (listTables L304-316) | ○ |
| C-74 | テーブル情報が取得できること | E-07 (getTable L327-332) | ○ |
| C-75 | UDF一覧が取得できること | E-07 (listUserDefinedFunctions L334-344) | ○ |
| C-76 | システム関数一覧が取得できること | E-07 (listSystemFunctions L346-368) | ○ |
| C-77 | 補完候補が取得できること | E-07 (getCompletionHints L384-395) | ○ |
| C-78 | ジョブが正常に停止されること | E-07 (callStopJobOperation L776-831) | ○ |
| C-79 | ジョブ一覧が取得できること | E-07 (callShowJobsOperation L833-873) | ○ |
| C-80 | ジョブ詳細が取得できること | E-07 (callDescribeJobOperation L875-924) | ○ |

### SessionContext クラス (UT-SGW-081 ~ UT-SGW-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | SessionContextが正しく作成されること | E-08 (create L297-318) | ○ |
| C-82 | 設定が正しくセットされること | E-08 (set L167-179) | ○ |
| C-83 | 不正な設定値で例外がスローされること | E-08 (set L172-175) | ○ |
| C-84 | 特定の設定がリセットされること | E-08 (reset(key) L181-192) | ○ |
| C-85 | 全ての設定がリセットされること | E-08 (reset() L194-200) | ○ |
| C-86 | StatementSet状態が有効になること | E-08 (enableStatementSet L224-226) | ○ |
| C-87 | StatementSet状態が無効になること | E-08 (disableStatementSet L228-231) | ○ |
| C-88 | リソースが正しく解放されること | E-08 (close L256-291) | ○ |

### DefaultContext クラス (UT-SGW-089 ~ UT-SGW-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | DefaultContextが正しく初期化されること | E-09 (コンストラクタ L54-61) | ○ |
| C-90 | デフォルトコンテキストがロードされること | E-09 (load L139-173) | ○ |
| C-91 | 不正な設定でロード失敗時に例外がスローされること | E-09 (load L166-168) | △ |

### ResultFetcher クラス (UT-SGW-092 ~ UT-SGW-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | TableResultからResultFetcherが作成されること | E-10 (fromTableResult L148-180) | ○ |
| C-93 | 結果リストからResultFetcherが作成されること | E-10 (fromResults L182-195) | ○ |
| C-94 | 現在のトークンで結果がフェッチできること | E-10 (fetchResults L258-371) | ○ |
| C-95 | 前のトークンで結果が再取得できること | E-10 (fetchResults L324-351) | ○ |
| C-96 | 不正なトークンで例外がスローされること | E-10 (fetchResults L352-370) | ○ |
| C-97 | maxFetchSizeが0以下の場合に例外がスローされること | E-10 (fetchResults L259-261) | ○ |
| C-98 | FETCH_NEXTでの結果取得 | E-10 (fetchResults(orientation) L230-249) | ○ |
| C-99 | FETCH_PRIORでの結果取得 | E-10 (fetchResults(orientation) L230-249) | ○ |
| C-100 | ResultFetcherがクローズされること | E-10 (close L202-211) | ○ |

### ResultStore クラス (UT-SGW-101 ~ UT-SGW-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | ResultStoreが正しく初期化されること | E-11 (コンストラクタ L55-59) | ○ |
| C-102 | バッファからレコードが取得できること | E-11 (retrieveRecords L72-97) | ○ |
| C-103 | データがない場合に空のOptionalが返却されること | E-11 (retrieveRecords L92-96) | ○ |
| C-104 | データが到着するまで待機すること | E-11 (waitUntilHasData L105-115) | ○ |
| C-105 | ResultStoreがクローズされること | E-11 (close L61-70) | ○ |

### SqlGatewayRestEndpoint クラス (UT-SGW-106 ~ UT-SGW-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | SqlGatewayRestEndpointが正しく初期化されること | E-12 (コンストラクタ L82-87) | ○ |
| C-107 | 全てのハンドラーが初期化されること | E-12 (initializeHandlers L95-106) | ○ |
| C-108 | エンドポイントが起動されること | E-12 (startInternal L272-274) | ○ |
| C-109 | エンドポイントが停止されること | E-12 (stop L277-280) | ○ |

### EmbeddedQuartzScheduler クラス (UT-SGW-110 ~ UT-SGW-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | スケジューラーが正常に起動すること | E-13 (start L102-114) | ○ |
| C-111 | スケジューラーが正常に停止すること | E-13 (stop L116-123) | ○ |
| C-112 | ワークフローが正常に作成されること | E-13 (createScheduleWorkflow L125-181) | ○ |
| C-113 | 既存のワークフローがある場合に例外がスローされること | E-13 (createScheduleWorkflow L133-142) | ○ |
| C-114 | ワークフローが正常に一時停止されること | E-13 (suspendScheduleWorkflow L183-201) | ○ |
| C-115 | 存在しないワークフローの一時停止で例外がスローされること | E-13 (suspendScheduleWorkflow L188-191) | ○ |
| C-116 | ワークフローが正常に再開されること（dynamicOptions空） | E-13 (resumeScheduleWorkflow L217-266) | ○ |
| C-117 | dynamicOptionsありでワークフローが再作成されること | E-13 (resumeScheduleWorkflow L231-258) | ○ |
| C-118 | ワークフローが正常に削除されること | E-13 (deleteScheduleWorkflow L268-281) | ○ |

### EmbeddedRefreshHandler クラス (UT-SGW-119 ~ UT-SGW-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | EmbeddedRefreshHandlerが正しく初期化されること | E-14 (コンストラクタ L36-39) | ○ |
| C-120 | サマリー文字列が正しく生成されること | E-14 (asSummaryString L42-45) | ○ |
| C-121 | 同じ内容のオブジェクトが等しいと判定されること | E-14 (equals L55-66) | ○ |
| C-122 | 異なる内容のオブジェクトが等しくないと判定されること | E-14 (equals L55-66) | ○ |

### MaterializedTableManager クラス (UT-SGW-123 ~ UT-SGW-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | MaterializedTableManagerが正しく初期化されること | E-15 (コンストラクタ L132-137) | ○ |
| C-124 | マネージャーがオープンされること | E-15 (open L155-159) | ○ |
| C-125 | マネージャーがクローズされること | E-15 (close L161-165) | ○ |
| C-126 | CreateMaterializedTableOperationが実行されること | E-15 (callMaterializedTableOperation L167-194) | ○ |
| C-127 | AlterMaterializedTableRefreshOperationが実行されること | E-15 (callMaterializedTableOperation L174-175) | ○ |
| C-128 | AlterMaterializedTableSuspendOperationが実行されること | E-15 (callMaterializedTableOperation L176-178) | ○ |
| C-129 | AlterMaterializedTableResumeOperationが実行されること | E-15 (callMaterializedTableOperation L179-181) | ○ |
| C-130 | DropMaterializedTableOperationが実行されること | E-15 (callMaterializedTableOperation L182-184) | ○ |
| C-131 | 未サポートのオペレーションで例外がスローされること | E-15 (callMaterializedTableOperation L190-193) | ○ |
| C-132 | マテリアライズドテーブルがリフレッシュされること | E-15 (refreshMaterializedTable L606-689) | ○ |
| C-133 | パーティションスペックに未知のキーがある場合に例外がスローされること | E-15 (validatePartitionSpec L739-779) | ○ |
| C-134 | INSERT文が正しく生成されること | E-15 (getInsertStatement L1185-1194) | ○ |
| C-135 | dynamicOptionsありでINSERT文が正しく生成されること | E-15 (generateTableWithDynamicOptions L1196-1209) | ○ |
| C-136 | リフレッシュ用INSERT OVERWRITE文が正しく生成されること | E-15 (getRefreshStatement L782-807) | ○ |
| C-137 | パーティション指定ありでリフレッシュ用INSERT OVERWRITE文が正しく生成されること | E-15 (getRefreshStatement L794-804) | ○ |
| C-138 | ヘルプオプションがパースされること | E-16 (parseSqlGatewayOptions L55-65) | ○ |
| C-139 | 動的プロパティがパースされること | E-16 (parseSqlGatewayOptions L55-65) | ○ |
| C-140 | 不正な引数で例外がスローされること | E-16 (parseSqlGatewayOptions L62-64) | ○ |
| C-141 | ヘルプが出力されること | E-16 (printHelpSqlGateway L72-76) | ○ |
| C-142 | 定期リフレッシュ用パーティションが計算されること | E-15 (getPeriodRefreshPartition L692-737) | ○ |
| C-143 | scheduleTimeがnullの場合に例外がスローされること | E-15 (getPeriodRefreshPartition L698-703) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-28 (UT-SGW-028)**: deployScriptメソッドの両方null時の挙動は実装コードで確認済みだが、実際のテスト環境での検証が望ましい
  - 候補：統合テスト / 既存のテストコード参照 / 実行環境での検証
- **C-91 (UT-SGW-091)**: DefaultContext.loadの異常系は設定ファイルの有無に依存するため、環境依存のテストとなる
  - 候補：テスト用設定ファイル / モックを使用した検証
- **C-143 (UT-SGW-143)**: getPeriodRefreshPartitionの内部ロジックは静的メソッドであり、単体テストで直接検証可能だが、実際の運用環境での検証が望ましい
  - 候補：統合テスト / エンドツーエンドテスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース - ソースコードから直接導出された明確なテスト仕様
- **1 (中リスク)**: セッションタイムアウト関連テスト (UT-SGW-037, 038) - タイミング依存のため、テスト実行時の不安定性の可能性
- **1 (中リスク)**: クラスタ操作関連テスト (UT-SGW-078, 079, 080) - 外部システム依存のため、モックまたはテスト環境が必要
- **2 (高リスク)**: MaterializedTableManager関連テスト - 複雑なワークフローを含むため、統合テストでの検証が重要

## 6) レビュアーチェックリスト（最小）
- [ ] SqlGateway/SqlGatewayServiceImplのセッション管理テストが適切にカバーされているか確認
- [ ] OperationManagerの状態遷移テストが全てのステータスを網羅しているか確認
- [ ] ResultFetcherのトークンベースのフェッチングテストの境界値が適切か確認
- [ ] EmbeddedQuartzSchedulerのワークフロー操作テストが並行実行を考慮しているか確認
- [ ] MaterializedTableManagerの各オペレーションタイプに対するテストが網羅的か確認
- [ ] 異常系テストケースのエラーメッセージ検証が適切に設計されているか確認
- [ ] 外部依存（クラスタ、ファイルシステム等）のモック化方針を確認
