---
generated_at: 2026-02-02 18:35:00
metrics:
  claims_total: 187
  claims_with_evidence: 187
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: flink-table_flink-sql-jdbc-driver 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：187 / 187、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全テストケースにソースコードの根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/FlinkDriver.java`
- E-02: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/FlinkConnection.java`
- E-03: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/FlinkStatement.java`
- E-04: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/FlinkResultSet.java`
- E-05: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/FlinkDataSource.java`
- E-06: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/FlinkDatabaseMetaData.java`
- E-07: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/FlinkResultSetMetaData.java`
- E-08: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/DriverUri.java`
- E-09: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/ColumnInfo.java`
- E-10: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/DriverInfo.java`
- E-11: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/BaseResultSet.java`
- E-12: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/BaseConnection.java`
- E-13: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/BaseStatement.java`
- E-14: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/BaseDatabaseMetaData.java`
- E-15: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/utils/DriverUtils.java`
- E-16: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/utils/DatabaseMetaDataUtils.java`
- E-17: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/utils/CollectionResultIterator.java`
- E-18: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/utils/StatementResultIterator.java`
- E-19: `flink-table/flink-sql-jdbc-driver/src/main/java/org/apache/flink/table/jdbc/utils/CloseableResultIterator.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### FlinkDriver (UT-JDB-001 ~ UT-JDB-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | connect()でFlinkConnectionが作成される | E-01 L53-55 | ○ |
| C-02 | acceptsURL()でURL検証が行われる | E-01 L58-60, E-08 L195-197 | ○ |
| C-03 | getMajorVersion()でメジャーバージョン取得 | E-01 L72-75, E-10 | ○ |
| C-04 | getMinorVersion()でマイナーバージョン取得 | E-01 L82-85, E-10 | ○ |
| C-05 | jdbcCompliant()はfalseを返す | E-01 L87-90 | ○ |
| C-06 | getParentLogger()は例外スロー | E-01 L93-96 | ○ |

### FlinkConnection (UT-JDB-009 ~ UT-JDB-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | コンストラクタでExecutor初期化 | E-02 L56-69 | ○ |
| C-08 | createStatement()でFlinkStatement作成 | E-02 L78-84 | ○ |
| C-09 | close()で全Statementクローズ | E-02 L110-127 | ○ |
| C-10 | setCatalog()でUSE CATALOG実行 | E-02 L141-152 | ○ |
| C-11 | getCatalog()でSHOW CURRENT CATALOG実行 | E-02 L155-166 | ○ |
| C-12 | setSchema()でUSE実行 | E-02 L221-232 | ○ |
| C-13 | getSchema()でSHOW CURRENT DATABASE実行 | E-02 L235-246 | ○ |
| C-14 | setClientInfo()でSET実行 | E-02 L188-195 | ○ |
| C-15 | getClientInfo()でセッション設定取得 | E-02 L205-218 | ○ |
| C-16 | getAutoCommit()はtrueを返す | E-02 L94-96 | ○ |
| C-17 | getTransactionIsolation()はTRANSACTION_NONE | E-02 L176-178 | ○ |

### FlinkStatement (UT-JDB-029 ~ UT-JDB-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | executeQuery()でResultSet返却 | E-03 L57-67 | ○ |
| C-19 | execute()でクエリ/非クエリ判定 | E-03 L121-131 | ○ |
| C-20 | close()でcurrentResultsクローズ | E-03 L78-86 | ○ |
| C-21 | cancel()でclearCurrentResults | E-03 L89-92 | ○ |
| C-22 | getResultSet()でnullチェック | E-03 L141-152 | ○ |
| C-23 | getMoreResults()で複数結果未サポート | E-03 L155-164 | ○ |
| C-24 | getUpdateCount()でhasResults判定 | E-03 L167-174 | ○ |

### FlinkResultSet (UT-JDB-048 ~ UT-JDB-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | next()でイテレータ進行 | E-04 L100-111 | ○ |
| C-26 | getString()で列インデックス検証 | E-04 L128-141 | ○ |
| C-27 | getBoolean()でnull時false | E-04 L179-188 | ○ |
| C-28 | getInt()でnull時0 | E-04 L215-224 | ○ |
| C-29 | getBigDecimal()でDecimalType検証 | E-04 L475-501 | ○ |
| C-30 | getObject()で型変換 | E-04 L374-462 | ○ |
| C-31 | close()でiterator.close() | E-04 L144-155 | ○ |
| C-32 | wasNull()でnull判定 | E-04 L158-162 | ○ |

### FlinkDataSource (UT-JDB-090 ~ UT-JDB-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | getConnection()でFlinkConnection作成 | E-05 L41-43 | ○ |
| C-34 | getConnection(user,pass)で例外スロー | E-05 L46-49 | ○ |
| C-35 | unwrap/isWrapperFor未サポート | E-05 L52-59 | ○ |

### FlinkDatabaseMetaData (UT-JDB-095 ~ UT-JDB-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | getCatalogs()でSHOW CATALOGS実行 | E-06 L55-65 | ○ |
| C-37 | getSchemas()でカタログ毎にデータベース取得 | E-06 L68-107 | ○ |
| C-38 | isReadOnly()はtrueを返す | E-06 L206-208 | ○ |
| C-39 | nullsAreSortedLow()はtrueを返す | E-06 L217-219 | ○ |
| C-40 | supportsMixedCaseIdentifiers()はtrue | E-06 L363-365 | ○ |
| C-41 | getIdentifierQuoteString()はバッククォート | E-06 L406-408 | ○ |
| C-42 | supportsTransactions()はfalse | E-06 L698-700 | ○ |

### FlinkResultSetMetaData (UT-JDB-108 ~ UT-JDB-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | getColumnCount()で列数取得 | E-07 L52-54 | ○ |
| C-44 | getColumnName()で列名取得 | E-07 L105-108 | ○ |
| C-45 | checkIndexBound()で範囲検証 | E-07 L190-201 | ○ |
| C-46 | getColumnType()でSQL型取得 | E-07 L141-144 | ○ |
| C-47 | getColumnClassName()でクラス名取得 | E-07 L171-173, L209-255 | ○ |

### DriverUri (UT-JDB-121 ~ UT-JDB-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | create()でURL解析 | E-08 L50-60, L166-193 | ○ |
| C-49 | カタログ・データベースパス解析 | E-08 L82-117 | ○ |
| C-50 | クエリパラメータ解析 | E-08 L143-164 | ○ |
| C-51 | ポート範囲検証 | E-08 L189-191 | ○ |
| C-52 | acceptsURL()でプレフィックス確認 | E-08 L195-197 | ○ |
| C-53 | プロパティ重複検証 | E-08 L119-135 | ○ |

### ColumnInfo (UT-JDB-143 ~ UT-JDB-164)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | fromLogicalType()で各型変換 | E-09 L126-222 | ○ |
| C-55 | 未サポート型でRuntimeException | E-09 L218-220 | ○ |
| C-56 | アクセサメソッド | E-09 L87-118 | ○ |

### DriverUtils (UT-JDB-165 ~ UT-JDB-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | checkNotNull()でnull検証 | E-15 L41-46 | ○ |
| C-58 | checkArgument()で条件検証 | E-15 L58-62 | ○ |
| C-59 | isNullOrWhitespaceOnly()で空白検証 | E-15 L71-83 | ○ |
| C-60 | fromProperties()でMap生成 | E-15 L91-101 | ○ |

### DatabaseMetaDataUtils (UT-JDB-175 ~ UT-JDB-178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | createCatalogsResultSet()でResultSet作成 | E-16 L60-70 | ○ |
| C-62 | createSchemasResultSet()でResultSet作成 | E-16 L87-107 | ○ |
| C-63 | ソート処理 | E-16 L64, L91, L94 | ○ |

### CollectionResultIterator (UT-JDB-179 ~ UT-JDB-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | Iterator操作委譲 | E-17 L37-44 | ○ |
| C-65 | close()は何もしない | E-17 L34 | ○ |

### StatementResultIterator (UT-JDB-184 ~ UT-JDB-187)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | StatementResult操作委譲 | E-18 L37-44 | ○ |
| C-67 | close()でresult.close()呼び出し | E-18 L33-35 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースがソースコードの実装に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコードの根拠あり
- 注意点：
  - 一部メソッドは外部依存（Executor、StatementResult）のモック化が必要
  - 統合テスト観点の検証は本単体テストでは対象外

## 6) レビュアーチェックリスト（最小）
- [ ] FlinkDriver: connect()でDriverUri解析エラー時のエラーメッセージが適切か
- [ ] FlinkConnection: close()時のExecutor例外処理が適切か
- [ ] FlinkStatement: executeQuery()で非クエリ文時のリソース解放が行われているか
- [ ] FlinkResultSet: getObject()の型変換網羅性（MAP、TIMESTAMP等）
- [ ] DriverUri: ポート境界値(0, 65536)のテストが網羅されているか
- [ ] ColumnInfo: 全LogicalType型の変換テストが存在するか
- [ ] DatabaseMetaDataUtils: ソート処理の安定性テスト
