---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: flink-table_flink-sql-parser 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースはソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/SqlConstraintValidator.java`
- E-02: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/SqlParseUtils.java`
- E-03: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/SqlUnparseUtils.java`
- E-04: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/SqlProperty.java`
- E-05: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/validate/FlinkSqlConformance.java`
- E-06: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/FlinkSqlParsingValidator.java`
- E-07: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/ddl/table/SqlCreateTable.java`
- E-08: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/ddl/SqlTableColumn.java`
- E-09: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/ddl/constraint/SqlTableConstraint.java`
- E-10: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/dml/RichSqlInsert.java`
- E-11: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/dql/SqlShowCall.java`
- E-12: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/dql/SqlShowTables.java`
- E-13: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/ddl/SqlWatermark.java`
- E-14: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/ddl/SqlDistribution.java`
- E-15: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/type/SqlMapTypeNameSpec.java`
- E-16: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/type/SqlRawTypeNameSpec.java`
- E-17: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/error/SqlValidateException.java`
- E-18: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/SqlPartitionSpecProperty.java`
- E-19: `flink-table/flink-sql-parser/src/main/java/org/apache/flink/sql/parser/ExtendedSqlNode.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SqlConstraintValidator (C-01 〜 C-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getFullConstraints正常系：テーブル制約とカラム制約の結合 | E-01 (L39-53) | ○ |
| C-02 | getFullConstraints境界値：空テーブル制約の処理 | E-01 (L41-52) | ○ |
| C-03 | getFullConstraints境界値：空カラムリストの処理 | E-01 (L42-51) | ○ |
| C-04 | validateAndChangeColumnNullability正常系：主キー列のnullability変更 | E-01 (L61-88) | ○ |
| C-05 | validateAndChangeColumnNullability異常系：重複主キー検出 | E-01 (L65-68) | ○ |
| C-06 | validate異常系：UNIQUE制約の検出 | E-01 (L93-96) | ○ |
| C-07 | validate異常系：ENFORCED制約の検出 | E-01 (L97-103) | ○ |
| C-08 | validate正常系：NOT ENFORCED主キー検証 | E-01 (L92-104) | ○ |

### SqlParseUtils (C-09 〜 C-18)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | getPartitionKVs正常系：パーティション仕様のMap変換 | E-02 (L55-69) | ○ |
| C-10 | getPartitionKVs異常系：null入力処理 | E-02 (L56-58) | ○ |
| C-11 | getPartitionKVs境界値：空リスト処理 | E-02 (L60-62) | ○ |
| C-12 | extractString(SqlLiteral)正常系：文字列抽出 | E-02 (L72-74) | ○ |
| C-13 | extractString(SqlLiteral)異常系：null処理 | E-02 (L72-73) | ○ |
| C-14 | extractString(SqlNode)正常系：汎用文字列抽出 | E-02 (L77-86) | ○ |
| C-15 | extractMap正常系：プロパティマップ抽出 | E-02 (L88-101) | ○ |
| C-16 | extractMap境界値：null入力処理 | E-02 (L89-91) | ○ |
| C-17 | extractList正常系：リスト抽出 | E-02 (L103-109) | ○ |
| C-18 | extractSet正常系：セット抽出 | E-02 (L111-117) | ○ |

### SqlUnparseUtils (C-19 〜 C-28)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | unparseTableSchema正常系：テーブルスキーマunparse | E-03 (L41-73) | ○ |
| C-20 | unparseTableSchema境界値：空スキーマ処理 | E-03 (L48-50) | ○ |
| C-21 | printIndent正常系：インデント出力 | E-03 (L75-79) | ○ |
| C-22 | unparseDistribution正常系：Distribution unparse | E-03 (L81-88) | ○ |
| C-23 | unparseDistribution境界値：null処理 | E-03 (L83-85) | ○ |
| C-24 | unparsePartitionKeyList正常系：パーティションキーunparse | E-03 (L90-100) | ○ |
| C-25 | unparsePartitionKeyList境界値：空リスト処理 | E-03 (L92-94) | ○ |
| C-26 | unparseFreshness正常系：Freshness unparse | E-03 (L102-117) | ○ |
| C-27 | unparseComment正常系：コメントunparse | E-03 (L129-143) | ○ |
| C-28 | unparseProperties正常系：プロパティunparse | E-03 (L170-177) | ○ |

### SqlProperty (C-29 〜 C-36)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | constructor正常系：SqlProperty生成 | E-04 (L46-50) | ○ |
| C-30 | constructor異常系：キーnull検証 | E-04 (L48) | ○ |
| C-31 | constructor異常系：値null検証 | E-04 (L49) | ○ |
| C-32 | getKey正常系：キー取得 | E-04 (L52-54) | ○ |
| C-33 | getValue正常系：値取得 | E-04 (L56-58) | ○ |
| C-34 | getKeyString正常系：キー文字列取得 | E-04 (L60-62) | ○ |
| C-35 | getValueString正常系：値文字列取得 | E-04 (L64-66) | ○ |
| C-36 | unparse正常系：プロパティunparse | E-04 (L79-83) | ○ |

### FlinkSqlConformance (C-37 〜 C-41)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | isSortByOrdinal正常系：true返却 | E-05 (L56-58) | ○ |
| C-38 | isSortByAlias正常系：true返却 | E-05 (L61-63) | ○ |
| C-39 | isPercentRemainderAllowed正常系：true返却 | E-05 (L91-93) | ○ |
| C-40 | allowNiladicParentheses正常系：true返却 | E-05 (L121-123) | ○ |
| C-41 | isValueAllowed正常系：true返却 | E-05 (L181-183) | ○ |

### FlinkSqlParsingValidator (C-42 〜 C-43)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | constructor正常系：バリデータ生成 | E-06 (L33-41) | ○ |
| C-43 | isLegacyNestedRowNullability正常系：設定値取得 | E-06 (L43-45) | ○ |

### SqlCreateTable (C-44 〜 C-56)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | constructor正常系：CREATE TABLE生成 | E-07 (L69-95) | ○ |
| C-45 | constructor異常系：columnList null検証 | E-07 (L112) | ○ |
| C-46 | getColumnList正常系：カラムリスト取得 | E-07 (L134-136) | ○ |
| C-47 | getDistribution正常系：Distribution取得 | E-07 (L138-140) | ○ |
| C-48 | getPartitionKeyList正常系：パーティションキー取得 | E-07 (L142-144) | ○ |
| C-49 | getTableConstraints正常系：制約取得 | E-07 (L146-148) | ○ |
| C-50 | getWatermark正常系：ウォーターマーク取得 | E-07 (L150-152) | ○ |
| C-51 | getWatermark境界値：未設定時のOptional.empty | E-07 (L151) | ○ |
| C-52 | validate正常系：有効DDL検証 | E-07 (L160-162) | ○ |
| C-53 | validate異常系：重複主キー検出 | E-07 (L161), E-01 (L65-68) | ○ |
| C-54 | getFullConstraints正常系：全制約取得 | E-07 (L165-167) | ○ |
| C-55 | getColumnSqlString正常系：カラムSQL生成 | E-07 (L186-207) | ○ |
| C-56 | unparse正常系：DDL unparse | E-07 (L210-218) | ○ |

### SqlTableColumn (C-57 〜 C-75)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | SqlRegularColumn constructor正常系 | E-08 (L95-104) | ○ |
| C-58 | SqlRegularColumn constructor異常系：name null検証 | E-08 (L57) | ○ |
| C-59 | SqlRegularColumn getType正常系 | E-08 (L106-108) | ○ |
| C-60 | SqlRegularColumn setType正常系 | E-08 (L110-112) | ○ |
| C-61 | SqlRegularColumn getConstraint正常系 | E-08 (L114-116) | ○ |
| C-62 | SqlRegularColumn getConstraint境界値 | E-08 (L115) | ○ |
| C-63 | SqlRegularColumn unparseColumn正常系 | E-08 (L119-128) | ○ |
| C-64 | SqlMetadataColumn constructor正常系 | E-08 (L145-156) | ○ |
| C-65 | SqlMetadataColumn getType正常系 | E-08 (L158-160) | ○ |
| C-66 | SqlMetadataColumn getMetadataAlias正常系 | E-08 (L162-164) | ○ |
| C-67 | SqlMetadataColumn isVirtual正常系 | E-08 (L166-168) | ○ |
| C-68 | SqlMetadataColumn unparseColumn正常系 | E-08 (L171-185) | ○ |
| C-69 | SqlComputedColumn constructor正常系 | E-08 (L198-205) | ○ |
| C-70 | SqlComputedColumn constructor異常系：expr null検証 | E-08 (L204) | ○ |
| C-71 | SqlComputedColumn getExpr正常系 | E-08 (L207-209) | ○ |
| C-72 | SqlComputedColumn unparseColumn正常系 | E-08 (L212-215) | ○ |
| C-73 | SqlTableColumn getName正常系 | E-08 (L80-82) | ○ |
| C-74 | SqlTableColumn getComment正常系 | E-08 (L84-86) | ○ |
| C-75 | SqlTableColumn unparse正常系 | E-08 (L69-78) | ○ |

### SqlTableConstraint (C-76 〜 C-86)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | constructor正常系：制約生成 | E-09 (L82-95) | ○ |
| C-77 | isUnique正常系：UNIQUE判定 | E-09 (L103-105) | ○ |
| C-78 | isPrimaryKey正常系：PRIMARY KEY判定 | E-09 (L108-110) | ○ |
| C-79 | isEnforced正常系：ENFORCED判定 | E-09 (L113-118) | ○ |
| C-80 | isEnforced境界値：デフォルトENFORCED | E-09 (L115-116) | ○ |
| C-81 | getConstraintName正常系：制約名取得 | E-09 (L120-123) | ○ |
| C-82 | getConstraintName境界値：未設定時 | E-09 (L121-122) | ○ |
| C-83 | getColumns正常系：カラム取得 | E-09 (L129-131) | ○ |
| C-84 | isTableConstraint正常系：フラグ取得 | E-09 (L133-135) | ○ |
| C-85 | getColumnNames正常系：カラム名配列取得 | E-09 (L138-142) | ○ |
| C-86 | unparse正常系：制約unparse | E-09 (L150-167) | ○ |

### RichSqlInsert (C-87 〜 C-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | constructor正常系：INSERT生成 | E-10 (L54-94) | ○ |
| C-88 | getStaticPartitions正常系：静的パーティション取得 | E-10 (L100-102) | ○ |
| C-89 | getStaticPartitionKVs正常系：パーティションKV取得 | E-10 (L114-125) | ○ |
| C-90 | getStaticPartitionKVs境界値：空パーティション | E-10 (L116-118) | ○ |
| C-91 | getTargetTableID正常系：ターゲットテーブル取得 | E-10 (L128-130) | ○ |
| C-92 | getTableHints正常系：テーブルヒント取得 | E-10 (L133-135) | ○ |
| C-93 | getConflictStrategy正常系：コンフリクト戦略取得 | E-10 (L142-147) | ○ |
| C-94 | getConflictStrategy境界値：未設定時 | E-10 (L143-145) | ○ |
| C-95 | isOverwrite正常系：OVERWRITE判定 | E-10 (L198-200) | ○ |
| C-96 | isOverwrite正常系：非OVERWRITE判定 | E-10 (L198-200) | ○ |
| C-97 | isUpsert正常系：UPSERT判定 | E-10 (L183-191) | ○ |
| C-98 | unparse正常系：INSERT INTO unparse | E-10 (L150-179) | ○ |
| C-99 | unparse正常系：INSERT OVERWRITE unparse | E-10 (L154-156) | ○ |
| C-100 | unparse正常系：UPSERT INTO unparse | E-10 (L153-154) | ○ |

### SqlShowCall (C-101 〜 C-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | constructor正常系：SHOWコマンド生成 | E-11 (L42-55) | ○ |
| C-102 | getPreposition正常系：前置詞取得 | E-11 (L82-84) | ○ |
| C-103 | getSqlIdentifierNameList正常系：識別子名リスト取得 | E-11 (L86-88) | ○ |
| C-104 | getSqlIdentifierNameList境界値：未設定時 | E-11 (L87) | ○ |
| C-105 | isWithLike正常系：LIKE有無判定 | E-11 (L90-92) | ○ |
| C-106 | getLikeType正常系：LIKEタイプ取得 | E-11 (L94-96) | ○ |
| C-107 | getLikeSqlPattern正常系：LIKEパターン取得 | E-11 (L98-100) | ○ |
| C-108 | isNotLike正常系：NOT LIKE判定 | E-11 (L102-104) | ○ |
| C-109 | unparse正常系：SHOW unparse | E-11 (L68-80) | ○ |

### SqlShowTables (C-110 〜 C-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | constructor正常系：SHOW TABLES生成 | E-12 (L40-56) | ○ |
| C-111 | getOperator正常系：オペレータ取得 | E-12 (L59-61) | ○ |
| C-112 | getTableKind正常系：テーブル種別取得 | E-12 (L68-70) | ○ |

### SqlWatermark (C-113 〜 C-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | constructor正常系：ウォーターマーク生成 | E-13 (L47-52) | ○ |
| C-114 | constructor異常系：eventTimeColumnName null検証 | E-13 (L50) | ○ |
| C-115 | getEventTimeColumnName正常系 | E-13 (L73-75) | ○ |
| C-116 | getWatermarkStrategy正常系 | E-13 (L77-79) | ○ |
| C-117 | unparse正常系：ウォーターマークunparse | E-13 (L65-71) | ○ |

### SqlDistribution (C-118 〜 C-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | constructor正常系：分散定義生成 | E-14 (L51-59) | ○ |
| C-119 | getDistributionKind正常系：分散種別取得 | E-14 (L97-99) | ○ |
| C-120 | getDistributionKind境界値：未設定時 | E-14 (L98) | ○ |
| C-121 | getBucketCount正常系：バケット数取得 | E-14 (L101-103) | ○ |
| C-122 | getBucketColumns正常系：バケットカラム取得 | E-14 (L105-107) | ○ |
| C-123 | unparse正常系：分散定義unparse | E-14 (L68-95) | ○ |
| C-124 | unparse境界値：カラムなし分散定義 | E-14 (L77-82) | ○ |
| C-125 | unparseAlter正常系：ALTER用unparse | E-14 (L72-74) | ○ |

### SqlMapTypeNameSpec (C-126 〜 C-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | constructor正常系：MAP型生成 | E-15 (L49-53) | ○ |
| C-127 | getKeyType正常系：キー型取得 | E-15 (L55-57) | ○ |
| C-128 | getValType正常系：値型取得 | E-15 (L59-61) | ○ |
| C-129 | deriveType正常系：型導出 | E-15 (L64-68) | ○ |
| C-130 | unparse正常系：MAP型unparse | E-15 (L71-87) | ○ |
| C-131 | equalsDeep正常系：等価判定 | E-15 (L90-102) | ○ |
| C-132 | equalsDeep正常系：不等価判定 | E-15 (L90-102) | ○ |

### SqlRawTypeNameSpec (C-133 〜 C-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | constructor正常系：RAW型生成 | E-16 (L48-52) | ○ |
| C-134 | deriveType正常系：型導出 | E-16 (L55-61) | ○ |
| C-135 | unparse正常系：RAW型unparse | E-16 (L64-72) | ○ |
| C-136 | equalsDeep正常系：等価判定 | E-16 (L75-87) | ○ |
| C-137 | equalsDeep正常系：不等価判定 | E-16 (L75-87) | ○ |

### その他 (C-138 〜 C-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | SqlValidateException constructor正常系 | E-17 | ○ |
| C-139 | SqlPartitionSpecProperty constructor正常系 | E-18 | ○ |
| C-140 | ExtendedSqlNode validate正常系 | E-19 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに明確な根拠があります
- 注意点：
  - flink-sql-parserモジュールは159個のJavaファイルを含む大規模モジュールです
  - 本テストケース一覧は主要クラスの代表的なメソッドをカバーしていますが、全ファイル・全メソッドを網羅しているわけではありません
  - DDL/DML/DQL関連の拡張クラス（ddl/connection/, ddl/catalog/, ddl/materializedtable/等）は、類似パターンのため代表的なクラスでカバーしています

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（UT-SQP-XXX）の命名規則が一貫しているか確認
- [ ] 各テストケースの前提条件と期待結果が明確か確認
- [ ] 優先度（高/中/低）の割り当てが適切か確認
- [ ] 正常系・異常系・境界値の観点が網羅されているか確認
- [ ] SqlConstraintValidatorの重複主キー検出テストが重要なため優先レビュー
- [ ] RichSqlInsertのOVERWRITE/UPSERTモード判定テストが重要なため優先レビュー
- [ ] SqlCreateTableのvalidateメソッドが適切にカバーされているか確認
