---
generated_at: 2026-02-02 18:40:00
metrics:
  claims_total: 64
  claims_with_evidence: 64
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: flink-table_flink-table-api-bridge-base 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：64 / 64、根拠なし：0
- 優先レビュー（高）
  1. **テストID UT-TAB-030〜032（lookupExecutor）**: ExecutorFactory検索ロジックの複雑な分岐をカバー
  2. **テストID UT-TAB-033〜039（fromStreamInternal）**: DataStream→Table変換の主要ロジック
  3. **テストID UT-TAB-057〜059（validateTimeCharacteristic）**: rowtimeとウォーターマーク間隔の検証ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-table/flink-table-api-bridge-base/src/main/java/org/apache/flink/table/operations/ExternalQueryOperation.java`
- E-02: `flink-table/flink-table-api-bridge-base/src/main/java/org/apache/flink/table/operations/DataStreamQueryOperation.java`
- E-03: `flink-table/flink-table-api-bridge-base/src/main/java/org/apache/flink/table/delegation/StreamExecutorFactory.java`
- E-04: `flink-table/flink-table-api-bridge-base/src/main/java/org/apache/flink/table/api/bridge/internal/AbstractStreamTableEnvironmentImpl.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ExternalQueryOperation.java (UT-TAB-001〜013)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExternalQueryOperationコンストラクタで5つのパラメータを受け取る | E-01（49-60行目） | ○ |
| C-02 | getContextResolvedTable()がcontextResolvedTableを返却する | E-01（62-64行目） | ○ |
| C-03 | getDataStream()がdataStreamを返却する | E-01（66-68行目） | ○ |
| C-04 | getPhysicalDataType()がphysicalDataTypeを返却する | E-01（70-72行目） | ○ |
| C-05 | isTopLevelRecord()がisTopLevelRecordフラグを返却する | E-01（74-76行目） | ○ |
| C-06 | getChangelogMode()がchangelogModeを返却する | E-01（78-80行目） | ○ |
| C-07 | asSummaryString()がLinkedHashMapを使用してフォーマット文字列を生成する | E-01（82-94行目） | ○ |
| C-08 | getChildren()が空リストを返却する | E-01（96-99行目） | ○ |
| C-09 | getResolvedSchema()がcontextResolvedTable.getResolvedSchema()を呼び出す | E-01（101-104行目） | ○ |
| C-10 | accept()がビジターパターンを実装する | E-01（106-109行目） | ○ |

### DataStreamQueryOperation.java (UT-TAB-014〜026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | DataStreamQueryOperationに3引数コンストラクタが存在し、identifierがnullになる | E-02（59-62行目） | ○ |
| C-12 | DataStreamQueryOperationに4引数コンストラクタが存在する | E-02（64-73行目） | ○ |
| C-13 | identifierフィールドは@Nullableアノテーションが付与されている | E-02（53行目） | ○ |
| C-14 | getDataStream()がdataStreamを返却する | E-02（75-77行目） | ○ |
| C-15 | getIdentifier()がOptional.ofNullable(identifier)を返却する | E-02（79-81行目） | ○ |
| C-16 | getFieldIndices()がfieldIndicesを返却する | E-02（83-85行目） | ○ |
| C-17 | getResolvedSchema()がresolvedSchemaを返却する | E-02（87-90行目） | ○ |
| C-18 | asSummaryString()でidentifier有無により出力が分岐する | E-02（92-104行目） | ○ |
| C-19 | getChildren()が空リストを返却する | E-02（106-109行目） | ○ |
| C-20 | accept()がビジターパターンを実装する | E-02（111-114行目） | ○ |

### StreamExecutorFactory.java (UT-TAB-027〜028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | StreamExecutorFactoryはExecutorFactoryを継承するインターフェース | E-03（28行目） | ○ |
| C-22 | create(StreamExecutionEnvironment)メソッドが定義されている | E-03（36行目） | ○ |

### AbstractStreamTableEnvironmentImpl.java (UT-TAB-029〜064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | AbstractStreamTableEnvironmentImplはTableEnvironmentImplを継承する | E-04（75行目） | ○ |
| C-24 | executionEnvironmentフィールドをprotectedで保持する | E-04（77行目） | ○ |
| C-25 | lookupExecutor()でFactoryUtil.discoverFactoryを使用する | E-04（104-107行目） | ○ |
| C-26 | lookupExecutor()でStreamExecutorFactoryの型チェックを行う | E-04（113-120行目） | ○ |
| C-27 | fromStreamInternal()でPreconditions.checkNotNullを使用してnull検証を行う | E-04（128-129行目） | ○ |
| C-28 | fromStreamInternal()でDataStreamのexecutionEnvironmentの同一性を検証する | E-04（131-135行目） | ○ |
| C-29 | fromStreamInternal()でSchemaTranslatorを使用してスキーマ変換を行う | E-04（140-142行目） | ○ |
| C-30 | fromStreamInternal()でviewPathの有無により処理が分岐する | E-04（148-158行目） | ○ |
| C-31 | fromStreamInternal()でExternalQueryOperationを生成する | E-04（160-166行目） | ○ |
| C-32 | fromStreamInternal()でプロジェクションの有無により処理が分岐する | E-04（168-180行目） | ○ |
| C-33 | toStreamInternal(5引数)でExternalModifyOperationを生成する | E-04（207-219行目） | ○ |
| C-34 | toStreamInternal(2引数)でplanner.translateを呼び出す | E-04（225-226行目） | ○ |
| C-35 | toStreamInternal(2引数)でtransformationsのサイズを検証する | E-04（262-271行目） | ○ |
| C-36 | toStreamInternal(2引数)でexecutionEnvironment.addOperatorを呼び出す | E-04（229行目） | ○ |
| C-37 | execEnv()がexecutionEnvironmentを返却する（Python API向け） | E-04（243-247行目） | ○ |
| C-38 | extractTypeInformation()でTypeExtractor.createTypeInfoを使用する | E-04（249-259行目） | ○ |
| C-39 | wrapWithChangeFlag()でTupleTypeInfoを生成する | E-04（274-278行目） | ○ |
| C-40 | asQueryOperation()でFieldInfoUtils.getFieldsInfoを使用する | E-04（285-296行目） | ○ |
| C-41 | asQueryOperation()でvalidateTimeCharacteristicを呼び出す | E-04（293行目） | ○ |
| C-42 | validateTimeCharacteristic()でautoWatermarkIntervalの検証を行う | E-04（302-309行目） | ○ |
| C-43 | qualifyQueryOperation()でDataStreamQueryOperationの型チェックを行う | E-04（312-324行目） | ○ |
| C-44 | attachAsDataStream()でtranslateとaddOperatorを呼び出す | E-04（326-329行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。
- すべてのテストケースはソースコードの実装を根拠としています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードの実装に基づいており、根拠が明確です。
- 注意点:
  - AbstractStreamTableEnvironmentImplは抽象クラスであるため、テスト実行時には具体的なサブクラスのモックまたは実装が必要です
  - StreamExecutorFactoryはインターフェースであるため、テスト実行時には実装クラスまたはモックが必要です
  - 外部依存（DataStream、StreamExecutionEnvironment等）のモック化が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] ExternalQueryOperationの5つのゲッターメソッドがすべてテストされているか
- [ ] DataStreamQueryOperationのOptional戻り値（getIdentifier）のテストが適切か
- [ ] lookupExecutorの3つのケース（正常、Factory見つからず、型不一致）が網羅されているか
- [ ] fromStreamInternalのnullチェック（dataStream、changelogMode）が網羅されているか
- [ ] validateTimeCharacteristicの境界値（autoWatermarkInterval=0）がテストされているか
- [ ] 非推奨（@Deprecated）のDataStreamQueryOperationに対するテストの必要性を検討しているか
