---
generated_at: 2026-02-02 18:40:00
metrics:
  claims_total: 145
  claims_with_evidence: 141
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：flink-table_flink-table-api-java-bridge 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：publicメソッド、ビジネスロジック、エッジケースを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 141 / 145 = 0.97

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で主要な検証結果を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：141 / 145、根拠なし：4
- 優先レビュー（高）
  1. **インターフェースメソッドのデフォルト実装テスト（C-142）**：実装の詳細が抽象化されている
  2. **非推奨APIの互換性テスト（C-27, C-28, C-29）**：使用方法の確認が必要
  3. **例外ハンドリングの詳細（C-18）**：具体的な例外型の確認が必要

## 2) 参照した情報（Evidence一覧）
> 以下のソースファイルを解析して根拠としました

- E-01: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/api/bridge/java/StreamTableEnvironment.java`
- E-02: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/api/bridge/java/internal/StreamTableEnvironmentImpl.java`
- E-03: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/api/bridge/java/StreamStatementSet.java`
- E-04: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/api/bridge/java/internal/StreamStatementSetImpl.java`
- E-05: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/datagen/table/DataGenTableSourceFactory.java`
- E-06: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/datagen/table/DataGenTableSource.java`
- E-07: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/print/table/PrintTableSinkFactory.java`
- E-08: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/blackhole/table/BlackHoleTableSinkFactory.java`
- E-09: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/datagen/table/RandomGeneratorVisitor.java`
- E-10: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/datagen/table/SequenceGeneratorVisitor.java`
- E-11: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/datagen/table/types/RowDataGenerator.java`
- E-12: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/sinks/CsvTableSink.java`
- E-13: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/sources/CsvTableSource.java`
- E-14: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/procedure/DefaultProcedureContext.java`
- E-15: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/descriptors/OldCsvValidator.java`
- E-16: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/connector/source/DataStreamScanProvider.java`
- E-17: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/table/connector/sink/DataStreamSinkProvider.java`
- E-18: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/datagen/table/DataGeneratorContainer.java`
- E-19: `flink-table/flink-table-api-java-bridge/src/main/java/org/apache/flink/connector/datagen/table/DataGenConnectorOptions.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### StreamTableEnvironment関連（C-01〜C-29）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamTableEnvironment.create(StreamExecutionEnvironment)が正常に動作すること | E-01, E-02 | ○ |
| C-02 | nullのStreamExecutionEnvironmentで例外がスローされること | E-01, E-02 | ○ |
| C-03 | EnvironmentSettingsを指定した作成が正常に動作すること | E-01, E-02 | ○ |
| C-04 | nullのEnvironmentSettingsで例外がスローされること | E-01, E-02 | ○ |
| C-05 | StreamTableEnvironmentImplの初期化が正常に行われること | E-02 | ○ |
| C-06 | fromDataStream(DataStream)が正常に動作すること | E-02 | ○ |
| C-07 | nullのDataStreamで例外がスローされること | E-02 | ○ |
| C-08 | fromDataStream(DataStream, Schema)が正常に動作すること | E-02 | ○ |
| C-09 | nullのSchemaで例外がスローされること | E-02 | ○ |
| C-10 | fromChangelogStream(DataStream<Row>)が正常に動作すること | E-02 | ○ |
| C-11 | fromChangelogStream(DataStream<Row>, Schema)が正常に動作すること | E-02 | ○ |
| C-12 | fromChangelogStream(DataStream<Row>, Schema, ChangelogMode)が正常に動作すること | E-02 | ○ |
| C-13 | createTemporaryView(String, DataStream)が正常に動作すること | E-02 | ○ |
| C-14 | 空のパスで例外がスローされること | E-02 | ○ |
| C-15 | createTemporaryView(String, DataStream, Schema)が正常に動作すること | E-02 | ○ |
| C-16 | toDataStream(Table)が正常に動作すること | E-02 | ○ |
| C-17 | nullのTableで例外がスローされること | E-02 | ○ |
| C-18 | 更新を含むTableでinsert-only期待時に例外がスローされること | E-02 | △ |
| C-19 | toDataStream(Table, Class)が正常に動作すること | E-02 | ○ |
| C-20 | Row.class指定時にtoDataStream(Table)と同等に動作すること | E-02 | ○ |
| C-21 | toDataStream(Table, AbstractDataType)が正常に動作すること | E-02 | ○ |
| C-22 | toChangelogStream(Table)が正常に動作すること | E-02 | ○ |
| C-23 | toChangelogStream(Table, Schema)が正常に動作すること | E-02 | ○ |
| C-24 | toChangelogStream(Table, Schema, ChangelogMode)が正常に動作すること | E-02 | ○ |
| C-25 | toChangelogStream(Table, Schema, ChangelogMode, InsertConflictStrategy)が正常に動作すること | E-02 | ○ |
| C-26 | createStatementSetが正常に動作すること | E-02 | ○ |
| C-27 | fromDataStream(DataStream, Expression...)が正常に動作すること（非推奨） | E-02 | ○ |
| C-28 | toAppendStream(Table, Class)が正常に動作すること（非推奨） | E-02 | ○ |
| C-29 | toRetractStream(Table, Class)が正常に動作すること（非推奨） | E-02 | ○ |

### StreamStatementSet関連（C-30〜C-37）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | add(TablePipeline)が正常に動作すること | E-04 | ○ |
| C-31 | addInsertSql(String)が正常に動作すること | E-04 | ○ |
| C-32 | addInsert(String, Table)が正常に動作すること | E-04 | ○ |
| C-33 | addInsert(String, Table, boolean)が正常に動作すること | E-04 | ○ |
| C-34 | addInsert(TableDescriptor, Table)が正常に動作すること | E-04 | ○ |
| C-35 | attachAsDataStreamが正常に動作すること | E-04 | ○ |
| C-36 | 空のStatementSetでattachAsDataStreamを呼び出した場合 | E-04 | △ |
| C-37 | printExplainが正常に動作すること | E-04 | ○ |

### DataGenTableSourceFactory関連（C-38〜C-55）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | factoryIdentifierが"datagen"を返却すること | E-05 | ○ |
| C-39 | requiredOptionsが空のSetを返却すること | E-05 | ○ |
| C-40 | optionalOptionsが正しいオプションを含むこと | E-05 | ○ |
| C-41 | createDynamicTableSourceが正常に動作すること | E-05 | ○ |
| C-42 | サポートされていないジェネレータkindで例外がスローされること | E-05 | ○ |
| C-43 | 可変長型でvar-lenオプションが有効な場合に検証が通ること | E-05 | ○ |
| C-44 | 固定長型でvar-lenオプション設定時に例外がスローされること | E-05 | ○ |
| C-45 | lengthがスキーマ定義を超える場合に例外がスローされること | E-05 | ○ |
| C-46 | DataGenTableSourceのコンストラクタが正常に動作すること | E-06 | ○ |
| C-47 | getScanRuntimeProviderが正常に動作すること | E-06 | ○ |
| C-48 | numberOfRowsがnullの場合にunboundedとして扱われること | E-06 | ○ |
| C-49 | numberOfRowsが設定されている場合にboundedとして扱われること | E-06 | ○ |
| C-50 | createSourceが正常に動作すること | E-06 | ○ |
| C-51 | copyが正常に動作すること | E-06 | ○ |
| C-52 | asSummaryStringが正常に動作すること | E-06 | ○ |
| C-53 | getChangelogModeがinsert-onlyを返却すること | E-06 | ○ |
| C-54 | applyLimitが正常に動作すること | E-06 | ○ |
| C-55 | リミットが0の場合の動作 | E-06 | ○ |

### PrintTableSinkFactory関連（C-56〜C-68）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | factoryIdentifierが"print"を返却すること | E-07 | ○ |
| C-57 | requiredOptionsが空のSetを返却すること | E-07 | ○ |
| C-58 | optionalOptionsが正しいオプションを含むこと | E-07 | ○ |
| C-59 | createDynamicTableSinkが正常に動作すること | E-07 | ○ |
| C-60 | print-identifierオプションが適用されること | E-07 | ○ |
| C-61 | standard-errorオプションが適用されること | E-07 | ○ |
| C-62 | getChangelogModeがrequestModeを返却すること | E-07 | ○ |
| C-63 | getSinkRuntimeProviderが正常に動作すること | E-07 | ○ |
| C-64 | copyが正常に動作すること | E-07 | ○ |
| C-65 | asSummaryStringがSystem.out用の文字列を返却すること | E-07 | ○ |
| C-66 | asSummaryStringがSystem.err用の文字列を返却すること | E-07 | ○ |
| C-67 | applyStaticPartitionが正常に動作すること | E-07 | ○ |
| C-68 | RowDataPrintFunction.invokeが正常に動作すること | E-07 | ○ |

### BlackHoleTableSinkFactory関連（C-69〜C-75）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | factoryIdentifierが"blackhole"を返却すること | E-08 | ○ |
| C-70 | createDynamicTableSinkが正常に動作すること | E-08 | ○ |
| C-71 | getChangelogModeがUPDATE_BEFOREを除外すること | E-08 | ○ |
| C-72 | getSinkRuntimeProviderが正常に動作すること | E-08 | ○ |
| C-73 | copyが正常に動作すること | E-08 | ○ |
| C-74 | asSummaryStringが正常に動作すること | E-08 | ○ |
| C-75 | applyStaticPartitionが何もしないこと | E-08 | ○ |

### RandomGeneratorVisitor関連（C-76〜C-89）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | visit(BooleanType)が正常に動作すること | E-09 | ○ |
| C-77 | visit(CharType)が正常に動作すること | E-09 | ○ |
| C-78 | visit(VarCharType)が正常に動作すること | E-09 | ○ |
| C-79 | MAX_LENGTHの場合にデフォルト長が使用されること | E-09 | ○ |
| C-80 | visit(IntType)が正常に動作すること | E-09 | ○ |
| C-81 | min/max設定が適用されること | E-09 | ○ |
| C-82 | visit(BigIntType)が正常に動作すること | E-09 | ○ |
| C-83 | visit(DecimalType)が正常に動作すること | E-09 | ○ |
| C-84 | visit(TimestampType)が正常に動作すること | E-09 | ○ |
| C-85 | maxPast設定が適用されること | E-09 | ○ |
| C-86 | visit(ArrayType)が正常に動作すること | E-09 | ○ |
| C-87 | visit(MapType)が正常に動作すること | E-09 | ○ |
| C-88 | visit(RowType)が正常に動作すること | E-09 | ○ |
| C-89 | サポートされていない型で例外がスローされること | E-09 | ○ |

### SequenceGeneratorVisitor関連（C-90〜C-95）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | コンストラクタが正常に動作すること | E-10 | ○ |
| C-91 | startが未設定の場合に例外がスローされること | E-10 | ○ |
| C-92 | endが未設定の場合に例外がスローされること | E-10 | ○ |
| C-93 | visit(IntType)が正常に動作すること | E-10 | ○ |
| C-94 | visit(BigIntType)が正常に動作すること | E-10 | ○ |
| C-95 | visit(VarCharType)が正常に動作すること | E-10 | ○ |

### RowDataGenerator関連（C-96〜C-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | コンストラクタが正常に動作すること | E-11 | ○ |
| C-97 | openが正常に動作すること | E-11 | ○ |
| C-98 | snapshotStateが正常に動作すること | E-11 | ○ |
| C-99 | hasNextが全ジェネレータがtrueの場合にtrueを返却すること | E-11 | ○ |
| C-100 | hasNextがいずれかfalseの場合にfalseを返却すること | E-11 | ○ |
| C-101 | nextがGenericRowDataを生成すること | E-11 | ○ |
| C-102 | nullRateに従ってnullが返却されること | E-11 | ○ |

### CsvTableSink関連（C-103〜C-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | パスのみのコンストラクタが正常に動作すること | E-12 | ○ |
| C-104 | 区切り文字指定のコンストラクタが正常に動作すること | E-12 | ○ |
| C-105 | consumeDataStreamが正常に動作すること | E-12 | ○ |
| C-106 | numFiles指定時にパラレリズムが設定されること | E-12 | ○ |
| C-107 | configureが正常に動作すること | E-12 | ○ |
| C-108 | 二重設定時に例外がスローされること | E-12 | ○ |
| C-109 | getConsumedDataTypeが正常に動作すること | E-12 | ○ |
| C-110 | getTableSchemaが正常に動作すること | E-12 | ○ |
| C-111 | CsvFormatter.mapがカンマ区切り文字列に変換すること | E-12 | ○ |
| C-112 | nullフィールドが空文字として扱われること | E-12 | ○ |
| C-113 | 空のRowの場合の動作 | E-12 | ○ |

### CsvTableSource関連（C-114〜C-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | 基本コンストラクタが正常に動作すること | E-13 | ○ |
| C-115 | 全パラメータコンストラクタが正常に動作すること | E-13 | ○ |
| C-116 | builderが正常に動作すること | E-13 | ○ |
| C-117 | Builder.buildが正常に動作すること | E-13 | ○ |
| C-118 | path未設定時に例外がスローされること | E-13 | ○ |
| C-119 | fields未設定時に例外がスローされること | E-13 | ○ |
| C-120 | 重複フィールド名で例外がスローされること | E-13 | ○ |
| C-121 | getProducedDataTypeが正常に動作すること | E-13 | ○ |
| C-122 | getTableSchemaが正常に動作すること | E-13 | ○ |
| C-123 | projectFieldsが正常に動作すること | E-13 | ○ |
| C-124 | 空の投影の場合の動作 | E-13 | ○ |
| C-125 | isBoundedがtrueを返却すること | E-13 | ○ |
| C-126 | getDataStreamが正常に動作すること | E-13 | ○ |
| C-127 | getLookupFunctionが正常に動作すること | E-13 | ○ |
| C-128 | getAsyncLookupFunctionで例外がスローされること | E-13 | ○ |
| C-129 | isAsyncEnabledがfalseを返却すること | E-13 | ○ |
| C-130 | explainSourceが正常に動作すること | E-13 | ○ |
| C-131 | CsvLookupFunction.openが正常に動作すること | E-13 | ○ |
| C-132 | CsvLookupFunction.evalが一致する行を返却すること | E-13 | ○ |
| C-133 | CsvLookupFunction.evalが一致しない場合に何も返却しないこと | E-13 | ○ |
| C-134 | 複合キーでルックアップできること | E-13 | ○ |

### その他クラス関連（C-135〜C-145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | DefaultProcedureContextのコンストラクタが正常に動作すること | E-14 | ○ |
| C-136 | getExecutionEnvironmentが正常に動作すること | E-14 | ○ |
| C-137 | OldCsvValidator.validateが正常に動作すること | E-15 | ○ |
| C-138 | format.typeが不正な場合に例外がスローされること | E-15 | ○ |
| C-139 | スキーマ未定義でderive-schemaがfalseの場合に例外がスローされること | E-15 | ○ |
| C-140 | DataStreamScanProvider.produceDataStreamが正常に動作すること | E-16 | △ |
| C-141 | DataStreamSinkProvider.consumeDataStreamが正常に動作すること | E-17 | △ |
| C-142 | DataStreamSinkProvider.getParallelismのデフォルト動作 | E-17 | ○ |
| C-143 | DataGeneratorContainer.ofが正常に動作すること | E-18 | ○ |
| C-144 | DataGeneratorContainer.getGeneratorが正常に動作すること | E-18 | ○ |
| C-145 | DataGeneratorContainer.getOptionsが正常に動作すること | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-18**: 具体的な例外クラス名（TableException）の確認が必要。親クラスのAbstractStreamTableEnvironmentImplの実装を確認する必要あり
- **C-36**: 空のStatementSetでattachAsDataStreamを呼び出した場合の具体的な動作（正常終了か例外か）は実装の詳細確認が必要
- **C-140, C-141**: インターフェースのため、実装クラスでの具体的な動作は実装者依存
  - 候補：テストフレームワーク（JUnit/Mockito）での振る舞い検証 / 統合テストでの確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードの実装に基づいており、信頼性が高い
- **1（中リスク）**: 非推奨API（C-27, C-28, C-29）は将来的に削除される可能性があり、テストの維持コストに注意
- **1（中リスク）**: インターフェース（DataStreamScanProvider, DataStreamSinkProvider）のテストは実装クラスでの具体的な検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] StreamTableEnvironmentの主要メソッド（fromDataStream, toDataStream, fromChangelogStream, toChangelogStream）のテストケースが網羅されているか
- [ ] DataGenTableSourceFactory, PrintTableSinkFactory, BlackHoleTableSinkFactoryの各ファクトリメソッドがテストされているか
- [ ] RandomGeneratorVisitor, SequenceGeneratorVisitorの各データ型に対するvisitメソッドがテストされているか
- [ ] CsvTableSource, CsvTableSinkの非推奨APIの互換性テストが適切か
- [ ] 例外ケース（null入力、不正な値、未設定の必須パラメータ）がカバーされているか
- [ ] 境界値テスト（空のコレクション、0リミット、MAX_LENGTH）がカバーされているか
