---
generated_at: 2026-02-02 12:30:00
metrics:
  claims_total: 220
  claims_with_evidence: 220
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-table_flink-table-api-java 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なpublicメソッドと重要なビジネスロジックがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：220 / 220、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースはソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/module/ModuleManager.java`
- E-02: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/catalog/FunctionCatalog.java`
- E-03: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/resource/ResourceManager.java`
- E-04: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/catalog/GenericInMemoryCatalog.java`
- E-05: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/api/internal/TableEnvironmentImpl.java`
- E-06: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/expressions/resolver/ExpressionResolver.java`
- E-07: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/operations/utils/OperationTreeBuilder.java`
- E-08: `flink-table/flink-table-api-java/src/main/java/org/apache/flink/table/catalog/CatalogManager.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ModuleManager (UT-TAJ-001 - UT-TAJ-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ModuleManager.loadModule() 正常系テスト | E-01 (76-89行) | ○ |
| C-02 | ModuleManager.loadModule() 重複名異常系 | E-01 (81-83行) | ○ |
| C-03 | ModuleManager.loadModule() null/空名異常系 | E-01 (77-78行) | ○ |
| C-04 | ModuleManager.loadModule() nullモジュール異常系 | E-01 (79行) | ○ |
| C-05 | ModuleManager.unloadModule() 正常系テスト | E-01 (97-105行) | ○ |
| C-06 | ModuleManager.unloadModule() 存在しないモジュール異常系 | E-01 (102-104行) | ○ |
| C-07 | ModuleManager.useModules() 正常系テスト | E-01 (114-129行) | ○ |
| C-08 | ModuleManager.useModules() 未ロードモジュール異常系 | E-01 (118-121行) | ○ |
| C-09 | ModuleManager.useModules() 重複名異常系 | E-01 (122-125行) | ○ |
| C-10 | ModuleManager.listModules() 正常系テスト | E-01 (136-138行) | ○ |
| C-11 | ModuleManager.listFullModules() 正常系テスト | E-01 (146-156行) | ○ |
| C-12 | ModuleManager.listFunctions() 正常系テスト | E-01 (163-168行) | ○ |
| C-13 | ModuleManager.getFunctionDefinition() 正常系テスト | E-01 (180-191行) | ○ |
| C-14 | ModuleManager.getFunctionDefinition() 存在しない関数 | E-01 (189-190行) | ○ |
| C-15 | ModuleManager.getFactory() 正常系テスト | E-01 (200-210行) | ○ |

### FunctionCatalog (UT-TAJ-016 - UT-TAJ-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | FunctionCatalog.registerTemporarySystemFunction() 正常系 | E-02 (114-118行, 557-579行) | ○ |
| C-17 | FunctionCatalog.registerTemporarySystemFunction() 重複名異常系 | E-02 (573-578行) | ○ |
| C-18 | FunctionCatalog.registerTemporarySystemFunction() ignoreIfExists | E-02 (571-572行) | ○ |
| C-19 | FunctionCatalog.dropTemporarySystemFunction() 正常系 | E-02 (134-147行) | ○ |
| C-20 | FunctionCatalog.dropTemporarySystemFunction() 存在しない関数異常系 | E-02 (138-143行) | ○ |
| C-21 | FunctionCatalog.dropTemporarySystemFunction() ignoreIfNotExist | E-02 (138行) | ○ |
| C-22 | FunctionCatalog.registerTemporaryCatalogFunction() 正常系 | E-02 (156-198行) | ○ |
| C-23 | FunctionCatalog.registerTemporaryCatalogFunction() 不正関数異常系 | E-02 (183-190行) | ○ |
| C-24 | FunctionCatalog.dropTemporaryCatalogFunction() 正常系 | E-02 (201-205行, 501-518行) | ○ |
| C-25 | FunctionCatalog.registerCatalogFunction() 正常系 | E-02 (207-221行, 769-817行) | ○ |
| C-26 | FunctionCatalog.registerCatalogFunction() 一時関数競合異常系 | E-02 (787-796行) | ○ |
| C-27 | FunctionCatalog.dropCatalogFunction() 正常系 | E-02 (227-267行) | ○ |
| C-28 | FunctionCatalog.dropCatalogFunction() 一時関数競合異常系 | E-02 (240-246行) | ○ |
| C-29 | FunctionCatalog.getUserDefinedFunctions() 正常系 | E-02 (273-279行) | ○ |
| C-30 | FunctionCatalog.getFunctions() 正常系 | E-02 (335-354行) | ○ |
| C-31 | FunctionCatalog.hasTemporaryCatalogFunction() 正常系 | E-02 (362-366行) | ○ |
| C-32 | FunctionCatalog.hasTemporaryCatalogFunction() 不存在 | E-02 (362-366行) | ○ |
| C-33 | FunctionCatalog.hasTemporarySystemFunction() 正常系 | E-02 (374-376行) | ○ |
| C-34 | FunctionCatalog.lookupFunction() 正常系 | E-02 (416-424行) | ○ |
| C-35 | FunctionCatalog.lookupFunction() 存在しない関数 | E-02 (416-424行) | ○ |
| C-36 | FunctionCatalog.lookupProcedure() 正常系 | E-02 (399-414行) | ○ |

### ResourceManager (UT-TAJ-037 - UT-TAJ-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | ResourceManager.registerJarResources() 正常系 | E-03 (122-139行) | ○ |
| C-38 | ResourceManager.registerJarResources() 不正JAR異常系 | E-03 (130-135行) | ○ |
| C-39 | ResourceManager.registerJarResources() 存在しないファイル異常系 | E-03 (342-368行) | ○ |
| C-40 | ResourceManager.registerFileResource() 正常系 | E-03 (152-162行) | ○ |
| C-41 | ResourceManager.registerFileResource() リモートファイル | E-03 (529行, 371-388行) | ○ |
| C-42 | ResourceManager.declareFunctionResources() 正常系 | E-03 (171-185行) | ○ |
| C-43 | ResourceManager.unregisterFunctionResources() 正常系 | E-03 (193-203行) | ○ |
| C-44 | ResourceManager.getUserClassLoader() 正常系 | E-03 (212-214行) | ○ |
| C-45 | ResourceManager.createUserClassLoader() 正常系 | E-03 (216-226行) | ○ |
| C-46 | ResourceManager.createUserClassLoader() 空リスト | E-03 (217-219行) | ○ |
| C-47 | ResourceManager.getResources() 正常系 | E-03 (228-230行) | ○ |
| C-48 | ResourceManager.getLocalJarResources() 正常系 | E-03 (236-241行) | ○ |
| C-49 | ResourceManager.addJarConfiguration() 正常系 | E-03 (248-261行) | ○ |
| C-50 | ResourceManager.copy() 正常系 | E-03 (263-270行) | ○ |
| C-51 | ResourceManager.close() 正常系 | E-03 (272-301行) | ○ |
| C-52 | ResourceManager.exists() 存在パス | E-03 (304-306行) | ○ |
| C-53 | ResourceManager.exists() 不存在パス | E-03 (304-306行) | ○ |
| C-54 | ResourceManager.syncFileResource() 正常系 | E-03 (320-338行) | ○ |

### GenericInMemoryCatalog (UT-TAJ-055 - UT-TAJ-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | GenericInMemoryCatalog.createDatabase() 正常系 | E-04 (99-111行) | ○ |
| C-56 | GenericInMemoryCatalog.createDatabase() 重複名異常系 | E-04 (104-107行) | ○ |
| C-57 | GenericInMemoryCatalog.createDatabase() ignoreIfExists | E-04 (105行) | ○ |
| C-58 | GenericInMemoryCatalog.createDatabase() null/空名異常系 | E-04 (101行) | ○ |
| C-59 | GenericInMemoryCatalog.dropDatabase() 正常系 | E-04 (114-156行) | ○ |
| C-60 | GenericInMemoryCatalog.dropDatabase() 非空DB異常系 | E-04 (150-152行) | ○ |
| C-61 | GenericInMemoryCatalog.dropDatabase() cascade | E-04 (123-149行) | ○ |
| C-62 | GenericInMemoryCatalog.dropDatabase() 存在しないDB異常系 | E-04 (153-155行) | ○ |
| C-63 | GenericInMemoryCatalog.alterDatabase() 正常系 | E-04 (167-188行) | ○ |
| C-64 | GenericInMemoryCatalog.alterDatabase() タイプ不一致異常系 | E-04 (176-182行) | ○ |
| C-65 | GenericInMemoryCatalog.listDatabases() 正常系 | E-04 (191-193行) | ○ |
| C-66 | GenericInMemoryCatalog.getDatabase() 正常系 | E-04 (196-204行) | ○ |
| C-67 | GenericInMemoryCatalog.getDatabase() 存在しないDB異常系 | E-04 (199-200行) | ○ |
| C-68 | GenericInMemoryCatalog.databaseExists() 存在 | E-04 (207-211行) | ○ |
| C-69 | GenericInMemoryCatalog.databaseExists() 不存在 | E-04 (207-211行) | ○ |
| C-70 | GenericInMemoryCatalog.createTable() 正常系 | E-04 (216-238行) | ○ |
| C-71 | GenericInMemoryCatalog.createTable() DB不存在異常系 | E-04 (221-223行) | ○ |
| C-72 | GenericInMemoryCatalog.createTable() 重複テーブル異常系 | E-04 (225-228行) | ○ |
| C-73 | GenericInMemoryCatalog.createTable() パーティションテーブル | E-04 (232-236行) | ○ |
| C-74 | GenericInMemoryCatalog.alterTable() 正常系 | E-04 (241-261行) | ○ |
| C-75 | GenericInMemoryCatalog.alterTable() テーブル種類不一致異常系 | E-04 (250-255行) | ○ |
| C-76 | GenericInMemoryCatalog.dropTable() 正常系 | E-04 (266-281行) | ○ |
| C-77 | GenericInMemoryCatalog.dropTable() 存在しないテーブル異常系 | E-04 (278-280行) | ○ |
| C-78 | GenericInMemoryCatalog.renameTable() 正常系 | E-04 (284-325行) | ○ |
| C-79 | GenericInMemoryCatalog.renameTable() 重複名異常系 | E-04 (292-293行) | ○ |
| C-80 | GenericInMemoryCatalog.listTables() 正常系 | E-04 (328-330行) | ○ |
| C-81 | GenericInMemoryCatalog.listTables() DB不存在異常系 | E-04 (872-888行) | ○ |
| C-82 | GenericInMemoryCatalog.listViews() 正常系 | E-04 (333-336行) | ○ |
| C-83 | GenericInMemoryCatalog.listMaterializedTables() 正常系 | E-04 (339-343行) | ○ |
| C-84 | GenericInMemoryCatalog.getTable() 正常系 | E-04 (346-354行) | ○ |
| C-85 | GenericInMemoryCatalog.tableExists() 正常系 | E-04 (357-361行) | ○ |
| C-86 | GenericInMemoryCatalog.createModel() 正常系 | E-04 (372-386行) | ○ |
| C-87 | GenericInMemoryCatalog.createModel() 重複名異常系 | E-04 (379-383行) | ○ |
| C-88 | GenericInMemoryCatalog.alterModel() 正常系 | E-04 (389-402行) | ○ |
| C-89 | GenericInMemoryCatalog.dropModel() 正常系 | E-04 (405-413行) | ○ |
| C-90 | GenericInMemoryCatalog.renameModel() 正常系 | E-04 (416-432行) | ○ |
| C-91 | GenericInMemoryCatalog.listModels() 正常系 | E-04 (435-437行) | ○ |
| C-92 | GenericInMemoryCatalog.getModel() 正常系 | E-04 (440-448行) | ○ |
| C-93 | GenericInMemoryCatalog.modelExists() 正常系 | E-04 (451-454行) | ○ |
| C-94 | GenericInMemoryCatalog.createFunction() 正常系 | E-04 (459-477行) | ○ |
| C-95 | GenericInMemoryCatalog.createFunction() 重複名異常系 | E-04 (470-473行) | ○ |
| C-96 | GenericInMemoryCatalog.alterFunction() 正常系 | E-04 (480-503行) | ○ |
| C-97 | GenericInMemoryCatalog.alterFunction() タイプ不一致異常系 | E-04 (491-497行) | ○ |
| C-98 | GenericInMemoryCatalog.dropFunction() 正常系 | E-04 (506-517行) | ○ |
| C-99 | GenericInMemoryCatalog.listFunctions() 正常系 | E-04 (520-522行) | ○ |
| C-100 | GenericInMemoryCatalog.getFunction() 正常系 | E-04 (525-535行) | ○ |
| C-101 | GenericInMemoryCatalog.functionExists() 正常系 | E-04 (538-546行) | ○ |
| C-102 | GenericInMemoryCatalog.createPartition() 正常系 | E-04 (556-581行) | ○ |
| C-103 | GenericInMemoryCatalog.createPartition() 非パーティションテーブル異常系 | E-04 (571行, 724-728行) | ○ |
| C-104 | GenericInMemoryCatalog.createPartition() 不完全スペック異常系 | E-04 (572行, 696-705行) | ○ |
| C-105 | GenericInMemoryCatalog.dropPartition() 正常系 | E-04 (584-597行) | ○ |
| C-106 | GenericInMemoryCatalog.alterPartition() 正常系 | E-04 (600-625行) | ○ |
| C-107 | GenericInMemoryCatalog.listPartitions() 正常系 | E-04 (628-636行) | ○ |
| C-108 | GenericInMemoryCatalog.getPartition() 正常系 | E-04 (674-684行) | ○ |
| C-109 | GenericInMemoryCatalog.partitionExists() 正常系 | E-04 (687-694行) | ○ |
| C-110 | GenericInMemoryCatalog.getTableStatistics() 正常系 | E-04 (748-761行) | ○ |
| C-111 | GenericInMemoryCatalog.getTableStatistics() パーティションテーブル | E-04 (755-760行) | ○ |
| C-112 | GenericInMemoryCatalog.getTableColumnStatistics() 正常系 | E-04 (764-774行) | ○ |
| C-113 | GenericInMemoryCatalog.alterTableStatistics() 正常系 | E-04 (807-818行) | ○ |
| C-114 | GenericInMemoryCatalog.alterTableColumnStatistics() 正常系 | E-04 (821-835行) | ○ |

### TableEnvironmentImpl (UT-TAJ-115 - UT-TAJ-182)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | TableEnvironmentImpl.create() EnvironmentSettings | E-05 (244-319行) | ○ |
| C-116 | TableEnvironmentImpl.create() Configuration | E-05 (240-241行) | ○ |
| C-117 | TableEnvironmentImpl.fromValues() 正常系 | E-05 (322-324行) | ○ |
| C-118 | TableEnvironmentImpl.fromValues() 型指定付き | E-05 (327-341行) | ○ |
| C-119 | TableEnvironmentImpl.fromValues() 空配列 | E-05 (344-350行) | ○ |
| C-120 | TableEnvironmentImpl.registerCatalog() 正常系 | E-05 (375-377行) | ○ |
| C-121 | TableEnvironmentImpl.createCatalog() 正常系 | E-05 (380-382行) | ○ |
| C-122 | TableEnvironmentImpl.getCatalog() 存在 | E-05 (385-387行) | ○ |
| C-123 | TableEnvironmentImpl.getCatalog() 不存在 | E-05 (385-387行) | ○ |
| C-124 | TableEnvironmentImpl.loadModule() 正常系 | E-05 (390-392行) | ○ |
| C-125 | TableEnvironmentImpl.useModules() 正常系 | E-05 (395-397行) | ○ |
| C-126 | TableEnvironmentImpl.unloadModule() 正常系 | E-05 (400-402行) | ○ |
| C-127 | TableEnvironmentImpl.createTemporarySystemFunction() クラス | E-05 (410-415行) | ○ |
| C-128 | TableEnvironmentImpl.createTemporarySystemFunction() インスタンス | E-05 (418-420行) | ○ |
| C-129 | TableEnvironmentImpl.dropTemporarySystemFunction() 正常系 | E-05 (436-438行) | ○ |
| C-130 | TableEnvironmentImpl.createFunction() 正常系 | E-05 (441-469行) | ○ |
| C-131 | TableEnvironmentImpl.dropFunction() 正常系 | E-05 (486-489行) | ○ |
| C-132 | TableEnvironmentImpl.createTemporaryFunction() 正常系 | E-05 (492-528行) | ○ |
| C-133 | TableEnvironmentImpl.dropTemporaryFunction() 正常系 | E-05 (531-534行) | ○ |
| C-134 | TableEnvironmentImpl.createTemporaryTable() 正常系 | E-05 (537-550行) | ○ |
| C-135 | TableEnvironmentImpl.createTemporaryTable() nullパス異常系 | E-05 (544行) | ○ |
| C-136 | TableEnvironmentImpl.createTable() 正常系 | E-05 (553-565行) | ○ |
| C-137 | TableEnvironmentImpl.createTemporaryView() 正常系 | E-05 (574-593行) | ○ |
| C-138 | TableEnvironmentImpl.createTemporaryView() 異なるEnv異常系 | E-05 (582-585行) | ○ |
| C-139 | TableEnvironmentImpl.createView() 正常系 | E-05 (596-611行) | ○ |
| C-140 | TableEnvironmentImpl.createModel() 正常系 | E-05 (614-619行) | ○ |
| C-141 | TableEnvironmentImpl.createTemporaryModel() 正常系 | E-05 (627-639行) | ○ |
| C-142 | TableEnvironmentImpl.scan() 正常系 | E-05 (642-651行) | ○ |
| C-143 | TableEnvironmentImpl.scan() 存在しないテーブル異常系 | E-05 (646-650行) | ○ |
| C-144 | TableEnvironmentImpl.from() パス | E-05 (654-663行) | ○ |
| C-145 | TableEnvironmentImpl.from() TableDescriptor | E-05 (666-674行) | ○ |
| C-146 | TableEnvironmentImpl.fromModel() 正常系 | E-05 (690-701行) | ○ |
| C-147 | TableEnvironmentImpl.fromCall() 正常系 | E-05 (677-680行) | ○ |
| C-148 | TableEnvironmentImpl.listCatalogs() 正常系 | E-05 (719-721行) | ○ |
| C-149 | TableEnvironmentImpl.listModules() 正常系 | E-05 (724-726行) | ○ |
| C-150 | TableEnvironmentImpl.listFullModules() 正常系 | E-05 (729-731行) | ○ |
| C-151 | TableEnvironmentImpl.listDatabases() 正常系 | E-05 (734-742行) | ○ |
| C-152 | TableEnvironmentImpl.listTables() 正常系 | E-05 (745-747行) | ○ |
| C-153 | TableEnvironmentImpl.listViews() 正常系 | E-05 (757-759行) | ○ |
| C-154 | TableEnvironmentImpl.listTemporaryTables() 正常系 | E-05 (767-769行) | ○ |
| C-155 | TableEnvironmentImpl.listTemporaryViews() 正常系 | E-05 (772-774行) | ○ |
| C-156 | TableEnvironmentImpl.listModels() 正常系 | E-05 (863-865行) | ○ |
| C-157 | TableEnvironmentImpl.dropTemporaryTable() 正常系 | E-05 (777-786行) | ○ |
| C-158 | TableEnvironmentImpl.dropTemporaryTable() 不存在 | E-05 (783-785行) | ○ |
| C-159 | TableEnvironmentImpl.dropTable() 正常系 | E-05 (789-798行) | ○ |
| C-160 | TableEnvironmentImpl.dropTemporaryView() 正常系 | E-05 (801-810行) | ○ |
| C-161 | TableEnvironmentImpl.dropView() 正常系 | E-05 (813-822行) | ○ |
| C-162 | TableEnvironmentImpl.dropModel() 正常系 | E-05 (825-834行) | ○ |
| C-163 | TableEnvironmentImpl.dropTemporaryModel() 正常系 | E-05 (837-846行) | ○ |
| C-164 | TableEnvironmentImpl.listUserDefinedFunctions() 正常系 | E-05 (849-853行) | ○ |
| C-165 | TableEnvironmentImpl.listFunctions() 正常系 | E-05 (856-860行) | ○ |
| C-166 | TableEnvironmentImpl.explainSql() 正常系 | E-05 (873-887行) | ○ |
| C-167 | TableEnvironmentImpl.explainSql() 複数SQL異常系 | E-05 (877-879行) | ○ |
| C-168 | TableEnvironmentImpl.sqlQuery() 正常系 | E-05 (916-933行) | ○ |
| C-169 | TableEnvironmentImpl.sqlQuery() 非クエリ異常系 | E-05 (928-932行) | ○ |
| C-170 | TableEnvironmentImpl.executeSql() DDL | E-05 (936-945行) | ○ |
| C-171 | TableEnvironmentImpl.executeSql() INSERT | E-05 (936-945行) | ○ |
| C-172 | TableEnvironmentImpl.executeSql() 複数SQL異常系 | E-05 (939-941行) | ○ |
| C-173 | TableEnvironmentImpl.createStatementSet() 正常系 | E-05 (960-962行) | ○ |
| C-174 | TableEnvironmentImpl.loadPlan() 正常系 | E-05 (965-971行) | ○ |
| C-175 | TableEnvironmentImpl.loadPlan() 存在しないファイル異常系 | E-05 (968-970行) | ○ |
| C-176 | TableEnvironmentImpl.compilePlanSql() 正常系 | E-05 (974-988行) | ○ |
| C-177 | TableEnvironmentImpl.compilePlanSql() 非INSERT異常系 | E-05 (977-982行) | ○ |
| C-178 | TableEnvironmentImpl.getCurrentCatalog() 正常系 | E-05 (1453-1455行) | ○ |
| C-179 | TableEnvironmentImpl.useCatalog() 正常系 | E-05 (1458-1460行) | ○ |
| C-180 | TableEnvironmentImpl.getCurrentDatabase() 正常系 | E-05 (1463-1465行) | ○ |
| C-181 | TableEnvironmentImpl.useDatabase() 正常系 | E-05 (1468-1470行) | ○ |
| C-182 | TableEnvironmentImpl.getConfig() 正常系 | E-05 (1473-1475行) | ○ |

### ExpressionResolver (UT-TAJ-183 - UT-TAJ-190)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-183 | ExpressionResolver.resolve() 正常系 | E-06 (207-214行) | ○ |
| C-184 | ExpressionResolver.resolve() 解決不可能異常系 | E-06 (278-296行) | ○ |
| C-185 | ExpressionResolver.resolveExpanding() 正常系 | E-06 (226-230行) | ○ |
| C-186 | ExpressionResolverBuilder.build() 正常系 | E-06 (491-505行) | ○ |
| C-187 | ExpressionResolverBuilder.withOverWindows() 正常系 | E-06 (470-473行) | ○ |
| C-188 | ExpressionResolverBuilder.withLocalReferences() 正常系 | E-06 (475-478行) | ○ |
| C-189 | PostResolverFactory.as() 正常系 | E-06 (384-389行) | ○ |
| C-190 | PostResolverFactory.cast() 正常系 | E-06 (391-396行) | ○ |

### OperationTreeBuilder (UT-TAJ-191 - UT-TAJ-220)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-191 | OperationTreeBuilder.project() 正常系 | E-07 (162-180行) | ○ |
| C-192 | OperationTreeBuilder.project() 集約関数異常系 | E-07 (168-173行) | ○ |
| C-193 | OperationTreeBuilder.addColumns() 正常系 | E-07 (210-221行) | ○ |
| C-194 | OperationTreeBuilder.addColumns() replace | E-07 (213-216行) | ○ |
| C-195 | OperationTreeBuilder.renameColumns() 正常系 | E-07 (223-232行) | ○ |
| C-196 | OperationTreeBuilder.dropColumns() 正常系 | E-07 (234-243行) | ○ |
| C-197 | OperationTreeBuilder.aggregate() 正常系 | E-07 (245-256行) | ○ |
| C-198 | OperationTreeBuilder.windowAggregate() 正常系 | E-07 (258-290行) | ○ |
| C-199 | OperationTreeBuilder.join() 正常系 | E-07 (366-378行) | ○ |
| C-200 | OperationTreeBuilder.join() 条件なし | E-07 (377行) | ○ |
| C-201 | OperationTreeBuilder.joinLateral() 正常系 | E-07 (380-393行) | ○ |
| C-202 | OperationTreeBuilder.sort() 正常系 | E-07 (424-430行) | ○ |
| C-203 | OperationTreeBuilder.limitWithOffset() 正常系 | E-07 (432-436行) | ○ |
| C-204 | OperationTreeBuilder.limitWithFetch() 正常系 | E-07 (438-442行) | ○ |
| C-205 | OperationTreeBuilder.alias() 正常系 | E-07 (444-448行) | ○ |
| C-206 | OperationTreeBuilder.filter() 正常系 | E-07 (450-463行) | ○ |
| C-207 | OperationTreeBuilder.filter() 非Boolean異常系 | E-07 (455-460行) | ○ |
| C-208 | OperationTreeBuilder.distinct() 正常系 | E-07 (465-467行) | ○ |
| C-209 | OperationTreeBuilder.minus() 正常系 | E-07 (469-471行) | ○ |
| C-210 | OperationTreeBuilder.intersect() 正常系 | E-07 (473-475行) | ○ |
| C-211 | OperationTreeBuilder.union() 正常系 | E-07 (477-479行) | ○ |
| C-212 | OperationTreeBuilder.map() 正常系 | E-07 (481-500行) | ○ |
| C-213 | OperationTreeBuilder.map() 非スカラー関数異常系 | E-07 (485-488行) | ○ |
| C-214 | OperationTreeBuilder.flatMap() 正常系 | E-07 (502-541行) | ○ |
| C-215 | OperationTreeBuilder.flatMap() 非テーブル関数異常系 | E-07 (507-510行) | ○ |
| C-216 | OperationTreeBuilder.values() 正常系 | E-07 (603-605行) | ○ |
| C-217 | OperationTreeBuilder.values() 型指定付き | E-07 (590-601行) | ○ |
| C-218 | OperationTreeBuilder.values() 空配列 | E-07 (621-630行) | ○ |
| C-219 | OperationTreeBuilder.tableFunction() 正常系 | E-07 (607-611行) | ○ |
| C-220 | OperationTreeBuilder.partition() 正常系 | E-07 (613-617行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全てのテストケースは実際のソースコードに基づいて生成されています
- 追加で検討すべきクラス（時間制約により省略）：
  - `CatalogManager` - カタログ管理の中核クラス
  - `TableImpl` - Table APIの実装クラス
  - その他のOperation系クラス
  - 各種Factory系クラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく網羅的なテストケース生成
- 以下の点については追加確認を推奨：
  - 並行性に関するテストケース（ModuleManager、CatalogManager等での同時アクセス）
  - エッジケース（極端に大きなデータ、特殊文字を含む識別子等）
  - 統合テストに近いシナリオ（複数コンポーネントの連携）

## 6) レビュアーチェックリスト（最小）
- [ ] 主要クラス（ModuleManager、FunctionCatalog、GenericInMemoryCatalog、TableEnvironmentImpl）のテストケースが網羅的か確認
- [ ] 各テストケースの前提条件が実際のテスト環境で再現可能か確認
- [ ] 期待結果が具体的で検証可能か確認
- [ ] 優先度の設定が適切か確認（金額・セキュリティ関連は高、ヘルパー関数は低）
- [ ] 異常系テストケースがエラーハンドリングを適切にカバーしているか確認
- [ ] 境界値テストケースが重要な境界条件をカバーしているか確認
