---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：flink-table_flink-table-api-scala 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-029**：createTypeInformation マクロの詳細動作確認が必要
  2. **C-099**：lookupConstructorのリフレクション例外パターンの網羅性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main/scala/org/apache/flink/table/api/ImplicitExpressionConversions.scala`
- E-02: `src/main/scala/org/apache/flink/table/api/ImplicitExpressionOperations.scala`
- E-03: `src/main/scala/org/apache/flink/table/api/ImplicitTypeConversions.scala`
- E-04: `src/main/scala/org/apache/flink/table/api/package.scala`
- E-05: `src/main/scala/org/apache/flink/table/api/typeutils/CaseClassTypeInfo.scala`
- E-06: `src/main/scala/org/apache/flink/table/api/typeutils/CaseClassSerializer.scala`
- E-07: `src/main/scala/org/apache/flink/table/api/typeutils/OptionTypeInfo.scala`
- E-08: `src/main/scala/org/apache/flink/table/api/typeutils/OptionSerializer.scala`
- E-09: `src/main/scala/org/apache/flink/table/api/typeutils/EitherTypeInfo.scala`
- E-10: `src/main/scala/org/apache/flink/table/api/typeutils/EitherSerializer.scala`
- E-11: `src/main/scala/org/apache/flink/table/api/typeutils/TryTypeInfo.scala`
- E-12: `src/main/scala/org/apache/flink/table/api/typeutils/TrySerializer.scala`
- E-13: `src/main/scala/org/apache/flink/table/api/typeutils/TraversableTypeInfo.scala`
- E-14: `src/main/scala/org/apache/flink/table/api/typeutils/TraversableSerializer.scala`
- E-15: `src/main/scala/org/apache/flink/table/api/typeutils/EnumValueTypeInfo.scala`
- E-16: `src/main/scala/org/apache/flink/table/api/typeutils/EnumValueSerializer.scala`
- E-17: `src/main/scala/org/apache/flink/table/api/typeutils/ScalaCaseClassSerializer.scala`
- E-18: `src/main/scala/org/apache/flink/table/api/typeutils/UnitTypeInfo.scala`
- E-19: `src/main/scala/org/apache/flink/table/api/typeutils/ScalaNothingTypeInfo.scala`
- E-20: `src/main/scala/org/apache/flink/table/api/typeutils/NothingSerializer.scala`
- E-21: `src/main/scala/org/apache/flink/table/api/typeutils/CaseClassComparator.scala`
- E-22: `src/main/scala/org/apache/flink/table/api/typeutils/OptionTypeComparator.scala`
- E-23: `src/main/scala/org/apache/flink/table/api/codegen/TypeInformationGen.scala`
- E-24: `src/main/scala/org/apache/flink/table/api/codegen/TypeAnalyzer.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

### ImplicitExpressionConversions (UT-TAS-001 - UT-TAS-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | lit関数で任意の値からリテラル式が生成される | E-01 (L413) | ○ |
| C-002 | lit関数でDataType指定でリテラル式が生成される | E-01 (L422) | ○ |
| C-003 | $関数で文字列から列参照が生成される | E-01 (L383) | ○ |
| C-004 | call関数で関数名でのUDF呼び出しが生成される | E-01 (L340) | ○ |
| C-005 | call関数でUserDefinedFunctionでのUDF呼び出しが生成される | E-01 (L346) | ○ |
| C-006 | array関数で配列式が生成される | E-01 (L633) | ○ |
| C-007 | row関数でRow式が生成される | E-01 (L638) | ○ |
| C-008 | map関数でMap式が生成される | E-01 (L643) | ○ |
| C-009 | ifThenElse関数で三項条件式が生成される | E-01 (L799) | ○ |
| C-010 | coalesce関数でCOALESCE式が生成される | E-01 (L822) | ○ |
| C-011 | byte2Literal暗黙変換が動作する | E-01 (L236) | ○ |
| C-012 | symbol2FieldExpression暗黙変換が動作する | E-01 (L227) | ○ |

### ImplicitExpressionOperations (UT-TAS-013 - UT-TAS-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-013 | as関数でエイリアス指定ができる | E-02 (L58) | ○ |
| C-014 | &&演算子で論理AND演算ができる | E-02 (L61) | ○ |
| C-015 | \|\|演算子で論理OR演算ができる | E-02 (L64) | ○ |
| C-016 | >演算子で大なり比較ができる | E-02 (L67) | ○ |
| C-017 | >=演算子で大なりイコール比較ができる | E-02 (L70) | ○ |
| C-018 | <演算子で小なり比較ができる | E-02 (L73) | ○ |
| C-019 | <=演算子で小なりイコール比較ができる | E-02 (L76) | ○ |
| C-020 | ===演算子で等価比較ができる | E-02 (L79) | ○ |
| C-021 | !==演算子で不等価比較ができる | E-02 (L82) | ○ |
| C-022 | +演算子で加算演算ができる | E-02 (L94) | ○ |
| C-023 | -演算子で減算演算ができる | E-02 (L97) | ○ |
| C-024 | *演算子で乗算演算ができる | E-02 (L103) | ○ |
| C-025 | /演算子で除算演算ができる | E-02 (L100) | ○ |
| C-026 | %演算子で剰余演算ができる | E-02 (L109) | ○ |
| C-027 | trim関数でトリム処理ができる | E-02 (L147-157) | ○ |
| C-028 | ?演算子で三項演算子が使用できる | E-02 (L130-131) | ○ |

### ImplicitTypeConversions (UT-TAS-029 - UT-TAS-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-029 | createTypeInformationマクロで型情報が生成される | E-03 (L47) | △ |
| C-030 | createTuple2TypeInformationでTuple2の型情報が生成される | E-03 (L54-72) | ○ |

### CaseClassTypeInfo (UT-TAS-031 - UT-TAS-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-031 | getFieldIndicesでフィールドインデックスが取得できる | E-05 (L78-80) | ○ |
| C-032 | getFieldIndicesで存在しないフィールド名の場合-1が返る | E-05 (L78-80) | ○ |
| C-033 | getFlatFieldsでフラットフィールド一覧が取得できる | E-05 (L83-168) | ○ |
| C-034 | getFlatFieldsで不正なフィールド式で例外がスローされる | E-05 (L90-93) | ○ |
| C-035 | getTypeAtで指定フィールドの型情報が取得できる | E-05 (L171-215) | ○ |
| C-036 | getTypeAtでワイルドカード式で例外がスローされる | E-05 (L175-179) | ○ |
| C-037 | getFieldIndexでフィールドインデックスが取得できる | E-05 (L221-228) | ○ |
| C-038 | getFieldIndexで重複フィールド名の場合-1が返る | E-05 (L222-227) | ○ |
| C-039 | equalsで同一型情報の比較がtrueを返す | E-05 (L269-278) | ○ |
| C-040 | equalsで異なる型情報の比較がfalseを返す | E-05 (L269-278) | ○ |

### CaseClassSerializer (UT-TAS-041 - UT-TAS-048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-041 | createInstanceでインスタンスが生成される | E-06 (L58-76) | ○ |
| C-042 | createInstanceでインスタンス生成失敗時nullが返る | E-06 (L59-61) | ○ |
| C-043 | copyでオブジェクトのコピーが作成される | E-06 (L86-98) | ○ |
| C-044 | copyでnullの場合nullが返る | E-06 (L87-88) | ○ |
| C-045 | serializeでシリアライズが正常に行われる | E-06 (L100-113) | ○ |
| C-046 | serializeでnullフィールドでNullFieldExceptionがスローされる | E-06 (L108-109) | ○ |
| C-047 | deserializeでデシリアライズが正常に行われる | E-06 (L119-127) | ○ |
| C-048 | duplicateでシリアライザの複製が作成される | E-06 (L42-44) | ○ |

### OptionTypeInfo (UT-TAS-049 - UT-TAS-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-049 | isKeyTypeで要素型がキー型の場合trueを返す | E-07 (L49) | ○ |
| C-050 | isKeyTypeで要素型がキー型でない場合falseを返す | E-07 (L49) | ○ |
| C-051 | createComparatorでキー型の場合コンパレータが生成される | E-07 (L60-71) | ○ |
| C-052 | createComparatorでキー型でない場合例外がスローされる | E-07 (L69) | ○ |
| C-053 | createSerializerでシリアライザが生成される | E-07 (L74-82) | ○ |
| C-054 | createSerializerでelemTypeInfoがnullの場合NothingSerializerでラップされる | E-07 (L75-77) | ○ |

### OptionSerializer (UT-TAS-055 - UT-TAS-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-055 | createInstanceでNoneが生成される | E-08 (L39-41) | ○ |
| C-056 | copyでSome値がコピーされる | E-08 (L47-48) | ○ |
| C-057 | copyでNoneがそのまま返る | E-08 (L47-49) | ○ |
| C-058 | serializeでSomeがシリアライズされる | E-08 (L62-65) | ○ |
| C-059 | serializeでNoneがシリアライズされる | E-08 (L66-67) | ○ |
| C-060 | deserializeでSomeがデシリアライズされる | E-08 (L70-73) | ○ |
| C-061 | deserializeでNoneがデシリアライズされる | E-08 (L74-76) | ○ |

### EitherTypeInfo (UT-TAS-062 - UT-TAS-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-062 | createSerializerでEitherSerializerが生成される | E-09 (L62-75) | ○ |
| C-063 | createSerializerでleftTypeInfoがnullの場合NothingSerializerが使用される | E-09 (L63-67) | ○ |
| C-064 | createSerializerでrightTypeInfoがnullの場合NothingSerializerが使用される | E-09 (L69-73) | ○ |
| C-065 | equalsで同一型情報の比較がtrueを返す | E-09 (L77-86) | ○ |

### EitherSerializer (UT-TAS-066 - UT-TAS-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-066 | createInstanceでLeft(null)が生成される | E-10 (L44-46) | ○ |
| C-067 | copyでLeft値がコピーされる | E-10 (L55-56) | ○ |
| C-068 | copyでRight値がコピーされる | E-10 (L55-57) | ○ |
| C-069 | serializeでLeftがシリアライズされる | E-10 (L72-75) | ○ |
| C-070 | serializeでRightがシリアライズされる | E-10 (L76-78) | ○ |
| C-071 | deserializeでLeftがデシリアライズされる | E-10 (L81-84) | ○ |
| C-072 | deserializeでRightがデシリアライズされる | E-10 (L85-87) | ○ |

### TryTypeInfo (UT-TAS-073 - UT-TAS-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-073 | createSerializerでTrySerializerが生成される | E-11 (L58-66) | ○ |
| C-074 | createSerializerでelemTypeInfoがnullの場合NothingSerializerが使用される | E-11 (L59-61) | ○ |

### TrySerializer (UT-TAS-075 - UT-TAS-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-075 | createInstanceでFailure(RuntimeException)が生成される | E-12 (L50-52) | ○ |
| C-076 | copyでSuccess値がコピーされる | E-12 (L58-59) | ○ |
| C-077 | copyでFailure値がコピーされる | E-12 (L58-60) | ○ |
| C-078 | serializeでSuccessがシリアライズされる | E-12 (L75-78) | ○ |
| C-079 | serializeでFailureがシリアライズされる | E-12 (L79-81) | ○ |
| C-080 | deserializeでSuccessがデシリアライズされる | E-12 (L84-86) | ○ |
| C-081 | deserializeでFailureがデシリアライズされる | E-12 (L87-89) | ○ |

### TraversableTypeInfo (UT-TAS-082 - UT-TAS-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-082 | equalsで同一型情報の比較がtrueを返す | E-13 (L63-70) | ○ |
| C-083 | equalsで異なる型情報の比較がfalseを返す | E-13 (L63-70) | ○ |

### TraversableSerializer (UT-TAS-084 - UT-TAS-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-084 | createInstanceで空のコレクションが生成される | E-14 (L74-76) | ○ |
| C-085 | copyでコレクションがコピーされる | E-14 (L82-87) | ○ |
| C-086 | serializeでコレクションがシリアライズされる | E-14 (L106-118) | ○ |
| C-087 | serializeで空コレクションがシリアライズされる | E-14 (L106-118) | ○ |
| C-088 | serializeでnull要素を含むコレクションがシリアライズされる | E-14 (L111-114) | ○ |
| C-089 | deserializeでコレクションがデシリアライズされる | E-14 (L120-136) | ○ |

### EnumValueTypeInfo (UT-TAS-090 - UT-TAS-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-090 | isKeyTypeでEnum値がキー型である | E-15 (L51) | ○ |
| C-091 | createSerializerでEnumValueSerializerが生成される | E-15 (L62-64) | ○ |
| C-092 | createComparatorでEnumValueComparatorが生成される | E-15 (L67-69) | ○ |

### EnumValueSerializer (UT-TAS-093 - UT-TAS-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-093 | createInstanceでenum(0)が生成される | E-16 (L33) | ○ |
| C-094 | isImmutableTypeでEnum値が不変型である | E-16 (L35) | ○ |
| C-095 | getLengthで固定長4が返る | E-16 (L37) | ○ |
| C-096 | serializeでEnum値のIDがシリアライズされる | E-16 (L47) | ○ |
| C-097 | deserializeでIDからEnum値がデシリアライズされる | E-16 (L49) | ○ |

### ScalaCaseClassSerializer (UT-TAS-098 - UT-TAS-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-098 | createInstanceでリフレクションでインスタンスが生成される | E-17 (L44-46) | ○ |
| C-099 | lookupConstructorでプライマリコンストラクタが取得できる | E-17 (L62-92) | △ |
| C-100 | lookupConstructorで非静的クラスで例外がスローされる | E-17 (L66-74) | ○ |

### CaseClassComparator (UT-TAS-101 - UT-TAS-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | hashでハッシュ値が計算される | E-21 (L52-70) | ○ |
| C-102 | hashでnullフィールドでNullKeyFieldExceptionがスローされる | E-21 (L64-65) | ○ |
| C-103 | compareで2つのProductが比較できる | E-21 (L107-127) | ○ |
| C-104 | compareで同一Productの比較で0が返る | E-21 (L107-127) | ○ |
| C-105 | setReferenceで参照値が設定される | E-21 (L72-86) | ○ |
| C-106 | equalToReferenceで参照値と等価な場合trueが返る | E-21 (L88-105) | ○ |
| C-107 | duplicateでコンパレータの複製が作成される | E-21 (L40-46) | ○ |

### OptionTypeComparator (UT-TAS-108 - UT-TAS-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | compareでSome同士が比較できる | E-22 (L34-38) | ○ |
| C-109 | compareでSomeとNoneの比較で正の値が返る(昇順) | E-22 (L39-44) | ○ |
| C-110 | compareでNoneとSomeの比較で負の値が返る(昇順) | E-22 (L47-52) | ○ |
| C-111 | compareでNone同士の比較で0が返る | E-22 (L53-54) | ○ |
| C-112 | compareで降順の場合SomeとNoneの比較で負の値が返る | E-22 (L42-43) | ○ |

### UnitTypeInfo (UT-TAS-113 - UT-TAS-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | getArityでArityが0である | E-18 (L41) | ○ |
| C-114 | getTotalFieldsでTotalFieldsが1である | E-18 (L43) | ○ |
| C-115 | createSerializerでUnitSerializerが生成される | E-18 (L50-51) | ○ |

### ScalaNothingTypeInfo (UT-TAS-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | createSerializerでNothingSerializerが生成される | E-19 (L51-52) | ○ |

### NothingSerializer (UT-TAS-117 - UT-TAS-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | copyでRuntimeExceptionがスローされる | E-20 (L44-45) | ○ |
| C-118 | serializeでRuntimeExceptionがスローされる | E-20 (L52-53) | ○ |
| C-119 | deserializeでRuntimeExceptionがスローされる | E-20 (L55-56) | ○ |
| C-120 | createInstanceでInteger(-1)が生成される | E-20 (L36-38) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-029（createTypeInformationマクロ）**：マクロの内部動作はTypeUtils.scalaとTypeInformationGen.scalaに依存しているが、コンパイル時の動作のため、テスト実行時の詳細な動作確認が難しい
  - 候補：TypeInformationGenTestの既存テストケース参照 / マクロ展開結果の確認
- **C-099（lookupConstructorのリフレクション）**：全ての例外パターンをカバーしているか不明
  - 候補：クラスローダー関連エラー / アクセス権限エラー / NoSuchMethodException

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的な型情報・シリアライザ機能（UT-TAS-001 - UT-TAS-028, UT-TAS-055 - UT-TAS-097）
  - Expressions APIの暗黙変換と基本操作
  - 各種シリアライザの基本的なシリアライズ/デシリアライズ
- **1: 中リスク** - CaseClass関連の複雑な型処理（UT-TAS-031 - UT-TAS-054）
  - フィールド参照の解決ロジック
  - 複合型のシリアライザ生成
- **2: 高リスク** - リフレクション・マクロ関連（UT-TAS-029, UT-TAS-098 - UT-TAS-100）
  - コンパイル時マクロの動作検証が困難
  - リフレクションによるコンストラクタ呼び出しのエッジケース

## 6) レビュアーチェックリスト（最小）
- [ ] createTypeInformationマクロが正しく展開されることを確認（TypeInformationGenTestを参照）
- [ ] ScalaCaseClassSerializer.lookupConstructorの非静的クラス検出が正しく動作することを確認
- [ ] NothingSerializerが意図的に例外をスローする設計であることを理解した上でテストケースを確認
- [ ] OptionTypeComparatorの昇順/降順ロジックがNoneの扱いと整合していることを確認
- [ ] TraversableSerializerのCanBuildFrom依存がScala 2.12互換性を維持していることを確認
