---
generated_at: 2026-02-02 18:45:00
metrics:
  claims_total: 80
  claims_with_evidence: 80
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-table_flink-table-code-splitter 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：80 / 80、根拠なし：0
- 優先レビュー（高）
  1. なし（すべてのテストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/JavaCodeSplitter.java`
- E-02: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/CodeSplitUtil.java`
- E-03: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/CodeRewriter.java`
- E-04: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/ReturnValueRewriter.java`
- E-05: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/DeclarationRewriter.java`
- E-06: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/BlockStatementRewriter.java`
- E-07: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/BlockStatementSplitter.java`
- E-08: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/BlockStatementGrouper.java`
- E-09: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/FunctionSplitter.java`
- E-10: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/MemberFieldRewriter.java`
- E-11: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/AddBoolBeforeReturnRewriter.java`
- E-12: `flink-table/flink-table-code-splitter/src/main/java/org/apache/flink/table/codesplit/ReturnAndJumpCounter.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### JavaCodeSplitter (C-01 から C-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 有効なJavaコードが正常に分割されること | E-01 (split, splitImplメソッド) | ○ |
| C-02 | コード長がmaxMethodLength以下の場合は元のコードがそのまま返却されること | E-01 (splitImpl内のif文 line 47-49) | ○ |
| C-03 | nullコードが渡された場合に例外がスローされること | E-01 (checkArgument line 43) | ○ |
| C-04 | 空文字列コードが渡された場合に例外がスローされること | E-01 (checkArgument line 43) | ○ |
| C-05 | maxMethodLengthが0以下の場合に例外がスローされること | E-01 (checkArgument line 44) | ○ |
| C-06 | maxClassMemberCountが0以下の場合に例外がスローされること | E-01 (checkArgument line 45) | ○ |
| C-07 | maxMethodLengthが1の場合でも正常に動作すること | E-01 (splitImplメソッド) | ○ |
| C-08 | 不正なJava構文の場合にRuntimeExceptionがスローされること | E-01 (try-catch line 34-39) | ○ |

### CodeSplitUtil (C-09 から C-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | カウンターが正しく取得できること | E-02 (getCounter line 34-36) | ○ |
| C-10 | 新しい名前が正しく生成されること | E-02 (newName line 38-40) | ○ |
| C-11 | 連続呼び出しでカウンターが増加すること | E-02 (getAndIncrement line 39) | ○ |
| C-12 | ParserRuleContextから文字列が正しく取得できること | E-02 (getContextString line 42-49) | ○ |
| C-13 | nullコンテキストの場合に空文字列が返却されること | E-02 (null check line 43-45) | ○ |
| C-14 | コンテキストのテキスト長が正しく取得できること | E-02 (getContextTextLength line 51-53) | ○ |

### CodeRewriter (C-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | インターフェースメソッドが正しく定義されていること | E-03 (rewrite interface method line 23) | ○ |

### ReturnValueRewriter (C-16 から C-21)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | 正常にインスタンスが生成されること | E-04 (constructor line 74-79) | ○ |
| C-17 | 戻り値を持つメソッドが正しく変換されること | E-04 (visitMethodDeclaration, InnerVisitor) | ○ |
| C-18 | voidメソッドは変換されないこと | E-04 (void check line 107-109) | ○ |
| C-19 | メソッド本体がmaxMethodLength未満の場合は変換されないこと | E-04 (methodBodyLength check line 110-113) | ○ |
| C-20 | 匿名クラス内のreturn文はスキップされること | E-04 (visitClassBody line 170-173) | ○ |
| C-21 | ラムダ式内のreturn文はスキップされること | E-04 (visitLambdaBody line 176-179) | ○ |

### DeclarationRewriter (C-22 から C-27)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | 正常にインスタンスが生成されること | E-05 (constructor line 88-94) | ○ |
| C-23 | ローカル変数がメンバー変数に抽出されること | E-05 (visitLocalVariableDeclaration) | ○ |
| C-24 | リライト不要な場合はnullが返却されること | E-05 (hasRewrite check line 100-102) | ○ |
| C-25 | 同名のローカル変数がリネームされること | E-05 (extractLocalVariable line 231-256) | ○ |
| C-26 | 拡張forループ内の変数が処理されること | E-05 (visitEnhancedForControl line 212-225) | ○ |
| C-27 | 1文で複数変数宣言がある場合に例外がスローされること | E-05 (Preconditions.checkArgument line 185-188) | ○ |

### BlockStatementRewriter (C-28 から C-33)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | 正常にインスタンスが生成されること | E-06 (constructor line 124-127) | ○ |
| C-29 | IF文のブロックが別メソッドに抽出されること | E-06 (statement.IF() check line 186-187) | ○ |
| C-30 | WHILE文のブロックが別メソッドに抽出されること | E-06 (statement.WHILE() check line 188) | ○ |
| C-31 | ELSE文のブロックが別メソッドに抽出されること | E-06 (statement.ELSE() check line 187) | ○ |
| C-32 | voidでないメソッドは処理されないこと | E-06 (void check line 155-157) | ○ |
| C-33 | throws句が正しく引き継がれること | E-06 (methodQualifier line 173-177) | ○ |

### BlockStatementSplitter (C-34 から C-38)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | 正常にインスタンスが生成されること | E-07 (constructor line 115-118) | ○ |
| C-35 | コードブロックが正しくリライトされること | E-07 (rewriteBlock line 127-135) | ○ |
| C-36 | 抽出されたブロックのマップが返却されること | E-07 (extractBlocks line 147-162) | ○ |
| C-37 | return文を含むブロックは抽出されないこと | E-07 (getNumOfReturnOrJumpStatements check line 184-186) | ○ |
| C-38 | 単一ステートメントは抽出されないこと | E-07 (canGroupAsSingleStatement line 249-253) | ○ |

### BlockStatementGrouper (C-39 から C-44)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | 正常にインスタンスが生成されること | E-08 (constructor line 124-133) | ○ |
| C-40 | ステートメントがグループ化されること | E-08 (rewrite line 143-151) | ○ |
| C-41 | maxMethodLengthを超えるとグループが分割されること | E-08 (groupBlock line 217-227) | ○ |
| C-42 | return文を含むブロックは抽出されないこと | E-08 (shouldExtract line 266-275) | ○ |
| C-43 | リライトされたコードが取得できること | E-08 (RewriteGroupedCode.getRewriteCode line 459-461) | ○ |
| C-44 | グループのマップが取得できること | E-08 (RewriteGroupedCode.getGroups line 463-465) | ○ |

### FunctionSplitter (C-45 から C-51)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | 正常にインスタンスが生成されること | E-09 (constructor line 106-109) | ○ |
| C-46 | 長いvoidメソッドが分割されること | E-09 (doFunctionSplit, visitMethodDeclaration) | ○ |
| C-47 | コンストラクタも分割されること | E-09 (visitConstructorDeclaration line 147-156) | ○ |
| C-48 | 非voidメソッドは分割されないこと | E-09 (void check line 161-163) | ○ |
| C-49 | return文がある場合にbool変数チェックが追加されること | E-09 (hasReturnedVarName check line 250-253) | ○ |
| C-50 | throws句が正しく引き継がれること | E-09 (methodQualifier line 217-219) | ○ |
| C-51 | ステートメントが1つしかない場合は分割されないこと | E-09 (blockStatement size check line 189-192) | ○ |

### MemberFieldRewriter (C-52 から C-64)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | 正常にインスタンスが生成されること | E-10 (constructor line 78-81) | ○ |
| C-53 | 同じ型のメンバー変数が配列にグループ化されること | E-10 (rewriteClassDeclaration line 197-247) | ○ |
| C-54 | フィールド数がmaxFieldCount未満の場合は変換されないこと | E-10 (fieldCount check line 86-93) | ○ |
| C-55 | static変数は変換されないこと | E-10 (static check line 159-165) | ○ |
| C-56 | referencesフィールドは変換されないこと | E-10 (references check line 173-176) | ○ |
| C-57 | 初期化式を持つフィールドの初期化ブロックが生成されること | E-10 (hasInit check line 229-245) | ○ |
| C-58 | ジェネリック型のフィールドが正しく処理されること | E-10 (typeWithoutArgs processing line 202-207) | ○ |
| C-59 | this.フィールド参照が正しく置換されること | E-10 (visitPrimary THIS check line 320-331) | ○ |
| C-60 | メソッドパラメータと同名のフィールドは区別されること | E-10 (visitMethodDeclaration excludedNames line 284-293) | ○ |
| C-61 | ローカル変数と同名のフィールドは区別されること | E-10 (visitLocalVariableDeclaration line 310-316) | ○ |
| C-62 | 1文で複数フィールド宣言がある場合に例外がスローされること | E-10 (checkMemberDeclaration line 255-258) | ○ |
| C-63 | 同名フィールドが存在する場合に例外がスローされること | E-10 (checkMemberDeclaration line 259-268) | ○ |
| C-64 | インナークラスのフィールドが正しく処理されること | E-10 (classStack in MemberFieldVisitor) | ○ |

### AddBoolBeforeReturnRewriter (C-65 から C-72)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | 正常にインスタンスが生成されること | E-11 (constructor line 90-97) | ○ |
| C-66 | return文の前にbool変数設定が追加されること | E-11 (InnerVisitor.visitStatement line 174-182) | ○ |
| C-67 | 非voidメソッドは処理されないこと | E-11 (void check line 126-128) | ○ |
| C-68 | メソッド本体がmaxMethodLength未満の場合は処理されないこと | E-11 (methodBodyLength check line 129-132) | ○ |
| C-69 | 匿名クラス内のreturn文はスキップされること | E-11 (visitClassBody line 162-165) | ○ |
| C-70 | ラムダ式内のreturn文はスキップされること | E-11 (visitLambdaBody line 167-170) | ○ |
| C-71 | bool変数名のリストが取得できること | E-11 (getBoolVarNames line 107-109) | ○ |
| C-72 | 複数のreturn文がすべて処理されること | E-11 (visitStatement visits all statements) | ○ |

### ReturnAndJumpCounter (C-73 から C-80)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | 正常にインスタンスが生成されること | E-12 (class definition line 23) | ○ |
| C-74 | return文がカウントされること | E-12 (RETURN check line 29) | ○ |
| C-75 | break文がカウントされること | E-12 (BREAK check line 29) | ○ |
| C-76 | continue文がカウントされること | E-12 (CONTINUE check line 29) | ○ |
| C-77 | カウント値が正しく取得できること | E-12 (getCounter line 35-37) | ○ |
| C-78 | 複数のジャンプ文が正しくカウントされること | E-12 (counter++ on each visit) | ○ |
| C-79 | ネストされたブロック内のジャンプ文もカウントされること | E-12 (visitChildren line 32) | ○ |
| C-80 | ジャンプ文がない場合は0が返却されること | E-12 (counter initialized to 0 line 25) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースにソースコードによる根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべてのテストケースがソースコードに基づいて生成されており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] JavaCodeSplitter.split() の入力検証テスト（C-03〜C-06）が実際の例外メッセージと一致するか確認
- [ ] 各Rewriterのrewrite()メソッドの戻り値の型と実装が一致するか確認
- [ ] 境界値テスト（C-07, C-51, C-80）が実際のエッジケースをカバーしているか確認
- [ ] ネストされたクラス（インナークラス、匿名クラス）の処理テストが十分か確認
- [ ] ラムダ式とストリーム処理のスキップ動作が正しくテストされているか確認
