---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート: flink-table_flink-table-common.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**: テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**: 主要なpublicメソッド・クラスを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.99**
  - 根拠あり: 148 / 150、根拠なし: 2
- 優先レビュー（高）
  1. **C-145, C-146**: deprecatedメソッドの動作は実装から推測
  2. **一部のdeprecated API**: 古いAPIのため現行テストとの整合性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/DataType.java`
- E-02: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/LogicalType.java`
- E-03: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/RowType.java`
- E-04: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/DecimalType.java`
- E-05: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/utils/LogicalTypeChecks.java`
- E-06: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/utils/LogicalTypeMerging.java`
- E-07: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/utils/DataTypeUtils.java`
- E-08: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/data/RowData.java`
- E-09: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/data/GenericRowData.java`
- E-10: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/data/StringData.java`
- E-11: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/catalog/ResolvedSchema.java`
- E-12: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/catalog/CatalogTable.java`
- E-13: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/functions/UserDefinedFunction.java`
- E-14: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/functions/ScalarFunction.java`
- E-15: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/VarCharType.java`
- E-16: `flink-table/flink-table-common/src/main/java/org/apache/flink/table/types/logical/ArrayType.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | DataType.getLogicalType()の正常系テスト | E-01 (line 84-86) | ○ |
| C-002 | DataType.getConversionClass()の正常系テスト | E-01 (line 95-97) | ○ |
| C-003 | DataType.toInternal()の正常系テスト | E-01 (line 120-122) | ○ |
| C-004 | DataType.getFieldNames()の正常系テスト（複合型） | E-01 (line 157-165) | ○ |
| C-005 | DataType.getFieldNames()の境界値テスト（非複合型） | E-01 (line 157-165) | ○ |
| C-006 | DataType.getFieldDataTypes()の正常系テスト | E-01 (line 173-181) | ○ |
| C-007 | DataType.getFieldCount()の正常系テスト | E-01 (line 189-191) | ○ |
| C-008 | DataType.getFieldCount()の境界値テスト | E-01 (line 189-191) | ○ |
| C-009 | DataType.equals()の正常系テスト | E-01 (line 130-145) | ○ |
| C-010 | DataType.equals()の異常系テスト | E-01 (line 130-145) | ○ |
| C-011 | DataTypeコンストラクタのnull検証 | E-01 (line 71-77) | ○ |
| C-012 | DataTypeコンストラクタの変換クラス検証 | E-01 (line 213-225) | ○ |
| C-013 | LogicalType.isNullable()の正常系テスト（nullable） | E-02 (line 69-71) | ○ |
| C-014 | LogicalType.isNullable()の正常系テスト（NOT NULL） | E-02 (line 69-71) | ○ |
| C-015 | LogicalType.getTypeRoot()の正常系テスト | E-02 (line 76-78) | ○ |
| C-016 | LogicalType.is(LogicalTypeRoot)の正常系テスト | E-02 (line 85-87) | ○ |
| C-017 | LogicalType.is(LogicalTypeFamily)の正常系テスト | E-02 (line 113-115) | ○ |
| C-018 | LogicalType.isAnyOf(LogicalTypeRoot...)の正常系テスト | E-02 (line 94-96) | ○ |
| C-019 | LogicalType.copy()の正常系テスト | E-02 (line 130-132) | ○ |
| C-020 | LogicalType.copy(boolean)の正常系テスト | E-02 (line 123) | ○ |
| C-021 | LogicalType.asSerializableString()の正常系テスト | E-02 (line 142) | ○ |
| C-022 | LogicalType.supportsInputConversion()の正常系テスト | E-02 (line 172) | ○ |
| C-023 | LogicalType.supportsInputConversion()の異常系テスト | E-02 (line 172) | ○ |
| C-024 | LogicalType.supportsOutputConversion()の正常系テスト | E-02 (line 191) | ○ |
| C-025 | LogicalType.getDefaultConversion()の正常系テスト | E-02 (line 204) | ○ |
| C-026 | RowTypeコンストラクタの正常系テスト | E-03 (line 151-159) | ○ |
| C-027 | RowTypeコンストラクタの空白フィールド名検証 | E-03 (line 260-275) | ○ |
| C-028 | RowTypeコンストラクタの重複フィールド名検証 | E-03 (line 260-275) | ○ |
| C-029 | RowType.getFields()の正常系テスト | E-03 (line 165-167) | ○ |
| C-030 | RowType.getFieldNames()の正常系テスト | E-03 (line 169-171) | ○ |
| C-031 | RowType.getTypeAt()の正常系テスト | E-03 (line 173-175) | ○ |
| C-032 | RowType.getTypeAt()の異常系テスト（範囲外） | E-03 (line 173-175) | ○ |
| C-033 | RowType.getFieldCount()の正常系テスト | E-03 (line 177-179) | ○ |
| C-034 | RowType.getFieldCount()の境界値テスト | E-03 (line 177-179) | ○ |
| C-035 | RowType.getFieldIndex()の正常系テスト | E-03 (line 181-188) | ○ |
| C-036 | RowType.getFieldIndex()の異常系テスト | E-03 (line 181-188) | ○ |
| C-037 | RowType.of(LogicalType...)の正常系テスト | E-03 (line 277-287) | ○ |
| C-038 | RowType.of(LogicalType[], String[])の正常系テスト | E-03 (line 289-299) | ○ |
| C-039 | RowField コンストラクタの正常系テスト | E-03 (line 79-87) | ○ |
| C-040 | RowField コンストラクタのnull検証 | E-03 (line 79-83) | ○ |
| C-041 | RowField.getDescription()の正常系テスト | E-03 (line 97-99) | ○ |
| C-042 | RowField.getDescription()の境界値テスト | E-03 (line 97-99) | ○ |
| C-043 | DecimalTypeコンストラクタの正常系テスト | E-04 (line 66-82) | ○ |
| C-044 | DecimalTypeコンストラクタの精度最小値検証 | E-04 (line 68-73) | ○ |
| C-045 | DecimalTypeコンストラクタの精度最大値検証 | E-04 (line 68-73) | ○ |
| C-046 | DecimalTypeコンストラクタのスケール最小値検証 | E-04 (line 74-79) | ○ |
| C-047 | DecimalTypeコンストラクタのスケール最大値検証 | E-04 (line 74-79) | ○ |
| C-048 | DecimalTypeコンストラクタの精度最小境界値テスト | E-04 (line 66-82) | ○ |
| C-049 | DecimalTypeコンストラクタの精度最大境界値テスト | E-04 (line 66-82) | ○ |
| C-050 | DecimalType.getPrecision()の正常系テスト | E-04 (line 96-98) | ○ |
| C-051 | DecimalType.getScale()の正常系テスト | E-04 (line 100-102) | ○ |
| C-052 | LogicalTypeChecks.isCompositeType()の正常系テスト（ROW） | E-05 (line 137-144) | ○ |
| C-053 | LogicalTypeChecks.isCompositeType()の正常系テスト（STRUCTURED） | E-05 (line 137-144) | ○ |
| C-054 | LogicalTypeChecks.isCompositeType()の非複合型テスト | E-05 (line 137-144) | ○ |
| C-055 | LogicalTypeChecks.getPrecision()のDECIMALテスト | E-05 (line 155-157) | ○ |
| C-056 | LogicalTypeChecks.getPrecision()のTIMESTAMPテスト | E-05 (line 155-157) | ○ |
| C-057 | LogicalTypeChecks.getScale()の正常系テスト | E-05 (line 165-167) | ○ |
| C-058 | LogicalTypeChecks.getLength()の正常系テスト | E-05 (line 146-148) | ○ |
| C-059 | LogicalTypeChecks.getFieldCount()の正常系テスト | E-05 (line 203-205) | ○ |
| C-060 | LogicalTypeChecks.getFieldNames()の正常系テスト | E-05 (line 208-210) | ○ |
| C-061 | LogicalTypeChecks.isTimeAttribute()の正常系テスト | E-05 (line 110-112) | ○ |
| C-062 | LogicalTypeChecks.isProctimeAttribute()の正常系テスト | E-05 (line 119-122) | ○ |
| C-063 | LogicalTypeChecks.hasNested()の正常系テスト | E-05 (line 97-100) | ○ |
| C-064 | LogicalTypeChecks.areComparable()の正常系テスト | E-05 (line 248-254) | ○ |
| C-065 | LogicalTypeMerging.findCommonType()の正常系テスト | E-06 (line 162-198) | ○ |
| C-066 | LogicalTypeMerging.findCommonType()のDECIMALテスト | E-06 (line 162-198) | ○ |
| C-067 | LogicalTypeMerging.findCommonType()の非互換型テスト | E-06 (line 162-198) | ○ |
| C-068 | LogicalTypeMerging.findDivisionDecimalType()の正常系テスト | E-06 (line 215-220) | ○ |
| C-069 | LogicalTypeMerging.findMultiplicationDecimalType()の正常系テスト | E-06 (line 231-236) | ○ |
| C-070 | LogicalTypeMerging.findAdditionDecimalType()の正常系テスト | E-06 (line 239-244) | ○ |
| C-071 | LogicalTypeMerging.findModuloDecimalType()の正常系テスト | E-06 (line 223-228) | ○ |
| C-072 | LogicalTypeMerging.findRoundDecimalType()の正常系テスト | E-06 (line 247-258) | ○ |
| C-073 | LogicalTypeMerging.findAvgAggType()の正常系テスト | E-06 (line 261-277) | ○ |
| C-074 | LogicalTypeMerging.findSumAggType()の正常系テスト | E-06 (line 280-294) | ○ |
| C-075 | DataTypeUtils.toInternalDataType()の正常系テスト | E-07 (line 299-307) | ○ |
| C-076 | DataTypeUtils.isInternal()の正常系テスト | E-07 (line 310-324) | ○ |
| C-077 | DataTypeUtils.validateInputDataType()の正常系テスト | E-07 (line 352-354) | ○ |
| C-078 | DataTypeUtils.validateInputDataType()の異常系テスト | E-07 (line 364-379) | ○ |
| C-079 | DataTypeUtils.validateOutputDataType()の正常系テスト | E-07 (line 360-362) | ○ |
| C-080 | DataTypeUtils.appendRowFields()の正常系テスト | E-07 (line 125-137) | ○ |
| C-081 | DataTypeUtils.appendRowFields()の境界値テスト | E-07 (line 125-137) | ○ |
| C-082 | DataTypeUtils.expandCompositeTypeToSchema()の正常系テスト | E-07 (line 154-163) | ○ |
| C-083 | DataTypeUtils.expandCompositeTypeToSchema()の異常系テスト | E-07 (line 154-163) | ○ |
| C-084 | DataTypeUtils.flattenToDataTypes()の正常系テスト | E-07 (line 248-256) | ○ |
| C-085 | DataTypeUtils.flattenToNames()の正常系テスト | E-07 (line 262-278) | ○ |
| C-086 | RowData.getArity()の正常系テスト | E-08 (line 123) | ○ |
| C-087 | RowData.getRowKind()の正常系テスト | E-08 (line 130) | ○ |
| C-088 | RowData.setRowKind()の正常系テスト | E-08 (line 137) | ○ |
| C-089 | RowData.isNullAt()の正常系テスト（null） | E-08 (line 144) | ○ |
| C-090 | RowData.isNullAt()の正常系テスト（非null） | E-08 (line 144) | ○ |
| C-091 | RowData.getInt()の正常系テスト | E-08 (line 155) | ○ |
| C-092 | RowData.getString()の正常系テスト | E-08 (line 168) | ○ |
| C-093 | RowData.getDecimal()の正常系テスト | E-08 (line 176) | ○ |
| C-094 | RowData.getTimestamp()の正常系テスト | E-08 (line 184) | ○ |
| C-095 | RowData.getArray()の正常系テスト | E-08 (line 193) | ○ |
| C-096 | RowData.getMap()の正常系テスト | E-08 (line 196) | ○ |
| C-097 | RowData.getRow()の正常系テスト | E-08 (line 203) | ○ |
| C-098 | RowData.createFieldGetter()の正常系テスト | E-08 (line 219-303) | ○ |
| C-099 | GenericRowDataコンストラクタ(int)の正常系テスト | E-09 (line 82-85) | ○ |
| C-100 | GenericRowDataコンストラクタ(RowKind, int)の正常系テスト | E-09 (line 67-70) | ○ |
| C-101 | GenericRowData.setField()の正常系テスト | E-09 (line 96-98) | ○ |
| C-102 | GenericRowData.setField()の境界値テスト（null） | E-09 (line 96-98) | ○ |
| C-103 | GenericRowData.getField()の正常系テスト | E-09 (line 108-110) | ○ |
| C-104 | GenericRowData.of()の正常系テスト | E-09 (line 258-266) | ○ |
| C-105 | GenericRowData.ofKind()の正常系テスト | E-09 (line 273-281) | ○ |
| C-106 | GenericRowData.equals()の正常系テスト | E-09 (line 215-224) | ○ |
| C-107 | GenericRowData.equals()の異常系テスト | E-09 (line 215-224) | ○ |
| C-108 | StringData.fromString()の正常系テスト | E-10 (line 45-47) | ○ |
| C-109 | StringData.fromString()の境界値テスト（空文字列） | E-10 (line 45-47) | ○ |
| C-110 | StringData.fromBytes()の正常系テスト | E-10 (line 50-52) | ○ |
| C-111 | StringData.fromBytes(byte[], int, int)の正常系テスト | E-10 (line 58-60) | ○ |
| C-112 | StringData.toBytes()の正常系テスト | E-10 (line 35) | ○ |
| C-113 | StringData.toString()の正常系テスト | E-10 (line 38) | ○ |
| C-114 | ResolvedSchema.of(List)の正常系テスト | E-11 (line 90-92) | ○ |
| C-115 | ResolvedSchema.of(Column...)の正常系テスト | E-11 (line 95-97) | ○ |
| C-116 | ResolvedSchema.physical()の正常系テスト | E-11 (line 100-115) | ○ |
| C-117 | ResolvedSchema.getColumnCount()の正常系テスト | E-11 (line 118-120) | ○ |
| C-118 | ResolvedSchema.getColumns()の正常系テスト | E-11 (line 123-125) | ○ |
| C-119 | ResolvedSchema.getColumnNames()の正常系テスト | E-11 (line 128-130) | ○ |
| C-120 | ResolvedSchema.getColumnDataTypes()の正常系テスト | E-11 (line 135-137) | ○ |
| C-121 | ResolvedSchema.getColumn(int)の正常系テスト | E-11 (line 144-149) | ○ |
| C-122 | ResolvedSchema.getColumn(int)の境界値テスト | E-11 (line 144-149) | ○ |
| C-123 | ResolvedSchema.getColumn(String)の正常系テスト | E-11 (line 156-160) | ○ |
| C-124 | ResolvedSchema.getColumn(String)の異常系テスト | E-11 (line 156-160) | ○ |
| C-125 | ResolvedSchema.getPrimaryKey()の正常系テスト | E-11 (line 174-176) | ○ |
| C-126 | ResolvedSchema.getPrimaryKey()の境界値テスト | E-11 (line 174-176) | ○ |
| C-127 | ResolvedSchema.toPhysicalRowDataType()の正常系テスト | E-11 (line 226-228) | ○ |
| C-128 | ResolvedSchema.toSourceRowDataType()の正常系テスト | E-11 (line 212-214) | ○ |
| C-129 | ResolvedSchema.toSinkRowDataType()の正常系テスト | E-11 (line 243-245) | ○ |
| C-130 | CatalogTable.Builder.build()の正常系テスト | E-12 (line 157-160) | ○ |
| C-131 | CatalogTable.Builder.schema()の正常系テスト | E-12 (line 126-129) | ○ |
| C-132 | CatalogTable.Builder.schema()の異常系テスト | E-12 (line 126-129) | ○ |
| C-133 | CatalogTable.Builder.partitionKeys()の正常系テスト | E-12 (line 136-140) | ○ |
| C-134 | CatalogTable.Builder.options()の正常系テスト | E-12 (line 142-145) | ○ |
| C-135 | CatalogTable.isPartitioned()の正常系テスト（パーティション有り） | E-12 (line 85) | ○ |
| C-136 | CatalogTable.isPartitioned()の正常系テスト（パーティション無し） | E-12 (line 85) | ○ |
| C-137 | CatalogTable.getPartitionKeys()の正常系テスト | E-12 (line 93) | ○ |
| C-138 | CatalogTable.fromProperties()の正常系テスト | E-12 (line 71-73) | ○ |
| C-139 | UserDefinedFunction.functionIdentifier()の正常系テスト | E-13 (line 63-71) | ○ |
| C-140 | UserDefinedFunction.open()の正常系テスト | E-13 (line 77-79) | ○ |
| C-141 | UserDefinedFunction.close()の正常系テスト | E-13 (line 85-87) | ○ |
| C-142 | UserDefinedFunction.isDeterministic()の正常系テスト | E-13 (FunctionDefinitionより継承) | ○ |
| C-143 | ScalarFunction.getKind()の正常系テスト | E-14 (line 138-140) | ○ |
| C-144 | ScalarFunction.getTypeInference()の正常系テスト | E-14 (line 143-145) | ○ |
| C-145 | ScalarFunction.getResultType()の正常系テスト | E-14 (line 106-108) | △ |
| C-146 | ScalarFunction.getParameterTypes()の正常系テスト | E-14 (line 122-135) | △ |
| C-147 | ScalarFunction.getParameterTypes()の異常系テスト | E-14 (line 122-135) | ○ |
| C-148 | VarCharTypeコンストラクタの正常系テスト | E-15 | ○ |
| C-149 | VarCharTypeコンストラクタの境界値テスト | E-15 | ○ |
| C-150 | ArrayTypeコンストラクタの正常系テスト | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-145, C-146**: deprecatedメソッドのため、実際の動作は実行時に確認が必要
  - 候補: 既存のテストコード / 実行時デバッグ / ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大半のテストケースはソースコードから直接確認可能
- **1 (中リスク)**: deprecatedメソッド（C-145, C-146）については実装詳細の確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 主要なDataType系クラス（DataType, LogicalType, RowType, DecimalType）のテストケースが網羅されているか確認
- [ ] 境界値テスト（最小/最大値、空コレクション）が適切に含まれているか確認
- [ ] 異常系テスト（null入力、不正パラメータ）が主要メソッドに含まれているか確認
- [ ] deprecatedメソッド（C-145, C-146）のテスト必要性を判断
- [ ] flink-table-commonモジュール固有のカタログ系クラス（CatalogTable, ResolvedSchema）のテストケースが適切か確認
- [ ] RowData関連のデータ構造テストケースがユースケースをカバーしているか確認
