---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 90
  claims_with_evidence: 85
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート：flink-table_flink-table-planner 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：85 / 90、根拠なし：5
- 優先レビュー（高）
  1. **UT-TPL-086**: CatalogSchemaTable コンストラクタ - 内部実装詳細が不明
  2. **UT-TPL-087**: FunctionCatalogOperatorTable - 関数検索の詳細ロジック未確認
  3. **UT-TPL-088-089**: DatabaseCalciteSchema - getTable の詳細実装未確認
  4. **UT-TPL-090**: TableConfigUtils - 設定値取得の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/calcite/FlinkTypeSystem.java`
- E-02: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/calcite/FlinkRelBuilder.java`
- E-03: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/connectors/DynamicSinkUtils.java`
- E-04: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/connectors/DynamicSourceUtils.java`
- E-05: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/hint/FlinkHints.java`
- E-06: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/QueryOperationConverter.java`
- E-07: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/delegation/ParserImpl.java`
- E-08: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/ExecNodeGraphGenerator.java`
- E-09: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/catalog/CatalogSchemaTable.java` (参照のみ)
- E-10: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/catalog/FunctionCatalogOperatorTable.java` (参照のみ)
- E-11: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/catalog/DatabaseCalciteSchema.java` (参照のみ)
- E-12: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/utils/TableConfigUtils.java` (参照のみ)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FlinkTypeSystem.getMaxNumericPrecision が DecimalType.MAX_PRECISION を返す | E-01 (line 52-55) | ○ |
| C-02 | FlinkTypeSystem.getMaxNumericScale が DecimalType.MAX_PRECISION を返す | E-01 (line 57-61) | ○ |
| C-03 | FlinkTypeSystem.getDefaultPrecision(VARCHAR) が Integer.MAX_VALUE を返す | E-01 (line 64-79) | ○ |
| C-04 | FlinkTypeSystem.getDefaultPrecision(TIMESTAMP) が 6 を返す | E-01 (line 64-79) | ○ |
| C-05 | FlinkTypeSystem.getMaxPrecision(TIMESTAMP) が 9 を返す | E-01 (line 81-101) | ○ |
| C-06 | FlinkTypeSystem.shouldConvertRaggedUnionTypesToVarying が true を返す | E-01 (line 103-109) | ○ |
| C-07 | FlinkTypeSystem.deriveAvgAggType が正しい型を導出する | E-01 (line 111-117) | ○ |
| C-08 | FlinkTypeSystem.deriveSumType が正しい型を導出する | E-01 (line 119-124) | ○ |
| C-09 | FlinkTypeSystem.deriveDecimalPlusType が正しい型を導出する | E-01 (line 126-131) | ○ |
| C-10 | FlinkTypeSystem.deriveDecimalModType が正しい型を導出する | E-01 (line 133-148) | ○ |
| C-11 | FlinkTypeSystem.deriveDecimalDivideType が正しい型を導出する | E-01 (line 150-155) | ○ |
| C-12 | FlinkTypeSystem.deriveDecimalMultiplyType が正しい型を導出する | E-01 (line 157-162) | ○ |
| C-13 | FlinkRelBuilder.of がインスタンスを生成する | E-02 (line 98-101) | ○ |
| C-14 | FlinkRelBuilder.of が null context で例外をスローする | E-02 (line 100) Preconditions.checkNotNull | ○ |
| C-15 | FlinkRelBuilder.pushFunctionScan がテーブル関数をプッシュする | E-02 (line 119-161) | ○ |
| C-16 | FlinkRelBuilder.pushFunctionScan が非テーブル関数で例外をスローする | E-02 (line 126-128) | ○ |
| C-17 | FlinkRelBuilder.expand が Expand ノードを構築する | E-02 (line 163-167) | ○ |
| C-18 | FlinkRelBuilder.rank が Rank ノードを構築する | E-02 (line 169-187) | ○ |
| C-19 | FlinkRelBuilder.aggregate が集計を構築する | E-02 (line 190-210) | ○ |
| C-20 | FlinkRelBuilder.aggregate が TableAggregate を生成する | E-02 (line 196-199) | ○ |
| C-21 | FlinkRelBuilder.windowAggregate がウィンドウ集計を構築する | E-02 (line 213-243) | ○ |
| C-22 | FlinkRelBuilder.watermark が WatermarkAssigner を構築する | E-02 (line 245-252) | ○ |
| C-23 | FlinkRelBuilder.queryOperation が QueryOperation を変換する | E-02 (line 254-257) | ○ |
| C-24 | FlinkRelBuilder.getTypeFactory が FlinkTypeFactory を返す | E-02 (line 259-262) | ○ |
| C-25 | DynamicSinkUtils.convertCollectToRel が Collect を変換する | E-03 (line 126-178) | ○ |
| C-26 | DynamicSinkUtils.convertExternalToRel が External を変換する | E-03 (line 183-202) | ○ |
| C-27 | DynamicSinkUtils.convertSinkToRel が Sink を変換する | E-03 (line 207-223) | ○ |
| C-28 | DynamicSinkUtils.validateSchemaAndApplyImplicitCast がスキーマ検証を行う | E-03 (line 366-438) | ○ |
| C-29 | validateSchemaAndApplyImplicitCast が列数不一致で例外をスローする | E-03 (line 410-413) | ○ |
| C-30 | validateSchemaAndApplyImplicitCast が型不一致で例外をスローする | E-03 (line 419-427) | ○ |
| C-31 | DynamicSinkUtils.createConsumedType が RowType を生成する | E-03 (line 1340-1366) | ○ |
| C-32 | DynamicSourceUtils.convertDataStreamToRel が DataStream を変換する | E-04 (line 83-109) | ○ |
| C-33 | DynamicSourceUtils.convertSourceToRel が Source を変換する | E-04 (line 114-159) | ○ |
| C-34 | DynamicSourceUtils.prepareDynamicSource が Source を準備する | E-04 (line 164-183) | ○ |
| C-35 | DynamicSourceUtils.createRequiredMetadataColumns がメタデータ列を生成する | E-04 (line 195-207) | ○ |
| C-36 | DynamicSourceUtils.createProducedType が RowType を生成する | E-04 (line 236-258) | ○ |
| C-37 | DynamicSourceUtils.isUpsertSource が Upsert を判定する | E-04 (line 260-271) | ○ |
| C-38 | DynamicSourceUtils.isUpsertSource が INSERT-only で false を返す | E-04 (line 260-271) | ○ |
| C-39 | DynamicSourceUtils.isSourceChangeEventsDuplicate が CDC 重複を判定する | E-04 (line 273-288) | ○ |
| C-40 | DynamicSourceUtils.changelogNormalizeEnabled が Normalize 有効を判定する | E-04 (line 290-299) | ○ |
| C-41 | DynamicSourceUtils.validateAndApplyMetadata がメタデータを検証する | E-04 (line 425-504) | ○ |
| C-42 | validateAndApplyMetadata が SupportsReadingMetadata 未実装で例外をスローする | E-04 (line 436-444) | ○ |
| C-43 | FlinkHints.getHintedOptions が OPTIONS ヒントを取得する | E-05 (line 72-78) | ○ |
| C-44 | FlinkHints.getHintedOptions が OPTIONS なしで空 Map を返す | E-05 (line 72-78) | ○ |
| C-45 | FlinkHints.mergeTableOptions がオプションをマージする | E-05 (line 92-101) | ○ |
| C-46 | FlinkHints.mergeTableOptions が hints を優先する | E-05 (line 92-101) | ○ |
| C-47 | FlinkHints.mergeTableOptions が空 hints で props を返す | E-05 (line 94-96) | ○ |
| C-48 | FlinkHints.getTableAlias がエイリアスを取得する | E-05 (line 103-118) | ○ |
| C-49 | FlinkHints.getTableAlias がエイリアスなしで空を返す | E-05 (line 103-118) | ○ |
| C-50 | FlinkHints.canTransposeToTableScan がトランスポーズ可否を判定する | E-05 (line 120-125) | ○ |
| C-51 | FlinkHints.getTableName がテーブル名を取得する | E-05 (line 128-144) | ○ |
| C-52 | FlinkHints.getTableName が null で空を返す | E-05 (line 129-131) | ○ |
| C-53 | FlinkHints.getTableName が未知クラスで例外をスローする | E-05 (line 137-141) | ○ |
| C-54 | FlinkHints.stringifyHints がヒントを文字列化する | E-05 (line 146-170) | ○ |
| C-55 | FlinkHints.getAllQueryHints がクエリヒントを抽出する | E-05 (line 173-180) | ○ |
| C-56 | FlinkHints.isQueryHint がクエリヒントを判定する | E-05 (line 268-270) | ○ |
| C-57 | FlinkHints.isAliasHint がエイリアスヒントを判定する | E-05 (line 273-275) | ○ |
| C-58 | QueryOperationConverter.defaultMethod が QueryOperation を変換する | E-06 (line 158-162) | ○ |
| C-59 | SingleRelVisitor.visit(ProjectQueryOperation) が Project を変換する | E-06 (line 167-173) | ○ |
| C-60 | SingleRelVisitor.visit(AggregateQueryOperation) が Aggregate を変換する | E-06 (line 176-185) | ○ |
| C-61 | SingleRelVisitor.visit(WindowAggregateQueryOperation) が WindowAggregate を変換する | E-06 (line 188-205) | ○ |
| C-62 | SingleRelVisitor.visit(JoinQueryOperation) が Join を変換する | E-06 (line 246-261) | ○ |
| C-63 | SingleRelVisitor.visit(SetQueryOperation) UNION が Union を変換する | E-06 (line 264-277) | ○ |
| C-64 | SingleRelVisitor.visit(SetQueryOperation) INTERSECT が Intersect を変換する | E-06 (line 264-277) | ○ |
| C-65 | SingleRelVisitor.visit(SetQueryOperation) MINUS が Minus を変換する | E-06 (line 264-277) | ○ |
| C-66 | SingleRelVisitor.visit(FilterQueryOperation) が Filter を変換する | E-06 (line 280-283) | ○ |
| C-67 | SingleRelVisitor.visit(DistinctQueryOperation) が Distinct を変換する | E-06 (line 286-288) | ○ |
| C-68 | SingleRelVisitor.visit(SortQueryOperation) が Sort を変換する | E-06 (line 291-294) | ○ |
| C-69 | SingleRelVisitor.visit(FunctionQueryOperation) が TableFunctionScan を変換する | E-06 (line 297-362) | ○ |
| C-70 | SingleRelVisitor.visit(SourceQueryOperation) が TableScan を変換する | E-06 (line 434-444) | ○ |
| C-71 | SingleRelVisitor.visit(ValuesQueryOperation) が LogicalValues を変換する | E-06 (line 447-482) | ○ |
| C-72 | SingleRelVisitor.visit(ValuesQueryOperation) 空 values で空 LogicalValues を生成する | E-06 (line 457-460) | ○ |
| C-73 | ParserImpl.parse が SQL を Operation に変換する | E-07 (line 91-108) | ○ |
| C-74 | ParserImpl.parse が拡張パーサーを優先する | E-07 (line 95-98) | ○ |
| C-75 | ParserImpl.parse がサポート外で例外をスローする | E-07 (line 105-107) | ○ |
| C-76 | ParserImpl.parse が複数文で例外をスローする | E-07 (line 104) | ○ |
| C-77 | ParserImpl.parseIdentifier が識別子を解析する | E-07 (line 111-115) | ○ |
| C-78 | ParserImpl.parseSqlExpression が式を解析する | E-07 (line 118-136) | ○ |
| C-79 | ParserImpl.parseSqlExpression が無効式で例外をスローする | E-07 (line 132-135) | ○ |
| C-80 | ParserImpl.getCompletionHints が補完候補を取得する | E-07 (line 138-157) | ○ |
| C-81 | ExecNodeGraphGenerator.generate が ExecNodeGraph を生成する | E-08 (line 57-63) | ○ |
| C-82 | ExecNodeGraphGenerator.generate が共有ノードを処理する | E-08 (line 65-69) | ○ |
| C-83 | ExecNodeGraphGenerator.generate が IntermediateTableScan で例外をスローする | E-08 (line 71-73) | ○ |
| C-84 | checkUidForProcessTableFunction が一意 UID で正常終了する | E-08 (line 92-109) | ○ |
| C-85 | checkUidForProcessTableFunction が重複 UID で例外をスローする | E-08 (line 100-108) | ○ |
| C-86 | CatalogSchemaTable コンストラクタが初期化する | E-09 (参照のみ) | △ |
| C-87 | FunctionCatalogOperatorTable.lookupOperatorOverloads が関数を検索する | E-10 (参照のみ) | △ |
| C-88 | DatabaseCalciteSchema.getTable がテーブルを取得する | E-11 (参照のみ) | △ |
| C-89 | DatabaseCalciteSchema.getTable が存在しないテーブルで null を返す | E-11 (参照のみ) | △ |
| C-90 | TableConfigUtils.getMaxIdleStateRetentionTime が設定値を取得する | E-12 (参照のみ) | △ |

## 4) 不足情報（Unknown / Missing）
- **CatalogSchemaTable、FunctionCatalogOperatorTable、DatabaseCalciteSchema、TableConfigUtils** の詳細実装を読み込んでいないため、テストケースの正確性を十分に検証できていません
  - 候補：これらのファイルを詳細に解析 / 既存テストコードを参照 / 設計ドキュメントを確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: FlinkTypeSystem、FlinkRelBuilder、FlinkHints - ソースコードを詳細に確認済み
- **0: 低リスク**: DynamicSinkUtils、DynamicSourceUtils - ソースコードを詳細に確認済み
- **0: 低リスク**: QueryOperationConverter、ParserImpl、ExecNodeGraphGenerator - ソースコードを詳細に確認済み
- **1: 中リスク**: CatalogSchemaTable、FunctionCatalogOperatorTable - 参照のみで詳細未確認
- **1: 中リスク**: DatabaseCalciteSchema、TableConfigUtils - 参照のみで詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] FlinkTypeSystem の型精度・スケール設定が Flink の仕様と一致しているか確認
- [ ] FlinkRelBuilder の各ビルダーメソッドがCalcite RelNodeを正しく生成するか確認
- [ ] DynamicSinkUtils/DynamicSourceUtils の検証ロジックが実際の制約と一致しているか確認
- [ ] QueryOperationConverter の各visit メソッドが全ての QueryOperation タイプをカバーしているか確認
- [ ] ParserImpl の例外処理が適切なエラーメッセージを出力するか確認
- [ ] ExecNodeGraphGenerator のノード共有・UID重複検出ロジックが正しいか確認
- [ ] 未詳細確認クラス（CatalogSchemaTable等）のテストケースが実装と整合しているか確認
