---
generated_at: 2026-02-02 18:45:00
metrics:
  claims_total: 141
  claims_with_evidence: 141
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: flink-table_flink-table-runtime.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：141 / 141、根拠なし：0
- 優先レビュー（高）
  1. **CompileUtils関連テストケース**: コード生成・コンパイル機能の中核テスト
  2. **TopNBuffer関連テストケース**: ランキング処理のバッファ管理テスト
  3. **TimeWindowUtil関連テストケース**: ウィンドウ処理のタイムゾーン・時刻計算テスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/generated/CompileUtils.java`
- E-02: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/types/PlannerTypeUtils.java`
- E-03: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/operators/join/HashJoinType.java`
- E-04: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/operators/sort/SortUtil.java`
- E-05: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/operators/join/stream/bundle/BufferBundle.java`
- E-06: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/formats/raw/RawFormatSerializationSchema.java`
- E-07: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/context/ExecutionContextImpl.java`
- E-08: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/operators/rank/TopNBuffer.java`
- E-09: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/util/SegmentsUtil.java`
- E-10: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/data/util/RowDataUtil.java`
- E-11: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/util/TimeWindowUtil.java`
- E-12: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/runtime/util/MurmurHashUtil.java`
- E-13: `flink-table/flink-table-runtime/src/main/java/org/apache/flink/table/data/util/DataFormatConverters.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompileUtils.compile - 有効なJavaコードがクラスにコンパイルされること | E-01 (L86-96) | ○ |
| C-02 | CompileUtils.compile - キャッシュが使用されること | E-01 (L52-59, L91-92) | ○ |
| C-03 | CompileUtils.compile - 不正なJavaコードでエラー発生 | E-01 (L93-95) | ○ |
| C-04 | CompileUtils.compile - nullのClassLoaderでエラー | E-01 (L99) | ○ |
| C-05 | CompileUtils.compileExpression - 有効な式がコンパイルされること | E-01 (L140-172) | ○ |
| C-06 | CompileUtils.compileExpression - 不正な式でエラー | E-01 (L161-166) | ○ |
| C-07 | CompileUtils.cleanUp - キャッシュがクリーンアップされること | E-01 (L71-74) | ○ |
| C-08 | PlannerTypeUtils.removeLegacyTypes - レガシー型変換 | E-02 (L65-67) | ○ |
| C-09 | PlannerTypeUtils.isPrimitive - プリミティブ型判定(true) | E-02 (L69-86) | ○ |
| C-10 | PlannerTypeUtils.isPrimitive - 非プリミティブ型判定(false) | E-02 (L69-86) | ○ |
| C-11 | PlannerTypeUtils.isInteroperable - 互換性あり(true) | E-02 (L92-125) | ○ |
| C-12 | PlannerTypeUtils.isInteroperable - 互換性なし(false) | E-02 (L102-104) | ○ |
| C-13 | PlannerTypeUtils.isInteroperable - ネスト型の互換性 | E-02 (L106-121) | ○ |
| C-14 | PlannerTypeUtils.isAssignable - 代入可能(true) | E-02 (L133-174) | ○ |
| C-15 | PlannerTypeUtils.isAssignable - 代入不可能(false) | E-02 (L144-146) | ○ |
| C-16 | HashJoinType.isBuildOuter - BUILD_OUTER判定 | E-03 (L32-34) | ○ |
| C-17 | HashJoinType.isBuildOuter - FULL_OUTER判定 | E-03 (L32-34) | ○ |
| C-18 | HashJoinType.isBuildOuter - INNER判定 | E-03 (L32-34) | ○ |
| C-19 | HashJoinType.isProbeOuter - PROBE_OUTER判定 | E-03 (L36-38) | ○ |
| C-20 | HashJoinType.leftSemiOrAnti - SEMI判定 | E-03 (L40-42) | ○ |
| C-21 | HashJoinType.buildLeftSemiOrAnti - BUILD_LEFT_SEMI判定 | E-03 (L44-46) | ○ |
| C-22 | HashJoinType.needSetProbed - 設定要否判定 | E-03 (L48-50) | ○ |
| C-23 | HashJoinType.of(3args) - FULL_OUTER生成 | E-03 (L52-62) | ○ |
| C-24 | HashJoinType.of(3args) - INNER生成 | E-03 (L52-62) | ○ |
| C-25 | HashJoinType.of(5args) - SEMI生成 | E-03 (L64-83) | ○ |
| C-26 | SortUtil.minNormalizedKey - 最小キー生成 | E-04 (L39-44) | ○ |
| C-27 | SortUtil.maxNormalizedKey - 最大キー生成 | E-04 (L47-52) | ○ |
| C-28 | SortUtil.putStringNormalizedKey - 文字列キー設定 | E-04 (L70-82) | ○ |
| C-29 | SortUtil.putStringNormalizedKey - 切り詰め処理 | E-04 (L74-77) | ○ |
| C-30 | SortUtil.putDecimalNormalizedKey - Decimalキー設定 | E-04 (L85-89) | ○ |
| C-31 | SortUtil.putIntNormalizedKey - Intキー設定 | E-04 (L91-94) | ○ |
| C-32 | SortUtil.putLongNormalizedKey - Longキー設定 | E-04 (L96-99) | ○ |
| C-33 | SortUtil.putFloatNormalizedKey - Floatキー設定 | E-04 (L102-107) | ○ |
| C-34 | SortUtil.putDoubleNormalizedKey - Doubleキー設定 | E-04 (L110-115) | ○ |
| C-35 | SortUtil.putTimestampNormalizedKey - Timestampキー設定 | E-04 (L131-135) | ○ |
| C-36 | SortUtil.compareBinary - 等しい配列で0 | E-04 (L137-139) | ○ |
| C-37 | SortUtil.compareBinary - aが小さい場合に負 | E-04 (L141-201) | ○ |
| C-38 | SortUtil.compareBinary - aが大きい場合に正 | E-04 (L141-201) | ○ |
| C-39 | SortUtil.compareBinary - 同一参照で0 | E-04 (L143-146) | ○ |
| C-40 | SortUtil.compareBinary - 長さ異なる場合 | E-04 (L200) | ○ |
| C-41 | BufferBundle.isEmpty - 空判定(true) | E-05 (L52-54) | ○ |
| C-42 | BufferBundle.isEmpty - 空判定(false) | E-05 (L52-54) | ○ |
| C-43 | BufferBundle.reducedSize - 削減サイズ計算 | E-05 (L57-59) | ○ |
| C-44 | BufferBundle.clear - クリア処理 | E-05 (L62-66) | ○ |
| C-45 | BufferBundle.getJoinKeys - デフォルト動作 | E-05 (L72-74) | ○ |
| C-46 | RawFormatSerializationSchema.serialize - VARCHAR | E-06 (L64-70) | ○ |
| C-47 | RawFormatSerializationSchema.serialize - INTEGER BigEndian | E-06 (L153-154, L230-249) | ○ |
| C-48 | RawFormatSerializationSchema.serialize - INTEGER LittleEndian | E-06 (L230-249) | ○ |
| C-49 | RawFormatSerializationSchema.serialize - BIGINT | E-06 (L157, L252-271) | ○ |
| C-50 | RawFormatSerializationSchema.serialize - FLOAT | E-06 (L159-160, L273-292) | ○ |
| C-51 | RawFormatSerializationSchema.serialize - DOUBLE | E-06 (L162-163, L295-315) | ○ |
| C-52 | RawFormatSerializationSchema.serialize - BOOLEAN | E-06 (L141-145) | ○ |
| C-53 | RawFormatSerializationSchema.serialize - TINYINT | E-06 (L147-148) | ○ |
| C-54 | RawFormatSerializationSchema.serialize - null処理 | E-06 (L117-122) | ○ |
| C-55 | RawFormatSerializationSchema.serialize - BINARY | E-06 (L134-136) | ○ |
| C-56 | RawFormatSerializationSchema.equals - 等価性 | E-06 (L72-89) | ○ |
| C-57 | RawFormatSerializationSchema.hashCode - ハッシュ | E-06 (L86-89) | ○ |
| C-58 | ExecutionContextImpl.currentKey - キー取得 | E-07 (L37-40) | ○ |
| C-59 | ExecutionContextImpl.setCurrentKey - キー設定 | E-07 (L42-45) | ○ |
| C-60 | ExecutionContextImpl.getRuntimeContext - コンテキスト取得 | E-07 (L47-50) | ○ |
| C-61 | ExecutionContextImpl.コンストラクタ - null検証 | E-07 (L32-35) | ○ |
| C-62 | TopNBuffer.put - レコード追加 | E-08 (L59-69) | ○ |
| C-63 | TopNBuffer.put - 同キー追加 | E-08 (L62-68) | ○ |
| C-64 | TopNBuffer.putAll - 一括追加 | E-08 (L78-85) | ○ |
| C-65 | TopNBuffer.putAll - 既存キー上書き | E-08 (L79-84) | ○ |
| C-66 | TopNBuffer.get - レコード取得 | E-08 (L93-95) | ○ |
| C-67 | TopNBuffer.get - 存在しないキー | E-08 (L93-95) | ○ |
| C-68 | TopNBuffer.remove - レコード削除 | E-08 (L97-107) | ○ |
| C-69 | TopNBuffer.remove - 最後のレコード削除 | E-08 (L103-106) | ○ |
| C-70 | TopNBuffer.removeAll - 一括削除 | E-08 (L114-120) | ○ |
| C-71 | TopNBuffer.removeLast - 末尾削除 | E-08 (L127-157) | ○ |
| C-72 | TopNBuffer.removeLast - 空バッファ | E-08 (L128-129) | ○ |
| C-73 | TopNBuffer.lastElement - 末尾参照 | E-08 (L160-168) | ○ |
| C-74 | TopNBuffer.getElement - ランク指定取得 | E-08 (L176-192) | ○ |
| C-75 | TopNBuffer.getElement - 範囲外ランク | E-08 (L191) | ○ |
| C-76 | TopNBuffer.containsKey - キー存在確認(true) | E-08 (L226-228) | ○ |
| C-77 | TopNBuffer.containsKey - キー不存在確認(false) | E-08 (L226-228) | ○ |
| C-78 | TopNBuffer.getCurrentTopNum - 総数取得 | E-08 (L235-237) | ○ |
| C-79 | TopNBuffer.checkSortKeyInBufferRange - 範囲内 | E-08 (L255-270) | ○ |
| C-80 | TopNBuffer.checkSortKeyInBufferRange - 空バッファ | E-08 (L258-261) | ○ |
| C-81 | SegmentsUtil.allocateReuseBytes - バイト配列確保 | E-09 (L61-76) | ○ |
| C-82 | SegmentsUtil.allocateReuseBytes - ThreadLocal再利用 | E-09 (L50, L62-70) | ○ |
| C-83 | SegmentsUtil.allocateReuseChars - char配列確保 | E-09 (L78-93) | ○ |
| C-84 | SegmentsUtil.copyToBytes - セグメントからコピー | E-09 (L102-123) | ○ |
| C-85 | SegmentsUtil.copyToBytes - 複数セグメント | E-09 (L125-145) | ○ |
| C-86 | SegmentsUtil.copyFromBytes - バイト配列からコピー | E-09 (L236-243) | ○ |
| C-87 | SegmentsUtil.equals - 同一内容(true) | E-09 (L296-307) | ○ |
| C-88 | SegmentsUtil.equals - 異なる内容(false) | E-09 (L296-307) | ○ |
| C-89 | SegmentsUtil.equals - 長さ0 | E-09 (L316-318) | ○ |
| C-90 | SegmentsUtil.hashByWords - ワード境界ハッシュ | E-09 (L358-364) | ○ |
| C-91 | SegmentsUtil.hash - 任意長ハッシュ | E-09 (L379-385) | ○ |
| C-92 | SegmentsUtil.bitSet - ビットセット | E-09 (L429-434) | ○ |
| C-93 | SegmentsUtil.bitUnSet - ビットクリア | E-09 (L415-420) | ○ |
| C-94 | SegmentsUtil.bitGet - ビット読み取り | E-09 (L443-447) | ○ |
| C-95 | SegmentsUtil.getBoolean - Boolean取得 | E-09 (L530-536) | ○ |
| C-96 | SegmentsUtil.setBoolean - Boolean設定 | E-09 (L551-557) | ○ |
| C-97 | SegmentsUtil.getInt - Int取得 | E-09 (L615-621) | ○ |
| C-98 | SegmentsUtil.getInt - セグメント境界跨ぎ | E-09 (L623-653) | ○ |
| C-99 | SegmentsUtil.setInt - Int設定 | E-09 (L661-667) | ○ |
| C-100 | SegmentsUtil.getLong - Long取得 | E-09 (L706-712) | ○ |
| C-101 | SegmentsUtil.setLong - Long設定 | E-09 (L752-758) | ○ |
| C-102 | SegmentsUtil.getFloat - Float取得 | E-09 (L849-855) | ○ |
| C-103 | SegmentsUtil.setFloat - Float設定 | E-09 (L875-881) | ○ |
| C-104 | SegmentsUtil.getDouble - Double取得 | E-09 (L901-907) | ○ |
| C-105 | SegmentsUtil.setDouble - Double設定 | E-09 (L927-933) | ○ |
| C-106 | SegmentsUtil.find - パターン検索成功 | E-09 (L987-1013) | ○ |
| C-107 | SegmentsUtil.find - パターン検索失敗 | E-09 (L1007-1008) | ○ |
| C-108 | SegmentsUtil.find - 空文字検索 | E-09 (L994-996) | ○ |
| C-109 | RowDataUtil.isAccumulateMsg - INSERT(true) | E-10 (L31-34) | ○ |
| C-110 | RowDataUtil.isAccumulateMsg - UPDATE_AFTER(true) | E-10 (L31-34) | ○ |
| C-111 | RowDataUtil.isAccumulateMsg - DELETE(false) | E-10 (L31-34) | ○ |
| C-112 | RowDataUtil.isRetractMsg - DELETE(true) | E-10 (L40-43) | ○ |
| C-113 | RowDataUtil.isRetractMsg - UPDATE_BEFORE(true) | E-10 (L40-43) | ○ |
| C-114 | RowDataUtil.isRetractMsg - INSERT(false) | E-10 (L40-43) | ○ |
| C-115 | TimeWindowUtil.toUtcTimestampMills - タイムゾーン変換 | E-11 (L52-60) | ○ |
| C-116 | TimeWindowUtil.toUtcTimestampMills - UTCゾーン短絡 | E-11 (L54-56) | ○ |
| C-117 | TimeWindowUtil.toUtcTimestampMills - Long.MAX_VALUE | E-11 (L54) | ○ |
| C-118 | TimeWindowUtil.toEpochMillsForTimer - タイマー用変換 | E-11 (L69-139) | ○ |
| C-119 | TimeWindowUtil.toEpochMillsForTimer - DST処理 | E-11 (L75-133) | ○ |
| C-120 | TimeWindowUtil.toEpochMills - エポックミリ秒変換 | E-11 (L148-156) | ○ |
| C-121 | TimeWindowUtil.getShiftTimeZone - LocalZonedTimestampType | E-11 (L162-165) | ○ |
| C-122 | TimeWindowUtil.getShiftTimeZone - TimestampType | E-11 (L163-164) | ○ |
| C-123 | TimeWindowUtil.isWindowFired - 発火判定(true) | E-11 (L175-183) | ○ |
| C-124 | TimeWindowUtil.isWindowFired - 発火判定(false) | E-11 (L175-183) | ○ |
| C-125 | TimeWindowUtil.isWindowFired - Long.MAX_VALUE | E-11 (L178-180) | ○ |
| C-126 | TimeWindowUtil.getNextTriggerWatermark - 次回トリガー計算 | E-11 (L186-209) | ○ |
| C-127 | TimeWindowUtil.getNextTriggerWatermark - Long.MAX_VALUE | E-11 (L188-190) | ○ |
| C-128 | MurmurHashUtil.hashUnsafeBytesByWords - ワード境界ハッシュ | E-12 (L40-42) | ○ |
| C-129 | MurmurHashUtil.hashUnsafeBytes - 任意長ハッシュ | E-12 (L52-54) | ○ |
| C-130 | MurmurHashUtil.hashBytesByWords - MemorySegmentハッシュ | E-12 (L64-66) | ○ |
| C-131 | MurmurHashUtil.hashBytes - MemorySegment任意長 | E-12 (L76-78) | ○ |
| C-132 | MurmurHashUtil.fmix(int) - 整数ファイナライズ | E-12 (L157-164) | ○ |
| C-133 | MurmurHashUtil.fmix(long) - 長整数ファイナライズ | E-12 (L166-173) | ○ |
| C-134 | DataFormatConverters.getConverterForDataType - BOOLEAN | E-13 (L116-117, L168-174) | ○ |
| C-135 | DataFormatConverters.getConverterForDataType - INT | E-13 (L119-120, L168-174) | ○ |
| C-136 | DataFormatConverters.getConverterForDataType - VARCHAR | E-13 (L178-186) | ○ |
| C-137 | DataFormatConverters.getConverterForDataType - DECIMAL | E-13 (L190-199) | ○ |
| C-138 | DataFormatConverters.getConverterForDataType - DATE | E-13 (L137-140) | ○ |
| C-139 | DataFormatConverters.getConverterForDataType - TIME | E-13 (L142-145) | ○ |
| C-140 | DataFormatConverters.getConverterForDataType - TIMESTAMP | E-13 (L200以降) | ○ |
| C-141 | DataFormatConverters.getConverterForDataType - 未サポート型エラー | E-13 (L165-167等) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。
- すべてのテストケースはソースコードの実装に基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいており、主要なメソッドをカバー

## 6) レビュアーチェックリスト（最小）
- [ ] CompileUtils関連のテストケースがコード生成の主要パスをカバーしているか確認
- [ ] SortUtilの正規化キー生成が全データ型をカバーしているか確認
- [ ] TopNBufferのランキング処理が境界条件を適切にテストしているか確認
- [ ] SegmentsUtilのメモリ操作がセグメント境界跨ぎケースを含んでいるか確認
- [ ] TimeWindowUtilの夏時間(DST)処理テストが十分か確認
- [ ] DataFormatConvertersが主要なデータ型変換をカバーしているか確認
- [ ] 異常系テスト(null入力、不正な引数)が適切に含まれているか確認
