---
generated_at: 2026-02-02 18:46:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UAT-049 Heavy Deployment**：テストスクリプトは存在するが、具体的な期待値が不明確
  2. **UAT-057 Table Shaded Dependencies**：シェーディング確認の詳細基準が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-end-to-end-tests/README.md` - E2Eテストの概要とテスト方針
- E-02: `flink-end-to-end-tests/run-nightly-tests.sh` - ナイトリーテスト定義と実行テスト一覧
- E-03: `flink-end-to-end-tests/test-scripts/test_batch_wordcount.sh` - バッチWordCountテスト
- E-04: `flink-end-to-end-tests/test-scripts/test_streaming_examples.sh` - ストリーミングサンプルテスト
- E-05: `flink-end-to-end-tests/test-scripts/test_streaming_sql.sh` - ストリーミングSQLテスト
- E-06: `flink-end-to-end-tests/test-scripts/test_cli.sh` - CLIテスト
- E-07: `flink-end-to-end-tests/test-scripts/test_ha_datastream.sh` - HA DataStreamテスト
- E-08: `flink-end-to-end-tests/test-scripts/test_resume_savepoint.sh` - Savepoint復元テスト
- E-09: `flink-end-to-end-tests/test-scripts/test_resume_externalized_checkpoints.sh` - 外部化チェックポイント復元テスト
- E-10: `flink-end-to-end-tests/test-scripts/test_kubernetes_session.sh` - Kubernetesセッションテスト
- E-11: `flink-end-to-end-tests/test-scripts/test_kubernetes_application.sh` - Kubernetesアプリケーションテスト
- E-12: `flink-end-to-end-tests/test-scripts/test_kubernetes_application_ha.sh` - Kubernetes HA テスト
- E-13: `flink-end-to-end-tests/test-scripts/test_queryable_state.sh` - Queryable Stateテスト
- E-14: `flink-end-to-end-tests/test-scripts/test_file_sink.sh` - FileSinkテスト
- E-15: `flink-end-to-end-tests/test-scripts/test_sql_jdbc_driver.sh` - SQL JDBCドライバテスト
- E-16: `flink-end-to-end-tests/test-scripts/test_pyflink.sh` - PyFlinkテスト
- E-17: `flink-end-to-end-tests/test-scripts/test_state_migration.sh` - 状態マイグレーションテスト
- E-18: `flink-end-to-end-tests/test-scripts/test_tpcds.sh` - TPC-DSベンチマークテスト
- E-19: `flink-end-to-end-tests/test-scripts/test_tpch.sh` - TPC-Hベンチマークテスト
- E-20: `flink-end-to-end-tests/test-scripts/test_local_recovery_and_scheduling.sh` - ローカルリカバリテスト
- E-21: `flink-examples/` - サンプルアプリケーション

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチWordCount処理テスト | E-03 | ○ |
| C-02 | バッチWordCount S3連携テスト | E-03 | ○ |
| C-03 | ストリーミングSQL処理テスト | E-05 | ○ |
| C-04 | セッションウィンドウ処理テスト | E-04, E-21 | ○ |
| C-05 | 状態マシンサンプル実行テスト | E-04, E-21 | ○ |
| C-06 | TopSpeedWindowing処理テスト | E-04, E-21 | ○ |
| C-07 | WindowJoin処理テスト | E-04, E-21 | ○ |
| C-08 | ストリーミングWordCountテスト | E-04, E-21 | ○ |
| C-09 | CLIデフォルトジョブ起動テスト | E-06 | ○ |
| C-10 | CLI複合パラメータ起動テスト | E-06 | ○ |
| C-11 | CLIジョブ情報取得テスト | E-06 | ○ |
| C-12 | ストリーミングジョブ一覧テスト | E-06 | ○ |
| C-13 | ジョブキャンセルテスト | E-06 | ○ |
| C-14 | HA DataStream hashmap asyncテスト | E-07 | ○ |
| C-15 | HA DataStream hashmap syncテスト | E-07 | ○ |
| C-16 | HA DataStream rocks non-incrementalテスト | E-07 | ○ |
| C-17 | HA DataStream rocks incrementalテスト | E-07 | ○ |
| C-18 | Savepoint復元 hashmap asyncテスト | E-08 | ○ |
| C-19 | Savepoint復元スケールアップテスト | E-08 | ○ |
| C-20 | Savepoint復元スケールダウンテスト | E-08 | ○ |
| C-21 | Savepoint復元 RocksDB heap timersテスト | E-08 | ○ |
| C-22 | 外部化Checkpoint復元 hashmapテスト | E-09 | ○ |
| C-23 | 外部化Checkpoint復元 RocksDB incrementalテスト | E-09 | ○ |
| C-24 | Kubernetesセッションクラスタテスト | E-10 | ○ |
| C-25 | Kubernetesセッション dummy-fsテスト | E-10 | ○ |
| C-26 | Kubernetesアプリケーションクラスタテスト | E-11 | ○ |
| C-27 | Kubernetes Application HAテスト | E-12 | ○ |
| C-28 | Kubernetes PyFlink Applicationテスト | E-02 | ○ |
| C-29 | Kubernetes SQL Applicationテスト | E-02 | ○ |
| C-30 | Kubernetes Materialized Tableテスト | E-02 | ○ |
| C-31 | Docker Embedded Jobテスト | E-02 | ○ |
| C-32 | Queryable State RocksDBテスト | E-13 | ○ |
| C-33 | Queryable State TM再起動テスト | E-02 | ○ |
| C-34 | StreamingFileSinkローカルテスト | E-14 | ○ |
| C-35 | StreamingFileSink S3テスト | E-14 | ○ |
| C-36 | FileSinkローカルテスト | E-14 | ○ |
| C-37 | FileSink S3テスト | E-14 | ○ |
| C-38 | SQL JDBCドライバテスト | E-15 | ○ |
| C-39 | PyFlink Table Jobテスト | E-16 | ○ |
| C-40 | PyFlink UDF SQL Clientテスト | E-16 | ○ |
| C-41 | State Migrationテスト | E-17 | ○ |
| C-42 | Stateful Job Upgradeテスト | E-02 | ○ |
| C-43 | State TTL HashMapテスト | E-02 | ○ |
| C-44 | State TTL RocksDBテスト | E-02 | ○ |
| C-45 | RocksDB Memory Controlテスト | E-02 | ○ |
| C-46 | TPC-H Benchmarkテスト | E-19 | ○ |
| C-47 | TPC-DS Benchmark Defaultテスト | E-18 | ○ |
| C-48 | TPC-DS Benchmark AdaptiveBatchテスト | E-18 | ○ |
| C-49 | Heavy Deploymentテスト | E-02 | △ |
| C-50 | Local Recovery hashmap テスト | E-20 | ○ |
| C-51 | Local Recovery rocks incrementalテスト | E-20 | ○ |
| C-52 | Netty Shuffle Memory Controlテスト | E-02 | ○ |
| C-53 | Quickstart Javaテスト | E-02 | ○ |
| C-54 | DataStream Walkthrough Javaテスト | E-02 | ○ |
| C-55 | NAT環境での動作テスト | E-02 | ○ |
| C-56 | Failure Enricherテスト | E-02 | ○ |
| C-57 | Table Shaded Dependenciesテスト | E-02 | △ |
| C-58 | HA Per-Job Cluster hashmapテスト | E-02 | ○ |
| C-59 | HA Per-Job Cluster rocks incrementalテスト | E-02 | ○ |
| C-60 | Distributed Cache via Blobテスト | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-049 Heavy Deployment**: テストスクリプトは存在するが、「大規模環境でも安定して動作する」の具体的な検証基準が不明確
  - 候補：負荷テスト基準書 / パフォーマンス要件定義書 / スケーラビリティテスト仕様書
- **UAT-057 Table Shaded Dependencies**: 依存関係シェーディングの具体的な確認項目が不明確
  - 候補：ビルド仕様書 / 依存関係管理ガイドライン / Maven shade plugin設定

## 5) リスクフラグ（レビュー観点）
- **0 - 低リスク**: 大部分のテストケースは実際のE2Eテストスクリプトに基づいて生成
- **0 - 低リスク**: テスト実行環境（Kubernetes, Docker, S3など）の前提条件は明確
- **1 - 中リスク**: 一部のテストケース（Heavy Deployment, Shaded Dependencies）は期待結果の具体性が低い
- **0 - 低リスク**: TPC-H/TPC-DS等の標準ベンチマークは公開された回答セットと比較するため信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテストID（UAT-XXX）と対応するtest-scriptsファイルが正しく紐付いているか
- [ ] 前提条件（Flinkクラスタ起動、Kubernetes起動など）は実行環境で満たせるか
- [ ] 期待結果（特にハッシュ値）は最新のテストスクリプトと一致しているか
- [ ] ユーザーロール（開発者、運用者、DBA）の分類は適切か
- [ ] 優先度（高/中/低）の設定は組織のテスト方針と合致しているか
- [ ] 根拠不足の2件（UAT-049, UAT-057）について追加調査が必要か判断
