---
generated_at: 2026-02-02 16:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvBulkWriter.java`
- E-02: `flink-formats/flink-csv/src/main/java/org/apache/flink/formats/csv/CsvFileFormatFactory.java`
- E-03: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonFormatFactory.java`
- E-04: `flink-formats/flink-avro/src/main/java/org/apache/flink/formats/avro/AvroFormatFactory.java`
- E-05: `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetFileFormatFactory.java`
- E-06: `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFileFormatFactory.java`
- E-07: `flink-formats/flink-protobuf/src/main/java/org/apache/flink/formats/protobuf/PbFormatFactory.java`
- E-08: `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusReporter.java`
- E-09: `flink-metrics/flink-metrics-slf4j/src/main/java/org/apache/flink/metrics/slf4j/Slf4jReporter.java`
- E-10: `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DatadogHttpReporter.java`
- E-11: `flink-metrics/flink-metrics-graphite/src/main/java/org/apache/flink/metrics/graphite/GraphiteReporter.java`
- E-12: `flink-metrics/flink-metrics-influxdb/src/main/java/org/apache/flink/metrics/influxdb/InfluxdbReporter.java`
- E-13: `flink-metrics/flink-metrics-jmx/src/main/java/org/apache/flink/metrics/jmx/JMXReporter.java`
- E-14: `flink-metrics/flink-metrics-statsd/src/main/java/org/apache/flink/metrics/statsd/StatsDReporter.java`
- E-15: `flink-metrics/flink-metrics-otel/src/main/java/org/apache/flink/metrics/otel/OpenTelemetryMetricReporter.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSV出力機能の存在 | E-01, E-02 | ○ |
| C-02 | JSON出力機能の存在 | E-03 | ○ |
| C-03 | Avro出力機能の存在 | E-04 | ○ |
| C-04 | Parquet出力機能の存在 | E-05 | ○ |
| C-05 | ORC出力機能の存在 | E-06 | ○ |
| C-06 | Protobuf出力機能の存在 | E-07 | ○ |
| C-07 | Prometheusメトリクスレポート機能の存在 | E-08 | ○ |
| C-08 | SLF4Jメトリクスレポート機能の存在 | E-09 | ○ |
| C-09 | Datadogメトリクスレポート機能の存在 | E-10 | ○ |
| C-10 | Graphiteメトリクスレポート機能の存在 | E-11 | ○ |
| C-11 | InfluxDBメトリクスレポート機能の存在 | E-12 | ○ |
| C-12 | JMXメトリクスレポート機能の存在 | E-13 | ○ |
| C-13 | StatsDメトリクスレポート機能の存在 | E-14 | ○ |
| C-14 | OpenTelemetryメトリクスレポート機能の存在 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての帳票項目に対応するソースコードファイルが確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての帳票機能はソースコードで直接確認できる
- 注意点：Apache Flinkはストリーミング/バッチ処理フレームワークであり、一般的なビジネスアプリケーションにおける「帳票」（PDF帳票、Excel帳票など）とは異なり、データフォーマット出力とメトリクスレポート機能を帳票として分類している

## 6) レビュアーチェックリスト（最小）
- [ ] 各フォーマット出力機能（CSV, JSON, Avro, Parquet, ORC, Protobuf）が実際にファイル出力可能であることを確認
- [ ] 各メトリクスレポーター（Prometheus, SLF4J, Datadog, Graphite, InfluxDB, JMX, StatsD, OpenTelemetry）が対応サービスへの送信機能を持つことを確認
- [ ] 帳票の分類（データフォーマット出力 / メトリクスレポート）が適切であるか確認
