# 帳票設計書 10-Graphiteメトリクスレポート

## 概要

本ドキュメントは、Apache Flink のGraphiteメトリクスレポート機能に関する帳票設計書である。GraphiteReporterを中心としたTCP/UDP経由のメトリクス送信機能について、その仕様と実装詳細を記載する。

### 本帳票の処理概要

本帳票は、Apache Flink のジョブおよびタスクマネージャーから収集されたメトリクスをGraphiteサーバーへTCPまたはUDP経由で送信する機能を提供する。Dropwizardベースのレポーターを使用してメトリクスをGraphiteに転送する。

**業務上の目的・背景**：Graphiteは、時系列データの収集・保存・グラフ化を行うオープンソースの監視ツールである。シンプルなプロトコル（plaintext）でメトリクスを受信し、Whisperデータベースに保存する。長年の実績があり、多くのダッシュボードツール（Grafana等）との連携が可能である。

**帳票の利用シーン**：既存のGraphiteインフラストラクチャとの連携、レガシー監視システムへの統合、シンプルなメトリクス収集基盤の構築などで利用される。

**主要な出力内容**：
1. Counter型メトリクス
2. Gauge型メトリクス
3. Histogram型メトリクス
4. Meter型メトリクス
5. Timer型メトリクス

**帳票の出力タイミング**：設定されたレポート間隔に従い、定期的にGraphiteサーバーへ送信される。

**帳票の利用者**：インフラエンジニア、運用担当者、監視システム管理者

## 帳票種別

メトリクスレポート（TCP/UDP Push型 Graphite Plaintext形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Graphiteダッシュボード/Grafana | - | 定期的なスケジュール送信 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Graphite Plaintext Protocol |
| 通信プロトコル | TCP/UDP |
| ポート | 設定による（デフォルト: 2003） |
| 出力方法 | ソケット送信 |
| 文字コード | UTF-8 |

### Graphite固有設定

| 項目 | 内容 | デフォルト値 |
|-----|------|-------------|
| ホスト | metrics.reporter.grph.host | （必須） |
| ポート | metrics.reporter.grph.port | （必須） |
| プロトコル | metrics.reporter.grph.protocol | TCP |
| プレフィックス | metrics.reporter.grph.prefix | なし |
| レート変換単位 | metrics.reporter.grph.conversionRate | なし |
| 期間変換単位 | metrics.reporter.grph.conversionDuration | なし |

### プロトコル

| プロトコル | クラス | 説明 |
|----------|-------|------|
| TCP | Graphite | 信頼性重視 |
| UDP | GraphiteUDP | 低レイテンシ |

## 帳票レイアウト

### レイアウト概要

Graphite Plaintext Protocol形式でメトリクスを送信。

```
prefix.metric.name value timestamp
prefix.flink.jobmanager.numRegisteredTaskManagers 3 1609459200
prefix.flink.taskmanager.job.task.numRecordsIn 12345 1609459200
```

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ホスト設定 | Graphiteサーバーホストの設定 | Yes |
| ポート設定 | Graphiteサーバーポートの設定 | Yes |

### バリデーション

| 条件 | エラーメッセージ |
|------|---------------|
| ホストが空または未設定 | Invalid host/port configuration |
| ポートが1未満 | Invalid host/port configuration |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[スケジュールタイマー] --> B[ScheduledReporter.report]
    B --> C[GraphiteReporter.getReporter]
    C --> D{プロトコル判定}
    D -->|TCP| E[Graphite接続]
    D -->|UDP| F[GraphiteUDP接続]
    E --> G[メトリクス送信]
    F --> G
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 設定エラー | host/port無効 | Invalid host/port configuration. Host: {host} Port: {port} | 設定確認 |
| プロトコルエラー | 不正なプロトコル値 | Invalid protocol configuration: {protocol} Expected: TCP or UDP, defaulting to TCP. | TCP/UDPを指定 |
| 接続エラー | サーバー接続失敗 | Dropwizard例外 | サーバー確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| レポート間隔 | 設定依存 |
| 通信遅延 | プロトコル依存（TCPは確実、UDPは低遅延） |
| メトリクス数上限 | 制限なし |

## セキュリティ考慮事項

- Graphite Plaintext Protocolは暗号化なし
- ファイアウォールによるアクセス制御を推奨
- VPN経由での通信を推奨

## 備考

- ScheduledDropwizardReporterを継承
- Dropwizard Metricsライブラリ（com.codahale.metrics）を使用
- 不正なプロトコル指定時はTCPにフォールバック

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GraphiteReporter.java | `flink-metrics/flink-metrics-graphite/src/main/java/org/apache/flink/metrics/graphite/GraphiteReporter.java` | Reporter実装（行36-99）：getReporter()でDropwizard GraphiteReporter構築 |

**主要処理フロー**:
1. **行46-53**: getReporter()で設定値取得とバリデーション
2. **行60-73**: Builder設定（prefix, conversionRate, conversionDuration）
3. **行75-97**: プロトコル判定とビルド

### プログラム呼び出し階層図

```
GraphiteReporter
    │
    ├─ ScheduledDropwizardReporter（継承）
    │      └─ MetricRegistry
    │
    └─ getReporter()
           └─ com.codahale.metrics.graphite.GraphiteReporter.Builder
                  ├─ Graphite（TCP）
                  └─ GraphiteUDP（UDP）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GraphiteReporter.java | `flink-metrics/flink-metrics-graphite/src/main/java/org/apache/flink/metrics/graphite/GraphiteReporter.java` | ソース | Reporter実装 |
| GraphiteReporterFactory.java | `flink-metrics/flink-metrics-graphite/src/main/java/org/apache/flink/metrics/graphite/GraphiteReporterFactory.java` | ソース | ファクトリ |
| ScheduledDropwizardReporter.java | `flink-core/src/main/java/org/apache/flink/dropwizard/ScheduledDropwizardReporter.java` | ソース | 基底クラス |
