# 帳票設計書 4-Parquet出力

## 概要

本ドキュメントは、Apache Flink のApache Parquet出力機能に関する帳票設計書である。ParquetRowDataBuilderを中心とした列指向ファイルフォーマット出力機能について、その仕様と実装詳細を記載する。

### 本帳票の処理概要

本帳票は、Apache Flink のストリーミング処理またはバッチ処理において、RowData形式のデータをApache Parquet列指向フォーマットでファイルシステムに出力する機能を提供する。

**業務上の目的・背景**：Apache Parquetは、ビッグデータ分析ワークロードに最適化された列指向ファイルフォーマットである。高い圧縮率とカラムプルーニングによる効率的なクエリ実行を特徴とし、Hadoop、Spark、Hive、Impala等のビッグデータエコシステムとの互換性を持つ。分析クエリのパフォーマンス向上とストレージコスト削減に貢献する。

**帳票の利用シーン**：データレイクへの永続化、分析基盤へのデータエクスポート、ビッグデータウェアハウスとの連携などで利用される。特に、カラム選択型の分析クエリが多いユースケースや、長期保存を目的としたデータアーカイブに適している。

**主要な出力内容**：
1. RowData形式の各フィールドを列指向形式でシリアライズしたバイナリデータ
2. UTCタイムゾーンまたはローカルタイムゾーンでのタイムスタンプ変換
3. int64またはint96形式でのタイムスタンプ出力
4. バッチ単位での効率的な書き込み

**帳票の出力タイミング**：Flink Table/SQL APIにおいてファイルシステムSinkとして設定されたタイミングでバッチ単位で出力される。

**帳票の利用者**：データエンジニア、データアナリスト、データプラットフォーム担当者

## 帳票種別

データフォーマット出力（バッチ/ストリーミング Apache Parquet列指向形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Flink SQL CLI | - | CREATE TABLE ... WITH ('format' = 'parquet') |
| - | Flink Table API | - | FileSink with Parquet format |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Apache Parquet（列指向バイナリ） |
| 用紙サイズ | N/A（ファイル出力） |
| 向き | N/A |
| ファイル名 | Sinkの設定による（例：part-{subtask}-{id}.parquet） |
| 出力方法 | ファイルシステム（ローカル/HDFS/S3等）への書き込み |
| 文字コード | バイナリ形式 |

### Parquet固有設定

| 項目 | 内容 | デフォルト値 |
|-----|------|-------------|
| UTCタイムゾーン | utc-timezone | false |
| タイムスタンプ時間単位 | timestamp.time.unit | micros |
| int64タイムスタンプ書き込み | write.int64.timestamp | false |
| バッチサイズ | batch-size | 2048 |

## 帳票レイアウト

### レイアウト概要

Parquetファイルは列指向フォーマットで、行グループ単位でデータを格納する。

```
┌─────────────────────────────────────┐
│           ファイルヘッダー            │
├─────────────────────────────────────┤
│          行グループ1                 │
│   ├─ カラム1チャンク                 │
│   ├─ カラム2チャンク                 │
│   └─ カラムNチャンク                 │
├─────────────────────────────────────┤
│          行グループ2                 │
│              ...                    │
├─────────────────────────────────────┤
│           ファイルフッター            │
│   （スキーマ、メタデータ）             │
└─────────────────────────────────────┘
```

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Sinkテーブル定義 | CREATE TABLE文でformat='parquet'を指定 | Yes |
| データ型互換性 | 出力対象がサポート型であること | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | データ到着順 | N/A |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[RowData入力] --> B[ParquetRowDataBuilder.createWriterFactory]
    B --> C[ParquetBulkWriter]
    C --> D[列指向変換]
    D --> E[圧縮エンコーディング]
    E --> F[行グループ書き込み]
    F --> G[ファイルシステム出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイル書き込み失敗 | ディスク容量不足等 | IOException | ストレージ確認 |
| スキーマ変換エラー | サポート外型 | 変換エラー | 型を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 大容量対応 |
| 目標出力時間 | バッチ処理時間内 |
| 同時出力数上限 | 並列度に依存 |

## セキュリティ考慮事項

- Parquetファイルは暗号化オプションをサポート
- ファイルシステムのアクセス制御に従う

## 備考

- Hive 0.x/1.x/2.xはローカルタイムゾーン、Hive 3.xはUTCタイムゾーンを使用
- 列指向フォーマットのため、カラムプルーニングによる読み取り効率化が可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ParquetFileFormatFactory.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetFileFormatFactory.java` | ファクトリ実装（行57-186）：createEncodingFormat()でBulkWriter.Factoryを生成 |

**主要処理フロー**:
1. **行98-115**: createEncodingFormat()でParquetRowDataBuilderを使用
2. **行104-107**: ParquetRowDataBuilder.createWriterFactory()呼び出し
3. **行61-89**: 設定オプション定義（UTCタイムゾーン、バッチサイズ等）

### プログラム呼び出し階層図

```
ParquetFileFormatFactory
    │
    └─ createEncodingFormat()
           └─ ParquetRowDataBuilder.createWriterFactory()
                   └─ ParquetBulkWriter
                          └─ ParquetWriter
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ParquetFileFormatFactory.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetFileFormatFactory.java` | ソース | ファクトリ実装 |
| ParquetRowDataBuilder.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/row/ParquetRowDataBuilder.java` | ソース | Writer構築 |
| ParquetColumnarRowInputFormat.java | `flink-formats/flink-parquet/src/main/java/org/apache/flink/formats/parquet/ParquetColumnarRowInputFormat.java` | ソース | 入力フォーマット |
