# 帳票設計書 5-ORC出力

## 概要

本ドキュメントは、Apache Flink のApache ORC出力機能に関する帳票設計書である。OrcBulkWriterFactoryを中心とした高圧縮率列指向ファイルフォーマット出力機能について、その仕様と実装詳細を記載する。

### 本帳票の処理概要

本帳票は、Apache Flink のストリーミング処理またはバッチ処理において、RowData形式のデータをApache ORC列指向フォーマットでファイルシステムに出力する機能を提供する。

**業務上の目的・背景**：Apache ORC（Optimized Row Columnar）は、Hiveエコシステムで開発された高性能な列指向ファイルフォーマットである。高い圧縮率、プレディケートプッシュダウン、軽量なインデックスを特徴とし、特にHive、Presto、Impalaとの親和性が高い。大規模データウェアハウスワークロードにおいて、クエリパフォーマンスとストレージ効率の向上に貢献する。

**帳票の利用シーン**：Hiveデータウェアハウスとの連携、大規模分析ワークロードへのデータエクスポート、ストレージコスト最適化が求められるシナリオで利用される。特に、Hiveテーブルへの直接書き込みやACIDトランザクションサポートが必要な場合に適している。

**主要な出力内容**：
1. RowData形式の各フィールドをORC列指向形式でシリアライズしたバイナリデータ
2. RowDataVectorizerによるベクター化された書き込み
3. TypeDescriptionによるスキーマ定義
4. フィルタプレディケートのプッシュダウン対応

**帳票の出力タイミング**：Flink Table/SQL APIにおいてファイルシステムSinkとして設定されたタイミングでバッチ単位で出力される。

**帳票の利用者**：データエンジニア、データウェアハウス管理者、分析基盤担当者

## 帳票種別

データフォーマット出力（バッチ/ストリーミング Apache ORC列指向形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Flink SQL CLI | - | CREATE TABLE ... WITH ('format' = 'orc') |
| - | Flink Table API | - | FileSink with ORC format |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Apache ORC（列指向バイナリ） |
| 用紙サイズ | N/A（ファイル出力） |
| 向き | N/A |
| ファイル名 | Sinkの設定による（例：part-{subtask}-{id}.orc） |
| 出力方法 | ファイルシステム（ローカル/HDFS/S3等）への書き込み |
| 文字コード | バイナリ形式 |

### ORC固有設定

| 項目 | 内容 | デフォルト値 |
|-----|------|-------------|
| 圧縮方式 | orc.compress | ZLIB |
| ストライプサイズ | orc.stripe.size | 64MB |
| ブロックサイズ | orc.block.size | 256MB |

## 帳票レイアウト

### レイアウト概要

ORCファイルはストライプ単位でデータを格納する列指向フォーマット。

```
┌─────────────────────────────────────┐
│           ファイルヘッダー            │
├─────────────────────────────────────┤
│          ストライプ1                 │
│   ├─ インデックスデータ              │
│   ├─ 行データ（列チャンク）           │
│   └─ ストライプフッター              │
├─────────────────────────────────────┤
│          ストライプ2                 │
│              ...                    │
├─────────────────────────────────────┤
│           ファイルフッター            │
│   （スキーマ、統計情報、メタデータ）    │
└─────────────────────────────────────┘
```

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Sinkテーブル定義 | CREATE TABLE文でformat='orc'を指定 | Yes |
| データ型互換性 | 出力対象がサポート型であること | Yes |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[RowData入力] --> B[OrcFileFormatFactory.createEncodingFormat]
    B --> C[OrcBulkWriterFactory]
    C --> D[RowDataVectorizer]
    D --> E[VectorizedColumnBatch変換]
    E --> F[ORC Writer]
    F --> G[ファイルシステム出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイル書き込み失敗 | ディスク容量不足等 | IOException | ストレージ確認 |
| スキーマ変換エラー | サポート外型 | 変換エラー | 型を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 大容量対応 |
| 目標出力時間 | バッチ処理時間内 |
| 同時出力数上限 | 並列度に依存 |

## セキュリティ考慮事項

- ORCファイルは暗号化オプションをサポート
- ファイルシステムのアクセス制御に従う

## 備考

- RowDataVectorizerでベクター化変換を実行
- OrcFiltersによるプレディケートプッシュダウンをサポート
- VectorizedColumnBatch.DEFAULT_SIZEでデフォルトバッチサイズを定義

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrcFileFormatFactory.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFileFormatFactory.java` | ファクトリ実装（行63-188）：createEncodingFormat()でOrcBulkWriterFactoryを生成 |

**主要処理フロー**:
1. **行104-128**: createEncodingFormat()でBulkWriter.Factoryを生成
2. **行111-115**: RowTypeからTypeDescriptionへ変換
3. **行117-120**: OrcBulkWriterFactoryのインスタンス化

### プログラム呼び出し階層図

```
OrcFileFormatFactory
    │
    └─ createEncodingFormat()
           └─ OrcBulkWriterFactory
                   ├─ RowDataVectorizer
                   └─ OrcWriter
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrcFileFormatFactory.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcFileFormatFactory.java` | ソース | ファクトリ実装 |
| OrcBulkWriterFactory.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/writer/OrcBulkWriterFactory.java` | ソース | Writer Factory |
| RowDataVectorizer.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/vector/RowDataVectorizer.java` | ソース | ベクター化変換 |
| OrcSplitReaderUtil.java | `flink-formats/flink-orc/src/main/java/org/apache/flink/orc/OrcSplitReaderUtil.java` | ソース | 型変換ユーティリティ |
