# 帳票設計書 7-Prometheusメトリクスレポート

## 概要

本ドキュメントは、Apache Flink のPrometheusメトリクスレポート機能に関する帳票設計書である。PrometheusReporterを中心としたHTTP経由のメトリクスエクスポート機能について、その仕様と実装詳細を記載する。

### 本帳票の処理概要

本帳票は、Apache Flink のジョブおよびタスクマネージャーから収集されたメトリクスをPrometheusサーバーへHTTP経由でエクスポートする機能を提供する。組み込みHTTPサーバーを起動し、Prometheusのスクレイピング用エンドポイントを公開する。

**業務上の目的・背景**：Prometheusは、Cloud Native Computing Foundation（CNCF）が管理するオープンソースの監視・アラートシステムである。時系列データベースとしてメトリクスを収集・保存し、PromQLによる柔軟なクエリとアラート設定を可能にする。Kubernetesエコシステムとの親和性が高く、現代のクラウドネイティブ環境における標準的な監視ソリューションとして広く採用されている。

**帳票の利用シーン**：Flinkジョブの運用監視、パフォーマンス分析、異常検知、SLA管理などで利用される。Grafanaと組み合わせたダッシュボード構築、PagerDutyやSlackとのアラート連携、キャパシティプランニングのためのトレンド分析などのシーンで活用される。

**主要な出力内容**：
1. Counter型メトリクス（累積カウント値）
2. Gauge型メトリクス（現在値）
3. Histogram型メトリクス（分布統計）
4. Meter型メトリクス（レート計測）

**帳票の出力タイミング**：HTTPサーバー起動後、Prometheusからのスクレイプリクエストに応じてリアルタイムでメトリクスを返却する。

**帳票の利用者**：SRE（Site Reliability Engineer）、運用担当者、DevOpsエンジニア

## 帳票種別

メトリクスレポート（HTTP Pull型 Prometheus形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Prometheusエンドポイント | http://{host}:{port}/metrics | Prometheusスクレイプ |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Prometheus Exposition Format（テキスト） |
| 通信プロトコル | HTTP |
| ポート | 設定による（デフォルト: 9249-9250） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

### Prometheus固有設定

| 項目 | 内容 | デフォルト値 |
|-----|------|-------------|
| ポート範囲 | metrics.reporter.prom.port | 9249-9250 |

## 帳票レイアウト

### レイアウト概要

Prometheus Exposition Formatでメトリクスを出力。

```
# HELP flink_jobmanager_numRegisteredTaskManagers Number of registered TaskManagers
# TYPE flink_jobmanager_numRegisteredTaskManagers gauge
flink_jobmanager_numRegisteredTaskManagers 3

# HELP flink_taskmanager_job_task_numRecordsIn Number of records received
# TYPE flink_taskmanager_job_task_numRecordsIn counter
flink_taskmanager_job_task_numRecordsIn{job_name="MyJob",task_name="Source"} 12345
```

### メトリクス型

| メトリクス型 | Prometheus型 | 説明 |
|------------|-------------|------|
| Counter | counter | 累積カウント値（単調増加） |
| Gauge | gauge | 現在値（増減可能） |
| Histogram | histogram | 分布統計（パーセンタイル） |
| Meter | gauge | レート値 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Reporter設定 | flink-conf.yamlでPrometheusReporter設定 | Yes |
| ポート空き | 指定ポートが使用可能 | Yes |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Flink起動] --> B[PrometheusReporter初期化]
    B --> C[HTTPServer起動]
    C --> D{スクレイプリクエスト}
    D --> E[登録済みメトリクス収集]
    E --> F[Prometheus形式変換]
    F --> G[HTTPレスポンス返却]
    G --> D
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ポート競合 | 指定ポートが使用中 | Could not start PrometheusReporter HTTP server on port {port} | ポート範囲変更 |
| 起動失敗 | 全ポートが使用中 | Could not start PrometheusReporter HTTP server on any configured port | ポート確認・変更 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| スクレイプ間隔 | 通常15-60秒 |
| レスポンス時間 | ミリ秒オーダー |
| メトリクス数上限 | 制限なし |

## セキュリティ考慮事項

- デフォルトでは認証なしでメトリクスエンドポイントが公開される
- ネットワークレベルでのアクセス制御を推奨
- 本番環境ではファイアウォール設定による保護が必要

## 備考

- io.prometheus.client.exporter.HTTPServerを使用
- AbstractPrometheusReporterを継承
- ポート範囲指定により複数TaskManager起動時の競合を回避

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PrometheusReporter.java | `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusReporter.java` | Reporter実装（行36-75）：HTTPServer起動とポート管理 |

**主要処理フロー**:
1. **行47-65**: コンストラクタでポート範囲をイテレートしてHTTPServer起動
2. **行52**: HTTPServerインスタンス作成とregistryの登録
3. **行67-74**: close()でHTTPServer停止

### プログラム呼び出し階層図

```
PrometheusReporter
    │
    ├─ AbstractPrometheusReporter（継承）
    │      └─ CollectorRegistry
    │
    └─ HTTPServer（io.prometheus.client）
           └─ /metrics エンドポイント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PrometheusReporter.java | `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusReporter.java` | ソース | Reporter実装 |
| AbstractPrometheusReporter.java | `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/AbstractPrometheusReporter.java` | ソース | 基底クラス |
| PrometheusReporterFactory.java | `flink-metrics/flink-metrics-prometheus/src/main/java/org/apache/flink/metrics/prometheus/PrometheusReporterFactory.java` | ソース | ファクトリ |
