# 帳票設計書 8-SLF4Jメトリクスレポート

## 概要

本ドキュメントは、Apache Flink のSLF4Jメトリクスレポート機能に関する帳票設計書である。Slf4jReporterを中心としたログ出力によるメトリクスレポート機能について、その仕様と実装詳細を記載する。

### 本帳票の処理概要

本帳票は、Apache Flink のジョブおよびタスクマネージャーから収集されたメトリクスをSLF4Jロガー経由でログファイルに出力する機能を提供する。定期的にCounter、Gauge、Meter、Histogramの値をINFOレベルでログ出力する。

**業務上の目的・背景**：SLF4J（Simple Logging Facade for Java）は、Javaの標準的なロギングファサードである。既存のログ収集基盤（Logback、Log4j2等）との連携が容易で、追加のインフラストラクチャなしでメトリクスを収集・分析できる。開発環境やシンプルな監視要件の環境に適している。

**帳票の利用シーン**：開発・テスト環境でのメトリクス確認、既存ログ収集基盤へのメトリクス統合、シンプルな運用監視、トラブルシューティング時のメトリクス確認などで利用される。

**主要な出力内容**：
1. Counter型メトリクス（カウント値）
2. Gauge型メトリクス（現在値）
3. Meter型メトリクス（レート値）
4. Histogram型メトリクス（統計値：count, min, max, mean, stddev, パーセンタイル）

**帳票の出力タイミング**：設定されたレポート間隔（interval）に従い、定期的にログ出力される。

**帳票の利用者**：開発者、運用担当者、サポートエンジニア

## 帳票種別

メトリクスレポート（SLF4J Logger出力形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ログファイル | - | 定期的なスケジュール実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキストログ |
| 出力先 | SLF4J Logger（ログファイル/コンソール） |
| ログレベル | INFO |
| 出力方法 | 定期スケジュール |
| 文字コード | UTF-8（ログ設定依存） |

### SLF4J固有設定

| 項目 | 内容 | デフォルト値 |
|-----|------|-------------|
| レポート間隔 | metrics.reporter.slf4j.interval | 設定依存 |

## 帳票レイアウト

### レイアウト概要

構造化されたテキスト形式でメトリクスを出力。

```
=========================== Starting metrics report ===========================

-- Counters ---------------------------------------------------------------------
flink.jobmanager.job.numRestarts: 0
flink.taskmanager.job.task.numRecordsIn: 12345

-- Gauges -----------------------------------------------------------------------
flink.jobmanager.numRegisteredTaskManagers: 3

-- Meters -----------------------------------------------------------------------
flink.taskmanager.job.task.numRecordsInPerSecond: 1234.56

-- Histograms -------------------------------------------------------------------
flink.taskmanager.job.task.bufferPool: count=100, min=0, max=1000, mean=500.5, stddev=100.2, p50=500, p75=750, p95=950, p98=980, p99=990, p999=999

=========================== Finished metrics report ===========================
```

### メトリクス型別出力形式

| メトリクス型 | 出力形式 | 説明 |
|------------|---------|------|
| Counter | name: count | カウント値 |
| Gauge | name: value | 現在値 |
| Meter | name: rate | レート値 |
| Histogram | name: count=x, min=x, max=x, mean=x, stddev=x, p50=x, p75=x, p95=x, p98=x, p99=x, p999=x | 統計値一式 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Reporter設定 | flink-conf.yamlでSlf4jReporter設定 | Yes |
| メトリクス登録 | 1つ以上のメトリクスが登録されている | No |

### 改ページ条件

メトリクス数が0の場合は "Skipping metrics report because no metrics are registered." を出力

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[スケジュールタイマー] --> B[report呼び出し]
    B --> C{メトリクス有無}
    C -->|なし| D[スキップログ出力]
    C -->|あり| E[StringBuilder初期化]
    E --> F[Counters出力]
    F --> G[Gauges出力]
    G --> H[Meters出力]
    H --> I[Histograms出力]
    I --> J[LOG.info出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ConcurrentModificationException | メトリクス登録/削除中のレポート | （無視） | 次回レポートで回復 |
| NoSuchElementException | イテレーション中のメトリクス削除 | （無視） | 次回レポートで回復 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| レポート間隔 | 設定依存（通常10-60秒） |
| 初期バッファサイズ | 16384文字（約150メトリクス相当） |
| メトリクス数上限 | 制限なし |

## セキュリティ考慮事項

- メトリクスはログファイルに平文で出力される
- ログファイルのアクセス制御に従う
- 機密情報を含むメトリクス名に注意

## 備考

- AbstractReporterとScheduledインターフェースを実装
- ConcurrentModificationExceptionとNoSuchElementExceptionは無視して処理継続
- filterCharacters()は入力をそのまま返す（フィルタリングなし）

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Slf4jReporter.java | `flink-metrics/flink-metrics-slf4j/src/main/java/org/apache/flink/metrics/slf4j/Slf4jReporter.java` | Reporter実装（行43-181）：report()メソッドでメトリクス出力 |

**主要処理フロー**:
1. **行77-86**: report()でtryReport()を呼び出し、例外は無視
2. **行88-143**: tryReport()でメトリクスタイプ別にログ出力
3. **行103-134**: 各メトリクスタイプの出力処理

### プログラム呼び出し階層図

```
Slf4jReporter
    │
    ├─ AbstractReporter（継承）
    │      ├─ gauges Map
    │      ├─ counters Map
    │      ├─ histograms Map
    │      └─ meters Map
    │
    └─ report()
           └─ tryReport()
                  ├─ Counter.getCount()
                  ├─ Gauge.getValue()
                  ├─ Meter.getRate()
                  └─ Histogram.getStatistics()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Slf4jReporter.java | `flink-metrics/flink-metrics-slf4j/src/main/java/org/apache/flink/metrics/slf4j/Slf4jReporter.java` | ソース | Reporter実装 |
| Slf4jReporterFactory.java | `flink-metrics/flink-metrics-slf4j/src/main/java/org/apache/flink/metrics/slf4j/Slf4jReporterFactory.java` | ソース | ファクトリ |
