# 帳票設計書 9-Datadogメトリクスレポート

## 概要

本ドキュメントは、Apache Flink のDatadogメトリクスレポート機能に関する帳票設計書である。DatadogHttpReporterを中心としたHTTP経由のメトリクス送信機能について、その仕様と実装詳細を記載する。

### 本帳票の処理概要

本帳票は、Apache Flink のジョブおよびタスクマネージャーから収集されたメトリクスをDatadogサービスへHTTP経由で送信する機能を提供する。DatadogHttpClientを使用してメトリクスをDatadog APIに送信する。

**業務上の目的・背景**：Datadogは、クラウドネイティブ環境向けの統合型監視・分析プラットフォームである。インフラストラクチャ監視、APM、ログ管理、リアルユーザーモニタリングを一元化し、ダッシュボード、アラート、異常検知、機械学習ベースの分析を提供する。SaaSとして提供されるため、インフラストラクチャ管理の負担なく高度な監視機能を利用できる。

**帳票の利用シーン**：エンタープライズ環境での統合監視、マルチクラウド環境のメトリクス集約、APMとの連携によるパフォーマンス分析、ビジネスメトリクスの可視化などで利用される。

**主要な出力内容**：
1. Counter型メトリクス（DCounter）
2. Gauge型メトリクス（DGauge）
3. Meter型メトリクス（DMeter）
4. Histogram型メトリクス（DHistogram）

**帳票の出力タイミング**：設定されたレポート間隔に従い、定期的にDatadog APIへHTTP POSTで送信される。

**帳票の利用者**：SRE、DevOpsエンジニア、プラットフォームエンジニア

## 帳票種別

メトリクスレポート（HTTP Push型 Datadog API形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Datadogダッシュボード | https://app.datadoghq.com | 定期的なスケジュール送信 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON（Datadog Metrics API） |
| 通信プロトコル | HTTPS |
| エンドポイント | Datadog API（データセンター依存） |
| 出力方法 | HTTP POST |
| 文字コード | UTF-8 |

### Datadog固有設定

| 項目 | 内容 | デフォルト値 |
|-----|------|-------------|
| APIキー | metrics.reporter.dghttp.apikey | （必須） |
| プロキシホスト | metrics.reporter.dghttp.proxyHost | なし |
| プロキシポート | metrics.reporter.dghttp.proxyPort | なし |
| データセンター | metrics.reporter.dghttp.dataCenter | US |
| タグ | metrics.reporter.dghttp.tags | なし |
| 1リクエストあたり最大メトリクス数 | metrics.reporter.dghttp.maxMetricsPerRequest | 設定依存 |

## 帳票レイアウト

### レイアウト概要

Datadog Metrics API形式（DSeries）でメトリクスを送信。

```json
{
  "series": [
    {
      "metric": "flink.jobmanager.numRegisteredTaskManagers",
      "type": "gauge",
      "points": [[1609459200, 3]],
      "host": "flink-jobmanager",
      "tags": ["job_name:MyJob"]
    }
  ]
}
```

### メトリクス型マッピング

| Flink型 | Datadog型 | 説明 |
|--------|----------|------|
| Counter | count | カウント値 |
| Gauge | gauge | 現在値 |
| Meter | gauge | レート値（gaugeとして送信） |
| Histogram | 複数メトリクス | 統計値を複数メトリクスとして送信 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| APIキー設定 | Datadog APIキーの設定 | Yes |
| ネットワーク接続 | Datadog APIへの接続 | Yes |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[スケジュールタイマー] --> B[report呼び出し]
    B --> C[DSeries構築]
    C --> D[Gauges追加]
    D --> E[Counters追加]
    E --> F[Meters追加]
    F --> G[Histograms追加]
    G --> H{メトリクス分割}
    H --> I[DatadogHttpClient.send]
    I --> J{送信成功?}
    J -->|成功| K[ackReport呼び出し]
    J -->|失敗| L[警告ログ出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| SocketTimeoutException | 通信タイムアウト | Failed reporting metrics to Datadog because of socket timeout: {message} | ネットワーク確認 |
| Exception | その他の送信エラー | Failed reporting metrics to Datadog. | APIキー/ネットワーク確認 |
| ClassCastException | 非数値Gauge | The metric {name} will not be reported because only number types are supported | Gauge型確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| レポート間隔 | 設定依存（通常10-60秒） |
| 1リクエストあたりメトリクス数 | maxMetricsPerRequestで制御 |
| メトリクス数上限 | 制限なし（分割送信） |

## セキュリティ考慮事項

- APIキーは機密情報として管理
- HTTPS経由での暗号化通信
- プロキシ設定によるファイアウォール対応

## 備考

- MetricReporterとScheduledインターフェースを実装
- メトリクススコープの変数はDatadogタグとして送信
- host変数は特別扱い（タグではなくhostフィールドに設定）
- 非数値Gaugeは自動的に登録解除される

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DatadogHttpReporter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DatadogHttpReporter.java` | Reporter実装（行48-246）：メトリクス送信処理 |

**主要処理フロー**:
1. **行88-126**: notifyOfAddedMetric()でメトリクス登録
2. **行160-187**: report()でDSeriesを構築し送信
3. **行189-218**: addGaugesAndUnregisterOnException()で非数値Gauge処理

### プログラム呼び出し階層図

```
DatadogHttpReporter
    │
    ├─ notifyOfAddedMetric()
    │      ├─ DCounter
    │      ├─ DGauge
    │      ├─ DMeter
    │      └─ DHistogram
    │
    └─ report()
           └─ DSeries
                  └─ DatadogHttpClient.send()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DatadogHttpReporter.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DatadogHttpReporter.java` | ソース | Reporter実装 |
| DatadogHttpClient.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DatadogHttpClient.java` | ソース | HTTPクライアント |
| DSeries.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DSeries.java` | ソース | リクエストボディ |
| DMetric.java | `flink-metrics/flink-metrics-datadog/src/main/java/org/apache/flink/metrics/datadog/DMetric.java` | ソース | メトリクス基底クラス |
