---
generated_at: 2026-02-02 11:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Graphiteメトリクスレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-metrics/flink-metrics-graphite/src/main/java/org/apache/flink/metrics/graphite/GraphiteReporter.java`（行36-99）
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（行11）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GraphiteReporterはScheduledDropwizardReporterを継承 | E-01 行36 | ○ |
| C-02 | ARG_PROTOCOLは"protocol" | E-01 行38 | ○ |
| C-03 | ProtocolはTCPとUDPの2種類 | E-01 行40-43 | ○ |
| C-04 | getReporter()で設定値取得 | E-01 行46-58 | ○ |
| C-05 | host/port無効時にIllegalArgumentException | E-01 行50-53 | ○ |
| C-06 | prefixはARG_PREFIXで取得 | E-01 行55 | ○ |
| C-07 | conversionRateはARG_CONVERSION_RATEで取得 | E-01 行56 | ○ |
| C-08 | conversionDurationはARG_CONVERSION_DURATIONで取得 | E-01 行57 | ○ |
| C-09 | プロトコルデフォルトは"TCP" | E-01 行58 | ○ |
| C-10 | GraphiteReporter.forRegistry()でBuilder作成 | E-01 行60-61 | ○ |
| C-11 | prefixがnullでなければprefixedWith設定 | E-01 行63-65 | ○ |
| C-12 | conversionRateがnullでなければconvertRatesTo設定 | E-01 行67-69 | ○ |
| C-13 | conversionDurationがnullでなければconvertDurationsTo設定 | E-01 行71-73 | ○ |
| C-14 | 不正プロトコル時に警告ログ出力しTCPにフォールバック | E-01 行79-84 | ○ |
| C-15 | UDP時はGraphiteUDPを使用 | E-01 行93 | ○ |
| C-16 | TCP時（デフォルト）はGraphiteを使用 | E-01 行96 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GraphiteReporter.javaのgetReporter()実装が設計書と一致するか確認
- [ ] プロトコル判定のフォールバック動作確認
- [ ] Dropwizard GraphiteReporterとの連携確認
