---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-JSON出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：ドキュメントやコードに明示的な記載なし

## 2) 参照した情報（Evidence一覧）

- E-01: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonFormatFactory.java`（行61-209）
- E-02: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonRowDataSerializationSchema.java`（行46-150）
- E-03: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/JsonFormatOptions.java`（行27-102）
- E-04: `flink-formats/flink-json/src/main/java/org/apache/flink/formats/json/RowDataToJsonConverters.java`（行59-367）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（行3）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JsonRowDataSerializationSchemaはSerializationSchemaを実装 | E-02 行46 | ○ |
| C-02 | Jackson ObjectMapperを使用してJSON変換を実行 | E-02 行30, 100-106 | ○ |
| C-03 | タイムスタンプフォーマットのデフォルトはSQL | E-03 行60-67 | ○ |
| C-04 | map-null-key.modeのデフォルトはFAIL | E-03 行44-51 | ○ |
| C-05 | map-null-key.literalのデフォルトは"null" | E-03 行53-58 | ○ |
| C-06 | encode.decimal-as-plain-numberのデフォルトはfalse | E-03 行69-74 | ○ |
| C-07 | encode.ignore-null-fieldsのデフォルトはfalse | E-03 行76-81 | ○ |
| C-08 | RowDataToJsonConverterでRowDataをJsonNodeに変換 | E-04 行90-92 | ○ |
| C-09 | BOOLEAN型はbooleanNodeに変換 | E-04 行104-106 | ○ |
| C-10 | VARCHAR型はtextNodeに変換 | E-04 行121-124 | ○ |
| C-11 | DATE型はISO_LOCAL_DATE形式で出力 | E-04 行169-174 | ○ |
| C-12 | TIME型はSQL_TIME_FORMAT形式で出力 | E-04 行177-182 | ○ |
| C-13 | TIMESTAMP型はタイムスタンプフォーマット設定に依存 | E-04 行185-203 | ○ |
| C-14 | MAP型のキーは文字列型のみサポート | E-04 行261-266 | ○ |
| C-15 | RAW型はサポートされない | E-04 行152-154 | ○ |
| C-16 | MapNullKeyModeにはFAIL/DROP/LITERALの3モード | E-03 行95-99 | ○ |
| C-17 | FAILモードでnullキーエラー時のメッセージ | E-04 行294-298 | ○ |
| C-18 | createEncodingFormatでSerializationSchemaを生成 | E-01 行138-172 | ○ |
| C-19 | JsonRowDataSerializationSchemaのインスタンス化 | E-01 行158-164 | ○ |
| C-20 | serialize()でRowDataをbyte[]に変換 | E-02 行110-121 | ○ |
| C-21 | ignoreNullFieldsがtrueの場合に新しいObjectNodeを作成 | E-02 行111-113 | ○ |
| C-22 | エラー時に "Fail to serialize at field:" メッセージ | E-04 行350-351 | ○ |
| C-23 | エラー時に "Could not serialize row" メッセージ | E-02 行119 | ○ |
| C-24 | createMapConverter()でMAP型の変換処理 | E-04 行259-313 | ○ |
| C-25 | createRowConverter()で行全体の変換器を生成 | E-04 行315-356 | ○ |
| C-26 | ARRAY型はArrayNodeに変換 | E-04 行233-257 | ○ |
| C-27 | JsonFormatFactoryのIDENTIFIERは"json" | E-01 行63 | ○ |
| C-28 | パフォーマンス要件：リアルタイム処理対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値（スループット、レイテンシ等）についての公式ドキュメントやベンチマーク結果が見つからない
  - 候補：Flink公式ドキュメント / ベンチマーク資料 / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接確認可能な技術仕様の記載
- 0: 低リスク - 設定オプションの仕様はJsonFormatOptions.javaで確認済み
- 0: 低リスク - 型変換処理はRowDataToJsonConverters.javaで詳細に確認済み
- 1: 中リスク - パフォーマンス要件は具体的数値がなく一般的な記載

## 6) レビュアーチェックリスト（最小）
- [ ] JsonRowDataSerializationSchema.javaのserialize実装が設計書と一致するか確認
- [ ] JsonFormatOptions.javaの各オプションのデフォルト値が正しいか確認
- [ ] RowDataToJsonConverters.javaの型変換マッピングが網羅されているか確認
- [ ] MAP型のnullキー処理（FAIL/DROP/LITERAL）の動作確認
- [ ] エラーメッセージの記載がソースコードと一致するか確認
- [ ] パフォーマンス要件について、必要に応じて具体的な数値を補完
